/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hlcm.mservice;

import java.util.Locale;
import java.util.Map;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dlock.DLock;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.Assert;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hlcm.business.domian.repository.BosUserRepository;
import kd.hr.hlcm.business.domian.repository.ContractApplyRepository;
import kd.hr.hlcm.business.domian.service.signmgt.ISignManageService;
import kd.hr.hlcm.business.utils.RequestContextUtils;
import kd.hr.hlcm.common.enums.BusinessStatusEnum;
import kd.hr.hlcm.common.enums.SignModeEnum;
import kd.hr.hlcm.mservice.api.IHLCMEContractNotifyService;

public class HLCMEContractNotifyService
implements IHLCMEContractNotifyService {
    private static final Log LOGGER = LogFactory.getLog(HLCMEContractNotifyService.class);

    public void authNotify(Long naturalId, Long candidateId) {
    }

    public void signNotify(String contractNo) {
        LOGGER.info("{} sign notify begin", (Object)contractNo);
        DynamicObject signBill = ContractApplyRepository.getInstance().queryByContractNo(contractNo);
        HLCMEContractNotifyService.handleRequestContext(signBill);
        if (HRStringUtils.equals((String)signBill.getString("signmode"), (String)SignModeEnum.BATCH_MULTASK.getValue())) {
            String key = signBill.getString("id");
            DLock dLock = DLock.create((String)key);
            LOGGER.info("dLock  key|{}", (Object)key);
            try {
                ISignManageService.getInstance().empSignCompleteMulTaskMode(signBill, contractNo);
            }
            catch (Exception exp) {
                LOGGER.error("empSignCompleteMulTaskMode error", (Throwable)exp);
                throw exp;
            }
            finally {
                dLock.unlock();
            }
        } else {
            ISignManageService.getInstance().empSignComplete(signBill);
        }
        LOGGER.info("{} sign notify end", (Object)contractNo);
    }

    public void companySignNotify(String contractNo) {
        String result;
        LOGGER.info("{} company sign notify begin", (Object)contractNo);
        DynamicObject signBill = ContractApplyRepository.getInstance().queryByContractNo(contractNo);
        if (HRObjectUtils.isEmpty((Object)signBill)) {
            LOGGER.info("HLCMEContractNotifyService.companySignNotify.signbili.is.empty..");
            return;
        }
        this.handleCompanySignRequestContext(signBill);
        if (HRStringUtils.equals((String)signBill.getString("signmode"), (String)SignModeEnum.BATCH_MULTASK.getValue())) {
            String key = signBill.getString("id");
            DLock dLock = DLock.create((String)key);
            LOGGER.info("dLock  key|{}", (Object)key);
            try {
                result = ISignManageService.getInstance().companySignNotifyMulTaskMode(signBill, contractNo);
            }
            catch (Exception exp) {
                LOGGER.error("companySignNotifyMulTaskMode error", (Throwable)exp);
                throw exp;
            }
            finally {
                dLock.unlock();
            }
        } else {
            result = ISignManageService.getInstance().companySignNotify(contractNo);
        }
        if (!HRStringUtils.isEmpty((String)result)) {
            throw new KDBizException(result);
        }
        LOGGER.info("{} company sign notify end", (Object)contractNo);
    }

    public void signFailNotify(Map<String, Object> failInfo) {
        LOGGER.info("emp sign fail notify begin failInfo|{}", failInfo);
        try {
            this.failSign(failInfo, BusinessStatusEnum.PSIGN.getCombKey());
            LOGGER.info("emp sign fail notify end");
        }
        catch (Exception exp) {
            LOGGER.error("emp sign fail notify error.", (Throwable)exp);
            throw new KDBizException(exp.getMessage());
        }
    }

    public void companySignFailNotify(Map<String, Object> failInfo) {
        LOGGER.info("company sign fail notify begin failInfo|{}", failInfo);
        try {
            this.failSign(failInfo, BusinessStatusEnum.CSIGN.getCombKey());
            LOGGER.info("company sign fail notify end");
        }
        catch (Exception exp) {
            LOGGER.error("company sign fail notify error.", (Throwable)exp);
            throw new KDBizException(exp.getMessage());
        }
    }

    private void handleCompanySignRequestContext(DynamicObject signBill) {
        DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("hlcm");
        long pkValue = signBill.getLong("id");
        String key = String.format(Locale.ROOT, "%s_%d", "COMPANY_SIGN", pkValue);
        String userId = (String)cache.get(key);
        LOGGER.info("get userId|{} from cache", (Object)userId);
        if (HRStringUtils.isEmpty((String)userId)) {
            userId = signBill.getString(String.format(Locale.ROOT, "%s.%s", "modifier", "id"));
        }
        RequestContext requestContext = RequestContext.getOrCreate();
        requestContext = RequestContextUtils.copyRequestContext((RequestContext)requestContext, (String)userId);
        RequestContext.set((RequestContext)requestContext);
    }

    private static void handleRequestContext(DynamicObject signBill) {
        RequestContext requestContext = RequestContext.getOrCreate();
        Long userId = BosUserRepository.getBosUserId((String)signBill.getString("empnumber"));
        String userName = signBill.getString("empname");
        requestContext = RequestContextUtils.copyRequestContext((RequestContext)requestContext, (String)userId.toString(), (String)userName);
        RequestContext.set((RequestContext)requestContext);
    }

    private void failSign(Map<String, Object> failInfo, String businessType) {
        Object contractNo = failInfo.get("contractNo");
        Assert.notNull((Object)contractNo, (String)"contractNo is null");
        String contractNoText = contractNo.toString();
        Assert.hasText((String)contractNoText, (String)"contractNo is empty");
        DynamicObject signBill = ContractApplyRepository.getInstance().queryByContractNo(contractNoText);
        if (HRObjectUtils.isEmpty((Object)signBill)) {
            throw new KDBizException("signBill not exists");
        }
        if (HRStringUtils.equals((String)signBill.getString("signmode"), (String)SignModeEnum.BATCH_MULTASK.getValue())) {
            ISignManageService.getInstance().signFailNotifyHandlerMulTaskMode(signBill, contractNoText, businessType);
        } else {
            ISignManageService.getInstance().signFailNotifyHandler(signBill);
        }
    }
}

