/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hlcm.mservice;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.Assert;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.service.message.IHRMsgTplService;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.mservice.HRMServiceResult;
import kd.hr.hbp.common.util.HRJSONUtils;
import kd.hr.hlcm.business.common.HLCMCommonRepository;
import kd.hr.hlcm.business.domian.service.hismodel.IContractHisModel;
import kd.hr.hlcm.business.domian.service.revise.IReviseVersionService;
import kd.hr.hlcm.business.domian.service.signmgt.ISignManageService;
import kd.hr.hlcm.business.prewarn.SyncStartStatusService;
import kd.hr.hlcm.common.utils.CommonUtils;
import kd.hr.hlcm.mservice.api.IHLCMService;

public class HLCMService
implements IHLCMService,
IHRMsgTplService {
    private static final Log logger = LogFactory.getLog(HLCMService.class);
    private static final String SUCCESS = "success";
    private static final String ERROR_MSG = "errorMsg";
    private static final String MSG = "msg";
    private static final Map<String, Class> QUERY_CONTRACTS_TYPE_MAP = Maps.newHashMapWithExpectedSize((int)16);
    private static final Map<String, Class> REVISE_INFOS_TYPE_MAP = Maps.newHashMapWithExpectedSize((int)8);

    public HRMServiceResult consumerSaveMsg(DynamicObject dynamicObject) {
        logger.info("hiredperson-consumer:{}", (Object)dynamicObject);
        this.saveHiredPerson(dynamicObject);
        this.updateMsgCenterStatus(dynamicObject);
        return null;
    }

    private void saveHiredPerson(DynamicObject dynamicObject) {
        String msgcontent = SerializationUtils.deSerializeFromBase64((String)dynamicObject.getString("msgcontent")).toString();
        Map map = CommonUtils.getStringToMap((String)msgcontent);
        Long personId = this.getPersonIdFromRecord(map);
        SyncStartStatusService.getInstance().saveHirePerson(personId);
    }

    private void updateMsgCenterStatus(DynamicObject dynamicObject) {
        long msgcenterboId = dynamicObject.getLong("msgcenterbo");
        String msgsubno = dynamicObject.getString("msgsubno");
        HashMap<String, Object> param = new HashMap<String, Object>(3);
        param.put("msgCenterId", msgcenterboId);
        param.put("msgSubNo", msgsubno);
        param.put("handleStatus", "1");
        try (TXHandle txHandle = TX.notSupported();){
            HRMServiceHelper.invokeHRMPService((String)"hrcs", (String)"IHRCSMsgService", (String)"updateConsumeMsgInfo", (Object[])new Object[]{param});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> quitInvalidContract(Map<String, Object> quitInfo) {
        logger.info("quitInvalidContract param|{}", (Object)JSON.toJSONString(quitInfo));
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        try (TXHandle txHandle = TX.requiresNew();){
            Object personIdObj = quitInfo.get("person_id");
            Assert.notNull((Object)personIdObj);
            Assert.isTrue((boolean)(personIdObj instanceof Long));
            Long personId = (Long)Long.class.cast(personIdObj);
            Object contractEndDateObj = quitInfo.get("contractenddate");
            Assert.notNull((Object)contractEndDateObj);
            Assert.isTrue((boolean)(contractEndDateObj instanceof Date));
            Date contractEndDate = (Date)Date.class.cast(contractEndDateObj);
            IContractHisModel.getInstance().invalidContract(personId, contractEndDate);
            result.put(SUCCESS, Boolean.TRUE);
            result.put(MSG, "");
            logger.info("quitInvalidContract result|{}", (Object)JSON.toJSONString(result));
            LinkedHashMap<String, Object> linkedHashMap = result;
            return linkedHashMap;
        }
    }

    private Long getPersonIdFromRecord(Map<String, Object> map) {
        Long recordId = HRJSONUtils.getLongValOfCustomParam((Object)map.get("recordId"));
        logger.info("call rpc hpfs IHPFSPersonChgService.getChgInfoByRecordId param|{}", (Object)recordId);
        Map res = (Map)HRMServiceHelper.invokeHRService((String)"hpfs", (String)"IHPFSPersonChgService", (String)"getChgInfoByRecordId", (Object[])new Object[]{recordId});
        boolean success = (Boolean)res.get(SUCCESS);
        if (!success) {
            throw new KDBizException((String)res.get(ERROR_MSG));
        }
        Map data1 = (Map)res.get("data");
        List data2 = (List)data1.get("data");
        if (data2.isEmpty()) {
            return 0L;
        }
        Map data3 = (Map)data2.get(0);
        Map hrpiPerson = (Map)data3.get("hrpi_person");
        return HRJSONUtils.getLongValOfCustomParam(hrpiPerson.get("boid"));
    }

    public Map<String, Object> queryContracts(Map<String, Object> filters) {
        logger.info("param filters|{}", (Object)JSON.toJSONString(filters));
        LinkedHashMap result = Maps.newLinkedHashMapWithExpectedSize((int)3);
        try {
            this.assertParamType(filters, QUERY_CONTRACTS_TYPE_MAP);
            IReviseVersionService instance = IReviseVersionService.getInstance();
            List contracts = instance.queryContracts(filters);
            result.put(SUCCESS, Boolean.TRUE);
            result.put(ERROR_MSG, "");
            result.put("contracts", contracts);
        }
        catch (Exception exp) {
            logger.error("queryContracts error", (Throwable)exp);
            result.put(SUCCESS, Boolean.FALSE);
            result.put(ERROR_MSG, exp.getMessage());
            result.put("contracts", new ArrayList(0));
        }
        logger.info("queryContracts result|{}", (Object)JSON.toJSONString((Object)result));
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> reviseVersion(List<Map<String, Object>> reviseInfos) {
        logger.info("param reviseInfos|{}", (Object)JSON.toJSONString(reviseInfos));
        LinkedHashMap result = Maps.newLinkedHashMapWithExpectedSize((int)3);
        try (TXHandle txHandle = TX.requiresNew();){
            reviseInfos.forEach(reviseInfo -> this.assertParamType((Map<String, Object>)reviseInfo, REVISE_INFOS_TYPE_MAP));
            IReviseVersionService instance = IReviseVersionService.getInstance();
            instance.reviseVersion(reviseInfos);
            result.put(SUCCESS, Boolean.TRUE);
            result.put(ERROR_MSG, "");
        }
        logger.info("reviseVersion result|{}", (Object)JSON.toJSONString((Object)result));
        return result;
    }

    public Map<String, Object> generateContract(List<DynamicObject> dynamicObjects) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        try {
            IContractHisModel.getInstance().hisVersionChange(dynamicObjects.toArray(new DynamicObject[0]));
            resultMap.put(SUCCESS, Boolean.TRUE);
            resultMap.put(ERROR_MSG, "generateContract success");
            return resultMap;
        }
        catch (Exception ex) {
            logger.error("GenerateContractService_generateContract_error", (Throwable)ex);
            resultMap.put(SUCCESS, Boolean.FALSE);
            resultMap.put(ERROR_MSG, ex.getMessage());
            return resultMap;
        }
    }

    public void abandonSignProcess(Map<String, Object> abandonInfo) {
        logger.info("abandonSignProcess param", (Object)JSON.toJSONString(abandonInfo));
        List personIds = (List)abandonInfo.get("personIds");
        Long terminateCauseId = (Long)abandonInfo.get("terminateCauseId");
        List protocolTypes = (List)abandonInfo.get("protocolTypes");
        Assert.isTrue((!CollectionUtils.isEmpty((Collection)personIds) ? 1 : 0) != 0, (String)"param personIds is null or empty");
        Assert.isTrue((!CollectionUtils.isEmpty((Collection)protocolTypes) ? 1 : 0) != 0, (String)"param protocolTypes is null or empty");
        Assert.isTrue((terminateCauseId != null && terminateCauseId != 0L ? 1 : 0) != 0, (String)"param abandonReasonId is null or 0");
        boolean terminateCauseExist = HLCMCommonRepository.exist((String)"hlcm_terminatercause", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)terminateCauseId)});
        Assert.isTrue((boolean)terminateCauseExist, (String)"terminateCauseId is not exist");
        ISignManageService.getInstance().abandonSignProcess(personIds, protocolTypes, terminateCauseId);
    }

    public Map<String, String> replaceKeywordGenFile(Long signBillId, int index, boolean isAlterFileName, boolean isToPdf) {
        DynamicObject signBill = HLCMCommonRepository.queryDynamicObjectByPk((String)"hlcm_contractapplybase", null, (Object)signBillId);
        Assert.notNull((Object)signBill, (String)("can not find  signBill id=" + signBillId));
        DynamicObjectCollection entryEntityCollection = signBill.getDynamicObjectCollection("entryentity");
        int size = entryEntityCollection.size();
        Assert.isTrue((index < size ? 1 : 0) != 0, (String)("index must < " + size));
        return ISignManageService.getInstance().replaceKeywordGenFile(signBill, (DynamicObject)entryEntityCollection.get(index), isAlterFileName, isToPdf);
    }

    private void assertParamType(Map<String, Object> params, Map<String, Class> typeMap) {
        Set<String> paramEntries = typeMap.keySet();
        Assert.isTrue((!CollectionUtils.isEmpty(params) ? 1 : 0) != 0, (String)"param is empty");
        params.forEach((paramName, paramValue) -> {
            Assert.isTrue((boolean)paramEntries.contains(paramName), (String)String.format(Locale.ROOT, "illegal argument %s", paramName));
            if (Objects.nonNull(paramValue)) {
                Class type = (Class)typeMap.get(paramName);
                Assert.isTrue((boolean)type.isInstance(paramValue), (String)String.format(Locale.ROOT, "argument %s must be %s", paramName, type.toGenericString()));
            }
        });
    }

    static {
        QUERY_CONTRACTS_TYPE_MAP.put("ermanorg", Long[].class);
        QUERY_CONTRACTS_TYPE_MAP.put("adminororg", Long[].class);
        QUERY_CONTRACTS_TYPE_MAP.put("ermanperorg", Long[].class);
        QUERY_CONTRACTS_TYPE_MAP.put("ermanfile", Long[].class);
        QUERY_CONTRACTS_TYPE_MAP.put("signedcompany", Long[].class);
        QUERY_CONTRACTS_TYPE_MAP.put("department", Long[].class);
        QUERY_CONTRACTS_TYPE_MAP.put("position", Long[].class);
        QUERY_CONTRACTS_TYPE_MAP.put("stdposition", Long[].class);
        QUERY_CONTRACTS_TYPE_MAP.put("job", Long[].class);
        QUERY_CONTRACTS_TYPE_MAP.put("actualsigncompany", Long[].class);
        QUERY_CONTRACTS_TYPE_MAP.put("name", String[].class);
        QUERY_CONTRACTS_TYPE_MAP.put("empnumber", String[].class);
        QUERY_CONTRACTS_TYPE_MAP.put("contractstatus", String[].class);
        QUERY_CONTRACTS_TYPE_MAP.put("signway", String[].class);
        QUERY_CONTRACTS_TYPE_MAP.put("protocoltype", String[].class);
        REVISE_INFOS_TYPE_MAP.put("boid", Long.class);
        REVISE_INFOS_TYPE_MAP.put("ermanorg", Long.class);
        REVISE_INFOS_TYPE_MAP.put("adminororg", Long.class);
        REVISE_INFOS_TYPE_MAP.put("ermanperorg", Long.class);
        REVISE_INFOS_TYPE_MAP.put("signedcompany", Long.class);
        REVISE_INFOS_TYPE_MAP.put("department", Long.class);
        REVISE_INFOS_TYPE_MAP.put("position", Long.class);
        REVISE_INFOS_TYPE_MAP.put("stdposition", Long.class);
        REVISE_INFOS_TYPE_MAP.put("job", Long.class);
    }
}

