/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hlcm.formplugin.base;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.hr.hlcm.business.common.HLCMCommonRepository;
import kd.hr.hlcm.business.utils.ContractPageLoadUtils;
import kd.hr.hlcm.common.enums.ProtocolTypeEnum;
import kd.hr.hlcm.common.enums.SignTabEnum;
import kd.hr.hlcm.common.utils.ComboUtils;
import kd.hr.hlcm.common.utils.LabelOperateUtils;

public class BillHeadViewFullFormPlugin
extends HRDataBaseEdit {
    private static final Log LOGGER = LogFactory.getLog(BillHeadViewFullFormPlugin.class);
    private static final String HLCM_CONTRACTAPPLYMEW = "hlcm_contractapplynew";

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        String entityId = this.getView().getParentView().getEntityId();
        JSONObject data = (JSONObject)this.getView().getFormShowParameter().getCustomParam("data");
        if (data == null) {
            return;
        }
        String billNo = data.getString("billno");
        LOGGER.info("BillHeadViewFullFormPlugin====#billNo:{},entityId:{} ", (Object)billNo, (Object)entityId);
        IFormView view = this.getView();
        LabelOperateUtils.setLabelOrHideOther((IFormView)view, (String)data.getString("name"), (String)"contractname", (String[])new String[]{"contractflex"});
        LabelOperateUtils.setLabelOrHideOther((IFormView)view, (String)data.getString("contractstatus"), (String)"contractstatus", (String[])new String[]{"signstatustitle"});
        String processStatus = this.getProcessStatus();
        if (this.isSignBillTab().booleanValue() && HRStringUtils.isNotEmpty((String)processStatus)) {
            LabelOperateUtils.setLabelOrHideOther((IFormView)view, (String)processStatus, (String)"activestatus", (String[])new String[0]);
            LabelOperateUtils.setLabelOrHideOther((IFormView)view, (String)"", (String)"handlestatus", (String[])new String[0]);
        } else {
            LabelOperateUtils.setLabelOrHideOther((IFormView)view, (String)data.getString("handlestatus"), (String)"handlestatus", (String[])new String[0]);
            LabelOperateUtils.setLabelOrHideOther((IFormView)view, (String)data.getString("activestatus"), (String)"activestatus", (String[])new String[0]);
        }
        LabelOperateUtils.setLabelOrHideOther((IFormView)view, (String)data.getString("signstatus"), (String)"signstatus", (String[])new String[0]);
        LabelOperateUtils.setLabelOrHideOther((IFormView)view, (String)data.getString("billno"), (String)"billno", (String[])new String[0]);
        LabelOperateUtils.setLabelOrHideOther((IFormView)view, (String)data.getString("createtime"), (String)"createtime", (String[])new String[]{"createtimetitle"});
        LabelOperateUtils.setLabelOrHideOther((IFormView)view, (String)data.getString("creator"), (String)"creator", (String[])new String[]{"creatortitle"});
        LabelOperateUtils.setLabelOrHideOther((IFormView)view, (String)data.getString("org"), (String)"org", (String[])new String[]{"orgtitle"});
        LabelOperateUtils.setLabelOrHideOther((IFormView)view, (String)data.getString("ermanorg"), (String)"ermanorg", (String[])new String[]{"ermanorgtitle"});
        LabelOperateUtils.setLabelOrHideOther((IFormView)view, (String)data.getString("businesstype"), (String)"businesstype", (String[])new String[]{"businesstypetitle"});
        LabelOperateUtils.setLabelOrHideOther((IFormView)view, (String)data.getString("signway"), (String)"signway", (String[])new String[0]);
        if (!HRStringUtils.equals((String)ProtocolTypeEnum.CON.getCombKey(), (String)data.getString("protocoltype"))) {
            LabelOperateUtils.setLabelOrHideOther((IFormView)view, (String)data.getString("billStatus"), (String)"billstatus", (String[])new String[0]);
        } else {
            LabelOperateUtils.setLabelOrHideOther((IFormView)view, (String)"", (String)"billstatus", (String[])new String[0]);
        }
        if (HRStringUtils.isNotEmpty((String)data.getString("billname"))) {
            LabelOperateUtils.setLabelOrHideOther((IFormView)view, (String)data.getString("billname"), (String)"billname", (String[])new String[0]);
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        ContractPageLoadUtils.getInstance().loadPersonInfoCard(this.getView());
    }

    private Boolean isSignBillTab() {
        String entityId = this.getView().getParentView().getEntityId();
        ArrayList signBillLists = Lists.newArrayList((Object[])new Object[]{SignTabEnum.E_BEGIN.getSourceListFormId(), SignTabEnum.E_CONFIRM.getSourceListFormId(), SignTabEnum.E_ESIGN.getSourceListFormId(), SignTabEnum.E_CSIGN.getSourceListFormId(), SignTabEnum.E_CHECK.getSourceListFormId(), SignTabEnum.P_BEGIN.getSourceListFormId(), SignTabEnum.P_COMP.getSourceListFormId(), SignTabEnum.P_CHECK.getSourceListFormId()});
        if (HRStringUtils.isNotEmpty((String)entityId) && signBillLists.contains(entityId)) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    private String getProcessStatus() {
        IFormView parentView = this.getView().getParentView();
        DynamicObject dataEntity = parentView.getModel().getDataEntity();
        long primaryKeyValue = dataEntity.getLong("id");
        if (primaryKeyValue == 0L) {
            return "";
        }
        String entityId = dataEntity.getDataEntityType().getName();
        String formId = SignTabEnum.getListFormIdByFormId((String)entityId);
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)formId);
        if (!type.getProperties().containsKey((Object)"signapply")) {
            return "";
        }
        DynamicObject[] dys = HLCMCommonRepository.queryDynamicObjects((String)formId, (String)"processstatus", (QFilter[])new QFilter[]{new QFilter("activityins.bindbizkey", "=", (Object)entityId), new QFilter("signapply.id", "=", (Object)primaryKeyValue)});
        if (dys == null || dys.length < 1) {
            return "";
        }
        return ComboUtils.getComboOptionLocaleName((DynamicObject)dys[0], (String)"processstatus");
    }
}

