/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hlcm.formplugin.base;

import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.fileservice.extension.FileServiceExtFactory;
import kd.bos.form.IFormView;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.OperationColumn;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.operatecol.OperationColItem;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.hr.hlcm.business.common.HLCMCommonRepository;
import kd.hr.hlcm.business.domian.repository.CommonRepository;
import kd.hr.hlcm.business.service.ContractTplService;
import kd.hr.hlcm.business.utils.ContractDurationCalculateEntryHelper;
import kd.hr.hlcm.business.utils.ContractSignUtils;
import kd.hr.hlcm.common.enums.ContractPeriodTypeEnum;

public class ContractEntryEntityFormPlugin
extends HRDataBaseEdit {
    private static final Log LOGGER = LogFactory.getLog(ContractEntryEntityFormPlugin.class);
    private static final String OPERATION_COLUMN_AP = "operationcolumnap";
    private static final String[] SIGN_TEMPLATE_CUR = new String[]{"contracttemplate", "contempnumber", "contemptype", "signwaytemp", "econfig"};
    private static final String[] SIGN_TEMPLATE_HIS = new String[]{"texthis", "contempnumberhis", "contemptypehis", "signwaytemphis", "econfighis"};

    public void initialize() {
        if (!this.hasEntryGrid()) {
            return;
        }
        super.initialize();
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        entryGrid.addPackageDataListener(pkEvent -> {
            boolean isOperationColumn;
            DynamicObject rowData = pkEvent.getRowData();
            Object contractTemplate = rowData.get("contracttemplate");
            boolean bl = isOperationColumn = pkEvent.getSource() instanceof OperationColumn && OPERATION_COLUMN_AP.equalsIgnoreCase(((OperationColumn)pkEvent.getSource()).getKey());
            if (isOperationColumn && !HRObjectUtils.isEmpty((Object)contractTemplate)) {
                String fileName = rowData.getString("attachmentfield1");
                LOGGER.info("Entry attachmentfield1 is:{}", (Object)fileName);
                List operationColItems = (List)pkEvent.getFormatValue();
                for (OperationColItem operationColItem : operationColItems) {
                    operationColItem.setVisible(HRStringUtils.isNotEmpty((String)fileName));
                }
            }
            if (isOperationColumn && HRObjectUtils.isEmpty((Object)contractTemplate)) {
                List operationColItems = (List)pkEvent.getFormatValue();
                for (OperationColItem operationColItem : operationColItems) {
                    operationColItem.setVisible(false);
                }
            }
        });
    }

    public void beforeBindData(EventObject e) {
        if (!this.hasEntryGrid()) {
            return;
        }
        super.beforeBindData(e);
        OperationStatus operationStatus = this.getView().getFormShowParameter().getStatus();
        if (operationStatus == OperationStatus.VIEW) {
            this.getView().setVisible(Boolean.FALSE, SIGN_TEMPLATE_CUR);
            this.getView().setVisible(Boolean.TRUE, SIGN_TEMPLATE_HIS);
        } else {
            this.getView().setVisible(Boolean.TRUE, SIGN_TEMPLATE_CUR);
            this.getView().setVisible(Boolean.FALSE, SIGN_TEMPLATE_HIS);
        }
        IDataModel dataModel = this.getModel();
        DynamicObjectCollection entryEntities = dataModel.getEntryEntity("entryentity");
        for (int index = 0; index < entryEntities.size(); ++index) {
            DynamicObject entryEntity = (DynamicObject)entryEntities.get(index);
            String fileName = this.getFileName(entryEntity);
            this.getModel().setValue("attachmentfield1", (Object)fileName, index);
            String contractTypeCateName = this.getContractTypeCatName(entryEntity);
            this.getModel().setValue("contracttypecat", (Object)contractTypeCateName, index);
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        if (!this.hasEntryGrid()) {
            return;
        }
        super.propertyChanged(args);
        String propertyName = args.getProperty().getName();
        DynamicObject dataEntity = args.getChangeSet()[0].getDataEntity();
        new ContractDurationCalculateEntryHelper(this.getModel()).calcContractDurationRelatedFields(dataEntity, propertyName);
        switch (propertyName) {
            case "contracttemplate": {
                Date entryStartdate;
                ChangeData[] changeDataArr = args.getChangeSet();
                int rowIndex = changeDataArr[0].getRowIndex();
                DynamicObject entryEntity = changeDataArr[0].getDataEntity();
                DynamicObject contractTemplate = entryEntity.getDynamicObject("contracttemplate");
                IDataModel dataModel = this.getModel();
                if (HRObjectUtils.isEmpty((Object)contractTemplate)) {
                    dataModel.setValue("attachmentfield1", null, rowIndex);
                    dataModel.setValue("remark", null, rowIndex);
                    dataModel.setValue("contracttypecat", null, rowIndex);
                    dataModel.setValue("entrycontracttype", null, rowIndex);
                    dataModel.setValue("texthis", null, rowIndex);
                    return;
                }
                dataModel.setValue("remark", null, rowIndex);
                String fileName = null;
                if (!HRObjectUtils.isEmpty((Object)contractTemplate)) {
                    long vid = contractTemplate.getLong("vid");
                    dataModel.setValue("texthis", (Object)vid, rowIndex);
                    fileName = this.getFileName(entryEntity);
                }
                dataModel.setValue("attachmentfield1", fileName, rowIndex);
                String contractTypeCateName = this.getContractTypeCatName(entryEntity);
                this.getModel().setValue("contracttypecat", (Object)contractTypeCateName, rowIndex);
                dataModel.setValue("entrycontracttype", (Object)contractTemplate.getDynamicObject("contracttype"), rowIndex);
                String entityIdStr = this.getView().getEntityId();
                if (!"hlcm_contractapplynew".equals(entityIdStr) && !"hlcm_contractapplyrenew".equals(entityIdStr) && !"hlcm_contractapplychange".equals(entityIdStr) || !HRObjectUtils.isEmpty((Object)(entryStartdate = entryEntity.getDate("entrystartdate")))) break;
                this.getModel().setValue("entrystartdate", this.getModel().getValue("startdate"), rowIndex);
                break;
            }
            case "entrystartdate": {
                ContractSignUtils.setEntryStartDateAndEndDateInfo((IFormView)this.getView(), (DynamicObject)dataEntity);
                break;
            }
            case "entryenddate": {
                ContractSignUtils.setEntryStartDateAndEndDateInfo((IFormView)this.getView(), (DynamicObject)dataEntity);
                break;
            }
            case "entryperiodtype": {
                ContractSignUtils.updateEntryEndDateControlMustByPeriodType((IFormView)this.getView(), (DynamicObject)dataEntity, (int)args.getChangeSet()[0].getRowIndex(), (boolean)true);
                break;
            }
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        if (!HRStringUtils.equals((String)e.getEntryProp().getName(), (String)"entryentity")) {
            return;
        }
        String entityIdStr = this.getView().getEntityId();
        IDataModel dataModel = this.getModel();
        for (RowDataEntity row : e.getRowDataEntities()) {
            int rowIndex = row.getRowIndex();
            if ("hlcm_contractapplycancel".equals(this.getView().getEntityId())) {
                DynamicObject entryperiodtype;
                Date enddate = dataModel.getDataEntity().getDate("canceldate");
                if (enddate != null) {
                    Date entrystartdate = HRDateTimeUtils.addDay((Date)enddate, (long)1L);
                    dataModel.setValue("entrystartdate", (Object)entrystartdate, rowIndex);
                }
                if ((entryperiodtype = row.getDataEntity().getDynamicObject("entryperiodtype")) != null && entryperiodtype.getLong("id") == ContractPeriodTypeEnum.NONFIXED.getPkId()) {
                    dataModel.setValue("entryperiodunit", (Object)0, rowIndex);
                    this.getView().setEnable(Boolean.valueOf(false), rowIndex, new String[]{"entryenddate"});
                    this.getView().setEnable(Boolean.valueOf(false), rowIndex, new String[]{"entryperiodunit"});
                    this.getView().setEnable(Boolean.valueOf(false), rowIndex, new String[]{"entryperiod"});
                }
                ContractSignUtils.setOtherProtocolNumberForEntity((IFormView)this.getView(), (int)rowIndex);
            } else if ("hlcm_contractapplynew".equals(entityIdStr) || "hlcm_contractapplyrenew".equals(entityIdStr) || "hlcm_contractapplychange".equals(entityIdStr)) {
                dataModel.setValue("entrystartdate", this.getModel().getValue("startdate"), rowIndex);
                ContractSignUtils.setOtherProtocolNumberForEntity((IFormView)this.getView(), (int)rowIndex);
            }
            dataModel.setValue("opperson", (Object)RequestContext.get().getCurrUserId(), rowIndex);
            dataModel.setValue("opdate", (Object)new Date(), rowIndex);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        if (!this.hasEntryGrid()) {
            return;
        }
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if (HRStringUtils.equals((String)operateKey, (String)"contractdownload")) {
            ContractTplService.contractdownload((IFormView)this.getView(), (IDataModel)this.getModel());
        } else if (HRStringUtils.equals((String)operateKey, (String)"contractpreview")) {
            ContractTplService.contractpreview((IFormView)this.getView(), (IDataModel)this.getModel());
        } else {
            LOGGER.warn("operateKey|{}", (Object)operateKey);
        }
    }

    private String getFileName(DynamicObject entryEntity) {
        String fileName;
        DynamicObject contractTemplate = entryEntity.getDynamicObject("contracttemplate");
        if (HRObjectUtils.isEmpty((Object)contractTemplate)) {
            LOGGER.info("contractTemplate is empty");
            return null;
        }
        String url = entryEntity.getString("presigndocurl");
        if (HRStringUtils.isEmpty((String)url)) {
            DynamicObject attachment = this.getAttachment(entryEntity);
            if (Objects.isNull(attachment)) {
                return null;
            }
            fileName = attachment.getString("fattachmentname");
        } else {
            LOGGER.info("signDocUrl:{}", (Object)url);
            url = FileServiceExtFactory.getAttachFileServiceExt().getRealPath(url);
            fileName = url.substring(url.lastIndexOf(47) + 1);
        }
        return fileName;
    }

    private String getContractTypeCatName(DynamicObject entryEntity) {
        DynamicObject contractTemplate = entryEntity.getDynamicObject("contracttemplate");
        if (HRObjectUtils.isEmpty((Object)contractTemplate)) {
            LOGGER.info("contractTemplate is empty");
            return null;
        }
        long contractTypeId = contractTemplate.getLong("contracttype.id");
        if (contractTypeId == 0L) {
            return null;
        }
        DynamicObject contractTypeDy = HLCMCommonRepository.queryDynamicObjectByPk((String)"hbss_contracttypes", (String)"group.name", (Object)contractTypeId);
        return contractTypeDy.getString("group.name");
    }

    private DynamicObject getAttachment(DynamicObject entryEntity) {
        QFilter[] qFilterArray;
        boolean isView;
        DynamicObject contractTemplate = entryEntity.getDynamicObject("contracttemplate");
        DynamicObject contractTemplateHis = entryEntity.getDynamicObject("texthis");
        boolean bl = isView = this.getView().getFormShowParameter().getStatus() == OperationStatus.VIEW;
        if (isView) {
            QFilter[] qFilterArray2 = new QFilter[2];
            qFilterArray2[0] = new QFilter("fbilltype", "=", (Object)"hlcm_contracttemplatehis");
            qFilterArray = qFilterArray2;
            qFilterArray2[1] = new QFilter("finterid", "=", (Object)String.valueOf(Optional.ofNullable(contractTemplateHis).map(DataEntityBase::getPkValue).orElseGet(() -> 0L)));
        } else {
            QFilter[] qFilterArray3 = new QFilter[2];
            qFilterArray3[0] = new QFilter("fbilltype", "=", (Object)"hlcm_contracttemplate");
            qFilterArray = qFilterArray3;
            qFilterArray3[1] = new QFilter("finterid", "=", (Object)String.valueOf(contractTemplate.getPkValue()));
        }
        QFilter[] filters = qFilterArray;
        DynamicObject[] attachments = CommonRepository.query((String)"bos_attachment", (String)String.join((CharSequence)",", "ffileid", "fattachmentname"), (QFilter[])filters);
        if (attachments == null || attachments.length == 0) {
            LOGGER.info("attachments is empty");
            return null;
        }
        return attachments[0];
    }

    private boolean hasEntryGrid() {
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        return Objects.nonNull(entryGrid);
    }
}

