/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hlcm.formplugin.billapply.contractapply;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DataEntityState;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.fileservice.extension.FileServiceExt;
import kd.bos.fileservice.extension.FileServiceExtFactory;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.DateEdit;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.cache.PageCache;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.url.UrlService;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hlcm.business.common.HLCMCommonRepository;
import kd.hr.hlcm.business.domian.repository.BosAttachmentRepository;
import kd.hr.hlcm.business.domian.repository.CommonRepository;
import kd.hr.hlcm.business.domian.repository.ContractSignApplyRepository;
import kd.hr.hlcm.business.domian.repository.LicenseRepository;
import kd.hr.hlcm.business.domian.service.hbpm.IHbpmService;
import kd.hr.hlcm.business.domian.service.signmgt.ISignManageService;
import kd.hr.hlcm.business.utils.CancelProtocolValidUtils;
import kd.hr.hlcm.business.utils.ContractDurationCalculateHelper;
import kd.hr.hlcm.business.utils.ContractSignUtils;
import kd.hr.hlcm.business.utils.ModelUtils;
import kd.hr.hlcm.business.utils.ProxyUtils;
import kd.hr.hlcm.business.vaildator.ContractSignValidatorFactory;
import kd.hr.hlcm.business.vaildator.IsOrgSameValidator;
import kd.hr.hlcm.business.vaildator.ValidatorBase;
import kd.hr.hlcm.business.vaildator.ValidatorHolder;
import kd.hr.hlcm.common.enums.AuditStatusEnum;
import kd.hr.hlcm.common.enums.BusinessTypeEnum;
import kd.hr.hlcm.common.enums.ContractPeriodTypeEnum;
import kd.hr.hlcm.common.enums.ContractStatusEnum;
import kd.hr.hlcm.common.enums.ContractTypeCatEnum;
import kd.hr.hlcm.common.enums.PostypeEnum;
import kd.hr.hlcm.common.enums.ProbationUnitEnum;
import kd.hr.hlcm.common.enums.ProtocolTypeEnum;
import kd.hr.hlcm.common.utils.HeadCardUtil;
import kd.hr.hlcm.formplugin.billapply.contractapply.ContractSignServiceHelper;
import kd.hr.hlcm.formplugin.utils.ContractFormTipUtils;
import kd.hr.hlcm.formplugin.utils.TerminateHelper;
import kd.hr.hlcm.formplugin.utils.WorkBenchHelper;
import org.apache.commons.lang3.tuple.ImmutablePair;

public class ContractSignFormPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final Log LOGGER = LogFactory.getLog(ContractSignFormPlugin.class);
    private static final String ACTUAL_SIGNCOMPANYHIS_DATA_ID = "actualsigncompanyhisdata_id";
    private static final String HLCM_CONTRACTAPPLYRENEW = "hlcm_contractapplyrenew";
    private static final String CONTRACT_TOP_DOWNLOAD_OP = "topcontractdownload";
    private static final String CONTRACT_TOP_PREVIEW_OP = "topcontractpreview";

    public void registerListener(EventObject e) {
        BasedataEdit entryContractType;
        MulBasedataEdit pro;
        BasedataEdit reasonType;
        BasedataEdit contracTemplate;
        BasedataEdit contractTemplate;
        super.registerListener(e);
        BasedataEdit erManFile = (BasedataEdit)this.getControl("ermanfile");
        if (Objects.nonNull(erManFile)) {
            erManFile.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if (Objects.nonNull(contractTemplate = (BasedataEdit)this.getControl("contracttemplate"))) {
            contractTemplate.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if (Objects.nonNull(contracTemplate = (BasedataEdit)this.getControl("contractemplate"))) {
            contracTemplate.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if (Objects.nonNull(reasonType = (BasedataEdit)this.getControl("cancelreasontype"))) {
            reasonType.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if (Objects.nonNull(pro = (MulBasedataEdit)this.getControl("otherprotocol"))) {
            pro.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if (Objects.nonNull(entryContractType = (BasedataEdit)this.getControl("entrycontracttype"))) {
            entryContractType.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void afterCreateNewData(EventObject e) {
        long ermanorgId;
        String htNumber;
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        String billFormId = view.getEntityId();
        String businessTypeEnum = ContractSignUtils.getBusinessTypeByBillFormId((String)billFormId);
        model.setValue("businesstype", (Object)businessTypeEnum);
        model.setValue("protocoltype", (Object)ProtocolTypeEnum.CON.getCombKey());
        List<String> businessType = Arrays.asList(BusinessTypeEnum.NEW.getCombKey(), BusinessTypeEnum.RENEW.getCombKey(), BusinessTypeEnum.CHANGE.getCombKey());
        if (businessType.contains(businessTypeEnum) && !HRStringUtils.isEmpty((String)(htNumber = ContractSignUtils.getNumber((String)billFormId, (boolean)false, (String)String.valueOf(ermanorgId = this.getModel().getDataEntity().getLong("ermanorg.id")))))) {
            String businessTypeByBillFormId = ContractSignUtils.getContractNameBySignBill((String)billFormId);
            view.setEnable(Boolean.valueOf(ContractSignUtils.codeRuleIsModify((String)businessTypeByBillFormId, (String)String.valueOf(ermanorgId))), new String[]{"contractnumber"});
            model.setValue("contractnumber", (Object)htNumber);
        }
        this.getModel().setValue("paneltype", (Object)"0");
        if (WorkBenchHelper.isWorkBenchSkip(this.getView())) {
            WorkBenchHelper.fillErmanFile(this.getView());
            ImmutablePair<Boolean, String> isPairValue = this.checkPersonPanelInfo();
            if (((Boolean)isPairValue.getLeft()).booleanValue() && HRStringUtils.isEmpty((String)((String)isPairValue.getRight()))) {
                this.setPersonPanelInfoAll();
            }
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
            entryEntity.forEach(entry -> {
                entry.getDataEntityState().setPushChanged(true);
                entry.getDataEntityState().setBizChanged(true);
            });
        }
    }

    public void preOpenForm(PreOpenFormEventArgs evt) {
        super.preOpenForm(evt);
        FormShowParameter formShowParameter = evt.getFormShowParameter();
        String showWay = (String)formShowParameter.getCustomParam("showway");
        if (formShowParameter.getStatus() == OperationStatus.EDIT || HRStringUtils.equals((String)"hstc", (String)showWay)) {
            formShowParameter.setStatus(OperationStatus.VIEW);
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        String businessType = this.getModel().getDataEntity().getString("businesstype");
        if ("1".equals(businessType) && OperationStatus.ADDNEW.equals((Object)status)) {
            LicenseRepository.getInstance().verifyCertCount(this.getView(), this.getView().getEntityId());
        }
        if (WorkBenchHelper.isWorkBenchSkip(this.getView())) {
            WorkBenchHelper.setFormTitle(this.getView());
        }
        String entityIdStr = this.getView().getEntityId();
        String signWay = this.getModel().getDataEntity().getString("signway");
        if (HRStringUtils.isNotEmpty((String)signWay) && ("hlcm_contractapplynew".equals(entityIdStr) || HLCM_CONTRACTAPPLYRENEW.equals(entityIdStr) || "hlcm_contractapplychange".equals(entityIdStr) || "hlcm_contractapplycancel".equals(entityIdStr))) {
            BasedataEdit contracTemplate = (BasedataEdit)this.getView().getControl("contractemplate");
            BasedataEdit contracttemplate = (BasedataEdit)this.getView().getControl("contracttemplate");
            BasedataEdit contracTemplatehis = (BasedataEdit)this.getView().getControl("contractemplatehis");
            BasedataEdit textHis = (BasedataEdit)this.getView().getControl("texthis");
            if ("1".equals(signWay)) {
                if (!"hlcm_contractapplycancel".equals(entityIdStr)) {
                    contracTemplate.setMustInput(true);
                    contracTemplatehis.setMustInput(true);
                }
                contracttemplate.setMustInput(true);
                textHis.setMustInput(true);
            } else {
                if (!"hlcm_contractapplycancel".equals(entityIdStr)) {
                    contracTemplate.setMustInput(false);
                    contracTemplatehis.setMustInput(false);
                }
                contracttemplate.setMustInput(false);
                textHis.setMustInput(false);
            }
        }
        if ("hlcm_contractapplynew".equals(entityIdStr) || HLCM_CONTRACTAPPLYRENEW.equals(entityIdStr) || "hlcm_contractapplychange".equals(entityIdStr) || "hlcm_contractapplycancel".equals(entityIdStr)) {
            IDataModel dataModel = this.getModel();
            DynamicObjectCollection entryEntities = dataModel.getEntryEntity("entryentity");
            for (int index = 0; index < entryEntities.size(); ++index) {
                DynamicObject entryEntity = (DynamicObject)entryEntities.get(index);
                if (this.isContractType(entryEntity)) {
                    LOGGER.info("Entry contract type:{}", (Object)index);
                    this.getModel().setValue("opperson", entryEntity.get("opperson"), index);
                    this.getView().setEnable(Boolean.valueOf(false), index, new String[]{"entrycontractnumber", "entrycontracttype", "entryperiodtype", "entrystartdate", "entryperiod", "entryperiodunit", "entryenddate", "contracttemplate", "texthis", "remark"});
                    Object contractTemplate = entryEntity.get("contracttemplate");
                    if (HRObjectUtils.isEmpty((Object)contractTemplate)) {
                        LOGGER.info("Entry contract type and ContractTemplate is empty:{}", (Object)index);
                        this.getView().setVisible(Boolean.valueOf(false), new String[]{"templatebtnflex"});
                        this.getView().setVisible(Boolean.valueOf(false), new String[]{"sidecontractflex"});
                        continue;
                    }
                    LOGGER.info("Entry contract type and ContractTemplate is not empty:{}", (Object)index);
                    String fileName = entryEntity.getString("attachmentfield1");
                    LOGGER.info("Entry contract type and fileName is : {}", (Object)fileName);
                    this.getView().setVisible(Boolean.valueOf(HRStringUtils.isNotEmpty((String)fileName)), new String[]{"templatebtnflex"});
                    this.getView().setVisible(Boolean.valueOf(HRStringUtils.isNotEmpty((String)fileName)), new String[]{"sidecontractflex"});
                    continue;
                }
                ContractSignUtils.updateEntryEndDateControlMustByPeriodType((IFormView)this.getView(), (DynamicObject)entryEntity, (int)index, (boolean)false);
            }
        }
    }

    public void afterBindData(EventObject e) {
        String entityIdStr;
        super.afterBindData(e);
        ContractSignUtils.updateEndDateControlMustByPeriodType((IFormView)this.getView(), (boolean)false);
        this.setPanelAndBtn(this.getView(), this.getModel().getDataEntity());
        if (WorkBenchHelper.isWorkBenchSkip(this.getView())) {
            WorkBenchHelper.setEnable(this.getView());
            if (this.getView().getFormShowParameter().getStatus() == OperationStatus.ADDNEW) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"employeeinfopanelap", "personcardinfopanelap"});
            }
        }
        if ("hlcm_contractapplynew".equals(entityIdStr = this.getView().getEntityId()) || HLCM_CONTRACTAPPLYRENEW.equals(entityIdStr) || "hlcm_contractapplychange".equals(entityIdStr)) {
            if (this.getView().getFormShowParameter().getStatus() == OperationStatus.ADDNEW) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"contractsigntemppanelap"});
            }
            Boolean isSignother = (Boolean)this.getModel().getValue("issignother");
            this.getView().setVisible(isSignother, new String[]{"contractsigntemppanelap"});
            TextEdit entryContractnumber = (TextEdit)this.getView().getControl("entrycontractnumber");
            BasedataEdit entryContracttype = (BasedataEdit)this.getView().getControl("entrycontracttype");
            BasedataEdit entryPeriodtype = (BasedataEdit)this.getView().getControl("entryperiodtype");
            DateEdit entryStartdate = (DateEdit)this.getView().getControl("entrystartdate");
            entryContractnumber.setMustInput(isSignother.booleanValue());
            entryContracttype.setMustInput(isSignother.booleanValue());
            entryPeriodtype.setMustInput(isSignother.booleanValue());
            entryStartdate.setMustInput(isSignother.booleanValue());
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        IDataEntityProperty property = evt.getProperty();
        ListFilterParameter listFilterParameter = ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter();
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(16);
        String propertyName = property.getName();
        int rowIndex = evt.getRow();
        if (HRStringUtils.equals((String)"contracttemplate", (String)propertyName)) {
            String signwayObj;
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
            ArrayList<String> contractNumbers = new ArrayList<String>(entryEntity.size());
            for (DynamicObject dy : entryEntity) {
                DynamicObject contractTemplateDy = (DynamicObject)dy.get("contracttemplate");
                if (HRObjectUtils.isEmpty((Object)contractTemplateDy)) continue;
                contractNumbers.add(contractTemplateDy.getString("number"));
            }
            qFilters.add(new QFilter("number", "not in", contractNumbers));
            DynamicObject contracttype = this.getModel().getDataEntity().getDynamicObject("contracttype");
            String entityId = this.getView().getEntityId();
            if ("hlcm_contractapplycancel".equals(entityId)) {
                if (HRObjectUtils.isEmpty((Object)contracttype)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5408\u540c\u7c7b\u578b\u3002", (String)"ContractSignFormPlugin_5", (String)"hr-hlcm-formplugin", (Object[])new Object[0]));
                    evt.setCancel(true);
                    return;
                }
                qFilters.add(new QFilter("contracttype.group", "=", (Object)ContractTypeCatEnum.OTHER.getPkId()));
                qFilters.add(new QFilter("contracttype.name", "=", (Object)contracttype.getString("name")));
                listFilterParameter.setQFilters(qFilters);
                return;
            }
            qFilters.add(new QFilter("contracttype.group", "=", (Object)ContractTypeCatEnum.OTHER.getPkId()));
            DynamicObject entryDY = (DynamicObject)entryEntity.get(rowIndex);
            DynamicObject contractTypeDy = (DynamicObject)entryDY.get("entrycontracttype");
            if (!HRObjectUtils.isEmpty((Object)contractTypeDy)) {
                qFilters.add(new QFilter("contracttype.id", "=", contractTypeDy.get("id")));
            }
            if (!HRStringUtils.isEmpty((String)(signwayObj = (String)this.getModel().getValue("signway")))) {
                String separator = ",";
                String signwayFilter = separator.concat(signwayObj).concat(separator);
                qFilters.add(new QFilter("signway", "ftlike", (Object)signwayFilter));
            }
            qFilters.add(new QFilter("enable", "=", (Object)"1"));
            qFilters.add(new QFilter("status", "=", (Object)AuditStatusEnum.STATUS_AUDITED.getCode()));
            listFilterParameter.setQFilters(qFilters);
        } else if (HRStringUtils.equals((String)"cancelreasontype", (String)propertyName)) {
            Map customParams = evt.getFormShowParameter().getCustomParams();
            customParams.put("islistfilter", this.getView().getEntityId());
            evt.getFormShowParameter().setCustomParams(customParams);
        } else if (HRStringUtils.equals((String)"contractemplate", (String)propertyName)) {
            String signwayObj;
            qFilters.add(new QFilter("contracttype.group", "=", (Object)ContractTypeCatEnum.CON.getPkId()));
            DynamicObject contractTypeDy = (DynamicObject)this.getModel().getValue("contracttype");
            if (!HRObjectUtils.isEmpty((Object)contractTypeDy)) {
                qFilters.add(new QFilter("contracttype.id", "=", contractTypeDy.get("id")));
            }
            if (!HRStringUtils.isEmpty((String)(signwayObj = (String)this.getModel().getValue("signway")))) {
                String separator = ",";
                String signwayFilter = separator.concat(signwayObj).concat(separator);
                qFilters.add(new QFilter("signway", "ftlike", (Object)signwayFilter));
            }
            qFilters.add(new QFilter("enable", "=", (Object)"1"));
            qFilters.add(new QFilter("status", "=", (Object)AuditStatusEnum.STATUS_AUDITED.getCode()));
            listFilterParameter.setQFilters(qFilters);
        } else if (HRStringUtils.equals((String)"otherprotocol", (String)propertyName)) {
            qFilters.add(new QFilter("protocoltype", "=", (Object)ProtocolTypeEnum.FS.getCombKey()));
            qFilters.add(new QFilter("person", "=", (Object)this.getModel().getDataEntity().getLong(String.format(Locale.ROOT, "%s_id", "person"))));
            qFilters.add(new QFilter("contractstatus", "in", (Object)new String[]{ContractStatusEnum.STATUS_IN_EFFECT.getCode(), ContractStatusEnum.STATUS_PENDING.getCode()}));
            qFilters.add(new QFilter("iscurrentversion", "=", (Object)"1"));
            listFilterParameter.setQFilters(qFilters);
        } else if (HRStringUtils.equals((String)"entrycontracttype", (String)propertyName)) {
            qFilters.add(new QFilter("group", "=", (Object)ContractTypeCatEnum.OTHER.getPkId()));
            listFilterParameter.setQFilters(qFilters);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        FormOperate source = (FormOperate)args.getSource();
        String operateKey = source.getOperateKey();
        IFormView view = this.getView();
        if (operateKey.equals("perterminate")) {
            TerminateHelper.terminateValidate(this.getView(), "", (IFormPlugin)this, args);
        } else if (HRStringUtils.equals((String)operateKey, (String)"save")) {
            this.setCompanyAndHisInfo();
            ContractSignUtils.validateFixedMustInput((DynamicObject)this.getModel().getDataEntity()).ifPresent(validateMsg -> {
                args.setCancel(true);
                this.getView().showTipNotification(validateMsg);
            });
            this.setEntryEmptyWhenNoSignOther(false);
        } else if (HRStringUtils.equals((String)operateKey, (String)"modify")) {
            long ermanorgId = this.getModel().getDataEntity().getLong("ermanorg.id");
            view.setEnable(Boolean.valueOf(ContractSignUtils.codeRuleIsModify((String)"hlcm_contract", (String)String.valueOf(ermanorgId))), new String[]{"contractnumber"});
        } else {
            LOGGER.info("operateKey|{}", (Object)operateKey);
        }
    }

    private void setEntryEmptyWhenNoSignOther(boolean updateView) {
        String entityId = this.getView().getEntityId();
        if ("hlcm_contractapplycancel".equals(entityId) && !this.getModel().getDataEntity().getBoolean("issignprotocol")) {
            DynamicObjectCollection entryentity = this.getModel().getEntryEntity("entryentity");
            for (int i = entryentity.size() - 1; i >= 0; --i) {
                this.getModel().setValue("contracttemplate", null, i);
                this.getModel().deleteEntryRow("entryentity", i);
            }
            if (updateView) {
                this.getView().updateView("entryentity");
            }
            this.getModel().setValue("signeddate", null);
            this.getModel().setValue("contracttype", null);
            this.getModel().setValue("signway", null);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        IDataModel dataModel = this.getModel();
        DynamicObject entity = this.getModel().getDataEntity();
        if (!(args.getOperationResult() == null || !args.getOperationResult().isSuccess() || HRStringUtils.equals((String)"preunsubmit", (String)operateKey) || HRStringUtils.equals((String)"presubmiteffect", (String)operateKey) || HRStringUtils.equals((String)"presubmit", (String)operateKey) || HRStringUtils.equals((String)"perterminate", (String)operateKey) || HRStringUtils.equals((String)"refresh", (String)operateKey))) {
            if (Arrays.asList("save", "submit", "submiteffect").contains(operateKey)) {
                this.getView().setStatus(OperationStatus.VIEW);
                this.getView().cacheFormShowParameter();
                this.getView().updateView();
                this.getView().updateView("entryentity");
                this.getView().invokeOperation("refresh");
            } else if (HRStringUtils.equals((String)operateKey, (String)CONTRACT_TOP_DOWNLOAD_OP)) {
                String attachmentUrl = this.getContractAttachmentUrl(true);
                if (HRStringUtils.isEmpty((String)attachmentUrl)) {
                    return;
                }
                String downloadRealUrl = ProxyUtils.attachmentDownloadRealUrl((String)attachmentUrl);
                IClientViewProxy clientViewProxy = (IClientViewProxy)dataModel.getService(IClientViewProxy.class);
                clientViewProxy.addAction("download", (Object)downloadRealUrl);
            } else if (HRStringUtils.equals((String)operateKey, (String)CONTRACT_TOP_PREVIEW_OP)) {
                String attachmentUrl = this.getContractAttachmentUrl(false);
                String previewRealUrl = ProxyUtils.attachmentPreviewRealUrl((String)attachmentUrl);
                this.getView().openUrl(previewRealUrl);
            } else {
                this.setPanelAndBtn(this.getView(), entity);
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        ArrayList asList = Lists.newArrayList((Object[])new String[]{"crossquiteactionId", "crosstransferactionId", "crossretireactionId", "existfutureactionid"});
        MessageBoxResult result = messageBoxClosedEvent.getResult();
        if (result == MessageBoxResult.Yes) {
            if (HRStringUtils.equals((String)callBackId, (String)"unsubmitactionId")) {
                this.getPageCache().put(callBackId, callBackId);
                this.getView().invokeOperation("unsubmit");
            }
            if (asList.contains(callBackId)) {
                this.getPageCache().put(callBackId, callBackId);
                this.getCrossInfo();
            }
        } else if (result == MessageBoxResult.Cancel) {
            if (asList.contains(callBackId)) {
                this.clearPersonInfo();
            }
        } else {
            LOGGER.warn("result|{}", (Object)result);
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String propertyName = args.getProperty().getName();
        ContractDurationCalculateHelper.getInstance().calcContractDurationRelatedFields(this.getModel(), propertyName);
        switch (propertyName) {
            case "ermanfile": {
                ImmutablePair<Boolean, String> isPairValue = this.checkPersonPanelInfo();
                if (!((Boolean)isPairValue.getLeft()).booleanValue() || !HRStringUtils.isEmpty((String)((String)isPairValue.getRight()))) break;
                this.setPersonPanelInfoAll();
                break;
            }
            case "startdate": {
                boolean isValue = ContractSignUtils.setStartDateAndEndDateInfo((IFormView)this.getView());
                if (isValue) {
                    this.checkStartDateInfo();
                }
                this.setEntryContractInfo();
                break;
            }
            case "enddate": {
                boolean isValue = ContractSignUtils.setStartDateAndEndDateInfo((IFormView)this.getView());
                if (isValue) {
                    this.checkEndDateInfo();
                }
                this.setEntryContractInfo();
                break;
            }
            case "period": 
            case "periodunit": {
                this.checkEndDateInfo();
                this.setEntryContractInfo();
                break;
            }
            case "periodtype": {
                ContractSignUtils.updateEndDateControlMustByPeriodType((IFormView)this.getView(), (boolean)true);
                this.checkPeriodTypeInfo();
                this.setEntryContractInfo();
                break;
            }
            case "canceldate": {
                this.checkCancelDateInfo();
                break;
            }
            case "signeddate": {
                this.checkSignDateInfo();
                break;
            }
            case "actualsigncompany": {
                this.setCompanyAndHisInfo();
                break;
            }
            case "cardnumber": {
                String msg;
                HashSet contractEntityIds = Sets.newHashSet((Object[])new String[]{"hlcm_contractapplycancel", "hlcm_contractapplyend"});
                String entityId = this.getView().getEntityId();
                if (contractEntityIds.contains(entityId) || !HRStringUtils.isNotEmpty((String)(msg = ContractSignApplyRepository.getInstance().checkIDCard(this.getView().getModel().getDataEntity())))) break;
                this.getView().showErrorNotification(msg);
                break;
            }
            case "cardtype": {
                this.getModel().setValue("cardnumber", (Object)"");
                break;
            }
            case "signway": {
                DynamicObject dataEntity = this.getModel().getDataEntity();
                String signWay = dataEntity.getString("signway");
                String entityIdStr = this.getView().getEntityId();
                if (HRStringUtils.isNotEmpty((String)signWay) && "hlcm_contractapplycancel".equals(entityIdStr)) {
                    String existMultiEntry = CancelProtocolValidUtils.getInstance().isExistMultiEntry(dataEntity, ProtocolTypeEnum.loadKDStringByKey((String)"1"));
                    if (HRStringUtils.isNotEmpty((String)existMultiEntry)) {
                        this.getView().showTipNotification(existMultiEntry);
                    }
                    if ("1".equals(signWay)) {
                        this.getModel().setValue("empphone", (Object)dataEntity.getString("oldempphone"));
                        this.getModel().setValue("actualsigndate", null);
                        this.getView().setVisible(Boolean.FALSE, new String[]{"actualsigndate"});
                    } else if ("2".equals(signWay)) {
                        this.getView().setVisible(Boolean.TRUE, new String[]{"actualsigndate"});
                    }
                    this.getView().setEnable(Boolean.valueOf("2".equals(signWay)), new String[]{"empphone"});
                }
                if ((!HRStringUtils.isNotEmpty((String)signWay) || !"hlcm_contractapplynew".equals(entityIdStr) && !HLCM_CONTRACTAPPLYRENEW.equals(entityIdStr) && !"hlcm_contractapplychange".equals(entityIdStr)) && !"hlcm_contractapplycancel".equals(entityIdStr)) break;
                BasedataEdit contracTemplate = (BasedataEdit)this.getView().getControl("contractemplate");
                BasedataEdit contracttemplate = (BasedataEdit)this.getView().getControl("contracttemplate");
                BasedataEdit contracTemplatehis = (BasedataEdit)this.getView().getControl("contractemplatehis");
                BasedataEdit textHis = (BasedataEdit)this.getView().getControl("texthis");
                if ("1".equals(signWay)) {
                    if (!"hlcm_contractapplycancel".equals(entityIdStr)) {
                        contracTemplate.setMustInput(true);
                        contracTemplatehis.setMustInput(true);
                    }
                    contracttemplate.setMustInput(true);
                    textHis.setMustInput(true);
                    break;
                }
                if (!"hlcm_contractapplycancel".equals(entityIdStr)) {
                    contracTemplate.setMustInput(false);
                    contracTemplatehis.setMustInput(false);
                }
                contracttemplate.setMustInput(false);
                textHis.setMustInput(false);
                break;
            }
            case "issignprotocol": {
                this.setEntryEmptyWhenNoSignOther(true);
                break;
            }
            case "issignother": {
                this.isSignotherChange();
                break;
            }
            case "contractemplate": {
                DynamicObject contractTemplate = (DynamicObject)this.getModel().getValue("contractemplate");
                if (contractTemplate != null) {
                    this.getModel().setValue("contracttype", (Object)contractTemplate.getDynamicObject("contracttype"));
                    long vid = contractTemplate.getLong("vid");
                    this.getModel().setValue("contractemplatehis", (Object)vid);
                } else {
                    this.getModel().setValue("contractemplatehis", null);
                }
                this.setEntryContractInfo();
                break;
            }
            case "contractnumber": 
            case "contracttype": {
                this.setEntryContractInfo();
                break;
            }
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        if (this.isNotView()) {
            List<String> uncheckField = this.getUnCheckField();
            DataEntityState dataEntityState = this.getModel().getDataEntity().getDataEntityState();
            Iterable bizChangedProperties = dataEntityState.getBizChangedProperties();
            for (IDataEntityProperty iDataEntityProperty : bizChangedProperties) {
                String name = iDataEntityProperty.getName();
                if (!uncheckField.contains(name)) continue;
                dataEntityState.setBizChanged(iDataEntityProperty.getOrdinal(), false);
            }
            bizChangedProperties = dataEntityState.getBizChangedProperties();
            if (!bizChangedProperties.iterator().hasNext()) {
                this.getModel().setDataChanged(false);
            }
        } else {
            this.getModel().setDataChanged(false);
        }
    }

    private void isSignotherChange() {
        Boolean isSignother = (Boolean)this.getModel().getValue("issignother");
        String entityIdStr = this.getView().getEntityId();
        if ("hlcm_contractapplynew".equals(entityIdStr) || HLCM_CONTRACTAPPLYRENEW.equals(entityIdStr) || "hlcm_contractapplychange".equals(entityIdStr)) {
            this.getView().setVisible(isSignother, new String[]{"contractsigntemppanelap"});
            TextEdit entryContractnumber = (TextEdit)this.getView().getControl("entrycontractnumber");
            BasedataEdit entryContracttype = (BasedataEdit)this.getView().getControl("entrycontracttype");
            BasedataEdit entryPeriodtype = (BasedataEdit)this.getView().getControl("entryperiodtype");
            DateEdit entryStartdate = (DateEdit)this.getView().getControl("entrystartdate");
            entryContractnumber.setMustInput(isSignother.booleanValue());
            entryContracttype.setMustInput(isSignother.booleanValue());
            entryPeriodtype.setMustInput(isSignother.booleanValue());
            entryStartdate.setMustInput(isSignother.booleanValue());
        }
    }

    private List<String> getUnCheckField() {
        ArrayList unCheckField = Lists.newArrayList();
        unCheckField.add("crossaction");
        unCheckField.add("paneltype");
        unCheckField.add("probationperiodunit");
        unCheckField.add("probationstartdate");
        unCheckField.add("probationenddate");
        unCheckField.add(ACTUAL_SIGNCOMPANYHIS_DATA_ID);
        unCheckField.add("empnumber");
        unCheckField.add("signedcompanyhis");
        unCheckField.add("departmenthis");
        unCheckField.add("postionhis");
        unCheckField.add("actualsigncompanyhis_id");
        unCheckField.add("suggestsigncomphis_id");
        unCheckField.add("postype_id");
        DynamicObject erManFile = (DynamicObject)this.getModel().getValue("ermanfile");
        if (HRObjectUtils.isEmpty((Object)erManFile)) {
            unCheckField.add("ermanfile_id");
        }
        return unCheckField;
    }

    private void checkStartDateInfo() {
        ImmutablePair validateResult;
        DynamicObject erManFile = (DynamicObject)this.getModel().getValue("ermanfile");
        if (HRObjectUtils.isEmpty((Object)erManFile)) {
            return;
        }
        DynamicObject dataEntity = this.getModel().getDataEntity();
        ContractSignApplyRepository instance = ContractSignApplyRepository.getInstance();
        if (this.isBusinessTypeNew()) {
            validateResult = instance.isCheckContractUseStartDate(dataEntity);
            boolean notPass = this.showErrorMsg((ImmutablePair<Boolean, String>)validateResult);
            if (notPass) {
                return;
            }
            String contractPeriodResult = instance.isCheckContractPeriod(dataEntity);
            if (HRStringUtils.isNotEmpty((String)contractPeriodResult)) {
                this.getView().showTipNotification(contractPeriodResult);
            }
        }
        if (this.isBusinessTypeRenew()) {
            validateResult = instance.isDateStartOldEndValidate(dataEntity);
            this.showErrorMsg((ImmutablePair<Boolean, String>)validateResult);
        }
        if (this.isBusinessTypeChange()) {
            String errorMsg = instance.isDateStartOldStartValidate(dataEntity);
            this.handleErrorMsg(errorMsg, instance.isDateStartOldEnd2Validate(dataEntity));
        }
    }

    private void handleErrorMsg(String errorMsg, String dateStartOldEnd2Validate) {
        if (!HRStringUtils.isEmpty((String)errorMsg)) {
            this.getView().showTipNotification(errorMsg);
            return;
        }
        errorMsg = dateStartOldEnd2Validate;
        if (!HRStringUtils.isEmpty((String)errorMsg)) {
            this.getView().showTipNotification(errorMsg);
            return;
        }
    }

    private void checkEndDateInfo() {
        String errorMsg;
        DynamicObject erManFile = (DynamicObject)this.getModel().getValue("ermanfile");
        if (HRObjectUtils.isEmpty((Object)erManFile)) {
            return;
        }
        DynamicObject dataEntity = this.getModel().getDataEntity();
        ContractSignApplyRepository instance = ContractSignApplyRepository.getInstance();
        if (this.isBusinessTypeNew() && !HRStringUtils.isEmpty((String)(errorMsg = instance.isCheckContractPeriod(dataEntity)))) {
            this.getView().showTipNotification(errorMsg);
            return;
        }
        errorMsg = instance.isDateEndSignValidate(dataEntity);
        if (!HRStringUtils.isEmpty((String)errorMsg)) {
            this.getView().showErrorNotification(errorMsg);
        }
    }

    private void checkCancelDateInfo() {
        String errorMsg;
        DynamicObject erManFile = (DynamicObject)this.getModel().getValue("ermanfile");
        if (HRObjectUtils.isEmpty((Object)erManFile)) {
            return;
        }
        DynamicObject dataEntity = this.getModel().getDataEntity();
        ContractSignApplyRepository instance = ContractSignApplyRepository.getInstance();
        if ((this.isBusinessTypeCancel() || this.isBusinessTypeStop()) && !HRStringUtils.isEmpty((String)(errorMsg = instance.isDateStartOldEnd3Validate(dataEntity)))) {
            this.getView().showErrorNotification(errorMsg);
        }
    }

    private void setPersonPanelInfoAll() {
        this.setPersonPanelInfo();
        if (this.isBusinessTypeRenew()) {
            this.setOldContractInfo();
        } else if (this.isBusinessTypeChange()) {
            this.setOldContractInfo();
        } else if (this.isBusinessTypeCancel() || this.isBusinessTypeStop()) {
            this.propertyChangedCancelContractInfo();
        } else {
            LOGGER.info("businessType is not Renew,Change,Cancel,Stop");
        }
        boolean workBenchSkip = WorkBenchHelper.isWorkBenchSkip(this.getView());
        ContractSignUtils.propertyChangedOldContractSignStatus((IFormView)this.getView(), (!workBenchSkip ? 1 : 0) != 0);
        this.setRenewCount();
        ContractSignServiceHelper.getInstance().setContractInfoByRuleEngine(this.getView(), this.getModel(), "ermanfile");
    }

    private void setPersonPanelInfo() {
        DynamicObject erManFile = (DynamicObject)this.getModel().getValue("ermanfile");
        Long erManFileId = (Long)erManFile.getPkValue();
        HeadCardUtil.showSignPersonHead((IFormView)this.getView(), (Object)erManFileId);
        this.setPersonInfo(erManFileId);
        this.getModel().setValue("paneltype", (Object)"1");
        this.getModel().setValue("employee", (Object)erManFile.getDynamicObject("employee"));
    }

    private void checkPeriodTypeInfo() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObject periodTypeDy = dataEntity.getDynamicObject("periodtype");
        if (HRObjectUtils.isEmpty((Object)periodTypeDy)) {
            return;
        }
        long posTypeId = dataEntity.getLong("postype.id");
        Object periodTypeId = periodTypeDy.getPkValue();
        if (this.isBusinessTypeNew()) {
            if (Objects.equals(posTypeId, PostypeEnum.EXPATRIATE.getCombKey())) {
                return;
            }
            String empName = dataEntity.getString("empname");
            String periodTypeName = periodTypeDy.getString("name");
            BigDecimal probationPeriod = dataEntity.getBigDecimal("probationperiod");
            String probationPeriodUnit = dataEntity.getString("probationperiodunit");
            if (Objects.equals(periodTypeId, ContractPeriodTypeEnum.COMPTASK.getPkId()) && probationPeriod != null && probationPeriod.compareTo(BigDecimal.ZERO) > 0) {
                String tip = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u5f53\u524d\u5408\u540c\u671f\u9650\u7c7b\u578b\u4e3a%1$s\uff0c\u4e0d\u5f97\u7ea6\u5b9a\u8bd5\u7528\u671f\uff0c\u68c0\u6d4b\u5230%2$s\u8bd5\u7528\u671f\u9650\u4e3a%3$s\uff0c\u8bf7\u8c03\u6574\u3002", (String)"ContractSignFormPlugin_3", (String)"hr-hlcm-formplugin", (Object[])new Object[0]), periodTypeName, empName, probationPeriodUnit);
                this.getView().showTipNotification(tip);
            }
            if (Objects.equals(periodTypeId, ContractPeriodTypeEnum.NONFIXED.getPkId())) {
                BigDecimal probationPeriodMonth = ContractSignUtils.calcProbationPeriodMonth((DynamicObject)dataEntity);
                if (probationPeriod != null && probationPeriodMonth.compareTo(new BigDecimal(6)) > 0) {
                    String tip = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u5f53\u524d\u5408\u540c\u671f\u9650\u7c7b\u578b\u4e3a%1$s\uff0c\u8bd5\u7528\u671f\u4e0d\u5f97\u8d85\u8fc76\u4e2a\u6708\uff0c\u68c0\u6d4b\u5230%2$s\u8bd5\u7528\u671f\u9650\u4e3a%3$s\uff0c\u8bf7\u8c03\u6574\u3002", (String)"ContractSignFormPlugin_4", (String)"hr-hlcm-formplugin", (Object[])new Object[0]), periodTypeName, empName, probationPeriodUnit);
                    this.getView().showTipNotification(tip);
                }
            }
        }
        String businessType = dataEntity.getString("businesstype");
        int renewCount = dataEntity.getInt("renewcount");
        if (HRStringUtils.equals((String)businessType, (String)BusinessTypeEnum.RENEW.getCombKey()) && renewCount >= 2 && !Objects.equals(periodTypeId, ContractPeriodTypeEnum.NONFIXED.getPkId())) {
            String renewCountTip = ResManager.loadKDString((String)"\u6839\u636e\u300a\u4e2d\u534e\u4eba\u6c11\u5171\u548c\u56fd\u52b3\u52a8\u5408\u540c\u6cd5\u300b\uff0c\u8fde\u7eed\u8ba2\u7acb\u4e8c\u6b21\u56fa\u5b9a\u671f\u9650\u52b3\u52a8\u5408\u540c\u540e\uff0c\u9664\u7279\u6b8a\u60c5\u5f62\uff0c\u5e94\u5f53\u8ba2\u7acb\u65e0\u56fa\u5b9a\u671f\u9650\u52b3\u52a8\u5408\u540c\u3002", (String)"ContractSignFormPlugin_2", (String)"hr-hlcm-formplugin", (Object[])new Object[0]);
            this.getView().showTipNotification(renewCountTip);
        }
    }

    private void setCompanyAndHisInfo() {
        DynamicObject actualSignCompanyDy = (DynamicObject)this.getModel().getDataEntity().get("actualsigncompany");
        if (HRObjectUtils.isEmpty((Object)actualSignCompanyDy)) {
            return;
        }
        this.getModel().setValue("actualsigncompanyhis", (Object)actualSignCompanyDy.getLong("vid"));
    }

    private void setPersonInfo(Long erManFileId) {
        Date startDate;
        IDataModel model = this.getModel();
        Map personInfo = ContractSignUtils.getPersonInfoByErManFile((Long)erManFileId);
        model.setValue("empname", personInfo.get("empname"));
        model.setValue("empnumber", personInfo.get("empnumber"));
        model.setValue("postype", personInfo.get("postype"));
        if (this.isBusinessTypeNew() && !HRObjectUtils.isEmpty((Object)(startDate = (Date)personInfo.get("startdate")))) {
            ModelUtils.setDateValue((String)"startdate", (Date)startDate, (IDataModel)model);
            model.setValue("usestartdate", (Object)startDate);
        }
        Long personId = (Long)personInfo.get("person_id");
        model.setValue("person", (Object)personId);
        model.setValue("empphone", personInfo.get("empphone"));
        if (this.isBusinessTypeCancel()) {
            model.setValue("oldempphone", personInfo.get("empphone"));
        }
        model.setValue("baselocation", personInfo.get("location_id"));
        model.setValue("nation", personInfo.get("nationality_id"));
        Long cardTypeId = (Long)personInfo.get("cardtype");
        model.setValue("cardtype", (Object)cardTypeId);
        String cardNumber = (String)personInfo.get("cardnumber");
        model.setValue("cardnumber", (Object)cardNumber);
        Integer probationPeriod = (Integer)personInfo.get("probationperiod");
        Date preRegularDate = (Date)personInfo.get("probationenddate");
        if (!Objects.isNull(probationPeriod) && probationPeriod != 0 && !Objects.isNull(preRegularDate)) {
            model.setValue("probationstartdate", personInfo.get("probationstartdate"));
            model.setValue("probationenddate", (Object)HRDateTimeUtils.getBeforeDay((Date)preRegularDate));
            model.setValue("probationperiod", personInfo.get("probationperiod"));
            model.setValue("probationunit", personInfo.get("probationperiodunit"));
            model.setValue("probationperiodunit", (Object)(personInfo.get("probationperiod") + ProbationUnitEnum.getValueByKey((String)((String)personInfo.get("probationperiodunit")))));
        }
        model.setValue("householdregister", personInfo.get("householdregister"));
        model.setValue("residentialaddress", personInfo.get("residentialaddress"));
        Long companyId = (Long)personInfo.get("signedcompany");
        IHbpmService instance = IHbpmService.getInstance();
        model.setValue("signedcompanyhis", (Object)instance.getAdminOrgHis(companyId));
        model.setValue("curcompany", (Object)companyId);
        Long departmentId = (Long)personInfo.get("department");
        model.setValue("departmenthis", (Object)instance.getAdminOrgHis(departmentId));
        model.setValue("curdept", (Object)departmentId);
        Long positionId = (Long)personInfo.get("position");
        model.setValue("postionhis", (Object)instance.getPosHis(positionId));
        model.setValue("curpostion", (Object)positionId);
        Long stdPositionId = (Long)personInfo.get("stdposition");
        model.setValue("stdpostionhis", (Object)instance.getStdPosHis(stdPositionId));
        model.setValue("curstdpostion", (Object)stdPositionId);
        Long jobId = (Long)personInfo.get("job");
        model.setValue("job", (Object)instance.getJobHis(jobId));
        model.setValue("curjob", (Object)jobId);
        Long orgId = (Long)personInfo.get("org_id");
        model.setValue("ermanorg", (Object)orgId);
        Long affiliateAdminOrgId = (Long)personInfo.get("affiliateadminorg_id");
        model.setValue("adminororg", (Object)affiliateAdminOrgId);
        Long empGroupId = (Long)personInfo.get("empgroup_id");
        model.setValue("ermanperorg", (Object)empGroupId);
        this.getView().setVisible(Boolean.TRUE, new String[]{"personcardinfopanelap", "employeeinfopanelap"});
    }

    private void clearPersonInfo() {
        ContractSignServiceHelper.getInstance().clearBillInfo(this.getView(), this.getModel());
        this.getModel().setValue("paneltype", (Object)"0");
        this.getModel().setValue("ermanfile", null);
        PageCache cache = (PageCache)this.getView().getService(IPageCache.class);
        cache.put("crossquiteactionId", null);
        cache.put("crosstransferactionId", null);
        cache.put("crossretireactionId", null);
        cache.put("existfutureactionid", null);
        this.getView().setVisible(Boolean.FALSE, new String[]{"personcardinfopanelap", "employeeinfopanelap"});
    }

    private boolean isNotView() {
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        return status != OperationStatus.VIEW;
    }

    private boolean isBusinessTypeNew() {
        String businessType = this.getModel().getDataEntity().getString("businesstype");
        return HRStringUtils.equals((String)BusinessTypeEnum.NEW.getCombKey(), (String)businessType);
    }

    private boolean isBusinessTypeRenew() {
        String businessType = this.getModel().getDataEntity().getString("businesstype");
        return HRStringUtils.equals((String)BusinessTypeEnum.RENEW.getCombKey(), (String)businessType);
    }

    private boolean isBusinessTypeChange() {
        String businessType = this.getModel().getDataEntity().getString("businesstype");
        return HRStringUtils.equals((String)BusinessTypeEnum.CHANGE.getCombKey(), (String)businessType);
    }

    private boolean isBusinessTypeCancel() {
        String businessType = this.getModel().getDataEntity().getString("businesstype");
        return HRStringUtils.equals((String)BusinessTypeEnum.CANCEL.getCombKey(), (String)businessType);
    }

    private boolean isBusinessTypeStop() {
        String businessType = this.getModel().getDataEntity().getString("businesstype");
        return HRStringUtils.equals((String)BusinessTypeEnum.STOP.getCombKey(), (String)businessType);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId = closedCallBackEvent.getActionId();
        if (HRStringUtils.equals((String)actionId, (String)"terminateOperation")) {
            ContractFormTipUtils.getInstance().showTerminateTip(closedCallBackEvent, this.getView());
        }
    }

    private void checkSignDateInfo() {
        DynamicObject erManFile = (DynamicObject)this.getModel().getValue("ermanfile");
        if (HRObjectUtils.isEmpty((Object)erManFile)) {
            return;
        }
        DynamicObject dataEntity = this.getModel().getDataEntity();
        ContractSignApplyRepository instance = ContractSignApplyRepository.getInstance();
        String errorMsg = instance.isDateEndSignValidate(dataEntity);
        if (!HRStringUtils.isEmpty((String)errorMsg)) {
            this.getView().showErrorNotification(errorMsg);
        }
    }

    private ImmutablePair<Boolean, String> checkPersonPanelInfo() {
        String errorMsg;
        ImmutablePair immutablePair = ImmutablePair.of((Object)Boolean.FALSE, (Object)"");
        DynamicObject erManFile = (DynamicObject)this.getModel().getValue("ermanfile");
        if (HRObjectUtils.isEmpty((Object)erManFile)) {
            this.clearPersonInfo();
            return immutablePair;
        }
        ValidatorHolder isOrgSameHolder = new ValidatorHolder(this.getModel().getDataEntity());
        isOrgSameHolder.addValidator((ValidatorBase)new IsOrgSameValidator());
        Object msg = isOrgSameHolder.startValidate();
        if (msg != null && !HRStringUtils.isEmpty((String)(errorMsg = (String)String.class.cast(msg)))) {
            this.clearPersonInfo();
            this.getView().showErrorNotification(errorMsg);
            return immutablePair;
        }
        ContractSignServiceHelper.getInstance().clearBillInfo(this.getView(), this.getModel());
        String erManFileId = String.valueOf(erManFile.getPkValue());
        String erCache = this.getPageCache().get("pagecacheermanfileid");
        if (!HRStringUtils.equals((String)erCache, (String)erManFileId)) {
            this.getPageCache().put("crossquiteactionId", null);
            this.getPageCache().put("crosstransferactionId", null);
            this.getPageCache().put("crossretireactionId", null);
            this.getPageCache().put("existfutureactionid", null);
            if (this.isBusinessTypeNew()) {
                this.getModel().setValue("usestartdate", null);
            }
            if (this.isBusinessTypeCancel()) {
                this.getModel().setValue("canceldate", null);
            }
        }
        this.getPageCache().put("pagecacheermanfileid", erManFileId);
        if (this.isNotView()) {
            String errorMsg2;
            ValidatorHolder importValidatorHolder = ContractSignValidatorFactory.getManualValidatorHolder((DynamicObject)this.getModel().getDataEntity(true));
            Object error = importValidatorHolder.startValidate();
            if (error != null && !HRStringUtils.isEmpty((String)(errorMsg2 = (String)String.class.cast(error)))) {
                this.clearPersonInfo();
                this.getView().showErrorNotification(errorMsg2);
                return immutablePair;
            }
            return this.getCrossInfo();
        }
        return ImmutablePair.of((Object)Boolean.TRUE, (Object)"");
    }

    private ImmutablePair<Boolean, String> getCrossInfo() {
        ValidatorHolder importValidatorHolder = ContractSignValidatorFactory.getValidatorHolderWeakConfirm((DynamicObject)this.getModel().getDataEntity(), (IPageCache)this.getPageCache());
        if (CollectionUtils.isEmpty((Collection)importValidatorHolder.getValidators())) {
            this.setPersonPanelInfoAll();
            return ImmutablePair.of((Object)Boolean.FALSE, (Object)"");
        }
        DynamicObject signObj = importValidatorHolder.getSignObj();
        String crossAction = signObj.getString("crossaction");
        Object error = importValidatorHolder.startValidate();
        String crossTypeId = ContractSignServiceHelper.getInstance().getCrossIdTypeByCrossType(crossAction);
        if (error != null) {
            String errorMsg = (String)String.class.cast(error);
            if (!HRStringUtils.isEmpty((String)errorMsg)) {
                this.getView().showConfirm(errorMsg, MessageBoxOptions.OKCancel, new ConfirmCallBackListener(crossTypeId, (IFormPlugin)this));
                return ImmutablePair.of((Object)Boolean.TRUE, (Object)errorMsg);
            }
        } else {
            this.getPageCache().put(crossTypeId, crossTypeId);
            return this.getCrossInfo();
        }
        return ImmutablePair.of((Object)Boolean.TRUE, (Object)"");
    }

    private void setPanelAndBtn(IFormView view, DynamicObject signDy) {
        if (!HRObjectUtils.isEmpty((Object)signDy)) {
            DynamicObject signDynamicObject = ContractSignApplyRepository.getInstance().getSignStatusDynamicObject(signDy);
            signDy.set("handlestatus", (Object)signDynamicObject.getString("handlestatus"));
            signDy.set("billstatus", (Object)signDynamicObject.getString("billstatus"));
            signDy.set("isexistsworkflow", (Object)signDynamicObject.getBoolean("isexistsworkflow"));
        }
        ContractSignServiceHelper.getInstance().setPersonCardMain(view, this.getModel(), signDy);
        if (this.isBusinessTypeStop() || this.isBusinessTypeCancel()) {
            ContractSignServiceHelper.getInstance().setPersonCardStop(view, this.getModel(), signDy);
            this.setCancelContractInfo();
            if (this.isBusinessTypeCancel()) {
                String signWay = signDy.getString("signway");
                if ("1".equals(signWay)) {
                    this.getView().setEnable(Boolean.FALSE, new String[]{"empphone"});
                } else {
                    this.getView().setEnable(Boolean.TRUE, new String[]{"empphone"});
                }
            }
        } else if (this.isBusinessTypeRenew() || this.isBusinessTypeChange()) {
            ContractSignServiceHelper.getInstance().setPersonCardRenew(view, this.getModel(), signDy);
        } else if (this.isBusinessTypeNew()) {
            ContractSignServiceHelper.getInstance().setPersonCardNew(view, this.getModel(), signDy);
        } else {
            LOGGER.warn("BusinessType|{}", (Object)this.getModel().getDataEntity().getString("businesstype"));
        }
    }

    private void setOldContractInfo() {
        DynamicObject oldContract = ContractSignApplyRepository.getInstance().getOldContract(this.getModel().getDataEntity());
        this.getModel().setValue("oldcontract", (Object)oldContract);
        if (this.isBusinessTypeRenew() && !HRObjectUtils.isEmpty((Object)oldContract)) {
            Date endDate = oldContract.getDate("enddate");
            Date actualEndDate = oldContract.getDate("actualenddate");
            if (!Objects.isNull(actualEndDate)) {
                this.getModel().setValue("startdate", (Object)HRDateTimeUtils.getNextDay((Date)actualEndDate));
            } else if (!Objects.isNull(endDate)) {
                this.getModel().setValue("startdate", (Object)HRDateTimeUtils.getNextDay((Date)endDate));
            } else {
                LOGGER.warn("endDate is null,actualEndDate is null");
            }
            this.getModel().setValue("actualsigncompany", (Object)oldContract.getDynamicObject("actualsigncompany"));
        }
        if (this.isBusinessTypeChange() && !HRObjectUtils.isEmpty((Object)oldContract)) {
            this.getModel().setValue("actualsigncompany", (Object)oldContract.getDynamicObject("actualsigncompany"));
        }
    }

    private void propertyChangedCancelContractInfo() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObject cancelContract = ContractSignApplyRepository.getInstance().getCancelContractByErManFile(dataEntity);
        this.getModel().setValue("oldcontract", (Object)cancelContract);
        if (!HRObjectUtils.isEmpty((Object)cancelContract)) {
            ContractSignUtils.setCancelPartyABInfo((DynamicObject)cancelContract, (IDataModel)this.getModel());
            if (this.isBusinessTypeCancel()) {
                this.getModel().setValue("oldempphone", (Object)cancelContract.getString("empphone"));
                if (!OperationStatus.VIEW.equals((Object)this.getView().getFormShowParameter().getStatus())) {
                    this.getModel().setValue("empphone", (Object)cancelContract.getString("empphone"));
                }
            }
        }
    }

    private void setCancelContractInfo() {
        DynamicObject cancelContract = this.getModel().getDataEntity().getDynamicObject("oldcontract");
        if (!HRObjectUtils.isEmpty((Object)cancelContract)) {
            cancelContract = CommonRepository.queryById((String)"hlcm_contract", null, (Long)cancelContract.getLong("id"));
            ContractSignUtils.setCancelPartyABInfo((DynamicObject)cancelContract, (IDataModel)this.getModel());
            if (this.isBusinessTypeCancel()) {
                this.getModel().setValue("oldempphone", (Object)cancelContract.getString("empphone"));
                if (OperationStatus.ADDNEW.equals((Object)this.getView().getFormShowParameter().getStatus())) {
                    this.getModel().setValue("empphone", (Object)cancelContract.getString("empphone"));
                }
            }
        }
    }

    private void setRenewCount() {
        int renewCount = ContractSignApplyRepository.getInstance().getRenewCount(this.getModel().getDataEntity());
        this.getModel().setValue("renewcount", (Object)renewCount);
    }

    private boolean showErrorMsg(ImmutablePair<Boolean, String> validateResult) {
        String msg = (String)validateResult.getRight();
        if (((Boolean)validateResult.getLeft()).booleanValue()) {
            if (HRStringUtils.isNotEmpty((String)msg)) {
                this.getView().showTipNotification(msg);
            }
        } else {
            this.getView().showErrorNotification(msg);
            return false;
        }
        return true;
    }

    private boolean isContractType(DynamicObject entryEntity) {
        DynamicObject entryContractType = entryEntity.getDynamicObject("entrycontracttype");
        if (HRObjectUtils.isEmpty((Object)entryContractType)) {
            LOGGER.info("entryContractType is empty");
            return false;
        }
        return ContractTypeCatEnum.CON.getPkId() == entryContractType.getLong("group.id");
    }

    private String getContractAttachmentUrl(boolean downloadOrPreview) {
        String attachmentUrl = "";
        IDataModel dataModel = this.getModel();
        String entityIdStr = this.getView().getEntityId();
        if ("hlcm_contractapplynew".equals(entityIdStr) || HLCM_CONTRACTAPPLYRENEW.equals(entityIdStr) || "hlcm_contractapplychange".equals(entityIdStr)) {
            DynamicObjectCollection entryEntities = dataModel.getEntryEntity("entryentity");
            for (int index = 0; index < entryEntities.size(); ++index) {
                DynamicObject entryEntity = (DynamicObject)entryEntities.get(index);
                if (!this.isContractType(entryEntity)) continue;
                attachmentUrl = this.getPreviewOrDownloadUrl(index, downloadOrPreview);
            }
        }
        return attachmentUrl;
    }

    private String getPreviewOrDownloadUrl(int index, boolean downloadOrPreview) {
        IDataModel dataModel = this.getModel();
        DynamicObject entryEntity = dataModel.getEntryRowEntity("entryentity", index);
        FileServiceExt attachFileServiceExt = FileServiceExtFactory.getAttachFileServiceExt();
        String url = attachFileServiceExt.getRealPath(entryEntity.getString("presigndocurl"));
        DynamicObject contractTemplate = entryEntity.getDynamicObject("contracttemplate");
        if (HRObjectUtils.isEmpty((Object)contractTemplate)) {
            return null;
        }
        if (HRStringUtils.isEmpty((String)url)) {
            boolean isContractFileForm;
            String entityId = this.getView().getEntityId();
            DynamicObject dataEntity = dataModel.getDataEntity();
            boolean bl = isContractFileForm = HRStringUtils.equals((String)entityId, (String)"hlcm_contract") || HRStringUtils.equals((String)entityId, (String)"hlcm_contractfileemp") || HRStringUtils.equals((String)entityId, (String)"hlcm_contractfileother");
            if (isContractFileForm) {
                DynamicObject signBill = ContractSignApplyRepository.getInstance().getByContractNumber(null, dataEntity.getString("number"));
                if (HRObjectUtils.isEmpty((Object)signBill)) {
                    DynamicObject contract = HLCMCommonRepository.queryDynamicObjectByPk((String)"hlcm_contract", null, (Object)dataEntity.getPkValue());
                    DynamicObject contractTemplateEntry = (DynamicObject)contract.getDynamicObjectCollection("entryentity").get(index);
                    DynamicObject contractTemplateHis = CommonRepository.queryById((String)"hlcm_contracttemplatehis", null, (Long)contractTemplateEntry.getDynamicObject("texthis").getLong("id"));
                    DynamicObject[] attachments = BosAttachmentRepository.getInstance().queryByInterId(contractTemplateHis.getString("id"), "hlcm_contracttemplatehis", "ffileid");
                    url = Stream.of(attachments).findFirst().map(attachment -> attachment.getString("ffileid")).orElse(null);
                } else {
                    url = ISignManageService.getInstance().replaceKeywordGenContract(signBill, (DynamicObject)signBill.getDynamicObjectCollection("entryentity").get(index), false, false);
                }
            } else {
                DynamicObject signBill = CommonRepository.queryById((String)"hlcm_contractapplybase", null, (Long)dataEntity.getLong("id"));
                url = ISignManageService.getInstance().replaceKeywordGenContract(signBill, (DynamicObject)signBill.getDynamicObjectCollection("entryentity").get(index), false, false);
            }
            url = attachFileServiceExt.getRealPath(url);
            if (HRStringUtils.isEmpty((String)url)) {
                return null;
            }
            try {
                url = URLEncoder.encode(url, StandardCharsets.UTF_8.name());
            }
            catch (UnsupportedEncodingException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
        }
        return downloadOrPreview ? UrlService.getAttachmentFullUrl((String)url) : UrlService.getAttachmentPreviewUrl((String)url);
    }

    private void setEntryContractInfo() {
        String entityIdStr = this.getView().getEntityId();
        if ("hlcm_contractapplynew".equals(entityIdStr) || HLCM_CONTRACTAPPLYRENEW.equals(entityIdStr) || "hlcm_contractapplychange".equals(entityIdStr)) {
            IDataModel dataModel = this.getModel();
            DynamicObjectCollection entryEntities = dataModel.getEntryEntity("entryentity");
            if (entryEntities.size() == 0) {
                return;
            }
            for (int index = 0; index < entryEntities.size(); ++index) {
                DynamicObject entryEntity = (DynamicObject)entryEntities.get(index);
                if (this.isContractType(entryEntity)) {
                    entryEntity.set("entrycontractnumber", dataModel.getValue("contractnumber"));
                    entryEntity.set("entrycontracttype", dataModel.getValue("contracttype"));
                    entryEntity.set("entryperiodtype", dataModel.getValue("periodtype"));
                    entryEntity.set("entrystartdate", dataModel.getValue("startdate"));
                    entryEntity.set("entryperiod", dataModel.getValue("period"));
                    entryEntity.set("entryperiodunit", dataModel.getValue("periodunit"));
                    entryEntity.set("entryenddate", dataModel.getValue("enddate"));
                    entryEntity.set("contracttemplate", dataModel.getValue("contractemplate"));
                    String fileName = this.getFileName(entryEntity);
                    entryEntity.set("attachmentfield1", (Object)fileName);
                    this.getView().setEnable(Boolean.valueOf(false), index, new String[]{"entrycontractnumber", "entrycontracttype", "entryperiodtype", "entrystartdate", "entryperiod", "entryperiodunit", "entryenddate", "contracttemplate", "texthis", "remark"});
                    continue;
                }
                ContractSignUtils.updateEntryEndDateControlMustByPeriodType((IFormView)this.getView(), (DynamicObject)entryEntity, (int)index, (boolean)false);
            }
            this.getView().updateView("entryentity");
        } else if ("hlcm_contractapplycancel".equals(entityIdStr)) {
            IDataModel dataModel = this.getModel();
            DynamicObjectCollection entryEntities = dataModel.getEntryEntity("entryentity");
            if (entryEntities.size() == 0) {
                return;
            }
            for (DynamicObject entryEntity : entryEntities) {
                entryEntity.set("entrycontracttype", dataModel.getValue("contracttype"));
            }
        }
    }

    private String getFileName(DynamicObject entryEntity) {
        String fileName;
        DynamicObject contractTemplate = entryEntity.getDynamicObject("contracttemplate");
        if (HRObjectUtils.isEmpty((Object)contractTemplate)) {
            LOGGER.info("contractTemplate is empty");
            return null;
        }
        String url = entryEntity.getString("presigndocurl");
        if (HRStringUtils.isEmpty((String)url)) {
            DynamicObject attachment = this.getAttachment(entryEntity);
            if (Objects.isNull(attachment)) {
                return null;
            }
            fileName = attachment.getString("fattachmentname");
        } else {
            LOGGER.info("signDocUrl:{}", (Object)url);
            url = FileServiceExtFactory.getAttachFileServiceExt().getRealPath(url);
            fileName = url.substring(url.lastIndexOf(47) + 1);
        }
        return fileName;
    }

    private DynamicObject getAttachment(DynamicObject entryEntity) {
        QFilter[] qFilterArray;
        boolean isView;
        DynamicObject contractTemplate = entryEntity.getDynamicObject("contracttemplate");
        DynamicObject contractTemplateHis = entryEntity.getDynamicObject("texthis");
        boolean bl = isView = this.getView().getFormShowParameter().getStatus() == OperationStatus.VIEW;
        if (isView) {
            QFilter[] qFilterArray2 = new QFilter[2];
            qFilterArray2[0] = new QFilter("fbilltype", "=", (Object)"hlcm_contracttemplatehis");
            qFilterArray = qFilterArray2;
            qFilterArray2[1] = new QFilter("finterid", "=", (Object)String.valueOf(Optional.ofNullable(contractTemplateHis).map(DataEntityBase::getPkValue).orElseGet(() -> 0L)));
        } else {
            QFilter[] qFilterArray3 = new QFilter[2];
            qFilterArray3[0] = new QFilter("fbilltype", "=", (Object)"hlcm_contracttemplate");
            qFilterArray = qFilterArray3;
            qFilterArray3[1] = new QFilter("finterid", "=", (Object)String.valueOf(contractTemplate.getPkValue()));
        }
        QFilter[] filters = qFilterArray;
        DynamicObject[] attachments = CommonRepository.query((String)"bos_attachment", (String)String.join((CharSequence)",", "ffileid", "fattachmentname"), (QFilter[])filters);
        if (attachments == null || attachments.length == 0) {
            LOGGER.info("attachments is empty");
            return null;
        }
        return attachments[0];
    }
}

