/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hlcm.formplugin.billapply.contractapply;

import java.util.ArrayList;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.BillListHyperLinkClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseList;
import kd.hr.hlcm.business.common.HLCMCommonRepository;
import kd.hr.hlcm.business.domian.repository.ContractRepository;
import kd.hr.hlcm.business.domian.repository.LicenseRepository;
import kd.hr.hlcm.business.utils.ContractSignUtils;
import kd.hr.hlcm.common.enums.BusinessTypeEnum;
import kd.hr.hlcm.common.enums.ProtocolTypeEnum;
import kd.hr.hlcm.formplugin.utils.ContractFormTipUtils;
import kd.hr.hlcm.formplugin.utils.TerminateHelper;

public class ContractSignListPlugin
extends HRDataBaseList {
    private static final Log LOGGER = LogFactory.getLog(ContractSignListPlugin.class);

    public void setFilter(SetFilterEvent setFilterEvent) {
        super.setFilter(setFilterEvent);
        setFilterEvent.setOrderBy("id desc");
        ArrayList<QFilter> customQFilters = setFilterEvent.getCustomQFilters();
        if (customQFilters == null) {
            customQFilters = new ArrayList<QFilter>();
        }
        IListView view = (IListView)this.getView();
        String billFormId = view.getBillFormId();
        customQFilters.add(new QFilter("businesstype", "=", (Object)ContractSignUtils.getBusinessTypeByBillFormId((String)billFormId)));
        customQFilters.add(new QFilter("protocoltype", "=", (Object)ProtocolTypeEnum.CON.getCombKey()));
        setFilterEvent.setCustomQFilters(customQFilters);
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
        ContractRepository.getInstance().signCompanyAndReasonFilter(args, this.getView());
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId = closedCallBackEvent.getActionId();
        if (HRStringUtils.equals((String)actionId, (String)"terminateOperation")) {
            ContractFormTipUtils.getInstance().showTerminateTip(closedCallBackEvent, this.getView());
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if (HRStringUtils.equals((String)callBackId, (String)"unsubmitactionId") && messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            this.getPageCache().put(callBackId, callBackId);
            this.getView().invokeOperation("unsubmit");
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        boolean verifyCertCount;
        FormOperate source = (FormOperate)args.getSource();
        String operateKey = source.getOperateKey();
        IFormView view = this.getView();
        if (operateKey.equals("perterminate")) {
            String tip = ResManager.loadKDString((String)"\u7ec8\u6b62\u6d41\u7a0b\u540e\u4eba\u5458\u7684\u6d41\u7a0b\u5c06\u5168\u90e8\u7ec8\u6b62\uff0c\u4e14\u4e0d\u53ef\u64a4\u9500\uff0c\u5982\u679c\u786e\u8ba4\u7ec8\u6b62\uff0c\u8bf7\u586b\u5199\u4ee5\u4e0b\u4fe1\u606f\uff1a", (String)"ContractSignListPlugin_4", (String)"hr-hlcm-formplugin", (Object[])new Object[0]);
            TerminateHelper.terminateValidate(view, tip, (IFormPlugin)this, args);
        }
        IListView listView = (IListView)view;
        String billFormId = listView.getBillFormId();
        if (("new".equals(operateKey) || "importdata".equals(operateKey)) && "hlcm_contractapplynew".equals(billFormId) && !(verifyCertCount = LicenseRepository.getInstance().verifyCertCount(view, billFormId))) {
            args.setCancel(true);
        }
    }

    public void beforeShowBill(BeforeShowBillFormEvent evt) {
        BillShowParameter parameter = evt.getParameter();
        if (parameter.getStatus() == OperationStatus.ADDNEW) {
            IListView view = (IListView)this.getView();
            String billFormId = view.getBillFormId();
            parameter.setCaption(ResManager.loadKDString((String)"\u65b0\u589e\u52b3\u52a8\u5408\u540c%s\u7533\u8bf7", (String)"ContractSignListPlugin_2", (String)"hr-hlcm-formplugin", (Object[])new Object[]{BusinessTypeEnum.getValueByKey((String)ContractSignUtils.getBusinessTypeByBillFormId((String)billFormId))}));
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        super.billListHyperLinkClick(args);
        args.setCancel(true);
        BillListHyperLinkClickEvent hyperLinkClickEvent = (BillListHyperLinkClickEvent)args.getHyperLinkClickEvent();
        Object pkId = hyperLinkClickEvent.getCurrentRow().getPrimaryKeyValue();
        BillList billList = (BillList)hyperLinkClickEvent.getSource();
        String formId = billList.getBillFormId();
        BillShowParameter parameter = new BillShowParameter();
        DynamicObject dataEntity = HLCMCommonRepository.queryDynamicObjectByPk((String)"hlcm_signmanagebase", (String)"empname,protocoltype,businesstype", (Object)pkId);
        String businessType = dataEntity.getString("businesstype");
        String name = dataEntity.getString("empname");
        String protocolType = dataEntity.getString("protocoltype");
        parameter.setCaption(String.format(ResManager.loadKDString((String)"%1$s%2$s\u7533\u8bf7\uff1a%3$s", (String)"ContractSignListPlugin_1", (String)"hr-hlcm-formplugin", (Object[])new Object[0]), ProtocolTypeEnum.loadKDStringByKey((String)protocolType), BusinessTypeEnum.getValueByKey((String)businessType), name));
        parameter.setPkId(pkId);
        parameter.setStatus(OperationStatus.VIEW);
        parameter.setBillStatus(BillOperationStatus.VIEW);
        parameter.setFormId(formId);
        parameter.setPageId(this.getView().getPageId() + pkId);
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)parameter);
    }
}

