/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hlcm.formplugin.billapply.empprotocolapply;

import java.util.Locale;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.IFormView;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.IListView;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hlcm.business.common.HLCMCommonRepository;
import kd.hr.hlcm.business.domian.repository.ContractRepository;
import kd.hr.hlcm.business.domian.repository.LicenseRepository;
import kd.hr.hlcm.common.enums.BusinessTypeEnum;
import kd.hr.hlcm.common.enums.ProtocolTypeEnum;
import kd.hr.hlcm.formplugin.utils.ContractFormTipUtils;
import kd.hr.hlcm.formplugin.utils.TerminateHelper;

public class ContractBaseListPlugin
extends AbstractListPlugin {
    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId = closedCallBackEvent.getActionId();
        if (HRStringUtils.equals((String)actionId, (String)"terminateOperation")) {
            ContractFormTipUtils.getInstance().showTerminateTip(closedCallBackEvent, this.getView());
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        boolean verifyCertCount;
        FormOperate source = (FormOperate)args.getSource();
        String operateKey = source.getOperateKey();
        IFormView view = this.getView();
        if (operateKey.equals("perterminate")) {
            TerminateHelper.terminateValidate(view, "", (IFormPlugin)this, args);
        }
        IListView listView = (IListView)view;
        String billFormId = listView.getBillFormId();
        if ((operateKey.equals("new") || operateKey.equals("importdata")) && ("hlcm_otheragreements".equals(billFormId) || "hlcm_empprotocolnew".equals(billFormId)) && !(verifyCertCount = LicenseRepository.getInstance().verifyCertCount(view, billFormId))) {
            args.setCancel(true);
        }
    }

    public void beforeShowBill(BeforeShowBillFormEvent evt) {
        BillShowParameter parameter = evt.getParameter();
        if (parameter.getStatus() == OperationStatus.ADDNEW) {
            IListView view = (IListView)this.getView();
            String billFormId = view.getBillFormId();
            String caption = this.getFormBillTitleByBillFormId(billFormId);
            parameter.setCaption(caption);
        } else {
            Object pkId = parameter.getPkId();
            String caption = this.getViewAndEditFormTitle(pkId);
            parameter.setCaption(caption);
            if (parameter.getStatus() == OperationStatus.EDIT) {
                parameter.setStatus(OperationStatus.VIEW);
            }
        }
    }

    private String getViewAndEditFormTitle(Object pkId) {
        DynamicObject dataEntity = HLCMCommonRepository.queryDynamicObjectByPk((String)"hlcm_signmanagebase", (String)"empname,protocoltype,businesstype", (Object)pkId);
        String businessType = dataEntity.getString("businesstype");
        String name = dataEntity.getString("empname");
        String protocolType = dataEntity.getString("protocoltype");
        return String.format(Locale.ROOT, ResManager.loadKDString((String)"%1$s%2$s\u7533\u8bf7\uff1a%3$s", (String)"ContractBaseSignListPlugin_1", (String)"hr-hlcm-formplugin", (Object[])new Object[0]), ProtocolTypeEnum.loadKDStringByKey((String)protocolType), BusinessTypeEnum.getValueByKey((String)businessType), name);
    }

    private String getFormBillTitleByBillFormId(String billFormId) {
        String formBillTitleStart = ResManager.loadKDString((String)"\u65b0\u589e", (String)"ContractBaseSignListPlugin_2", (String)"hr-hlcm-formplugin", (Object[])new Object[0]);
        String formBillTitleEnd = ResManager.loadKDString((String)"\u7533\u8bf7", (String)"ContractBaseSignListPlugin_3", (String)"hr-hlcm-formplugin", (Object[])new Object[0]);
        String formBillTitle = "";
        switch (billFormId) {
            case "hlcm_empprotocolnew": {
                formBillTitle = formBillTitleStart.concat(ProtocolTypeEnum.YG.getDesc().concat(BusinessTypeEnum.NEW.loadKDString())).concat(formBillTitleEnd);
                break;
            }
            case "hlcm_empprotocolrelieve": {
                formBillTitle = formBillTitleStart.concat(ProtocolTypeEnum.YG.getDesc().concat(BusinessTypeEnum.CANCEL.loadKDString())).concat(formBillTitleEnd);
                break;
            }
            case "hlcm_otheragreements": {
                formBillTitle = formBillTitleStart.concat(ProtocolTypeEnum.FS.getDesc().concat(BusinessTypeEnum.NEW.loadKDString())).concat(formBillTitleEnd);
                break;
            }
        }
        return formBillTitle;
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
        ContractRepository.getInstance().signCompanyAndReasonFilter(args, this.getView());
    }
}

