/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hlcm.formplugin.billapply.empprotocolapply;

import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hlcm.business.domian.repository.ContractRepository;
import kd.hr.hlcm.business.domian.repository.ContractSignApplyRepository;
import kd.hr.hlcm.business.utils.CancelProtocolValidUtils;
import kd.hr.hlcm.common.enums.ContractStatusEnum;
import kd.hr.hlcm.common.enums.ContractTypeCatEnum;
import kd.hr.hlcm.common.enums.ProtocolTypeEnum;
import kd.hr.hlcm.formplugin.billapply.empprotocolapply.ContractProtocolBaseFormPlugin;

public class ContractEmpProtocolCancelFormPlugin
extends ContractProtocolBaseFormPlugin {
    @Override
    public void registerListener(EventObject eventObject) {
        BasedataEdit reasonType;
        super.registerListener(eventObject);
        BasedataEdit erManFile = (BasedataEdit)this.getControl("oldcontract");
        if (Objects.nonNull(erManFile)) {
            erManFile.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if (Objects.nonNull(reasonType = (BasedataEdit)this.getControl("cancelreasontype"))) {
            reasonType.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    @Override
    public void beforeBindData(EventObject evt) {
        super.beforeBindData(evt);
        if (this.getView().getFormShowParameter().getStatus() != OperationStatus.ADDNEW) {
            this.bindDataSignCompany();
        } else {
            this.getView().setEnable(Boolean.FALSE, new String[]{"empphone"});
        }
    }

    @Override
    public void afterBindData(EventObject event) {
        super.afterBindData(event);
        if (this.getModel().getDataEntity().getDynamicObject("oldcontract") != null) {
            long oldcontractId = this.getModel().getDataEntity().getDynamicObject("oldcontract").getLong("id");
            DynamicObject oldcontract = ContractRepository.getInstance().queryById(oldcontractId);
            this.getModel().setValue("oldempphone", (Object)oldcontract.getString("empphone"));
        }
        if ("1".equals(this.getModel().getDataEntity().getString("signway"))) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"empphone"});
        } else {
            this.getView().setEnable(Boolean.TRUE, new String[]{"empphone"});
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String propertyName;
        switch (propertyName = args.getProperty().getName()) {
            case "canceldate": {
                String errMsg = ContractSignApplyRepository.getInstance().checkCancelDate(this.getModel().getDataEntity());
                if (!HRStringUtils.isNotEmpty((String)errMsg)) break;
                this.getView().showErrorNotification(errMsg);
                break;
            }
            case "ermanfile": {
                this.clearBillInfoWhenSwitchFileID();
                DynamicObject erManFile = (DynamicObject)this.getModel().getValue("ermanfile");
                if (HRObjectUtils.isEmpty((Object)erManFile)) {
                    this.getModel().setValue("paneltype", (Object)"0");
                    break;
                }
                String erManFileId = this.getPageCache().get(this.getModel().getDataEntity().getString("ermanfile_id"));
                if (HRStringUtils.equals((String)erManFileId, (String)"1")) {
                    this.loadPageInfo();
                    this.getPageCache().remove(erManFileId);
                } else if (this.checkPersonPanel()) {
                    this.loadPageInfo();
                } else {
                    this.initEmptyPage();
                }
                this.getView().setEnable(Boolean.TRUE, new String[]{"empphone"});
                this.getModel().setValue("empphone", this.getModel().getValue("oldempphone"));
                break;
            }
            case "signway": {
                String signWay;
                DynamicObject dataEntity = this.getModel().getDataEntity();
                String existMultiEntry = CancelProtocolValidUtils.getInstance().isExistMultiEntry(dataEntity, ProtocolTypeEnum.loadKDStringByKey((String)"2"));
                if (HRStringUtils.isNotEmpty((String)existMultiEntry)) {
                    this.getView().showTipNotification(existMultiEntry);
                }
                if ("1".equals(signWay = dataEntity.getString("signway"))) {
                    this.getModel().setValue("empphone", (Object)dataEntity.getString("oldempphone"));
                }
                this.getView().setEnable(Boolean.valueOf("2".equals(signWay)), new String[]{"empphone"});
                break;
            }
            case "issignprotocol": {
                DynamicObject applyDy = this.getModel().getDataEntity();
                if (applyDy.getBoolean("issignprotocol") || !HRStringUtils.equals((String)"4", (String)applyDy.getString("businesstype"))) break;
                DynamicObjectCollection entryentity = this.getModel().getEntryEntity("entryentity");
                for (int i = entryentity.size() - 1; i >= 0; --i) {
                    this.getModel().setValue("contracttemplate", null, i);
                    this.getModel().deleteEntryRow("entryentity", i);
                }
                this.getView().updateView("entryentity");
                this.getModel().setValue("signeddate", null);
                this.getModel().setValue("contracttype", null);
                this.getModel().setValue("signway", null);
                break;
            }
        }
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent evt) {
        super.beforeF7Select(evt);
        IDataEntityProperty property = evt.getProperty();
        List qFilters = ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter().getQFilters();
        String propertyName = property.getName();
        if (HRStringUtils.equals((String)"oldcontract", (String)propertyName)) {
            String empNumber = this.getModel().getDataEntity().getDynamicObject("ermanfile").getString("number");
            qFilters.add(new QFilter("empnumber", "=", (Object)empNumber));
            qFilters.add(new QFilter("protocoltype", "=", (Object)ProtocolTypeEnum.YG.getCombKey()));
            qFilters.add(new QFilter("contractstatus", "=", (Object)ContractStatusEnum.STATUS_IN_EFFECT.getCode()));
            qFilters.add(new QFilter("iscurrentversion", "=", (Object)"1"));
        } else if (HRStringUtils.equals((String)"cancelreasontype", (String)propertyName)) {
            Map customParams = evt.getFormShowParameter().getCustomParams();
            customParams.put("islistfilter", this.getView().getEntityId());
            evt.getFormShowParameter().setCustomParams(customParams);
        } else if (HRStringUtils.equals((String)"contracttemplate", (String)propertyName)) {
            DynamicObject contracttype = this.getModel().getDataEntity().getDynamicObject("contracttype");
            String entityId = this.getView().getEntityId();
            if ("hlcm_empprotocolrelieve".equals(entityId)) {
                if (HRObjectUtils.isEmpty((Object)contracttype)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5408\u540c\u7c7b\u578b\u3002", (String)"ContractSignFormPlugin_5", (String)"hr-hlcm-formplugin", (Object[])new Object[0]));
                    evt.setCancel(true);
                    return;
                }
                qFilters.add(new QFilter("contracttype.group", "=", (Object)ContractTypeCatEnum.OTHER.getPkId()));
                qFilters.add(new QFilter("contracttype.name", "=", (Object)contracttype.getString("name")));
                return;
            }
        }
    }

    private void bindDataSignCompany() {
        DynamicObject oldContract = this.getModel().getDataEntity().getDynamicObject("oldcontract");
        if (Objects.isNull(oldContract)) {
            return;
        }
        DynamicObject actualSignCompanyHis = oldContract.getDynamicObject("actualsigncompanyhis");
        if (Objects.isNull(actualSignCompanyHis)) {
            return;
        }
        this.getModel().setValue("actualsigncompanyhisdata", (Object)actualSignCompanyHis);
    }

    @Override
    protected void clearBillInfoWhenSwitchFileID() {
        super.clearBillInfoWhenSwitchFileID();
        this.getModel().setValue("cancelreason", null);
        this.getModel().setValue("canceldate", null);
    }
}

