/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hlcm.formplugin.billapply.empprotocolapply;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DataEntityState;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.cache.PageCache;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hlcm.business.domian.repository.CommonRepository;
import kd.hr.hlcm.business.domian.repository.ContractRepository;
import kd.hr.hlcm.business.domian.repository.ContractSignApplyRepository;
import kd.hr.hlcm.business.domian.repository.LicenseRepository;
import kd.hr.hlcm.business.domian.service.hbpm.IHbpmService;
import kd.hr.hlcm.business.utils.AttachmentUtils;
import kd.hr.hlcm.business.utils.ContractPageLoadUtils;
import kd.hr.hlcm.business.utils.ContractSignUtils;
import kd.hr.hlcm.business.vaildator.ContractProtocolValidatorFactory;
import kd.hr.hlcm.business.vaildator.ContractSignValidatorFactory;
import kd.hr.hlcm.business.vaildator.IsOrgSameValidator;
import kd.hr.hlcm.business.vaildator.ValidatorBase;
import kd.hr.hlcm.business.vaildator.ValidatorHolder;
import kd.hr.hlcm.common.entity.NoticeEntity;
import kd.hr.hlcm.common.enums.BillStatusEnum;
import kd.hr.hlcm.common.enums.BusinessTypeEnum;
import kd.hr.hlcm.common.enums.ContractTypeCatEnum;
import kd.hr.hlcm.common.enums.PeriodUnitEnum;
import kd.hr.hlcm.common.enums.ProbationUnitEnum;
import kd.hr.hlcm.common.utils.HeadCardUtil;
import kd.hr.hlcm.formplugin.billapply.contractapply.ContractSignServiceHelper;
import kd.hr.hlcm.formplugin.utils.CardInfoHelper;
import kd.hr.hlcm.formplugin.utils.ContractFormTipUtils;
import kd.hr.hlcm.formplugin.utils.TerminateHelper;

public class ContractProtocolBaseFormPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final Log LOGGER = LogFactory.getLog(ContractProtocolBaseFormPlugin.class);
    private static final Set<String> REFUSH_OP = Sets.newHashSet((Object[])new String[]{"unsubmit", "submit", "save", "submiteffect", "terminate"});
    protected static final String CHECK_ERMANFILE_FLAG = "1";
    String PAGECATCH_ER_MAN_FILE = "ermanfile";
    protected static final String CONFIRM_CHECK = "confirmFileIdSwitch";

    public void afterCreateNewData(EventObject e) {
        IFormView view = this.getView();
        String billFormId = view.getEntityId();
        String businessTypeEnum = ContractSignUtils.getBusinessTypeByBillFormId((String)billFormId);
        List<String> businessTypes = Collections.singletonList(BusinessTypeEnum.CANCEL.getCombKey());
        if (!businessTypes.contains(businessTypeEnum)) {
            long ermanorgId = this.getModel().getDataEntity().getLong("ermanorg.id");
            this.setContractNumberFormIDByCurrFormID(billFormId, ermanorgId);
        }
        this.getModel().setValue("paneltype", (Object)"0");
    }

    private void setContractNumberFormIDByCurrFormID(String billFormId, Long orgId) {
        String htNumber = ContractSignUtils.getNumber((String)billFormId, (boolean)false, (String)String.valueOf(orgId));
        if (!HRStringUtils.isEmpty((String)htNumber)) {
            this.getModel().setValue("contractnumber", (Object)htNumber);
        }
        String businessTypeByBillFormId = ContractSignUtils.getContractNameBySignBill((String)billFormId);
        this.getView().setEnable(Boolean.valueOf(ContractSignUtils.codeRuleIsModify((String)businessTypeByBillFormId, (String)String.valueOf(orgId))), new String[]{"contractnumber"});
    }

    public void preOpenForm(PreOpenFormEventArgs evt) {
        super.preOpenForm(evt);
        FormShowParameter formShowParameter = evt.getFormShowParameter();
        if (formShowParameter.getStatus() == OperationStatus.EDIT) {
            formShowParameter.setStatus(OperationStatus.VIEW);
        }
    }

    public void registerListener(EventObject eventObject) {
        BasedataEdit contractTemplate;
        super.registerListener(eventObject);
        BasedataEdit erManFile = (BasedataEdit)this.getControl("ermanfile");
        if (Objects.nonNull(erManFile)) {
            erManFile.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if (Objects.nonNull(contractTemplate = (BasedataEdit)this.getControl("contracttemplate"))) {
            contractTemplate.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void beforeBindData(EventObject e) {
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        String businesstype = this.getModel().getDataEntity().getString("businesstype");
        if (CHECK_ERMANFILE_FLAG.equals(businesstype) && OperationStatus.ADDNEW.equals((Object)status)) {
            LicenseRepository.getInstance().verifyCertCount(this.getView(), this.getView().getEntityId());
        }
    }

    public void afterBindData(EventObject event) {
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        DynamicObject dataEntity = model.getDataEntity();
        OperationStatus pageStatus = view.getFormShowParameter().getStatus();
        switch (pageStatus) {
            case EDIT: {
                this.setPersonPanelInfo(false);
                HeadCardUtil.showBillHeadNew((IFormView)view, (DynamicObject)dataEntity);
                this.getView().setVisible(Boolean.TRUE, new String[]{"billheadpanelap", "personcardinfopanelap"});
                ContractSignUtils.updateEndDateControlMustByPeriodType((IFormView)this.getView(), (boolean)false);
                break;
            }
            case VIEW: {
                HeadCardUtil.showBillHeadView((IFormView)view, (DynamicObject)dataEntity, (String)CHECK_ERMANFILE_FLAG);
                String billStatus = dataEntity.getString("billstatus");
                if (!HRStringUtils.equals((String)BillStatusEnum.STATUS_STAGING.getCode(), (String)billStatus)) {
                    this.setPersonCardAllInfo();
                }
                ContractSignUtils.updateEndDateControlMustByPeriodType((IFormView)this.getView(), (boolean)false);
                break;
            }
            case ADDNEW: {
                HeadCardUtil.showBillHeadNew((IFormView)view, (DynamicObject)dataEntity);
                break;
            }
        }
        model.setDataChanged(false);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId = closedCallBackEvent.getActionId();
        if (HRStringUtils.equals((String)actionId, (String)"terminateOperation")) {
            ContractFormTipUtils.getInstance().showTerminateTip(closedCallBackEvent, this.getView());
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        if (!status.equals((Object)OperationStatus.VIEW)) {
            List<String> uncheckField = this.getUnCheckField();
            DataEntityState dataEntityState = this.getModel().getDataEntity().getDataEntityState();
            Iterable bizChangedProperties = dataEntityState.getBizChangedProperties();
            for (IDataEntityProperty iDataEntityProperty : bizChangedProperties) {
                String name = iDataEntityProperty.getName();
                if (!uncheckField.contains(name)) continue;
                dataEntityState.setBizChanged(iDataEntityProperty.getOrdinal(), false);
            }
            bizChangedProperties = dataEntityState.getBizChangedProperties();
            if (!bizChangedProperties.iterator().hasNext()) {
                this.getModel().setDataChanged(false);
            }
        } else {
            this.getModel().setDataChanged(false);
        }
    }

    private List<String> getUnCheckField() {
        ArrayList unCheckField = Lists.newArrayListWithCapacity((int)17);
        unCheckField.add("paneltype");
        unCheckField.add("actualsigncompanyhis");
        unCheckField.add("probationperiodunit");
        unCheckField.add("postype");
        unCheckField.add("postype_id");
        unCheckField.add("postionhis_id");
        unCheckField.add("baselocation_id");
        unCheckField.add("cardtype_id");
        unCheckField.add("person_id");
        unCheckField.add("departmenthis_id");
        unCheckField.add("actualsigncompanyhis_id");
        unCheckField.add("probationstartdate");
        unCheckField.add("probationenddate");
        unCheckField.add("empnumber");
        unCheckField.add("signedcompanyhis");
        unCheckField.add("departmenthis");
        unCheckField.add("postionhis");
        return unCheckField;
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        IFormView view = this.getView();
        FormOperate source = (FormOperate)afterDoOperationEventArgs.getSource();
        OperationResult operationResult = afterDoOperationEventArgs.getOperationResult();
        String operateKey = source.getOperateKey();
        if (REFUSH_OP.contains(operateKey) && operationResult.isSuccess()) {
            this.getView().setStatus(OperationStatus.VIEW);
            this.getView().cacheFormShowParameter();
            this.getView().updateView();
        }
    }

    protected void checkSignDateInfo() {
        DynamicObject erManFile = (DynamicObject)this.getModel().getValue("ermanfile");
        if (HRObjectUtils.isEmpty((Object)erManFile)) {
            return;
        }
        DynamicObject dataEntity = this.getModel().getDataEntity();
        ContractSignApplyRepository instance = ContractSignApplyRepository.getInstance();
        String errorMsg = instance.isDateEndSignValidate(dataEntity);
        if (!HRStringUtils.isEmpty((String)errorMsg)) {
            this.getView().showErrorNotification(errorMsg);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        IDataEntityProperty property = evt.getProperty();
        ListFilterParameter listFilterParameter = ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter();
        List qFilters = listFilterParameter.getQFilters();
        if (HRStringUtils.equals((String)"contracttemplate", (String)property.getName())) {
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
            ArrayList<String> contractNumbers = new ArrayList<String>();
            for (DynamicObject dy : entryEntity) {
                DynamicObject contractTemplateDy = (DynamicObject)dy.get("contracttemplate");
                if (HRObjectUtils.isEmpty((Object)contractTemplateDy)) continue;
                contractNumbers.add(contractTemplateDy.getString("number"));
            }
            qFilters.add(new QFilter("number", "not in", contractNumbers));
            this.contractTemplateFilterInit(qFilters);
        }
    }

    private void contractTemplateFilterInit(List<QFilter> qFilters) {
        String entityId = this.getView().getEntityId();
        HashSet ygSets = Sets.newHashSet((Object[])new Long[]{ContractTypeCatEnum.EMP.getPkId(), ContractTypeCatEnum.OTHER.getPkId()});
        if ("hlcm_empprotocolnew".equals(entityId)) {
            qFilters.add(new QFilter("contracttype.group", "in", (Object)ygSets));
        } else if ("hlcm_otheragreements".equals(entityId)) {
            qFilters.add(new QFilter("contracttype.group", "=", (Object)ContractTypeCatEnum.OTHER.getPkId()));
        } else {
            LOGGER.warn("entityId|{}", (Object)entityId);
        }
    }

    protected void setCompanyAndHisInfo() {
        DynamicObject actualSignCompanyDy = (DynamicObject)this.getModel().getDataEntity().get("actualsigncompany");
        if (HRObjectUtils.isEmpty((Object)actualSignCompanyDy)) {
            LOGGER.error("ContractProtocolBaseFormPlugin.setCompanyAndHisInfo_actualSignCompanyDy is null!");
            return;
        }
        this.getModel().setValue("actualsigncompanyhis", (Object)actualSignCompanyDy.getLong("vid"));
    }

    protected void setPersonPanelInfo(boolean isNeedSetPersonValue) {
        DynamicObject erManFile = (DynamicObject)this.getModel().getValue("ermanfile");
        Long erManFileId = (Long)erManFile.getPkValue();
        HeadCardUtil.showSignPersonHead((IFormView)this.getView(), (Object)erManFileId);
        if (isNeedSetPersonValue) {
            this.setPersonInfo(erManFileId);
            this.getModel().setValue("employee", (Object)erManFile.getDynamicObject("employee"));
        }
        this.getModel().setValue("paneltype", (Object)CHECK_ERMANFILE_FLAG);
    }

    protected boolean isBusinessTypeNew() {
        String businessType = this.getModel().getDataEntity().getString("businesstype");
        return HRStringUtils.equals((String)BusinessTypeEnum.NEW.getCombKey(), (String)businessType);
    }

    protected void setPersonInfo(Long erManFileId) {
        IDataModel model = this.getModel();
        Map personInfo = ContractSignUtils.getPersonInfoByErManFile((Long)erManFileId);
        model.setValue("empname", personInfo.get("empname"));
        model.setValue("empnumber", personInfo.get("empnumber"));
        model.setValue("postype", personInfo.get("postype"));
        if (this.isBusinessTypeNew()) {
            Date startDate = (Date)personInfo.get("startdate");
            model.setValue("startdate", (Object)startDate);
            if (!HRObjectUtils.isEmpty((Object)startDate)) {
                model.setValue("usestartdate", (Object)startDate);
            }
        }
        Long personId = (Long)personInfo.get("person_id");
        model.setValue("person", (Object)personId);
        model.setValue("empphone", personInfo.get("empphone"));
        model.setValue("baselocation", personInfo.get("location_id"));
        model.setValue("nation", personInfo.get("nationality_id"));
        Long cardTypeId = (Long)personInfo.get("cardtype");
        model.setValue("cardtype", (Object)cardTypeId);
        String cardNumber = (String)personInfo.get("cardnumber");
        model.setValue("cardnumber", (Object)cardNumber);
        model.setValue("probationstartdate", personInfo.get("probationstartdate"));
        model.setValue("probationenddate", personInfo.get("probationenddate"));
        Integer probationPeriod = (Integer)personInfo.get("probationperiod");
        model.setValue("probationperiod", personInfo.get("probationperiod"));
        model.setValue("probationunit", personInfo.get("probationperiodunit"));
        if (!Objects.isNull(probationPeriod) && probationPeriod != 0) {
            model.setValue("probationperiodunit", (Object)(personInfo.get("probationperiod") + ProbationUnitEnum.getValueByKey((String)((String)personInfo.get("probationperiodunit")))));
        }
        model.setValue("householdregister", personInfo.get("householdregister"));
        model.setValue("residentialaddress", personInfo.get("residentialaddress"));
        Long companyId = (Long)personInfo.get("signedcompany");
        IHbpmService instance = IHbpmService.getInstance();
        model.setValue("signedcompanyhis", (Object)instance.getAdminOrgHis(companyId));
        model.setValue("curcompany", (Object)companyId);
        Long departmentId = (Long)personInfo.get("department");
        model.setValue("departmenthis", (Object)instance.getAdminOrgHis(departmentId));
        model.setValue("curdept", (Object)departmentId);
        Long positionId = (Long)personInfo.get("position");
        model.setValue("postionhis", (Object)instance.getPosHis(positionId));
        model.setValue("curpostion", (Object)positionId);
        Long stdPositionId = (Long)personInfo.get("stdposition");
        model.setValue("stdpostionhis", (Object)instance.getStdPosHis(stdPositionId));
        model.setValue("curstdpostion", (Object)stdPositionId);
        Long jobId = (Long)personInfo.get("job");
        model.setValue("job", (Object)instance.getJobHis(jobId));
        model.setValue("curjob", (Object)jobId);
        Long orgId = (Long)personInfo.get("org_id");
        model.setValue("ermanorg", (Object)orgId);
        Long affiliateadminorgId = (Long)personInfo.get("affiliateadminorg_id");
        model.setValue("adminororg", (Object)affiliateadminorgId);
        Long empGroupId = (Long)personInfo.get("empgroup_id");
        model.setValue("ermanperorg", (Object)empGroupId);
    }

    protected void checkErManFileIDPassLoadPageInfo() {
        this.setPersonPanelInfo(true);
        this.getModel().setValue("paneltype", (Object)CHECK_ERMANFILE_FLAG);
        ContractSignServiceHelper.getInstance().setProtocolInfoByRuleEngine(this.getView(), this.getModel(), "ermanfile");
    }

    void loadPageInfo() {
        this.checkErManFileIDPassLoadPageInfo();
        ContractRepository.getInstance().setEmploymentAgreementToBeTerminatedValue(this.getModel());
        ContractSignUtils.propertyChangedOldContractSignStatus((IFormView)this.getView(), (boolean)true);
    }

    protected void clearBillInfoWhenSwitchFileID() {
        IDataModel model = this.getModel();
        ContractSignUtils.setControlIsEmpty((IFormView)this.getView(), (String[])new String[]{"startdate", "empname", "empnumber", "empphone", "cardtype", "cardnumber", "householdregister", "residentialaddress", "signedcompany", "position", "department", "probationstartdate", "probationenddate", "probationperiod"});
        model.setValue("suggestsigncompany", null);
        model.setValue("actualsigncompany", null);
        model.setValue("curcompany", null);
        model.setValue("curdept", null);
        model.setValue("curpostion", null);
        model.setValue("curstdpostion", null);
        model.setValue("curjob", null);
        model.setValue("contracttype", null);
        model.setValue("periodtype", null);
        PageCache cache = (PageCache)this.getView().getService(IPageCache.class);
        cache.put("startdate", null);
        cache.put("cacheselectcompany", null);
        cache.put("cacheselectcontracttype", null);
        cache.put("cacheselectsignway", null);
        cache.put("cacheermanfileid", null);
        model.setValue("enddate", null);
        model.setValue("usestartdate", null);
        model.setValue("period", null);
        model.setValue("signeddate", null);
        model.setValue("probationperiodunit", null);
        model.setValue("signway", null);
        model.setValue("oldcontract", null);
        model.setValue("periodunit", (Object)PeriodUnitEnum.YEAR.getCombKey());
        model.setValue("signreason", (Object)new LocaleString());
        int cnt = model.getEntryRowCount("entryentity");
        if (cnt > 0) {
            int[] deleteIndex = new int[cnt];
            for (int j = 0; j < cnt; ++j) {
                deleteIndex[j] = j;
            }
            DynamicObject entryRowEntity = model.getEntryRowEntity("entryentity", 0);
            if (!HRObjectUtils.isEmpty((Object)entryRowEntity.getDynamicObject("contracttemplate")) || !HRStringUtils.isEmpty((String)entryRowEntity.getString("seq"))) {
                model.deleteEntryRows("entryentity", deleteIndex);
            }
        }
        this.getView().invokeOperation("newentry");
        AttachmentPanel attachmentPanel = (AttachmentPanel)this.getView().getControl("attachmentpanel");
        AttachmentUtils.clearAttachmentData((AttachmentPanel)attachmentPanel);
    }

    protected void setPersonCardAllInfo() {
        String billFormId = this.getView().getEntityId();
        if (HRStringUtils.equals((String)"hlcm_empprotocolrelieve", (String)billFormId)) {
            Object oldContractID = this.getModel().getDataEntity().getDynamicObject("oldcontract").get("id");
            DynamicObject dynamicObject = CommonRepository.queryDynamicObjectByPk((String)"hlcm_contract", (String)"name,cardtype,actualsigncompanyhis,suggestsigncompanyhis,cardnumber,householdregister,suggestsigncompany,actualsigncompany,residentialaddress,empphone,signreason", (Object)oldContractID);
            ContractPageLoadUtils.getInstance().setMainContractInfo(dynamicObject, this.getView());
        } else {
            CardInfoHelper.getInstance().setMainConInfo(this.getModel().getDataEntity(), this.getView());
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if (HRStringUtils.equals((String)callBackId, (String)CONFIRM_CHECK)) {
            if (messageBoxClosedEvent.getResult().equals((Object)MessageBoxResult.Cancel)) {
                this.getModel().setValue("ermanfile", null);
            } else {
                String fileId = this.getPageCache().get(this.PAGECATCH_ER_MAN_FILE);
                this.showPopConfirm(callBackId, fileId);
            }
        }
    }

    private void showPopConfirm(String callBackId, String fileId) {
        String show2 = this.getPageCache().get("secondaryPops");
        List noticeEntities = JSONArray.parseArray((String)show2, NoticeEntity.class);
        for (NoticeEntity noticeEntity2 : noticeEntities) {
            if (!noticeEntity2.getNoticeStatus().equals(NoticeEntity.NoticeStatusEnum.PENDING.ordinal())) continue;
            noticeEntity2.setNoticeStatus(Integer.valueOf(NoticeEntity.NoticeStatusEnum.AGREED.ordinal()));
        }
        long count = noticeEntities.stream().filter(noticeEntity -> noticeEntity.getNoticeStatus().intValue() != NoticeEntity.NoticeStatusEnum.AGREED.ordinal()).count();
        if (count == 0L) {
            this.getPageCache().remove("secondaryPops");
            this.getPageCache().put(fileId, CHECK_ERMANFILE_FLAG);
            this.getPageCache().remove(this.PAGECATCH_ER_MAN_FILE);
            this.getModel().setValue("ermanfile", null);
            this.getModel().setValue("ermanfile", (Object)fileId);
        } else {
            Optional<NoticeEntity> noProcessOpt = noticeEntities.stream().filter(noticeEntity -> noticeEntity.getNoticeStatus().equals(NoticeEntity.NoticeStatusEnum.NO_PROCESS.ordinal())).findFirst();
            if (noProcessOpt.isPresent()) {
                NoticeEntity noticeEntity3 = noProcessOpt.get();
                this.getView().showConfirm(noticeEntity3.getErrorMsg(), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(callBackId, (IFormPlugin)this));
                noticeEntity3.setNoticeStatus(Integer.valueOf(NoticeEntity.NoticeStatusEnum.PENDING.ordinal()));
            }
            this.getPageCache().put("secondaryPops", JSON.toJSONString((Object)noticeEntities));
        }
    }

    protected boolean checkPersonPanel() {
        List collect;
        String errorMsg;
        this.getPageCache().get("ermanfile");
        DynamicObject dataEntity = this.getModel().getDataEntity();
        ValidatorHolder isOrgSameHolder = new ValidatorHolder(this.getModel().getDataEntity());
        isOrgSameHolder.addValidator((ValidatorBase)new IsOrgSameValidator());
        Object msg = isOrgSameHolder.startValidate();
        if (msg != null && !HRStringUtils.isEmpty((String)(errorMsg = (String)String.class.cast(msg)))) {
            this.getView().showErrorNotification(errorMsg);
            return false;
        }
        ValidatorHolder importValidatorHolder = ContractSignValidatorFactory.getManualValidatorHolder((DynamicObject)dataEntity);
        Object error = importValidatorHolder.startValidate();
        String errorMsg2 = "";
        if (error != null) {
            errorMsg2 = (String)String.class.cast(error);
        }
        if (HRStringUtils.isNotEmpty((String)errorMsg2)) {
            this.getView().showErrorNotification(errorMsg2);
            return false;
        }
        List noticeEntities = ContractProtocolValidatorFactory.getManualTipNoticeEntitie((DynamicObject)dataEntity);
        Set noticeEntitiesNotEmpty = noticeEntities.stream().filter(Objects::nonNull).collect(Collectors.toSet());
        if (!HRObjectUtils.isEmpty(noticeEntitiesNotEmpty) && noticeEntitiesNotEmpty.size() > 0 && !HRObjectUtils.isEmpty(collect = noticeEntitiesNotEmpty.stream().filter(notice -> notice.getNoticeLevel().equals(NoticeEntity.NoticeLevel.NOTICE.getVal())).collect(Collectors.toList())) && collect.size() > 0) {
            NoticeEntity noticeEntity = (NoticeEntity)collect.get(0);
            this.getView().showConfirm(noticeEntity.getErrorMsg(), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(CONFIRM_CHECK, (IFormPlugin)this));
            noticeEntity.setNoticeStatus(Integer.valueOf(NoticeEntity.NoticeStatusEnum.PENDING.ordinal()));
            this.getPageCache().put("secondaryPops", JSON.toJSONString(collect));
            this.getPageCache().put(this.PAGECATCH_ER_MAN_FILE, this.getModel().getDataEntity().getString("ermanfile_id"));
            return false;
        }
        return true;
    }

    protected void initEmptyPage() {
        this.getModel().setValue("paneltype", (Object)"0");
        this.getModel().setValue("ermanfile", null);
    }

    protected void checkStartDate() {
        Date useStartDate;
        Date startDate;
        String errorMsg;
        DynamicObject dataEntity = this.getModel().getDataEntity();
        ContractSignApplyRepository instance = ContractSignApplyRepository.getInstance();
        if (this.isBusinessTypeNew() && !HRStringUtils.isEmpty((String)(errorMsg = instance.checkEmpContractUseStartDate(startDate = dataEntity.getDate("startdate"), useStartDate = dataEntity.getDate("usestartdate"))))) {
            this.getView().showErrorNotification(errorMsg);
            return;
        }
        ContractSignUtils.setStartDateAndEndDateInfo((IFormView)this.getView());
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs evt) {
        super.beforeDoOperation(evt);
        String businessType = this.getModel().getDataEntity().getString("businesstype");
        FormOperate operate = (FormOperate)evt.getSource();
        if (HRStringUtils.equals((String)operate.getOperateKey(), (String)"save") && HRStringUtils.equals((String)BusinessTypeEnum.NEW.getCombKey(), (String)businessType)) {
            ContractSignUtils.validateFixedMustInput((DynamicObject)this.getModel().getDataEntity()).ifPresent(validateMsg -> {
                evt.setCancel(true);
                this.getView().showTipNotification(validateMsg);
            });
        }
        TerminateHelper.terminateValidate(this.getView(), "", (IFormPlugin)this, evt);
    }
}

