/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hlcm.formplugin.common;

import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.IListView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.hr.hbp.common.util.HRJSONUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseList;
import kd.hr.hlcm.business.domian.service.common.MulSelectConfirmEnum;
import kd.hr.hlcm.business.domian.service.common.MulSelectConfirmTemplate;

public class MulSelectConfirmCommonListPlugin
extends HRDataBaseList {
    private static final Log LOGGER = LogFactory.getLog(MulSelectConfirmCommonListPlugin.class);
    private static final String ABLE_OPERATE_PK_VALUES = "ableOperatePkValues";

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate source = (FormOperate)args.getSource();
        String operateKey = source.getOperateKey();
        String formId = source.getEntityId();
        MulSelectConfirmTemplate template = MulSelectConfirmEnum.getTemplate((String)operateKey);
        if (template == null) {
            return;
        }
        IFormView formView = this.getView();
        ListView listView = (ListView)formView;
        Object[] pkValues = this.getSelectedRows().getPrimaryKeyValues();
        if (pkValues.length == 0) {
            listView.showErrorNotification(template.getEmptySelectMessage());
        } else if (pkValues.length == 1) {
            if (HRStringUtils.equals((String)operateKey, (String)"submit")) {
                return;
            }
            args.setCancel(true);
            String errorInfo = template.invokeOperation((IFormView)listView, "pre" + operateKey, pkValues);
            if (HRStringUtils.isEmpty((String)errorInfo)) {
                template.singleOkCancelBox((IFormView)listView, pkValues[0], new ConfirmCallBackListener(operateKey, (IFormPlugin)this));
            } else {
                listView.showErrorNotification(errorInfo);
            }
        } else {
            args.setCancel(true);
            HashMap<Object, String> preErrorInfoMap = new HashMap<Object, String>(pkValues.length);
            String appId = formView.getFormShowParameter().getAppId();
            LOGGER.info("invoke operation appId|{}", (Object)appId);
            OperateOption operateOption = OperateOption.create();
            operateOption.setVariableValue("currbizappid", appId);
            OperationResult preOpResult = OperationServiceHelper.executeOperate((String)("pre" + operateKey), (String)listView.getBillFormId(), (Object[])pkValues, (OperateOption)operateOption);
            ArrayList<Object> preValidateSuccessPkValues = new ArrayList<Object>(pkValues.length);
            if (preOpResult.isSuccess()) {
                if (HRStringUtils.equals((String)operateKey, (String)"submit")) {
                    Map<Object, String> errorInfoMap = this.batchInvokeOperation((IFormView)listView, operateKey, pkValues);
                    this.showConfirmResultPage(formView, errorInfoMap, template, pkValues);
                    formView.invokeOperation("refresh");
                } else {
                    template.multiOkCancelBox(this.getView(), new ConfirmCallBackListener(operateKey, (IFormPlugin)this));
                }
                return;
            }
            preValidateSuccessPkValues.addAll(preOpResult.getSuccessPkIds());
            preErrorInfoMap.putAll(preOpResult.getAllErrorOrValidateInfo().stream().collect(Collectors.toMap(IOperateInfo::getPkValue, IOperateInfo::getMessage, (v1, v2) -> v1 + " " + v2)));
            Set errorSet = preErrorInfoMap.values().stream().map(value -> value.substring(value.indexOf(65306) + 1)).collect(Collectors.toSet());
            if (preErrorInfoMap.size() == pkValues.length && errorSet.size() == 1) {
                listView.showErrorNotification((String)errorSet.iterator().next());
                return;
            }
            IPageCache pageCache = this.getPageCache();
            this.pageCatchAbleOperatePkValues(pageCache, preValidateSuccessPkValues);
            HashMap<String, Object> params = new HashMap<String, Object>(8);
            params.put("sumlabel", pkValues.length);
            params.put("incongruentlabel", preErrorInfoMap.size());
            params.put("coincidentlabel", pkValues.length - preErrorInfoMap.size());
            params.put("filename", template.getFileName());
            params.put("headDataList", template.getMulSelectConfirmExcelHead(formId));
            params.put("exportDataList", template.getMulSelectConfirmExportData(pkValues, preErrorInfoMap, formId));
            params.put("donothing_confirm", operateKey);
            params.put("isShowCommentFlag", template.isShowComment());
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("hlcm_mulselectconfirm");
            showParameter.setCaption(template.getName());
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            showParameter.setCustomParams(params);
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, operateKey));
            listView.showForm(showParameter);
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        String callBackId = event.getActionId();
        MulSelectConfirmTemplate template = MulSelectConfirmEnum.getTemplate((String)callBackId);
        Map result = (Map)event.getReturnData();
        if (template != null && result != null && ((Boolean)result.get("isConfirm")).booleanValue()) {
            IFormView formView = this.getView();
            Object[] ableOperatePkValues = this.parsePkValues(this.getPageCache().get(ABLE_OPERATE_PK_VALUES)).toArray();
            Map<Object, String> errorInfoMap = this.batchInvokeOperation(formView, callBackId, ableOperatePkValues);
            this.showConfirmResultPage(formView, errorInfoMap, template, ableOperatePkValues);
            formView.invokeOperation("refresh");
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
        String callBackId = event.getCallBackId();
        MulSelectConfirmTemplate template = MulSelectConfirmEnum.getTemplate((String)callBackId);
        if (template != null && event.getResult() == MessageBoxResult.Yes) {
            Object[] pkValues = this.getSelectedRows().getPrimaryKeyValues();
            IFormView formView = this.getView();
            if (pkValues.length == 1) {
                String errorInfo = template.invokeOperation(formView, callBackId, pkValues);
                if (HRStringUtils.isEmpty((String)errorInfo)) {
                    formView.showSuccessNotification(template.getSingleOkSuccessMessage());
                    formView.invokeOperation("refresh");
                } else {
                    formView.showErrorNotification(errorInfo);
                }
            } else {
                Map<Object, String> errorInfoMap = this.batchInvokeOperation(formView, callBackId, pkValues);
                this.showConfirmResultPage(formView, errorInfoMap, template, pkValues);
                formView.invokeOperation("refresh");
            }
        }
    }

    private void showConfirmResultPage(IFormView formView, Map<Object, String> errorInfoMap, MulSelectConfirmTemplate template, Object[] pkValues) {
        String formId = ((IListView)formView).getBillFormId();
        HashMap<String, Object> params = new HashMap<String, Object>(9);
        params.put("hasoperation", Boolean.FALSE);
        params.put("successperson", String.valueOf(pkValues.length - errorInfoMap.size()));
        params.put("successoperation", this.getSuccessOperation());
        params.put("failperson", String.valueOf(errorInfoMap.size()));
        params.put("failoperation", this.getFailOperation());
        params.put("excelname", template.getFileName());
        params.put("headdatalist", template.getConfirmResultExcelHead(formId));
        params.put("exportdatalist", template.getConfirmResultExportData(pkValues, errorInfoMap, formId));
        params.put("isShowCommentFlag", template.isShowComment());
        FormShowParameter formShow = new FormShowParameter();
        formShow.getOpenStyle().setShowType(ShowType.Modal);
        formShow.setFormId("hlcm_result");
        formShow.setCustomParams(params);
        formShow.setCaption(template.getName());
        formView.showForm(formShow);
        formView.invokeOperation("refresh");
        formView.sendFormAction(formView);
        if (!(formView instanceof IListView)) {
            formView.close();
        }
    }

    private List<Object> parsePkValues(String json) {
        ArrayList<Object> objects = new ArrayList();
        try {
            objects = (List)HRJSONUtils.cast((String)json, List.class);
        }
        catch (IOException e) {
            LOGGER.error((Throwable)e);
        }
        return objects;
    }

    private void pageCatchAbleOperatePkValues(IPageCache pageCache, List<Object> successPkIds) {
        try {
            pageCache.put(ABLE_OPERATE_PK_VALUES, HRJSONUtils.toString(successPkIds));
        }
        catch (IOException e) {
            LOGGER.error((Throwable)e);
        }
    }

    public Map<Object, String> batchInvokeOperation(IFormView formView, String operationKey, Object[] pkValues) {
        Map<Object, Object> errorMap = Maps.newHashMapWithExpectedSize((int)pkValues.length);
        try {
            String billFormId = ((IListView)formView).getBillFormId();
            String appId = formView.getFormShowParameter().getAppId();
            LOGGER.info("invoke operation billFormId:{},operationKey:{},pkValues:{},appId|{}", new Object[]{billFormId, operationKey, pkValues, appId});
            OperateOption operateOption = OperateOption.create();
            operateOption.setVariableValue("currbizappid", appId);
            OperationResult operationResult = OperationServiceHelper.executeOperate((String)operationKey, (String)billFormId, (Object[])pkValues, (OperateOption)operateOption);
            if (operationResult != null && !operationResult.isSuccess()) {
                List allErrorOrValidateInfo = operationResult.getAllErrorOrValidateInfo();
                String wfAssignPersonsMsg = ResManager.loadKDString((String)"\u5728\u9700\u8981\u6307\u5b9a\u4e0b\u4e00\u6b65\u53c2\u4e0e\u4eba\u7684\u60c5\u51b5\u4e0b\u4e0d\u5141\u8bb8\u591a\u9009\u3002", (String)"WfAssignPersonsFacade_0", (String)"bos-wf-facade", (Object[])new Object[0]);
                if (!CollectionUtils.isEmpty((Collection)allErrorOrValidateInfo)) {
                    List notNullPkValue = allErrorOrValidateInfo.stream().map(IOperateInfo::getPkValue).filter(Objects::nonNull).collect(Collectors.toList());
                    if (notNullPkValue.isEmpty()) {
                        HashMap wfAssignPersonsErrorMap = Maps.newHashMapWithExpectedSize((int)pkValues.length);
                        allErrorOrValidateInfo.stream().map(IOperateInfo::getMessage).filter(msg -> HRStringUtils.equals((String)msg, (String)wfAssignPersonsMsg)).findFirst().ifPresent(msg -> wfAssignPersonsErrorMap.putAll(Arrays.stream(pkValues).collect(Collectors.toMap(id -> id, id -> msg))));
                        errorMap.putAll(wfAssignPersonsErrorMap);
                    } else {
                        Map<Object, List<IOperateInfo>> operationInfoMap = allErrorOrValidateInfo.stream().collect(Collectors.groupingBy(IOperateInfo::getPkValue));
                        errorMap = operationInfoMap.keySet().stream().collect(Collectors.toMap(key -> key, key -> {
                            List operateInfos = (List)operationInfoMap.get(key);
                            return ((IOperateInfo)operateInfos.get(operateInfos.size() - 1)).getMessage();
                        }, (v1, v2) -> v1 + " " + v2));
                        String unKnowErrorMsg = ResManager.loadKDString((String)"\u6570\u636e\u6709\u8bef", (String)"AbstractMulSelectConfirmTemplate_2", (String)"hr-hlcm-business", (Object[])new Object[0]);
                        Set<Object> failIds = errorMap.keySet();
                        List successPkIds = operationResult.getSuccessPkIds();
                        HashMap unKnowErrorMap = Maps.newHashMapWithExpectedSize((int)pkValues.length);
                        Arrays.stream(pkValues).filter(pkValue -> !failIds.contains(pkValue)).filter(pkValue -> !successPkIds.contains(pkValue)).forEach(failId -> unKnowErrorMap.put(failId, unKnowErrorMsg));
                        errorMap.putAll(unKnowErrorMap);
                    }
                } else {
                    errorMap = Arrays.stream(pkValues).collect(Collectors.toMap(id -> id, id -> pkValues.length == 1 && operationResult.isNeedWfAssignPersons() ? wfAssignPersonsMsg : operationResult.getMessage()));
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("invoke operation error", (Throwable)e);
            String message = e.getMessage();
            errorMap = Arrays.stream(pkValues).collect(Collectors.toMap(pkValue -> pkValue, pkValue -> message));
        }
        return errorMap;
    }

    public String getSuccessOperation() {
        return ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f", (String)"AbstractMulSelectConfirmTemplate_0", (String)"hr-hlcm-business", (Object[])new Object[0]);
    }

    public String getFailOperation() {
        return ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25", (String)"AbstractMulSelectConfirmTemplate_1", (String)"hr-hlcm-business", (Object[])new Object[0]);
    }
}

