/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hlcm.formplugin.handlebill;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.TextProp;
import kd.bos.entity.report.CellStyle;
import kd.bos.fileservice.extension.FileServiceExtFactory;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.OperationColumn;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.operatecol.OperationColItem;
import kd.bos.list.BillList;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mutex.DataMutex;
import kd.bos.mutex.impl.MutexFactory;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hlcm.business.domian.repository.CommonRepository;
import kd.hr.hlcm.business.domian.sharecenter.IShareService;
import kd.hr.hlcm.business.service.ContractTplService;
import kd.hr.hlcm.business.utils.ActivityUtils;
import kd.hr.hlcm.business.utils.AttachmentUtils;
import kd.hr.hlcm.common.enums.ActivityTaskStatusEnum;
import kd.hr.hlcm.common.enums.BillStatusEnum;
import kd.hr.hlcm.common.enums.BusinessTypeEnum;
import kd.hr.hlcm.common.enums.HandleStatusEnum;
import kd.hr.hlcm.common.enums.ProtocolTypeEnum;
import kd.hr.hlcm.common.enums.SignStatusEnum;
import kd.hr.hlcm.common.utils.ComboUtils;
import kd.hr.hlcm.common.utils.DateUtil;
import kd.hr.hlcm.common.utils.HeadCardUtil;
import kd.hr.hlcm.formplugin.billapply.empprotocolapply.ContractProtocolBaseFormPlugin;
import kd.hr.hlcm.formplugin.utils.CardInfoHelper;
import kd.sdk.hr.ssc.common.dto.SLATimeInfoDTO;
import org.apache.commons.lang3.tuple.ImmutablePair;

public class HandleBillPlugin
extends ContractProtocolBaseFormPlugin {
    private static final Log LOGGER = LogFactory.getLog(HandleBillPlugin.class);
    private static final String FIELD_REMAINDAYS = "remaindays";
    private static final String FIELD_ACTIVITY_STAGE = "activitystage";
    private static final String FIELD_ACTIVITY_STATUS = "activitystatus";
    private static final String FIELD_COMPLETION_SCHEDULE = "completionschedule";
    private static final String FIELD_EARLY_WARN_ACTIVITY_NUM = "earlywarnactivitynum";
    private static final String LABEL_NEW_CONTRACT_INFO_TAG = "newcontractinfotag";
    private static final String LABEL_TAB_PAGE_AP1 = "tabpageap1";

    public void initialize() {
        if (!this.hasEntryGrid()) {
            return;
        }
        super.initialize();
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        entryGrid.addPackageDataListener(pkEvent -> {
            boolean isOperationColumn;
            DynamicObject rowData = pkEvent.getRowData();
            Object contractTemplate = rowData.get("contracttemplate");
            boolean bl = isOperationColumn = pkEvent.getSource() instanceof OperationColumn && "operationcolumnap".equalsIgnoreCase(((OperationColumn)pkEvent.getSource()).getKey());
            if (isOperationColumn && !HRObjectUtils.isEmpty((Object)contractTemplate)) {
                String fileName = rowData.getString("attachmentfield1");
                LOGGER.info("Entry attachmentfield1 is:{}", (Object)fileName);
                List operationColItems = (List)pkEvent.getFormatValue();
                for (OperationColItem operationColItem : operationColItems) {
                    operationColItem.setVisible(HRStringUtils.isNotEmpty((String)fileName));
                }
            }
            if (isOperationColumn && HRObjectUtils.isEmpty((Object)contractTemplate)) {
                List operationColItems = (List)pkEvent.getFormatValue();
                for (OperationColItem operationColItem : operationColItems) {
                    operationColItem.setVisible(false);
                }
            }
        });
    }

    private boolean hasEntryGrid() {
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        return Objects.nonNull(entryGrid);
    }

    @Override
    public void registerListener(EventObject evt) {
        super.registerListener(evt);
        this.addClickListeners(new String[]{"lblcheckagain"});
        Tab tabControl = (Tab)this.getControl("tabap");
        tabControl.addTabSelectListener(tabSelectEvent -> {
            if (HRStringUtils.equals((String)tabSelectEvent.getTabKey(), (String)LABEL_TAB_PAGE_AP1)) {
                this.showInContainerForm();
            }
        });
        BillList listControl = (BillList)this.getControl("billlistap");
        DynamicObject dataEntity = this.getModel().getDataEntity();
        this.renderBillList(listControl, dataEntity);
    }

    public void click(EventObject evt) {
        super.click(evt);
        String sourceKey = ((Control)evt.getSource()).getKey();
        if (HRStringUtils.equals((String)"lblcheckagain", (String)sourceKey)) {
            this.showInContainerForm();
        }
    }

    private void showInContainerForm() {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("hlcm_handlecheck");
        showParameter.getOpenStyle().setShowType(ShowType.InContainer);
        showParameter.getOpenStyle().setTargetKey("checkinfopane");
        showParameter.setCustomParam("signapplyid", this.getModel().getDataEntity().getPkValue());
        this.getView().showForm(showParameter);
    }

    @Override
    public void afterBindData(EventObject event) {
        DataMutex dataMutex = MutexFactory.createDataMutex();
        DynamicObject dataEntity = this.getModel().getDataEntity();
        dataMutex.release(dataEntity.getPkValue().toString(), dataEntity.getDataEntityType().getName(), "modify");
    }

    private void setDifBusinessTypePanelInfo() {
        String businessType = this.getModel().getDataEntity().getString("businesstype");
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        if (HRStringUtils.equals((String)BusinessTypeEnum.RENEW.getCombKey(), (String)businessType) || HRStringUtils.equals((String)BusinessTypeEnum.CHANGE.getCombKey(), (String)businessType)) {
            CardInfoHelper instance = CardInfoHelper.getInstance();
            instance.setHandleBillRenewOrChangePanelInfo(model, view, businessType);
            Label label = (Label)view.getControl(LABEL_NEW_CONTRACT_INFO_TAG);
            if (HRStringUtils.equals((String)BusinessTypeEnum.RENEW.getCombKey(), (String)businessType)) {
                label.setText(ResManager.loadKDString((String)"\u5f85\u7eed\u7b7e\u5408\u540c\u4fe1\u606f", (String)"HandleBillPlugin_9", (String)"hr-hlcm-formplugin", (Object[])new Object[0]));
            }
            if (HRStringUtils.equals((String)BusinessTypeEnum.CHANGE.getCombKey(), (String)businessType)) {
                label.setText(ResManager.loadKDString((String)"\u5f85\u6539\u7b7e\u5408\u540c\u4fe1\u606f", (String)"HandleBillPlugin_10", (String)"hr-hlcm-formplugin", (Object[])new Object[0]));
            }
        }
    }

    @Override
    public void beforeBindData(EventObject evt) {
        super.beforeBindData(evt);
        DynamicObject dataEntity = this.getModel().getDataEntity();
        BillList listControl = (BillList)this.getControl("billlistap");
        this.renderBillList(listControl, dataEntity);
        String billname = ResManager.loadKDString((String)"\u529e\u7406\u5355", (String)"HandleBillPlugin_8", (String)"hr-hlcm-formplugin", (Object[])new Object[0]);
        String concat = this.getCaption().concat(billname).concat("-").concat(dataEntity.getString("empname"));
        int probationPeriod = dataEntity.getBigDecimal("probationperiod").intValue();
        String probationUnit = ComboUtils.getComboOptionLocaleName((DynamicObject)dataEntity, (String)"probationunit");
        this.getModel().setValue("probationperiodunit", (Object)String.format(Locale.ROOT, "%s%s", probationPeriod == 0 ? "-" : String.valueOf(probationPeriod), probationUnit));
        this.getView().setFormTitle(new LocaleString(concat));
        HeadCardUtil.showBillHeadView((IFormView)this.getView(), (DynamicObject)dataEntity, (String)"2");
        this.modifyLabel();
        this.setDifBusinessTypePanelInfo();
        this.setVisible();
        AttachmentUtils.bindAttachment((IFormView)this.getView());
        if (ProtocolTypeEnum.CON.getCombKey().equals(dataEntity.getString("protocoltype"))) {
            DynamicObjectCollection entryEntities = dataEntity.getDynamicObjectCollection("entryentity");
            for (int index = 0; index < entryEntities.size(); ++index) {
                DynamicObject entryEntity = (DynamicObject)entryEntities.get(index);
                String fileName = this.getFileName(entryEntity);
                this.getModel().setValue("attachmentfield1", (Object)fileName, index);
            }
        }
    }

    private String getFileName(DynamicObject entryEntity) {
        String fileName;
        DynamicObject contractTemplate = entryEntity.getDynamicObject("contracttemplate");
        if (HRObjectUtils.isEmpty((Object)contractTemplate)) {
            LOGGER.info("contractTemplate is empty");
            return null;
        }
        String url = entryEntity.getString("presigndocurl");
        if (HRStringUtils.isEmpty((String)url)) {
            DynamicObject attachment = this.getAttachment(entryEntity);
            if (Objects.isNull(attachment)) {
                return null;
            }
            fileName = attachment.getString("fattachmentname");
        } else {
            LOGGER.info("signDocUrl:{}", (Object)url);
            url = FileServiceExtFactory.getAttachFileServiceExt().getRealPath(url);
            fileName = url.substring(url.lastIndexOf(47) + 1);
        }
        return fileName;
    }

    private DynamicObject getAttachment(DynamicObject entryEntity) {
        QFilter[] qFilterArray;
        boolean isView;
        DynamicObject contractTemplate = entryEntity.getDynamicObject("contracttemplate");
        DynamicObject contractTemplateHis = entryEntity.getDynamicObject("texthis");
        boolean bl = isView = this.getView().getFormShowParameter().getStatus() == OperationStatus.VIEW;
        if (isView) {
            QFilter[] qFilterArray2 = new QFilter[2];
            qFilterArray2[0] = new QFilter("fbilltype", "=", (Object)"hlcm_contracttemplatehis");
            qFilterArray = qFilterArray2;
            qFilterArray2[1] = new QFilter("finterid", "=", (Object)String.valueOf(Optional.ofNullable(contractTemplateHis).map(DataEntityBase::getPkValue).orElseGet(() -> 0L)));
        } else {
            QFilter[] qFilterArray3 = new QFilter[2];
            qFilterArray3[0] = new QFilter("fbilltype", "=", (Object)"hlcm_contracttemplate");
            qFilterArray = qFilterArray3;
            qFilterArray3[1] = new QFilter("finterid", "=", (Object)String.valueOf(contractTemplate.getPkValue()));
        }
        QFilter[] filters = qFilterArray;
        DynamicObject[] attachments = CommonRepository.query((String)"bos_attachment", (String)String.join((CharSequence)",", "ffileid", "fattachmentname"), (QFilter[])filters);
        if (attachments == null || attachments.length == 0) {
            LOGGER.info("attachments is empty");
            return null;
        }
        return attachments[0];
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        if (HRStringUtils.equals((String)"refreshtable", (String)operateKey)) {
            BillList listControl = (BillList)this.getControl("billlistap");
            this.renderBillList(listControl, this.getModel().getDataEntity());
            listControl.refreshData();
            AttachmentUtils.bindAttachment((IFormView)this.getView());
        }
        super.beforeDoOperation(args);
    }

    private void renderBillList(final BillList listControl, DynamicObject dataEntity) {
        QFilter signApplyFilter = new QFilter("signapply", "=", dataEntity.getPkValue());
        listControl.getQueryFilterParameter().getQFilters().add(signApplyFilter);
        listControl.addCreateListDataProviderListener(beforeCreateListDataProviderArgs -> beforeCreateListDataProviderArgs.setListDataProvider((IListDataProvider)new ListDataProvider(){

            public DynamicObjectCollection getData(int start, int limit) {
                DynamicObjectCollection rows = super.getData(start, limit);
                long completionSchedule = rows.stream().filter(row -> HRStringUtils.equals((String)row.getString("activityins.taskstatus"), (String)ActivityTaskStatusEnum.COMPLETED.getCombKey())).count();
                HandleBillPlugin.this.getModel().setValue(HandleBillPlugin.FIELD_COMPLETION_SCHEDULE, (Object)String.format(Locale.ROOT, "%d/%d", completionSchedule, rows.size()));
                if (rows.isEmpty()) {
                    return rows;
                }
                TextProp remainDaysProp = new TextProp();
                remainDaysProp.setName(HandleBillPlugin.FIELD_REMAINDAYS);
                ComboProp activityStageProp = new ComboProp();
                activityStageProp.setName(HandleBillPlugin.FIELD_ACTIVITY_STAGE);
                TextProp activityHandleStatus = new TextProp();
                activityHandleStatus.setName(HandleBillPlugin.FIELD_ACTIVITY_STATUS);
                DataEntityPropertyCollection properties = ((DynamicObject)rows.get(0)).getDataEntityType().getProperties();
                properties.add((Object)remainDaysProp);
                properties.add((Object)activityStageProp);
                properties.add((Object)activityHandleStatus);
                AtomicInteger earlyWarnActivityNum = new AtomicInteger(0);
                Map slaMap = IShareService.getInstance().getSlaInfo(rows);
                rows.forEach(row -> {
                    int index = row.getInt("fseq") - 1;
                    Date deadLine = row.getDate("deadline");
                    String taskStatus = row.getString("activityins.taskstatus");
                    SLATimeInfoDTO slaTimeInfoDTO = (SLATimeInfoDTO)slaMap.get(row.getLong("id"));
                    if (slaTimeInfoDTO != null) {
                        row.set("activityins.createtime", (Object)slaTimeInfoDTO.getCreateTime());
                        deadLine = slaTimeInfoDTO.getLatestdFinishTime();
                        row.set("deadline", (Object)deadLine);
                        row.set(HandleBillPlugin.FIELD_REMAINDAYS, (Object)(Objects.isNull(deadLine) || Arrays.asList(ActivityTaskStatusEnum.TERMINATED.getCombKey(), ActivityTaskStatusEnum.COMPLETED.getCombKey()).contains(taskStatus) ? "-" : slaTimeInfoDTO.getRemainingDays()));
                    } else if (Objects.isNull(deadLine) || Arrays.asList(ActivityTaskStatusEnum.TERMINATED.getCombKey(), ActivityTaskStatusEnum.COMPLETED.getCombKey()).contains(taskStatus)) {
                        row.set(HandleBillPlugin.FIELD_REMAINDAYS, (Object)"-");
                    } else {
                        String remaindays = DateUtil.getDateDiff((Date)new Date(), (Date)deadLine);
                        row.set(HandleBillPlugin.FIELD_REMAINDAYS, (Object)remaindays);
                    }
                    Date threeDayAfter = HRDateTimeUtils.addDay((Date)new Date(), (long)3L);
                    if (!"-".equals(row.getString(HandleBillPlugin.FIELD_REMAINDAYS)) && deadLine != null && !deadLine.after(threeDayAfter)) {
                        earlyWarnActivityNum.incrementAndGet();
                        HandleBillPlugin.this.setGridFiledStyle(listControl, index, HandleBillPlugin.FIELD_REMAINDAYS, "#F00");
                    }
                    String activityStage = "0";
                    if (HRStringUtils.isNotEmpty((String)taskStatus)) {
                        activityStage = "1";
                    }
                    row.set(HandleBillPlugin.FIELD_ACTIVITY_STAGE, (Object)activityStage);
                    ImmutablePair activityStatus = ActivityUtils.getActivityStatus((DynamicObject)row);
                    row.set(HandleBillPlugin.FIELD_ACTIVITY_STATUS, activityStatus.getLeft());
                    HandleBillPlugin.this.setGridFiledStyle(listControl, index, HandleBillPlugin.FIELD_ACTIVITY_STATUS, (String)activityStatus.getRight());
                });
                HandleBillPlugin.this.getModel().setValue(HandleBillPlugin.FIELD_EARLY_WARN_ACTIVITY_NUM, (Object)earlyWarnActivityNum.get());
                return rows;
            }
        }));
    }

    private void modifyLabel() {
        BasedataEdit contractReason = (BasedataEdit)this.getControl("cancelreasontype");
        FieldEdit cancelDate = (FieldEdit)this.getControl("canceldate");
        String businessType = this.getModel().getDataEntity().getString("businesstype");
        switch (BusinessTypeEnum.matcher((String)businessType)) {
            case CANCEL: {
                contractReason.setCaption(ResManager.getLocaleString((String)"\u89e3\u9664\u539f\u56e0", (String)"HandleBillPlugin_6", (String)"hr-hlcm-formplugin"));
                cancelDate.setCaption(ResManager.getLocaleString((String)"\u89e3\u9664\u65e5\u671f", (String)"HandleBillPlugin_7", (String)"hr-hlcm-formplugin"));
                break;
            }
            case STOP: {
                contractReason.setCaption(ResManager.getLocaleString((String)"\u7ec8\u6b62\u539f\u56e0", (String)"HandleBillPlugin_4", (String)"hr-hlcm-formplugin"));
                cancelDate.setCaption(ResManager.getLocaleString((String)"\u7ec8\u6b62\u65e5\u671f", (String)"HandleBillPlugin_5", (String)"hr-hlcm-formplugin"));
                break;
            }
        }
    }

    private void setVisible() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        String businessType = dataEntity.getString("businesstype");
        String protocolType = dataEntity.getString("protocoltype");
        HashSet businessTypeSet = Sets.newHashSet((Object[])new String[]{BusinessTypeEnum.NEW.getCombKey(), BusinessTypeEnum.RENEW.getCombKey(), BusinessTypeEnum.CHANGE.getCombKey()});
        if (businessTypeSet.contains(businessType)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"oldcontractpanelap"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"tosignpanelap1"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"contractinfonewpanel"});
            this.getView().setVisible(Boolean.FALSE, new String[]{LABEL_TAB_PAGE_AP1, "flexpanelap2"});
        }
        if (HRStringUtils.equals((String)ProtocolTypeEnum.CON.getCombKey(), (String)protocolType) && HRStringUtils.equals((String)BusinessTypeEnum.NEW.getCombKey(), (String)businessType)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"contractinfonewpanel"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"renewcount"});
        } else if (HRStringUtils.equals((String)ProtocolTypeEnum.CON.getCombKey(), (String)protocolType) && HRStringUtils.equals((String)BusinessTypeEnum.RENEW.getCombKey(), (String)businessType)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"tosignpanelap1"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"probationstartdate", "probationenddate", "probationperiodunit"});
        } else if (HRStringUtils.equals((String)ProtocolTypeEnum.FS.getCombKey(), (String)protocolType) && HRStringUtils.equals((String)BusinessTypeEnum.NEW.getCombKey(), (String)businessType)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"contractinfonewpanel"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"probationstartdate", "probationenddate", "probationperiodunit", "renewcount"});
        } else if (HRStringUtils.equals((String)ProtocolTypeEnum.CON.getCombKey(), (String)protocolType) && HRStringUtils.equals((String)BusinessTypeEnum.CHANGE.getCombKey(), (String)businessType)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"tosignpanelap1"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"probationstartdate", "probationenddate", "probationperiodunit", "renewcount"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"newfield09"});
        } else if (HRStringUtils.equals((String)ProtocolTypeEnum.YG.getCombKey(), (String)protocolType) && HRStringUtils.equals((String)BusinessTypeEnum.NEW.getCombKey(), (String)businessType)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"contractinfonewpanel"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"probationstartdate", "probationenddate", "probationperiodunit", "renewcount"});
        } else {
            LOGGER.info("protocolType|{},businessType|{}", (Object)protocolType, (Object)businessType);
        }
        String handleStatus = dataEntity.getString("handlestatus");
        String signStatus = dataEntity.getString("signstatus");
        String billStatus = dataEntity.getString("billstatus");
        this.getView().setVisible(Boolean.valueOf(HRStringUtils.equals((String)handleStatus, (String)HandleStatusEnum.PROCESSEND.getCombKey())), new String[]{"flexpanelap"});
        this.getView().setVisible(Boolean.valueOf(HRStringUtils.equals((String)handleStatus, (String)HandleStatusEnum.PROCESSIN.getCombKey())), new String[]{"bar_terminate"});
        boolean archivePreconditionSignStatus = HRStringUtils.equals((String)signStatus, (String)SignStatusEnum.COMPLETE_SIGN.getCombKey());
        boolean archivePreconditionBillStatus = Sets.newHashSet((Object[])new String[]{BillStatusEnum.STATUS_APPROVED.getCode(), BillStatusEnum.STATUS_PASS.getCode()}).contains(billStatus);
        boolean archivePreconditionHandleStatus = !HRStringUtils.equals((String)handleStatus, (String)HandleStatusEnum.ARCHIVE.getCombKey());
        this.getView().setVisible(Boolean.valueOf(archivePreconditionSignStatus && archivePreconditionBillStatus && archivePreconditionHandleStatus), new String[]{"bar_file"});
        this.getView().setVisible(Boolean.valueOf(dataEntity.getBoolean("isexistsworkflow")), new String[]{"flexpanelap8"});
        if (!HRStringUtils.equals((String)ProtocolTypeEnum.CON.getCombKey(), (String)protocolType)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"contractsigntemppanelap", "issignother", "contractremark"});
        }
    }

    private String getCaption() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        String businessType = ComboUtils.getComboOptionLocaleName((DynamicObject)dataEntity, (String)"businesstype");
        String protocolType = ComboUtils.getComboOptionLocaleName((DynamicObject)dataEntity, (String)"protocoltype");
        return protocolType + businessType;
    }

    private void setGridFiledStyle(BillList billList, int index, String fieldKey, String color) {
        ArrayList<CellStyle> cellStyleList = new ArrayList<CellStyle>();
        CellStyle cellStyle = new CellStyle();
        cellStyle.setRow(index);
        cellStyle.setFieldKey(fieldKey);
        cellStyle.setForeColor(color);
        cellStyleList.add(cellStyle);
        billList.setCellStyle(cellStyleList);
    }

    @Override
    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if (HRStringUtils.equals((String)operateKey, (String)"contractdownload")) {
            ContractTplService.contractdownload((IFormView)this.getView(), (IDataModel)this.getModel());
        } else if (HRStringUtils.equals((String)operateKey, (String)"contractpreview")) {
            ContractTplService.contractpreview((IFormView)this.getView(), (IDataModel)this.getModel());
        }
    }
}

