/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hlcm.formplugin.importplugin;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ImportDataEventArgs;
import kd.bos.entity.datamodel.events.InitImportDataEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.bill.BillModel;
import kd.bos.util.StringUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hlcm.business.domian.repository.CommonRepository;
import kd.hr.hlcm.business.utils.ContractSignUtils;
import kd.hr.hlcm.business.utils.HLCMImportUtils;
import kd.hr.hlcm.common.entity.ErManQueryParam;
import kd.hr.hlcm.common.entity.PersonInfo;

public abstract class SignImportBasePlugin
extends AbstractFormPlugin {
    private static final Log LOGGER = LogFactory.getLog(SignImportBasePlugin.class);
    private static final String PERSON_INFO = "personinfo";
    private static final String BASEDATAMAPS = "baseDataMaps";
    private static final String OP_PERSON = "op_person";
    private Set<String> contractNumberSet = new HashSet<String>();

    public void initImportData(InitImportDataEventArgs evt) {
        IDataModel signBillModel = this.getModel();
        BillModel source = (BillModel)signBillModel;
        String signBillId = source.getMainEntityType().toString();
        HashSet erManQueryParamSet = new HashSet();
        List erManQueryParamList = HLCMImportUtils.filterRepeatDataRow((InitImportDataEventArgs)evt, (String)signBillId, erManQueryParamSet);
        Map<String, Map<String, DynamicObject>> baseDataMaps = this.getBaseDataMaps(evt, signBillId);
        Map<Long, ErManQueryParam> erManFileIdMap = this.queryAndCheckErManFile(evt, erManQueryParamList);
        this.checkMustInput(evt);
        String entityId = this.getView().getEntityId();
        Map personInfoByEmpNumber = HLCMImportUtils.getPersonInfoByErManFileId((String)entityId, erManFileIdMap);
        long currUserId = RequestContext.get().getCurrUserId();
        DynamicObject person = CommonRepository.queryById((String)"bos_user", (String)"id,name", (Long)currUserId);
        this.getModel().putContextVariable(PERSON_INFO, (Object)personInfoByEmpNumber);
        this.getModel().putContextVariable(BASEDATAMAPS, baseDataMaps);
        this.getModel().putContextVariable(OP_PERSON, (Object)person);
        this.setPersonProperty(personInfoByEmpNumber, evt.getSourceDataList());
    }

    private void setPersonProperty(Map<ErManQueryParam, PersonInfo> personInfoMap, List<Map<String, Object>> sourceDataList) {
        if (personInfoMap == null || personInfoMap.size() < 1) {
            return;
        }
        Map<String, Long> personIdMap = personInfoMap.values().stream().collect(Collectors.toMap(PersonInfo::getEmpNumber, PersonInfo::getPersonId, (o, n) -> n));
        sourceDataList.forEach(sourceData -> {
            JSONObject personJson = (JSONObject)sourceData.get("person");
            String personNumber = personJson.getString("number");
            if (HRStringUtils.isNotEmpty((String)personNumber)) {
                personJson.put("importprop", (Object)"id");
                personJson.put("id", personIdMap.get(personNumber));
            }
        });
    }

    private void checkMustInput(InitImportDataEventArgs evt) {
        List sourceDataList = evt.getSourceDataList();
        BillModel source = (BillModel)evt.getSource();
        String contractTypeName = ContractSignUtils.getContractNameBySignBill((String)source.getMainEntityType().toString());
        String entityId = this.getView().getEntityId();
        boolean existCodeRule = ContractSignUtils.isExistByCurrentDy((String)contractTypeName);
        boolean existOtherCodeRule = ContractSignUtils.isExistByCurrentDy((String)"hlcm_contractfileother");
        for (int sourceDataIndex = 0; sourceDataIndex < sourceDataList.size(); ++sourceDataIndex) {
            BigDecimal periodBigDecimal;
            HashSet pages;
            String entryErrorMsg;
            Map map = (Map)sourceDataList.get(sourceDataIndex);
            if (null == map.get("stdpositionmodel") && null == map.get("positionmodel") && null == map.get("job")) {
                evt.addCancelMessage(Integer.valueOf(sourceDataIndex), Integer.valueOf(0), Integer.valueOf(0), ResManager.loadKDString((String)"\u5c97\u4f4d\u7f16\u7801\u3001\u6807\u51c6\u5c97\u4f4d\u7f16\u7801\u3001\u804c\u4f4d\u7f16\u7801\u5fc5\u987b\u586b\u5199\u4e00\u4e2a\u3002", (String)"SignImportBasePlugin_2", (String)"hr-hlcm-formplugin", (Object[])new Object[0]));
            }
            if (this.postInfoRepeat(map)) {
                evt.addCancelMessage(Integer.valueOf(sourceDataIndex), Integer.valueOf(0), Integer.valueOf(0), ResManager.loadKDString((String)"\u5c97\u4f4d\u7f16\u7801\u3001\u6807\u51c6\u5c97\u4f4d\u7f16\u7801\u3001\u804c\u4f4d\u7f16\u7801\u53ea\u80fd\u586b\u5199\u4e00\u4e2a\u3002", (String)"SignImportBasePlugin_7", (String)"hr-hlcm-formplugin", (Object[])new Object[0]));
            }
            String cardTypeNumber = Optional.ofNullable((JSONObject)map.get("cardtype")).map(type -> type.get((Object)"number")).map(Object::toString).orElse(null);
            String cardNumber = (String)map.get("cardnumber");
            if (HRStringUtils.isEmpty((String)cardTypeNumber) && HRStringUtils.isNotEmpty((String)cardNumber) || HRStringUtils.isNotEmpty((String)cardTypeNumber) && HRStringUtils.isEmpty((String)cardNumber)) {
                evt.addCancelMessage(Integer.valueOf(sourceDataIndex), Integer.valueOf(0), Integer.valueOf(0), ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u8bc1\u636e\u7c7b\u578b\u4e0e\u8bc1\u4ef6\u53f7\u7801\u662f\u5426\u9700\u8981\u586b\u5199\uff0c\u5982\u9700\u8981\u8bf7\u586b\u5199\u5b8c\u6574\uff0c\u4e0d\u9700\u8981\u5219\u5747\u4e0d\u586b\u5199\u3002", (String)"SignImportBasePlugin_32", (String)"hr-hlcm-formplugin", (Object[])new Object[0]));
            }
            if (HRStringUtils.isNotEmpty((String)(entryErrorMsg = this.checkContractEntry(map, this.contractNumberSet, existOtherCodeRule, entityId)))) {
                evt.addCancelMessage(Integer.valueOf(sourceDataIndex), Integer.valueOf(0), Integer.valueOf(0), entryErrorMsg);
            }
            if ((pages = Sets.newHashSet((Object[])new String[]{"hlcm_contractapplyend", "hlcm_contractapplycancel", "hlcm_empprotocolrelieve"})).contains(entityId)) continue;
            if (existCodeRule) {
                map.put("contractnumber", "LDHT-20020231-00001");
            } else if (null == map.get("contractnumber")) {
                evt.addCancelMessage(Integer.valueOf(sourceDataIndex), Integer.valueOf(0), Integer.valueOf(0), ResManager.loadKDString((String)"\u7cfb\u7edf\u65e0\u8bbe\u7f6e\u81ea\u52a8\u7f16\u7801\u89c4\u5219\uff0c\u5408\u540c\u7f16\u53f7\u4e3a\u5fc5\u5f55\u5b57\u6bb5\u3002", (String)"SignImportBasePlugin_6", (String)"hr-hlcm-formplugin", (Object[])new Object[0]));
            } else {
                String contractNumber = (String)String.class.cast(map.get("contractnumber"));
                if (this.contractNumberSet.contains(contractNumber)) {
                    evt.addCancelMessage(Integer.valueOf(sourceDataIndex), Integer.valueOf(0), Integer.valueOf(0), ResManager.loadKDString((String)"\u540c\u4e00\u5408\u540c\u6a21\u677f\u4e0b\uff0c\u5b58\u5728\u76f8\u540c\u5408\u540c\u7f16\u53f7\u201c%s\u201d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"SignImportBasePlugin_24", (String)"hr-hlcm-formplugin", (Object[])new Object[]{contractNumber}));
                } else {
                    this.contractNumberSet.add(contractNumber);
                }
            }
            Object periodField = map.get("period");
            if (null == periodField) continue;
            String period = (String)periodField;
            boolean periodError = true;
            boolean isNumeric = StringUtils.isNumeric((String)period);
            if (isNumeric && (periodBigDecimal = new BigDecimal(period)).compareTo(BigDecimal.ZERO) >= 0 && periodBigDecimal.compareTo(new BigDecimal("9999.9")) <= 0 && periodBigDecimal.scale() <= 1) {
                periodError = false;
            }
            if (!periodError) continue;
            evt.addCancelMessage(Integer.valueOf(sourceDataIndex), Integer.valueOf(0), Integer.valueOf(0), ResManager.loadKDString((String)"\u5408\u540c\u671f\u9650\u8303\u56f4\u8f93\u5165\u4e0d\u7b26\u5408\u89c4\u8303\uff0c\u53ef\u8f93\u5165\u8303\u56f4\u4e3a[0.0-9999.9]\uff0c\u8981\u6c42\u6574\u6570\u90e8\u5206\u4e0d\u80fd\u5927\u4e8e4\u4f4d\uff0c\u5c0f\u6570\u90e8\u5206\u4e0d\u80fd\u5927\u4e8e1\u4f4d\u3002", (String)"SignImportBasePlugin_8", (String)"hr-hlcm-formplugin", (Object[])new Object[0]));
        }
    }

    protected String checkContractEntry(Map<String, Object> dataMap, Set<String> contractNumberSet, boolean existOtherCodeRule, String entityId) {
        return "";
    }

    private boolean postInfoRepeat(Map<String, Object> map) {
        int stdposition = null != map.get("stdpositionmodel") ? 1 : 0;
        int position = null != map.get("positionmodel") ? 1 : 0;
        int job = null != map.get("job") ? 1 : 0;
        return stdposition + position + job > 1;
    }

    private Map<Long, ErManQueryParam> queryAndCheckErManFile(InitImportDataEventArgs evt, List<ErManQueryParam> erManQueryParamList) {
        Map erManQueryParamErManQueryResultMap = HLCMImportUtils.queryInitErManFile(erManQueryParamList);
        HashMap<Long, ErManQueryParam> result = new HashMap<Long, ErManQueryParam>();
        erManQueryParamErManQueryResultMap.forEach((erManQueryParam, erManQueryResult) -> {
            LOGGER.info("erManQueryParam|{},erManQueryResult|{}", (Object)JSON.toJSONString((Object)erManQueryParam), (Object)JSON.toJSONString((Object)erManQueryResult));
            String checkResult = this.doCheckErManFile(erManQueryResult.getPosTypeId(), erManQueryResult.getLaborRelTypeClsId(), erManQueryResult.getLabrelStatusPrdId());
            if (!StringUtils.isBlank((String)checkResult)) {
                LOGGER.info("checkResult|{},erManQueryParam.getNum|{}", (Object)checkResult, (Object)erManQueryParam.getNum());
                evt.addCancelMessage(Integer.valueOf(erManQueryParam.getNum()), Integer.valueOf(0), Integer.valueOf(0), checkResult);
            } else {
                result.put(erManQueryResult.getErManFileId(), (ErManQueryParam)erManQueryParam);
            }
        });
        return result;
    }

    protected abstract String doCheckErManFile(Long var1, List<Long> var2, Long var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterImportData(ImportDataEventArgs evt) {
        Map mapPersonInfo = (Map)this.getModel().getContextVariable(PERSON_INFO);
        Map baseDataMaps = (Map)this.getModel().getContextVariable(BASEDATAMAPS);
        Map sourceData = evt.getSourceData();
        JSONObject orgModelJo = (JSONObject)sourceData.get("orgmodel");
        String orgNumber = null != orgModelJo ? (String)orgModelJo.get((Object)"number") : null;
        JSONObject positionJo = (JSONObject)sourceData.get("positionmodel");
        String positionNumber = null != positionJo ? (String)positionJo.get((Object)"number") : null;
        JSONObject stdPositionJo = (JSONObject)sourceData.get("stdpositionmodel");
        String stdPositionNumber = null != stdPositionJo ? (String)stdPositionJo.get((Object)"number") : null;
        JSONObject jobJo = (JSONObject)sourceData.get("job");
        String jobNumber = null != jobJo ? (String)jobJo.get((Object)"number") : null;
        String empNumber = ((JSONObject)sourceData.get("person")).getString("number");
        ErManQueryParam erManQueryParam = new ErManQueryParam(empNumber, orgNumber, positionNumber, stdPositionNumber, jobNumber, 0);
        PersonInfo personInfo = (PersonInfo)mapPersonInfo.get(erManQueryParam);
        if (null == personInfo) {
            LOGGER.info("SignImportBasePlugin========afterImportData======erManQueryParam|{}======mapPersonInfo|{}", (Object)erManQueryParam.toString(), (Object)JSONObject.toJSONString((Object)mapPersonInfo));
            evt.setCancel(true);
            evt.addCancelMessage(Integer.valueOf(0), Integer.valueOf(0), ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u8be5\u5458\u5de5\u7684\u5de5\u53f7\u3001\u6240\u5c5e\u5c97\u4f4d\u3001\u6807\u51c6\u5c97\u4f4d\u3001\u804c\u4f4d\u3001\u90e8\u95e8\u662f\u5426\u6b63\u786e\u3002", (String)"SignImportBasePlugin_0", (String)"hr-hlcm-formplugin", (Object[])new Object[0]));
            return;
        }
        if (!personInfo.getPermission().booleanValue()) {
            evt.setCancel(true);
            evt.addCancelMessage(Integer.valueOf(0), Integer.valueOf(0), ResManager.loadKDString((String)"\u5f53\u524d\u5458\u5de5\u4e0d\u5728\u60a8\u7684\u7ba1\u7406\u6743\u9650\u8303\u56f4\u5185\u3002", (String)"SignImportBasePlugin_5", (String)"hr-hlcm-formplugin", (Object[])new Object[0]));
        }
        DynamicObject opPerson = (DynamicObject)this.getModel().getContextVariable(OP_PERSON);
        try {
            this.getModel().beginInit();
            this.getModel().setValue("periodunit", sourceData.get("periodunit"));
            this.fillSignBillInfo(personInfo, opPerson);
            this.fillVirtualFieldSignBillInfo(evt, sourceData, baseDataMaps);
        }
        finally {
            this.getModel().endInit();
        }
    }

    protected void fillSignBillInfo(PersonInfo personInfo, DynamicObject opPerson) {
        HLCMImportUtils.setSignBillPersonInfo((IDataModel)this.getModel(), (PersonInfo)personInfo, (DynamicObject)opPerson);
    }

    protected abstract void fillVirtualFieldSignBillInfo(ImportDataEventArgs var1, Map<String, Object> var2, Map<String, Map<String, DynamicObject>> var3);

    protected abstract Map<String, Map<String, DynamicObject>> getBaseDataMaps(InitImportDataEventArgs var1, String var2);
}

