/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hlcm.formplugin.mobile;

import java.util.EventObject;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.plugin.AbstractMobFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hlcm.business.domian.repository.ContractSignApplyRepository;
import kd.hr.hlcm.business.domian.service.signmgt.ISignManageService;
import kd.hr.hlcm.common.enums.BusinessStatusEnum;

public class EmpInfoConfirmPlugin
extends AbstractMobFormPlugin {
    private static final Log LOGGER = LogFactory.getLog(EmpInfoConfirmPlugin.class);
    private static final String CONFIRM = "confirm";
    private static final Long PROMPT_ID = 1386961390048260096L;
    private static final String HTML_AP = "htmlap";

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        e.getFormShowParameter().setHasRight(true);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        IFormView formView = this.getView();
        try {
            ISignManageService.getInstance().initPrompt(formView, PROMPT_ID, HTML_AP);
            DynamicObject signBill = ISignManageService.getInstance().loadCurUserSignBill((String)this.getView().getFormShowParameter().getCustomParam("id"));
            LOGGER.info("EmpInfoConfirmPlugin#signBill.businessstatus={}", (Object)signBill.getString("businessstatus"));
            if (!HRStringUtils.equals((String)signBill.getString("businessstatus"), (String)BusinessStatusEnum.CONFIRM.getCombKey())) {
                formView.setStatus(OperationStatus.VIEW);
            }
            IDataModel dataModel = this.getModel();
            dataModel.setValue("empname", signBill.get("empname"));
            dataModel.setValue("cardtype", signBill.get("cardtype"));
            dataModel.setValue("cardnumber", signBill.get("cardnumber"));
            dataModel.setValue("empphone", (Object)signBill.getString("empphone").replace("-", ""));
            dataModel.setValue("residentialaddress", signBill.get("residentialaddress"));
        }
        catch (Exception exception) {
            LOGGER.error(exception.getMessage(), (Throwable)exception);
            formView.setStatus(OperationStatus.VIEW);
            if (exception instanceof KDException) {
                formView.showErrorNotification(exception.getMessage());
            }
            formView.showErrorNotification(ResManager.loadKDString((String)"\u7cfb\u7edf\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u3002", (String)"SignContractInfoPlugin_2", (String)"hr-hlcm-formplugin", (Object[])new Object[0]));
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        if (HRStringUtils.equals((String)args.getOperateKey(), (String)CONFIRM) && args.getOperationResult() != null && args.getOperationResult().isSuccess()) {
            IFormView formView = this.getView();
            DynamicObject dataEntity = this.getModel().getDataEntity();
            LOGGER.info("EmpInfoConfirmPlugin#dataEntity.cardtype={}", (Object)dataEntity.getDynamicObject("cardtype"));
            String msg = ContractSignApplyRepository.getInstance().checkIDCard(dataEntity);
            if (HRStringUtils.isNotEmpty((String)msg)) {
                formView.showErrorNotification(msg);
                return;
            }
            String empPhone = dataEntity.getString("empphone");
            if (!HRStringUtils.startsWithIgnoreCase((String)empPhone, (String)"+86")) {
                formView.showErrorNotification(ResManager.loadKDString((String)"\u53ea\u53ef\u8f93\u5165\u4e2d\u56fd\u5927\u9646\u7684\u624b\u673a\u53f7\u7801\u3002", (String)"EmpInfoConfirmPlugin_0", (String)"hr-hlcm-formplugin", (Object[])new Object[0]));
                return;
            }
            String id = (String)formView.getFormShowParameter().getCustomParam("id");
            DynamicObject signBill = ISignManageService.getInstance().loadCurUserSignBill(id);
            LOGGER.info("EmpInfoConfirmPlugin#id={},signBill.businessstatus={}", (Object)id, (Object)signBill.getString("businessstatus"));
            if (HRStringUtils.equals((String)signBill.getString("businessstatus"), (String)BusinessStatusEnum.STOP.getCombKey())) {
                formView.showErrorNotification(ResManager.loadKDString((String)"\u60a8\u7684\u7b7e\u7f72\u6d41\u7a0b\u5df2\u7ec8\u6b62\uff0c\u8bf7\u8054\u7cfbHR\u8fdb\u884c\u5904\u7406\u3002", (String)"EmpInfoConfirmPlugin_3", (String)"hr-hlcm-formplugin", (Object[])new Object[0]));
            } else if (!HRStringUtils.equals((String)signBill.getString("businessstatus"), (String)BusinessStatusEnum.CONFIRM.getCombKey())) {
                formView.showErrorNotification(ResManager.loadKDString((String)"\u60a8\u7684\u4e2a\u4eba\u4fe1\u606f\u5df2\u63d0\u4ea4\u786e\u8ba4\uff0c\u65e0\u9700\u91cd\u590d\u786e\u8ba4\u3002", (String)"EmpInfoConfirmPlugin_4", (String)"hr-hlcm-formplugin", (Object[])new Object[0]));
            } else {
                try {
                    ISignManageService.getInstance().empInfoConfirm(id, dataEntity);
                }
                catch (KDBizException exception) {
                    formView.showErrorNotification(exception.getMessage());
                    return;
                }
                LOGGER.info("EmpInfoConfirmPlugin#show----hlcm_signcontractinfo");
                MobileFormShowParameter showParameter = new MobileFormShowParameter();
                showParameter.setFormId("hlcm_signcontractinfo");
                showParameter.setCustomParam("id", (Object)id);
                showParameter.getOpenStyle().setShowType(ShowType.Floating);
                formView.showForm((FormShowParameter)showParameter);
            }
        }
    }
}

