/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hlcm.formplugin.mobile;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.plugin.AbstractMobFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRJSONUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hlcm.business.domian.service.privacy.IPrivacyService;
import kd.hr.hlcm.business.domian.service.signmgt.ISignManageService;
import kd.hr.hlcm.common.enums.BusinessStatusEnum;
import kd.hr.hlcm.common.utils.ServicePageUtil;

public class SignInitializationPlugin
extends AbstractMobFormPlugin {
    private static final Log LOGGER = LogFactory.getLog(SignInitializationPlugin.class);

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        e.getFormShowParameter().setHasRight(true);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        LOGGER.info("UserAgent|{}", (Object)RequestContext.get().getUserAgent());
        IFormView formView = this.getView();
        Tuple result = null;
        try {
            result = IPrivacyService.getInstance().queryPrivacy("getPrivacySigningList");
        }
        catch (Exception exception) {
            LOGGER.error("IPrivacyService#queryPrivacy is failed", (Throwable)exception);
            formView.showErrorNotification(ResManager.loadKDString((String)"\u7cfb\u7edf\u5f02\u5e38\uff0c\u9690\u79c1\u58f0\u660e\u63a5\u53e3\u5f02\u5e38\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\u3002", (String)"EmpInfoConfirmPlugin_2", (String)"hr-hlcm-formplugin", (Object[])new Object[0]));
        }
        LOGGER.info("SignInitializationPlugin#result={}", JSON.toJSON((Object)result));
        if (result == null) {
            return;
        }
        if (((Boolean)result.item1).booleanValue()) {
            Map responseMap = HRJSONUtils.convertJSONObjectToMap((Object)result.item2);
            if (responseMap == null) {
                formView.showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u914d\u7f6e\u9690\u79c1\u58f0\u660e\u3002", (String)"EmpInfoConfirmPlugin_1", (String)"hr-hlcm-formplugin", (Object[])new Object[0]));
                return;
            }
            if (HRObjectUtils.equals((Object)"1", responseMap.get("isAgree"))) {
                this.redirectFormPage();
            } else {
                this.dealUnsignedPrivacy(responseMap);
            }
        } else {
            LOGGER.info(String.format("SignInitializationPlugin.isPrivacyAgree query privacy fail,errMsg:%s", result.item2));
            formView.showErrorNotification(ResManager.loadKDString((String)"\u7cfb\u7edf\u5f02\u5e38\uff0c\u9690\u79c1\u58f0\u660e\u63a5\u53e3\u5f02\u5e38\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\u3002", (String)"EmpInfoConfirmPlugin_2", (String)"hr-hlcm-formplugin", (Object[])new Object[0]));
        }
    }

    private void redirectFormPage() {
        DynamicObject signBill;
        IFormView formView = this.getView();
        String id = (String)formView.getFormShowParameter().getCustomParam("id");
        LOGGER.info("SignInitializationPlugin#redirectFormPage#id={}", (Object)id);
        try {
            signBill = ISignManageService.getInstance().loadCurUserSignBill(id);
        }
        catch (Exception exception) {
            LOGGER.error(exception.getMessage(), (Throwable)exception);
            if (exception instanceof KDException) {
                formView.showErrorNotification(exception.getMessage());
            } else {
                formView.showErrorNotification(ResManager.loadKDString((String)"\u7cfb\u7edf\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u3002", (String)"SignContractInfoPlugin_2", (String)"hr-hlcm-formplugin", (Object[])new Object[0]));
            }
            return;
        }
        String businessStatus = signBill.getString("businessstatus");
        DynamicObject contract = (DynamicObject)signBill.getDynamicObjectCollection("entryentity").get(0);
        String preSignDocUrl = contract.getString("presigndocurl");
        MobileFormShowParameter showParameter = new MobileFormShowParameter();
        if (HRStringUtils.equals((String)businessStatus, (String)BusinessStatusEnum.CONFIRM.getCombKey()) && HRStringUtils.isEmpty((String)preSignDocUrl)) {
            showParameter.setFormId("hlcm_empinfoconfirm");
        } else if (signBill.getDynamicObjectCollection("entryentity").size() > 1 && Lists.newArrayList((Object[])new String[]{BusinessStatusEnum.CSIGN.getCombKey(), BusinessStatusEnum.CHECK.getCombKey(), BusinessStatusEnum.ARCHIVE.getCombKey()}).contains(businessStatus)) {
            showParameter.setFormId("hlcm_contractinformation");
        } else {
            showParameter.setFormId("hlcm_signcontractinfo");
        }
        showParameter.setCustomParam("id", (Object)id);
        showParameter.getOpenStyle().setShowType(ShowType.Floating);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void dealUnsignedPrivacy(Map responseMap) {
        IFormView formView = this.getView();
        FormShowParameter showParameter = formView.getFormShowParameter();
        Object content = responseMap.get("content");
        Object id = responseMap.get("id");
        if (content == null || id == null) {
            formView.showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u914d\u7f6e\u9690\u79c1\u58f0\u660e\u3002", (String)"EmpInfoConfirmPlugin_1", (String)"hr-hlcm-formplugin", (Object[])new Object[0]));
        } else {
            HashMap<String, Object> customs = new HashMap<String, Object>(16);
            customs.put("content", content);
            customs.put("name", responseMap.get("name"));
            customs.put("privacyId", id);
            customs.put("isAgree", Boolean.FALSE);
            customs.put("id", showParameter.getCustomParam("id"));
            ServicePageUtil.showMobileForm((IFormView)formView, (String)"hlcm_privacystatement", (ShowType)ShowType.Floating, customs);
        }
    }
}

