/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hlcm.formplugin.signmgt.electric;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.list.ListShowParameter;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.hr.hlcm.business.service.PermissionService;
import kd.hr.hlcm.common.enums.SignTabEnum;

public class ElectricSignDynamicPlugin
extends HRDataBaseEdit
implements TabSelectListener {
    private static final String TAB_AP = "tabap";
    private static List<SignTabEnum> ELECTAPLIST = new ArrayList<SignTabEnum>(8);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Tab tabAp = (Tab)this.getControl(TAB_AP);
        tabAp.addTabSelectListener((TabSelectListener)this);
    }

    public void beforeBindData(EventObject e) {
        for (SignTabEnum signtabenum : ELECTAPLIST) {
            Boolean b = PermissionService.hasViewPermission((String)"hlcm", (String)signtabenum.getListFormId());
            this.getView().setVisible(b, new String[]{signtabenum.getTabLabelName()});
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        for (SignTabEnum signtabenum : ELECTAPLIST) {
            boolean b = PermissionService.hasViewPermission((String)"hlcm", (String)signtabenum.getListFormId());
            if (!b) continue;
            this.loadBillList(signtabenum);
            break;
        }
    }

    private void loadBillList(SignTabEnum electricTabEnum) {
        IFormView view = this.getView();
        ListShowParameter listShowParameter = new ListShowParameter();
        listShowParameter.getOpenStyle().setTargetKey(electricTabEnum.getTabLabelName());
        listShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
        listShowParameter.setBillFormId(electricTabEnum.getListFormId());
        view.showForm((FormShowParameter)listShowParameter);
    }

    public void tabSelected(TabSelectEvent tabSelectEvent) {
        String tabKey = tabSelectEvent.getTabKey();
        SignTabEnum tabEnum = SignTabEnum.getTabEnum((String)tabKey);
        if (tabEnum == null) {
            return;
        }
        this.loadBillList(tabEnum);
    }

    static {
        ELECTAPLIST.add(SignTabEnum.E_ALL);
        ELECTAPLIST.add(SignTabEnum.E_BEGIN);
        ELECTAPLIST.add(SignTabEnum.E_CONFIRM);
        ELECTAPLIST.add(SignTabEnum.E_ESIGN);
        ELECTAPLIST.add(SignTabEnum.E_CSIGN);
        ELECTAPLIST.add(SignTabEnum.E_CHECK);
        ELECTAPLIST.add(SignTabEnum.E_STOP);
        ELECTAPLIST.add(SignTabEnum.E_ARCHIVE);
    }
}

