/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hlcm.formplugin.signmgt.paper;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.list.ListShowParameter;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.hr.hlcm.business.service.PermissionService;
import kd.hr.hlcm.common.enums.SignTabEnum;

public class PaperSignDynamicPlugin
extends HRDataBaseEdit
implements TabSelectListener {
    private static final String TAB_AP = "tabap";
    private static final List<SignTabEnum> PLIST = new ArrayList<SignTabEnum>(8);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Tab tabAp = (Tab)this.getControl(TAB_AP);
        tabAp.addTabSelectListener((TabSelectListener)this);
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        Map customParams = e.getFormShowParameter().getCustomParams();
        for (SignTabEnum signtabenum : PLIST) {
            boolean hasRight = PermissionService.hasViewPermission((String)"hlcm", (String)signtabenum.getListFormId());
            customParams.put(signtabenum.getListFormId(), hasRight);
        }
    }

    public void beforeBindData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        for (SignTabEnum signtabenum : PLIST) {
            boolean hasRight = (Boolean)customParams.get(signtabenum.getListFormId());
            this.getView().setVisible(Boolean.valueOf(hasRight), new String[]{signtabenum.getTabLabelName()});
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        for (SignTabEnum signtabenum : PLIST) {
            boolean hasRight = (Boolean)customParams.get(signtabenum.getListFormId());
            if (!hasRight) continue;
            this.loadBillList(signtabenum);
            break;
        }
    }

    private void loadBillList(SignTabEnum paperTabEnum) {
        IFormView view = this.getView();
        ListShowParameter listShowParameter = new ListShowParameter();
        listShowParameter.getOpenStyle().setTargetKey(paperTabEnum.getTabLabelName());
        listShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
        listShowParameter.setBillFormId(paperTabEnum.getListFormId());
        view.showForm((FormShowParameter)listShowParameter);
    }

    public void tabSelected(TabSelectEvent tabSelectEvent) {
        String tabKey = tabSelectEvent.getTabKey();
        SignTabEnum tabEnum = SignTabEnum.getTabEnum((String)tabKey);
        if (tabEnum == null) {
            return;
        }
        this.loadBillList(tabEnum);
    }

    static {
        PLIST.add(SignTabEnum.P_ALL);
        PLIST.add(SignTabEnum.P_BEGIN);
        PLIST.add(SignTabEnum.P_COMP);
        PLIST.add(SignTabEnum.P_CHECK);
        PLIST.add(SignTabEnum.P_STOP);
        PLIST.add(SignTabEnum.P_ARCHIVE);
    }
}

