/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hlcm.formplugin.utils;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.form.control.Label;
import kd.hr.hbp.common.util.HRInteDateTimeUtil;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hlcm.business.utils.ContractPageLoadUtils;
import kd.hr.hlcm.common.enums.BusinessTypeEnum;
import kd.hr.hlcm.common.enums.PeriodUnitEnum;
import kd.hr.hlcm.common.enums.ProbationUnitEnum;
import kd.hr.hlcm.common.enums.SignWayEnum;
import kd.hr.hlcm.common.utils.LabelOperateUtils;
import kd.sdk.hr.importutil.MethodUtil;

public class CardInfoHelper {
    private static final String HLCM_CONTRACTAPPLYREMEW = "hlcm_contractapplyrenew";

    public static CardInfoHelper getInstance() {
        return Holder.INSTANCE;
    }

    public void setNewConInfo(IDataModel model, IFormView view) {
        Date actualSignDate;
        Date signedDate;
        Date probationEndDate;
        Date probationStartDate;
        Date endDate;
        Date startDate;
        DynamicObject periodType;
        DynamicObject dataEntity = model.getDataEntity();
        this.setLabel(view, "r2contractnumber", dataEntity.getString("contractnumber"));
        DynamicObject contractTtype = dataEntity.getDynamicObject("contracttype");
        if (contractTtype != null) {
            this.setLabel(view, "r2contracttype", contractTtype.getString("name"));
        }
        if ((periodType = dataEntity.getDynamicObject("periodtype")) != null) {
            this.setLabel(view, "r2periodtype", periodType.getString("name"));
        }
        if ((startDate = dataEntity.getDate("startdate")) != null) {
            this.setLabel(view, "r2startdate", HRInteDateTimeUtil.formatDate((String)HLCM_CONTRACTAPPLYREMEW, (String)"startdate", (Date)startDate));
        }
        if ((endDate = dataEntity.getDate("enddate")) != null) {
            this.setLabel(view, "r2enddate", HRInteDateTimeUtil.formatDate((String)HLCM_CONTRACTAPPLYREMEW, (String)"enddate", (Date)endDate));
        }
        BigDecimal period = dataEntity.getBigDecimal("period");
        String periodUnit = dataEntity.getString("periodunit");
        if (period != null && period.compareTo(BigDecimal.ZERO) != 0) {
            this.setLabel(view, "r2period", period.setScale(1, RoundingMode.HALF_UP).toString().concat(PeriodUnitEnum.getValueByKey((String)periodUnit)));
        }
        if ((probationStartDate = dataEntity.getDate("probationstartdate")) != null) {
            this.setLabel(view, "r2probationstartdate", HRInteDateTimeUtil.formatDate((String)HLCM_CONTRACTAPPLYREMEW, (String)"probationstartdate", (Date)probationStartDate));
        }
        if ((probationEndDate = dataEntity.getDate("probationenddate")) != null) {
            this.setLabel(view, "r2probationenddate", HRInteDateTimeUtil.formatDate((String)HLCM_CONTRACTAPPLYREMEW, (String)"probationenddate", (Date)probationEndDate));
        }
        BigDecimal probationPeriod = dataEntity.getBigDecimal("probationperiod");
        String probationUnit = dataEntity.getString("probationunit");
        if (probationPeriod != null && probationPeriod.compareTo(BigDecimal.ZERO) != 0) {
            this.setLabel(view, "r2probationperiod", probationPeriod.setScale(0, RoundingMode.HALF_UP) + ProbationUnitEnum.getValueByKey((String)probationUnit));
        }
        if ((signedDate = dataEntity.getDate("signeddate")) != null) {
            this.setLabel(view, "r2signeddate", HRInteDateTimeUtil.formatDate((String)HLCM_CONTRACTAPPLYREMEW, (String)"signeddate", (Date)signedDate));
        }
        if ((actualSignDate = dataEntity.getDate("actualsigndate")) != null) {
            this.setLabel(view, "r2actualsigndate2", HRInteDateTimeUtil.formatDate((String)HLCM_CONTRACTAPPLYREMEW, (String)"actualsigndate", (Date)actualSignDate));
        }
    }

    public void setRenewConInfo(IDataModel model, IFormView view) {
        String compsignstatus;
        String empsignstatus;
        String signreason;
        Date actualSignDate;
        Date signedDate;
        String signway;
        String periodUnit;
        BigDecimal period;
        Date endDate;
        Date startDate;
        DynamicObject periodType;
        DynamicObject contractType;
        DynamicObject dataEntity = model.getDataEntity();
        DynamicObject oldContractDy = dataEntity.getDynamicObject("oldcontract");
        if (oldContractDy != null) {
            Date signedDate2;
            Date probationEndDate;
            Date probationStartDate;
            this.setLabel(view, "l2contractnumber1", oldContractDy.getString("number"));
            contractType = oldContractDy.getDynamicObject("contracttype");
            if (contractType != null) {
                this.setLabel(view, "l2contracttype1", contractType.getString("name"));
            }
            if ((periodType = oldContractDy.getDynamicObject("periodtype")) != null) {
                this.setLabel(view, "l2periodtype1", periodType.getString("name"));
            }
            if ((startDate = oldContractDy.getDate("startdate")) != null) {
                this.setLabel(view, "l2startdate1", HRInteDateTimeUtil.formatDate((String)HLCM_CONTRACTAPPLYREMEW, (String)"startdate", (Date)startDate));
            }
            if ((endDate = oldContractDy.getDate("enddate")) != null) {
                this.setLabel(view, "l2enddate1", HRInteDateTimeUtil.formatDate((String)HLCM_CONTRACTAPPLYREMEW, (String)"enddate", (Date)endDate));
            }
            period = oldContractDy.getBigDecimal("period");
            periodUnit = oldContractDy.getString("periodunit");
            if (period != null && period.compareTo(BigDecimal.ZERO) != 0) {
                this.setLabel(view, "l2period1", period.setScale(1, RoundingMode.HALF_UP).toString().concat(PeriodUnitEnum.getValueByKey((String)periodUnit)));
            }
            if ((probationStartDate = oldContractDy.getDate("probationstartdate")) != null) {
                this.setLabel(view, "l2probationstartdate1", HRInteDateTimeUtil.formatDate((String)"hlcm_contract", (String)"probationstartdate", (Date)probationStartDate));
            }
            if ((probationEndDate = oldContractDy.getDate("probationenddate")) != null) {
                this.setLabel(view, "l2probationenddate1", HRInteDateTimeUtil.formatDate((String)"hlcm_contract", (String)"probationenddate", (Date)probationEndDate));
            }
            BigDecimal probationPeriod = oldContractDy.getBigDecimal("probationperiod");
            String probationUnit = oldContractDy.getString("probationunit");
            if (probationPeriod != null && probationPeriod.compareTo(BigDecimal.ZERO) != 0) {
                this.setLabel(view, "l2probationperiod1", probationPeriod.setScale(0, RoundingMode.HALF_UP) + ProbationUnitEnum.getValueByKey((String)probationUnit));
            }
            if ((signedDate2 = oldContractDy.getDate("signeddate")) != null) {
                this.setLabel(view, "l2signeddate1", HRInteDateTimeUtil.formatDate((String)HLCM_CONTRACTAPPLYREMEW, (String)"signeddate", (Date)signedDate2));
            }
            if (HRStringUtils.isNotEmpty((String)(signway = oldContractDy.getString("signway")))) {
                this.setLabel(view, "l2signway1", SignWayEnum.getValueByKey((String)signway));
            }
        }
        this.setLabel(view, "r2contractnumber1", dataEntity.getString("contractnumber"));
        contractType = dataEntity.getDynamicObject("contracttype");
        if (contractType != null) {
            this.setLabel(view, "r2contracttype1", contractType.getString("name"));
        }
        if ((periodType = dataEntity.getDynamicObject("periodtype")) != null) {
            this.setLabel(view, "r2periodtype1", periodType.getString("name"));
        }
        if ((startDate = dataEntity.getDate("startdate")) != null) {
            this.setLabel(view, "r2startdate1", HRInteDateTimeUtil.formatDate((String)HLCM_CONTRACTAPPLYREMEW, (String)"startdate", (Date)startDate));
        }
        if ((endDate = dataEntity.getDate("enddate")) != null) {
            this.setLabel(view, "r2enddate1", HRInteDateTimeUtil.formatDate((String)HLCM_CONTRACTAPPLYREMEW, (String)"enddate", (Date)endDate));
        }
        period = dataEntity.getBigDecimal("period");
        periodUnit = dataEntity.getString("periodunit");
        if (period != null && period.compareTo(BigDecimal.ZERO) != 0) {
            this.setLabel(view, "r2period1", period.setScale(1, RoundingMode.HALF_UP).toString().concat(PeriodUnitEnum.getValueByKey((String)periodUnit)));
        }
        if ((signedDate = dataEntity.getDate("signeddate")) != null) {
            this.setLabel(view, "r2probationenddate1", HRInteDateTimeUtil.formatDate((String)HLCM_CONTRACTAPPLYREMEW, (String)"signeddate", (Date)signedDate));
        }
        if ((actualSignDate = dataEntity.getDate("actualsigndate")) != null) {
            this.setLabel(view, "r2actualsigndate", HRInteDateTimeUtil.formatDate((String)HLCM_CONTRACTAPPLYREMEW, (String)"actualsigndate", (Date)actualSignDate));
        }
        int renewCount = dataEntity.getInt("renewcount");
        this.setLabel(view, "r2renewcount", String.valueOf(renewCount));
        String contractRemark = dataEntity.getString("contractremark");
        this.setLabel(view, "r2contractremark", contractRemark);
        DynamicObject contracTemplatehisDy = dataEntity.getDynamicObject("contractemplatehis");
        if (contracTemplatehisDy != null) {
            this.setLabel(view, "r2contractemplatehis", contracTemplatehisDy.getString("name"));
        }
        if (HRStringUtils.isNotEmpty((String)(signway = dataEntity.getString("signway")))) {
            this.setLabel(view, "r2signway1", SignWayEnum.getValueByKey((String)signway));
        }
        if (HRStringUtils.isNotEmpty((String)(signreason = dataEntity.getString("signreason")))) {
            this.setLabel(view, "r2signreason1", signreason);
        }
        if (HRStringUtils.isNotEmpty((String)(empsignstatus = (String)MethodUtil.getComboKeyValue((String)dataEntity.getDataEntityType().getName(), (String)"empsignstatus").get(dataEntity.getString("empsignstatus"))))) {
            this.setLabel(view, "r2empsignstatus1", empsignstatus);
        }
        if (HRStringUtils.isNotEmpty((String)(compsignstatus = (String)MethodUtil.getComboKeyValue((String)dataEntity.getDataEntityType().getName(), (String)"compsignstatus").get(dataEntity.getString("compsignstatus"))))) {
            this.setLabel(view, "r2compsignstatus1", compsignstatus);
        }
    }

    public void setChangeConInfo(IDataModel model, IFormView view) {
        String compsignstatus;
        String empsignstatus;
        String signreason;
        String signway;
        Date actualSignDate;
        Date signedDate;
        String periodUnit;
        BigDecimal period;
        Date endDate;
        Date startDate;
        DynamicObject periodType;
        DynamicObject contractType;
        DynamicObject dataEntity = model.getDataEntity();
        DynamicObject oldContractDy = dataEntity.getDynamicObject("oldcontract");
        if (oldContractDy != null) {
            String signway2;
            Date signedDate2;
            Date probationEndDate;
            Date probationStartDate;
            this.setLabel(view, "l2contractnumber2", oldContractDy.getString("number"));
            contractType = oldContractDy.getDynamicObject("contracttype");
            if (contractType != null) {
                this.setLabel(view, "l2contracttype2", contractType.getString("name"));
            }
            if ((periodType = oldContractDy.getDynamicObject("periodtype")) != null) {
                this.setLabel(view, "l2periodtype2", periodType.getString("name"));
            }
            if ((startDate = oldContractDy.getDate("startdate")) != null) {
                this.setLabel(view, "l2startdate2", HRInteDateTimeUtil.formatDate((String)"hlcm_contractapplychange", (String)"startdate", (Date)startDate));
            }
            if ((endDate = oldContractDy.getDate("enddate")) != null) {
                this.setLabel(view, "l2enddate2", HRInteDateTimeUtil.formatDate((String)"hlcm_contractapplychange", (String)"enddate", (Date)endDate));
            }
            period = oldContractDy.getBigDecimal("period");
            periodUnit = oldContractDy.getString("periodunit");
            if (period != null && period.compareTo(BigDecimal.ZERO) != 0) {
                this.setLabel(view, "l2period2", period.setScale(1, RoundingMode.HALF_UP).toString().concat(PeriodUnitEnum.getValueByKey((String)periodUnit)));
            }
            if ((probationStartDate = oldContractDy.getDate("probationstartdate")) != null) {
                this.setLabel(view, "l2probationstartdate2", HRInteDateTimeUtil.formatDate((String)"hlcm_contract", (String)"probationstartdate", (Date)probationStartDate));
            }
            if ((probationEndDate = oldContractDy.getDate("probationenddate")) != null) {
                this.setLabel(view, "l2probationenddate2", HRInteDateTimeUtil.formatDate((String)"hlcm_contract", (String)"probationenddate", (Date)probationEndDate));
            }
            BigDecimal probationPeriod = oldContractDy.getBigDecimal("probationperiod");
            String probationUnit = oldContractDy.getString("probationunit");
            if (probationPeriod != null && probationPeriod.compareTo(BigDecimal.ZERO) != 0) {
                this.setLabel(view, "l2probationperiod2", probationPeriod.setScale(0, RoundingMode.HALF_UP) + ProbationUnitEnum.getValueByKey((String)probationUnit));
            }
            if ((signedDate2 = oldContractDy.getDate("signeddate")) != null) {
                this.setLabel(view, "l2signeddate2", HRInteDateTimeUtil.formatDate((String)"hlcm_contractapplychange", (String)"signeddate", (Date)signedDate2));
            }
            if (HRStringUtils.isNotEmpty((String)(signway2 = oldContractDy.getString("signway")))) {
                this.setLabel(view, "l2signway2", SignWayEnum.getValueByKey((String)signway2));
            }
        }
        this.setLabel(view, "r2contractnumber2", dataEntity.getString("contractnumber"));
        contractType = dataEntity.getDynamicObject("contracttype");
        if (contractType != null) {
            this.setLabel(view, "r2contracttype2", contractType.getString("name"));
        }
        if ((periodType = dataEntity.getDynamicObject("periodtype")) != null) {
            this.setLabel(view, "r2periodtype2", periodType.getString("name"));
        }
        if ((startDate = dataEntity.getDate("startdate")) != null) {
            this.setLabel(view, "r2startdate2", HRInteDateTimeUtil.formatDate((String)"hlcm_contractapplychange", (String)"startdate", (Date)startDate));
        }
        if ((endDate = dataEntity.getDate("enddate")) != null) {
            this.setLabel(view, "r2enddate2", HRInteDateTimeUtil.formatDate((String)"hlcm_contractapplychange", (String)"enddate", (Date)endDate));
        }
        period = dataEntity.getBigDecimal("period");
        periodUnit = dataEntity.getString("periodunit");
        if (period != null && period.compareTo(BigDecimal.ZERO) != 0) {
            this.setLabel(view, "r2period2", period.setScale(1, RoundingMode.HALF_UP).toString().concat(PeriodUnitEnum.getValueByKey((String)periodUnit)));
        }
        if ((signedDate = dataEntity.getDate("signeddate")) != null) {
            this.setLabel(view, "r2probationstartdate2", HRInteDateTimeUtil.formatDate((String)"hlcm_contractapplychange", (String)"signeddate", (Date)signedDate));
        }
        if ((actualSignDate = dataEntity.getDate("actualsigndate")) != null) {
            this.setLabel(view, "r2actualsigndate1", HRInteDateTimeUtil.formatDate((String)"hlcm_contractapplychange", (String)"actualsigndate", (Date)actualSignDate));
        }
        String contractRemark = dataEntity.getString("contractremark");
        this.setLabel(view, "r2contractremark2", contractRemark);
        DynamicObject contracTemplatehisDy = dataEntity.getDynamicObject("contractemplatehis");
        if (contracTemplatehisDy != null) {
            this.setLabel(view, "r2contractemplatehis2", contracTemplatehisDy.getString("name"));
        }
        if (HRStringUtils.isNotEmpty((String)(signway = dataEntity.getString("signway")))) {
            this.setLabel(view, "r2signway2", SignWayEnum.getValueByKey((String)signway));
        }
        if (HRStringUtils.isNotEmpty((String)(signreason = dataEntity.getString("signreason")))) {
            this.setLabel(view, "r2signreason2", signreason);
        }
        if (HRStringUtils.isNotEmpty((String)(empsignstatus = (String)MethodUtil.getComboKeyValue((String)dataEntity.getDataEntityType().getName(), (String)"empsignstatus").get(dataEntity.getString("empsignstatus"))))) {
            this.setLabel(view, "r2empsignstatus2", empsignstatus);
        }
        if (HRStringUtils.isNotEmpty((String)(compsignstatus = (String)MethodUtil.getComboKeyValue((String)dataEntity.getDataEntityType().getName(), (String)"compsignstatus").get(dataEntity.getString("compsignstatus"))))) {
            this.setLabel(view, "r2compsignstatus2", compsignstatus);
        }
    }

    public void setMainConInfo(DynamicObject dataEntity, IFormView view) {
        DynamicObject actualSignCompanyHis = dataEntity.getDynamicObject("actualsigncompanyhis");
        DynamicObject suggestSignCompanyHis = dataEntity.getDynamicObject("suggestsigncomphis");
        if (!HRObjectUtils.isEmpty((Object)suggestSignCompanyHis)) {
            LabelOperateUtils.setLabel((IFormView)view, (String)"l1suggestsigncompany", (String)suggestSignCompanyHis.getString("name"));
        }
        if (actualSignCompanyHis != null) {
            this.setLabel(view, "l1actualsigncompany", actualSignCompanyHis.getString("name"));
            this.setLabel(view, "l1corporateorg", actualSignCompanyHis.getString("reorg.name"));
            this.setLabel(view, "l1organizationcode", actualSignCompanyHis.getString("unifiedcode"));
            this.setLabel(view, "l1legalperson", actualSignCompanyHis.getString("representative"));
            this.setLabel(view, "l1address", actualSignCompanyHis.getString("address"));
            this.setLabel(view, "l1empphone", actualSignCompanyHis.getString("contactnumber"));
            this.setLabel(view, "l1postalcode", actualSignCompanyHis.getString("postalcode"));
        }
        this.setLabel(view, "r1name", dataEntity.getString("empname"));
        view.getModel().setValue("r2name", (Object)ContractPageLoadUtils.getStringValue((DynamicObject)dataEntity, (String)"empname"));
        DynamicObject cardType = dataEntity.getDynamicObject("cardtype");
        if (cardType != null) {
            this.setLabel(view, "r1cardtype", cardType.getString("name"));
        }
        this.setLabel(view, "r1cardnum", dataEntity.getString("cardnumber"));
        view.getModel().setValue("r2cardnum", (Object)ContractPageLoadUtils.getStringValue((DynamicObject)dataEntity, (String)"cardnumber"));
        this.setLabel(view, "r1householdregister", dataEntity.getString("householdregister"));
        view.getModel().setValue("r2householdregister", (Object)ContractPageLoadUtils.getStringValue((DynamicObject)dataEntity, (String)"householdregister"));
        this.setLabel(view, "r1residentialaddress", dataEntity.getString("residentialaddress"));
        view.getModel().setValue("r2residentialaddress", (Object)ContractPageLoadUtils.getStringValue((DynamicObject)dataEntity, (String)"residentialaddress"));
        this.setLabel(view, "r1empphone", dataEntity.getString("empphone"));
        view.getModel().setValue("r2empphone", (Object)ContractPageLoadUtils.getStringValue((DynamicObject)dataEntity, (String)"empphone"));
        this.setLabel(view, "r1signreason", dataEntity.getString("signreason"));
        this.setLabel(view, "r1baselocation", dataEntity.getString("baselocation"));
        this.setLabel(view, "r1nation", dataEntity.getString("nation"));
    }

    private void setLabel(IFormView formView, String labelKey, String labelShowVal) {
        Label label = (Label)formView.getControl(labelKey);
        if (!HRObjectUtils.isEmpty((Object)label) && !HRStringUtils.isEmpty((String)labelShowVal)) {
            label.setText(labelShowVal);
        }
    }

    public void setHandleBillRenewOrChangePanelInfo(IDataModel model, IFormView view, String businessType) {
        Date signedDate;
        Date endDate;
        String periodUnit;
        BigDecimal period;
        Date startDate;
        DynamicObject periodType;
        DynamicObject contractType;
        DynamicObject dataEntity = model.getDataEntity();
        DynamicObject oldContractDy = dataEntity.getDynamicObject("oldcontract");
        if (oldContractDy != null) {
            Date signedDate2;
            Date probationEndDate;
            Date probationStartDate;
            this.setLabel(view, "oldcontractnumbervalue", oldContractDy.getString("number"));
            DynamicObject actualSignCompany = oldContractDy.getDynamicObject("actualsigncompany");
            if (actualSignCompany != null) {
                this.setLabel(view, "oldactualsigncompanyvalue", actualSignCompany.getString("name"));
            }
            if ((contractType = oldContractDy.getDynamicObject("contracttype")) != null) {
                this.setLabel(view, "oldcontracttypevalue", contractType.getString("name"));
            }
            if ((periodType = oldContractDy.getDynamicObject("periodtype")) != null) {
                this.setLabel(view, "oldperiodtypevalue", periodType.getString("name"));
            }
            if ((startDate = oldContractDy.getDate("startdate")) != null) {
                this.setLabel(view, "oldstartdatevalue", HRInteDateTimeUtil.formatDate((String)"hlcm_contractsource", (String)"startdate", (Date)startDate));
            }
            period = oldContractDy.getBigDecimal("period");
            periodUnit = oldContractDy.getString("periodunit");
            if (period != null && period.compareTo(BigDecimal.ZERO) != 0) {
                this.setLabel(view, "oldperiodvalue", period.setScale(1, RoundingMode.HALF_UP).toString().concat(PeriodUnitEnum.getValueByKey((String)periodUnit)));
            }
            if ((endDate = oldContractDy.getDate("enddate")) != null) {
                this.setLabel(view, "oldplanenddatevalue", HRInteDateTimeUtil.formatDate((String)"hlcm_contractsource", (String)"enddate", (Date)endDate));
            }
            if ((probationStartDate = oldContractDy.getDate("probationstartdate")) != null) {
                this.setLabel(view, "oldprobationstartdateval", HRInteDateTimeUtil.formatDate((String)"hlcm_contractsource", (String)"probationstartdate", (Date)probationStartDate));
            }
            if ((probationEndDate = oldContractDy.getDate("probationenddate")) != null) {
                this.setLabel(view, "oldprobationenddatevalue", HRInteDateTimeUtil.formatDate((String)"hlcm_contractsource", (String)"probationenddate", (Date)probationEndDate));
            }
            BigDecimal probationPeriod = oldContractDy.getBigDecimal("probationperiod");
            String probationUnit = oldContractDy.getString("probationunit");
            if (probationPeriod != null && probationPeriod.compareTo(BigDecimal.ZERO) != 0) {
                this.setLabel(view, "oldprobationperiodvalue", probationPeriod.setScale(0, RoundingMode.HALF_UP) + ProbationUnitEnum.getValueByKey((String)probationUnit));
            }
            if ((signedDate2 = oldContractDy.getDate("signeddate")) != null) {
                this.setLabel(view, "oldsigneddatevalue", HRInteDateTimeUtil.formatDate((String)"hlcm_contractsource", (String)"signeddate", (Date)signedDate2));
            }
        }
        this.setLabel(view, "newcontractnumbervalue", dataEntity.getString("contractnumber"));
        DynamicObject actualSignCompanyHis = dataEntity.getDynamicObject("actualsigncompanyhis");
        if (actualSignCompanyHis != null) {
            this.setLabel(view, "newactualsigncompanyvalue", actualSignCompanyHis.getString("name"));
        }
        if ((contractType = dataEntity.getDynamicObject("contracttype")) != null) {
            this.setLabel(view, "newcontracttypevalue", contractType.getString("name"));
        }
        if ((periodType = dataEntity.getDynamicObject("periodtype")) != null) {
            this.setLabel(view, "newperiodtypevalue", periodType.getString("name"));
        }
        if ((startDate = dataEntity.getDate("startdate")) != null) {
            this.setLabel(view, "newstartdatevalue", HRInteDateTimeUtil.formatDate((String)"hlcm_contractapplyhandle", (String)"startdate", (Date)startDate));
        }
        period = dataEntity.getBigDecimal("period");
        periodUnit = dataEntity.getString("periodunit");
        if (period != null && period.compareTo(BigDecimal.ZERO) != 0) {
            this.setLabel(view, "newperiodvalue", period.setScale(1, RoundingMode.HALF_UP).toString().concat(PeriodUnitEnum.getValueByKey((String)periodUnit)));
        }
        if ((endDate = dataEntity.getDate("enddate")) != null) {
            this.setLabel(view, "newenddatevalue", HRInteDateTimeUtil.formatDate((String)"hlcm_contractapplyhandle", (String)"enddate", (Date)endDate));
        }
        if ((signedDate = dataEntity.getDate("signeddate")) != null) {
            this.setLabel(view, "newsigneddatevalue", HRInteDateTimeUtil.formatDate((String)"hlcm_contractapplyhandle", (String)"signeddate", (Date)signedDate));
        }
        if (HRStringUtils.equals((String)BusinessTypeEnum.RENEW.getCombKey(), (String)businessType)) {
            int renewCount = dataEntity.getInt("renewcount");
            this.setLabel(view, "newrenewcountvalue", String.valueOf(renewCount));
        }
        this.setLabel(view, "newsignreasonvalue", dataEntity.getString("signreason"));
        this.setLabel(view, "newsignremarkvalue1", dataEntity.getString("contractremark"));
    }

    private static class Holder {
        private static final CardInfoHelper INSTANCE = new CardInfoHelper();

        private Holder() {
        }
    }
}

