/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hlcm.formplugin.utils;

import com.google.common.collect.Lists;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.form.IFormView;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.IListView;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hlcm.business.common.HLCMCommonRepository;
import kd.hr.hlcm.business.domian.repository.TerminateRepository;
import kd.hr.hlcm.business.utils.TerminateUtils;
import kd.hr.hlcm.formplugin.utils.ContractFormTipUtils;

public class TerminateHelper {
    private TerminateHelper() {
        throw new IllegalStateException();
    }

    public static void terminateValidate(IFormView formView, String tip, IFormPlugin formPlugin, BeforeDoOperationEventArgs evt) {
        FormOperate source = (FormOperate)evt.getSource();
        String operateKey = source.getOperateKey();
        if (!HRStringUtils.equals((String)operateKey, (String)"perterminate")) {
            return;
        }
        if (formView instanceof IListView) {
            IListView listView = (IListView)formView;
            if (ContractFormTipUtils.getInstance().checkTerminateSelectRowOne(listView).booleanValue()) {
                listView.getSelectedRows().stream().findFirst().map(ListSelectedRow::getPrimaryKeyValue).map(primaryKeyValue -> HLCMCommonRepository.queryDynamicObjectByPk((String)"hlcm_contractapplybase", (String)String.join((CharSequence)",", Lists.newArrayList((Object[])new String[]{"handlestatus", "activityins"})), (Object)primaryKeyValue)).ifPresent(signBill -> TerminateHelper.statusValidate(signBill, formView, tip, formPlugin, evt));
            } else {
                evt.setCancel(true);
            }
        } else {
            DynamicObject signBill2 = formView.getModel().getDataEntity();
            TerminateHelper.statusValidate(signBill2, formView, tip, formPlugin, evt);
        }
    }

    private static void statusValidate(DynamicObject signBill, IFormView formView, String tip, IFormPlugin formPlugin, BeforeDoOperationEventArgs evt) {
        Optional optionalResult = TerminateRepository.getInstance().validateStatus(signBill);
        if (optionalResult.isPresent()) {
            evt.setCancel(true);
            formView.showErrorNotification((String)optionalResult.get());
        } else {
            long pkValue = signBill.getLong("id");
            TerminateUtils.getInstance().showOperationPage(tip, formView, Long.valueOf(pkValue), formPlugin);
        }
    }
}

