/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hlcm.formplugin.utils;

import java.util.Locale;
import java.util.Optional;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.list.IListView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hlcm.business.common.HLCMCommonRepository;
import kd.hr.hlcm.business.domian.repository.LicenseRepository;
import kd.hr.hlcm.business.service.PersonService;
import kd.hr.hlcm.common.utils.HeadCardUtil;
import org.apache.commons.lang3.tuple.Pair;

public class WorkBenchHelper {
    private static final Log LOGGER = LogFactory.getLog(WorkBenchHelper.class);
    private static final String ER_MAN_FILE_ID = "erManFileID";
    private static final String HSPM_ERMANFILE_PAGE = "hspm_ermanfile";

    private WorkBenchHelper() {
    }

    public static boolean isWorkBenchSkip(IFormView view) {
        Long erManFileID = (Long)view.getFormShowParameter().getCustomParam(ER_MAN_FILE_ID);
        return !HRObjectUtils.isEmpty((Object)erManFileID) && view.getFormShowParameter().getStatus() == OperationStatus.ADDNEW;
    }

    public static DynamicObject fillErmanFile(IFormView view) {
        Long erManFileID = (Long)view.getFormShowParameter().getCustomParam(ER_MAN_FILE_ID);
        DynamicObject ermanFile = HLCMCommonRepository.queryDynamicObjectByPk((String)HSPM_ERMANFILE_PAGE, null, (Object)erManFileID);
        view.getModel().setValue("ermanfile", (Object)ermanFile);
        return ermanFile;
    }

    public static void setEnable(IFormView view) {
        view.setEnable(Boolean.FALSE, new String[]{"ermanfile", "org"});
    }

    public static void setFormTitle(IFormView view) {
        String billName = HeadCardUtil.getBillName((DynamicObject)view.getModel().getDataEntity(), (String)"1");
        String preOp = ResManager.loadKDString((String)"\u65b0\u589e", (String)"WorkBenchHelper_1", (String)"hr-hlcm-formplugin", (Object[])new Object[0]);
        view.setFormTitle(new LocaleString(String.format(Locale.ROOT, "%s%s", preOp, billName)));
    }

    public static Optional<Object> getSelectRowPrimaryKeyValue(IListView view, String formId) {
        boolean verifyCertCount = LicenseRepository.getInstance().verifyCertCount((IFormView)view, formId);
        if (!verifyCertCount) {
            return Optional.empty();
        }
        return view.getSelectedRows().stream().findFirst().map(ListSelectedRow::getPrimaryKeyValue);
    }

    public static void open(Long personId, Long posTypeId, String formId, IFormView formView, Object primaryKeyValue) {
        Optional latestErManFileInfoOptional = PersonService.getInstance().getLatestErManFileInfo(personId, posTypeId);
        if (!latestErManFileInfoOptional.isPresent()) {
            LOGGER.info("latestErManFileInfoOptional.is not present");
            return;
        }
        Pair latestErManFileInfoPair = (Pair)latestErManFileInfoOptional.get();
        Long erManFileId = (Long)latestErManFileInfoPair.getLeft();
        Long orgId = (Long)latestErManFileInfoPair.getRight();
        if (HRObjectUtils.isEmpty((Object)erManFileId) || HRObjectUtils.isEmpty((Object)orgId)) {
            LOGGER.info("erManFileId.or.orgId.is.empty");
            return;
        }
        BillShowParameter billShowParameter = new BillShowParameter();
        billShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        billShowParameter.setFormId(formId);
        billShowParameter.getCustomParams().put(ER_MAN_FILE_ID, erManFileId);
        billShowParameter.setCustomParam("SELECT_ORG_ID", (Object)String.valueOf(orgId));
        String value = String.format(Locale.ROOT, "%s_%s_%d_%d", formView.getPageId(), formId, primaryKeyValue.hashCode(), RequestContext.get().getCurrUserId());
        billShowParameter.setPageId(value);
        formView.showForm((FormShowParameter)billShowParameter);
    }
}

