/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hlcm.formplugin.workbench;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.EventObject;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.IListView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseList;
import kd.hr.hlcm.business.common.HLCMCommonRepository;
import kd.hr.hlcm.business.domian.repository.CommonRepository;
import kd.hr.hlcm.business.service.PermissionService;
import kd.hr.hlcm.common.enums.PreWarnPersonStatusEnum;
import kd.hr.hlcm.formplugin.utils.WorkBenchHelper;

public abstract class BaseContractListPlugin
extends HRDataBaseList {
    private static final Log LOGGER = LogFactory.getLog(BaseContractListPlugin.class);
    private static final String TBLCXQ = "tblcxq";
    private static final String TBLYXQ = "tblyxq";
    private static final String TBLYZZ = "tblyzz";
    private static final String TBLQXQ = "tblqxq";
    private static final String CXQ = "cxq";
    private static final String YXQ = "yxq";
    private static final String YZZ = "yzz";
    private static final String QXQ = "qxq";
    private static final String CGX = "cgx";
    private static final List<String> SIGN_DATA_OP_KEYS = Lists.newArrayList((Object[])new String[]{"cxq", "yxq", "yzz", "qxq", "cgx"});
    private static final String FIELD_CONTRACT_NUMBER = "contract.number";
    private static final String FIELD_CONTRACT_ACTUAL_SIGN_COMPANY_NAME = "contract.actualsigncompany.name";

    public void setFilter(SetFilterEvent setFilterEvent) {
        super.setFilter(setFilterEvent);
        String protocolType = (String)this.getView().getFormShowParameter().getCustomParams().get("protocoltype");
        QFilter protocolContractFilter = new QFilter("protocoltype", "=", (Object)protocolType);
        List qFilters = setFilterEvent.getQFilters();
        qFilters.add(protocolContractFilter);
        setFilterEvent.setOrderBy("startstatus asc,contract.enddate asc,empnumber asc");
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        String protocolType = (String)this.getView().getFormShowParameter().getCustomParams().get("protocoltype");
        String fieldName = args.getFieldName();
        if (HRStringUtils.isEmpty((String)fieldName)) {
            return;
        }
        switch (fieldName) {
            case "contract.number": {
                if (HRStringUtils.equals((String)protocolType, (String)"1")) {
                    args.setRefEntityId("hlcm_contract");
                    break;
                }
                args.setRefEntityId("hlcm_contractfileemp");
                break;
            }
            case "contract.actualsigncompany.name": {
                QFilter signCompanyFilter = PermissionService.getBaseDataFilterByOrg((String)"hbss_signcompany", (boolean)true);
                Optional.ofNullable(signCompanyFilter).ifPresent(filter -> args.getQfilters().add(filter));
                break;
            }
        }
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        String protocolType = (String)this.getView().getFormShowParameter().getCustomParams().get("protocoltype");
        if (HRStringUtils.equals((String)protocolType, (String)"1")) {
            return;
        }
        args.getSchemeFilterColumns().removeIf(col -> HRStringUtils.equals((String)col.getFieldName(), (String)"contract.planenddate"));
    }

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        String protocolType = (String)this.getView().getFormShowParameter().getCustomParams().get("protocoltype");
        if ("1".equals(protocolType)) {
            return;
        }
        args.getListColumns().removeIf(col -> HRStringUtils.equals((String)col.getListFieldKey(), (String)"contract.planenddate"));
    }

    public void afterBindData(EventObject evt) {
        String protocolType;
        super.afterBindData(evt);
        this.getView().setVisible(Boolean.FALSE, new String[]{TBLCXQ, TBLYXQ, TBLYZZ, TBLQXQ});
        switch (protocolType = (String)this.getView().getFormShowParameter().getCustomParams().get("protocoltype")) {
            default: {
                this.getView().setVisible(Boolean.TRUE, new String[]{TBLCXQ});
                break;
            }
            case "2": {
                this.getView().setVisible(Boolean.TRUE, new String[]{TBLYXQ, TBLYZZ});
                break;
            }
            case "3": {
                this.getView().setVisible(Boolean.TRUE, new String[]{TBLQXQ});
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        if (HRStringUtils.equals((String)operateKey, (String)"close")) {
            LinkedHashMap param = Maps.newLinkedHashMapWithExpectedSize((int)1);
            param.put("pageId", this.getView().getParentView().getPageId());
            IClientViewProxy clientViewProxy = (IClientViewProxy)this.getModel().getService(IClientViewProxy.class);
            clientViewProxy.addAction("closeWindow", (Object)Lists.newArrayList((Object[])new Map[]{param}));
            this.getView().close();
            return;
        }
        if (!SIGN_DATA_OP_KEYS.contains(operateKey)) {
            return;
        }
        if (this.getSelectedRows().size() > 1) {
            args.setCancel(true);
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6bcf\u6b21\u53ea\u80fd\u5904\u7406\u4e00\u6761\u6570\u636e\u3002", (String)"BaseContractListPlugin_1", (String)"hr-hlcm-formplugin", (Object[])new Object[0]));
            return;
        }
        this.validateBeforeOperation(args, operateKey);
    }

    private void validateBeforeOperation(BeforeDoOperationEventArgs args, String operateKey) {
        String msg;
        ListSelectedRow listSelectedRow = this.getSelectedRows().get(0);
        DynamicObject preWarn = CommonRepository.queryDynamicObjectByPk((String)"hlcm_prewarn", (String)"startstatus", (Object)listSelectedRow.getPrimaryKeyValue());
        if (Objects.isNull(preWarn)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u9875\u9762\u6570\u636e\u53d1\u751f\u53d8\u5316\uff0c\u5c06\u81ea\u52a8\u5237\u65b0\u3002", (String)"BaseContractListPlugin_2", (String)"hr-hlcm-formplugin", (Object[])new Object[0]));
            this.getView().invokeOperation("refresh");
            args.setCancel(true);
            return;
        }
        if (PreWarnPersonStatusEnum.TOSUBMIT.getCombKey().equals(preWarn.get("startstatus"))) {
            args.setCancel(true);
            msg = "";
            switch (operateKey) {
                case "cxq": {
                    msg = ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u5f85\u63d0\u4ea4\u7533\u8bf7\u7684\u5355\u636e\uff0c\u8bf7\u81f3\u52b3\u52a8\u5408\u540c\u7eed\u7b7e\u9875\u9762\u64cd\u4f5c\u3002", (String)"BaseContractListPlugin_3", (String)"hr-hlcm-formplugin", (Object[])new Object[0]);
                    break;
                }
                case "yxq": {
                    msg = ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u5f85\u63d0\u4ea4\u7533\u8bf7\u7684\u5355\u636e\uff0c\u8bf7\u81f3\u7528\u5de5\u534f\u8bae\u65b0\u7b7e\u9875\u9762\u64cd\u4f5c\u3002", (String)"BaseContractListPlugin_4", (String)"hr-hlcm-formplugin", (Object[])new Object[0]);
                    break;
                }
                case "yzz": {
                    msg = ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u5f85\u63d0\u4ea4\u7533\u8bf7\u7684\u5355\u636e\uff0c\u8bf7\u81f3\u7528\u5de5\u534f\u8bae\u7ec8\u6b62\u9875\u9762\u64cd\u4f5c\u3002", (String)"BaseContractListPlugin_5", (String)"hr-hlcm-formplugin", (Object[])new Object[0]);
                    break;
                }
                case "cgx": {
                    msg = ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u5f85\u63d0\u4ea4\u7533\u8bf7\u7684\u5355\u636e\uff0c\u8bf7\u81f3\u52b3\u52a8\u5408\u540c\u6539\u7b7e\u9875\u9762\u64cd\u4f5c\u3002", (String)"BaseContractListPlugin_6", (String)"hr-hlcm-formplugin", (Object[])new Object[0]);
                    break;
                }
            }
            this.getView().showErrorNotification(msg);
        }
        if (PreWarnPersonStatusEnum.PROCESSIN.getCombKey().equals(preWarn.get("startstatus"))) {
            args.setCancel(true);
            msg = "";
            switch (operateKey) {
                case "cxq": {
                    msg = ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u6d41\u7a0b\u8fdb\u884c\u4e2d\u7684\u5355\u636e\uff0c\u8bf7\u81f3\u52b3\u52a8\u5408\u540c\u7eed\u7b7e\u9875\u9762\u64cd\u4f5c\u3002", (String)"BaseContractListPlugin_7", (String)"hr-hlcm-formplugin", (Object[])new Object[0]);
                    break;
                }
                case "yxq": {
                    msg = ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u6d41\u7a0b\u8fdb\u884c\u4e2d\u7684\u5355\u636e\uff0c\u8bf7\u81f3\u7528\u5de5\u534f\u8bae\u65b0\u7b7e\u9875\u9762\u64cd\u4f5c\u3002", (String)"BaseContractListPlugin_8", (String)"hr-hlcm-formplugin", (Object[])new Object[0]);
                    break;
                }
                case "yzz": {
                    msg = ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u6d41\u7a0b\u8fdb\u884c\u4e2d\u7684\u5355\u636e\uff0c\u8bf7\u81f3\u7528\u5de5\u534f\u8bae\u7ec8\u6b62\u9875\u9762\u64cd\u4f5c\u3002", (String)"BaseContractListPlugin_9", (String)"hr-hlcm-formplugin", (Object[])new Object[0]);
                    break;
                }
                case "cgx": {
                    msg = ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u6d41\u7a0b\u8fdb\u884c\u4e2d\u7684\u5355\u636e\uff0c\u8bf7\u81f3\u52b3\u52a8\u5408\u540c\u6539\u7b7e\u9875\u9762\u64cd\u4f5c\u3002", (String)"BaseContractListPlugin_10", (String)"hr-hlcm-formplugin", (Object[])new Object[0]);
                    break;
                }
            }
            this.getView().showErrorNotification(msg);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String operateKey;
        super.afterDoOperation(afterDoOperationEventArgs);
        switch (operateKey = afterDoOperationEventArgs.getOperateKey()) {
            case "cxq": {
                this.openPage("hlcm_contractapplyrenew");
                break;
            }
            case "yxq": {
                this.openPage("hlcm_empprotocolnew");
                break;
            }
            case "yzz": {
                this.openPage("hlcm_empprotocolterminate");
                break;
            }
            case "qxq": {
                this.openPage("hlcm_otheragreements");
                break;
            }
            case "cgx": {
                this.openPage("hlcm_contractapplychange");
                break;
            }
        }
    }

    private void openPage(String formId) {
        Optional<Object> selectRowPrimaryKeyValue = WorkBenchHelper.getSelectRowPrimaryKeyValue((IListView)this.getView(), formId);
        if (!selectRowPrimaryKeyValue.isPresent()) {
            LOGGER.info("openPage.selectRowPrimaryKeyValue.is.not.present.");
            return;
        }
        Object primaryKeyValue = selectRowPrimaryKeyValue.get();
        DynamicObject preWarn = HLCMCommonRepository.queryDynamicObjectByPk((String)"hlcm_prewarn", (String)"contract.postype.id,person.id", (Object)primaryKeyValue);
        Long personId = preWarn.getLong("person.id");
        Long posTypeId = preWarn.getLong("contract.postype.id");
        WorkBenchHelper.open(personId, posTypeId, formId, this.getView(), primaryKeyValue);
    }
}

