/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hlcm.formplugin.workbench;

import java.util.EventObject;
import java.util.Locale;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.hr.hlcm.business.domian.repository.HiredPersonRepository;
import kd.hr.hlcm.business.domian.repository.PreWarnRepository;

public class WorkbeanchWarningFormPlugin
extends AbstractFormPlugin
implements ClickListener {
    private static final String LABELKEY_ENTRIED_UNSIGNED = "lblinten";
    private static final String LABELKEY_CONTRACT_EXPIRED = "lblinten1";
    private static final String LABELKEY_CONTRACT_TOBE_EXPIRE = "lblinten2";
    private static final String LABELKEY_UNIT_CHANGED_UNSIGNED = "lblinten3";
    private static final String REFRESHAP = "refreshap";

    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{LABELKEY_ENTRIED_UNSIGNED, LABELKEY_CONTRACT_EXPIRED, LABELKEY_CONTRACT_TOBE_EXPIRE, LABELKEY_UNIT_CHANGED_UNSIGNED, REFRESHAP});
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control source = (Control)evt.getSource();
        switch (key = source.getKey()) {
            case "refreshap": {
                this.getView().invokeOperation("refresh");
                break;
            }
            case "lblinten": {
                FormShowParameter showParameter = new FormShowParameter();
                showParameter.setFormId("hlcm_hiredperson_tab");
                showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                String pageId = String.format(Locale.ROOT, "%s_%s_%d", this.getView().getPageId(), "hlcm_hiredperson_tab", RequestContext.get().getCurrUserId());
                showParameter.setPageId(pageId);
                this.getView().showForm(showParameter);
                break;
            }
            case "lblinten1": {
                this.openListPage(ResManager.loadKDString((String)"\u5408\u540c\u5df2\u5230\u671f\u672a\u7b7e\u5458\u5de5\u5217\u8868", (String)"WorkbeanchWarningFormPlugin_1", (String)"hr-hlcm-formplugin", (Object[])new Object[0]), "hlcm_prewarn_type1list");
                break;
            }
            case "lblinten2": {
                this.openListPage(ResManager.loadKDString((String)"\u5408\u540c\u5373\u5c06\u5230\u671f\u5458\u5de5\u5217\u8868", (String)"WorkbeanchWarningFormPlugin_2", (String)"hr-hlcm-formplugin", (Object[])new Object[0]), "hlcm_prewarn_type2list");
                break;
            }
            case "lblinten3": {
                this.openListPage(ResManager.loadKDString((String)"\u8058\u7528\u5355\u4f4d\u53d8\u66f4\u672a\u6539\u7b7e\u5458\u5de5\u5217\u8868", (String)"WorkbeanchWarningFormPlugin_3", (String)"hr-hlcm-formplugin", (Object[])new Object[0]), "hlcm_prewarn_type3list");
                break;
            }
        }
    }

    private void openListPage(String title, String formId) {
        FormShowParameter billShowParameter = new FormShowParameter();
        billShowParameter.setFormId("hlcm_warning_tab");
        billShowParameter.setCaption(title);
        billShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        String pageId = String.format(Locale.ROOT, "%s_%s_%d", this.getView().getPageId(), formId, RequestContext.get().getCurrUserId());
        billShowParameter.setPageId(pageId);
        billShowParameter.setCustomParam("formId", (Object)formId);
        this.getView().showForm(billShowParameter);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.entriedUnsignedCountInit();
        this.contractExpiredCountInit();
        this.contractToBeExpireCountInit();
        this.unitChangedUnsignedCountInit();
    }

    private void entriedUnsignedCountInit() {
        Label labelEntriedUnsigned = (Label)this.getView().getControl(LABELKEY_ENTRIED_UNSIGNED);
        labelEntriedUnsigned.setText(String.valueOf(HiredPersonRepository.getInstance().geHiredUnSignedCount()));
    }

    private void contractExpiredCountInit() {
        Label labelContractExpired = (Label)this.getView().getControl(LABELKEY_CONTRACT_EXPIRED);
        int count = PreWarnRepository.getInstance().getCountByWarningType("1");
        labelContractExpired.setText(String.valueOf(count));
    }

    private void contractToBeExpireCountInit() {
        Label labelContractExpired = (Label)this.getView().getControl(LABELKEY_CONTRACT_TOBE_EXPIRE);
        int count = PreWarnRepository.getInstance().getCountByWarningType("2");
        labelContractExpired.setText(String.valueOf(count));
    }

    private void unitChangedUnsignedCountInit() {
        Label labelContractExpired = (Label)this.getView().getControl(LABELKEY_UNIT_CHANGED_UNSIGNED);
        int count = PreWarnRepository.getInstance().getCountByWarningType("3");
        labelContractExpired.setText(String.valueOf(count));
    }

    public void preOpenForm(PreOpenFormEventArgs event) {
        super.preOpenForm(event);
        long currUserId = RequestContext.get().getCurrUserId();
        Boolean permission = PermissionServiceHelper.checkUserBizApp((Long)currUserId, (String)"hlcm");
        if (!permission.booleanValue()) {
            event.setCancel(true);
        }
    }
}

