/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hlcm.formplugin.workflow;

import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.api.AgentExecution;
import kd.bos.workflow.engine.extitf.IWorkflowPlugin;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.VariableInstance;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntityImpl;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hlcm.business.domian.repository.ContractSignApplyRepository;
import kd.hr.hlcm.common.enums.BillStatusEnum;
import kd.hr.hlcm.common.enums.HandleStatusEnum;

public class RejectWorkFlowPlugin
implements IWorkflowPlugin {
    private static final Log LOGGER = LogFactory.getLog(RejectWorkFlowPlugin.class);

    public void notify(AgentExecution execution) {
        String businessKey = execution.getBusinessKey();
        try {
            DynamicObject signDy = ContractSignApplyRepository.CONTRACT_APPLY_HELPER.queryOne("id,billstatus,handleStatus,businesstype", (Object)Long.valueOf(businessKey));
            if (!HRObjectUtils.isEmpty((Object)signDy)) {
                TaskEntityImpl currentTask = (TaskEntityImpl)execution.getCurrentTask();
                Map variableInstances = currentTask.getVariableInstances();
                VariableInstance nextNodeId = (VariableInstance)variableInstances.get("nextNodeId");
                String cachedValue = (String)nextNodeId.getCachedValue();
                if (!HRStringUtils.isEmpty((String)cachedValue) && cachedValue.endsWith("UserTask3")) {
                    signDy.set("billstatus", (Object)BillStatusEnum.STATUS_RESUBMIT.getCode());
                } else {
                    signDy.set("billstatus", (Object)BillStatusEnum.STATUS_APPROVED.getCode());
                }
                signDy.set("handlestatus", (Object)HandleStatusEnum.PROCESSIN.getCombKey());
                ContractSignApplyRepository.CONTRACT_APPLY_HELPER.updateOne(signDy);
            }
        }
        catch (KDException ex) {
            LOGGER.error("ApproveNoPassWorkFlowPlugin======notify======businessKey|{}  error..", (Object)businessKey, (Object)ex);
        }
        LOGGER.info("ApproveNoPassWorkFlowPlugin======notify======businessKey {}", (Object)businessKey);
    }
}

