/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.common.enums;

import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.hr.hom.common.enums.CooLabelStyleEnum;

public enum ActivityOperateEnum {
    RECEIVER("CREATE", CooLabelStyleEnum.PROCESSING),
    TRANSFER("TRANSFER", CooLabelStyleEnum.FINISHED),
    ASSIGN("ASSIGN", CooLabelStyleEnum.FINISHED),
    REJECT("REJECT", CooLabelStyleEnum.FINISHED),
    FINISHED("CONSENT", CooLabelStyleEnum.FINISHED),
    TERMINATED("TERMINATE", CooLabelStyleEnum.OVERDUE);

    private String operate;
    private CooLabelStyleEnum style;
    public static final Map<String, ActivityOperateEnum> OPERATE_CACHE;

    public CooLabelStyleEnum getStyle() {
        return this.style;
    }

    private ActivityOperateEnum(String key, CooLabelStyleEnum style) {
        this.operate = key;
        this.style = style;
    }

    public String getValue() {
        switch (this.operate) {
            case "TRANSFER": 
            case "ASSIGN": {
                return ResManager.loadKDString((String)"\u5df2\u8f6c\u4ea4", (String)"ActivityOperateEnum_0", (String)"hr-hom-common", (Object[])new Object[0]);
            }
            case "REJECT": {
                return ResManager.loadKDString((String)"\u5df2\u9a73\u56de", (String)"ActivityOperateEnum_1", (String)"hr-hom-common", (Object[])new Object[0]);
            }
            case "CONSENT": {
                return ResManager.loadKDString((String)"\u5df2\u5b8c\u6210", (String)"ActivityOperateEnum_2", (String)"hr-hom-common", (Object[])new Object[0]);
            }
            case "TERMINATE": {
                return ResManager.loadKDString((String)"\u5df2\u7ec8\u6b62", (String)"ActivityOperateEnum_3", (String)"hr-hom-common", (Object[])new Object[0]);
            }
        }
        return ResManager.loadKDString((String)"\u5df2\u63a5\u6536", (String)"ActivityOperateEnum_4", (String)"hr-hom-common", (Object[])new Object[0]);
    }

    public String getOperate() {
        return this.operate;
    }

    public static boolean isTransfer(String operate) {
        return TRANSFER.getOperate().equals(operate) || ASSIGN.getOperate().equals(operate);
    }

    static {
        HashMap map = Maps.newHashMapWithExpectedSize((int)ActivityOperateEnum.values().length);
        for (ActivityOperateEnum operateEnum : ActivityOperateEnum.values()) {
            map.put(operateEnum.getOperate(), operateEnum);
        }
        OPERATE_CACHE = Collections.unmodifiableMap(map);
    }
}

