/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.common.util;

import com.alibaba.fastjson.JSONObject;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.Period;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRObjectUtils;

public class DateUtils {
    private static final Log logger = LogFactory.getLog(DateUtils.class);
    private static final long ND = 86400000L;
    private static final long NH = 3600000L;
    public static final String FALSE = "false";

    public static Date selDay(Date date, int day) {
        if (date == null) {
            date = new Date();
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(5, day);
        return calendar.getTime();
    }

    public static Date selMon(Date date, int month) {
        if (date == null) {
            date = new Date();
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(2, month);
        return calendar.getTime();
    }

    public static String getDayAndHour(Date dDate1, Date dDate2) {
        String keyH = ResManager.loadKDString((String)"\u5c0f\u65f6", (String)"DateUtils_0", (String)"hr-hom-common", (Object[])new Object[0]);
        String keyD = ResManager.loadKDString((String)"\u5929", (String)"DateUtils_1", (String)"hr-hom-common", (Object[])new Object[0]);
        if (dDate1 == null || dDate2 == null) {
            return null;
        }
        long diff = dDate2.getTime() - dDate1.getTime();
        long day = diff / 86400000L;
        long hour = diff % 86400000L / 3600000L;
        if (day == 0L) {
            return hour + keyH;
        }
        return day + keyD + hour + keyH;
    }

    public static long getHour(Date dDate1, Date dDate2) {
        long diff = dDate2.getTime() - dDate1.getTime();
        long hour = diff / 3600000L;
        return hour;
    }

    public static Date parseDate(String date) {
        Date result = null;
        if (StringUtils.isEmpty((CharSequence)date)) {
            return null;
        }
        try {
            CharSequence[] split = DateUtils.replaceChinese(date, "-").split("-");
            String join = String.join((CharSequence)"-", split);
            String format = split.length == 2 ? "yyyy-MM" : "yyyy-MM-dd";
            result = HRDateTimeUtils.parseDate((String)join, (String)format);
        }
        catch (ParseException parseException) {
            logger.error("parseDate fail", (Throwable)parseException);
        }
        return result;
    }

    public static String replaceChinese(String source, String replacement) {
        String reg = "[\u4e00-\u9fa5]";
        Pattern pat = Pattern.compile(reg);
        Matcher mat = pat.matcher(source);
        return mat.replaceAll(replacement);
    }

    public static Date setTransDate(DynamicObject onbrdBill) {
        if (onbrdBill != null) {
            Date effect = onbrdBill.getDate("effectdate");
            String isProbation = onbrdBill.getString("isprobation");
            if (effect == null || "0".equals(isProbation) || FALSE.equals(isProbation)) {
                return null;
            }
            int probation = HRObjectUtils.isEmpty((Object)onbrdBill.get("probationtime")) ? 0 : onbrdBill.getInt("probationtime");
            String perProbation = onbrdBill.getString("perprobationtime");
            if ("1".equals(perProbation)) {
                return DateUtils.selMon(effect, probation);
            }
            if ("2".equals(perProbation)) {
                return DateUtils.selDay(effect, 7 * probation);
            }
            if ("3".equals(perProbation)) {
                return DateUtils.selDay(effect, probation);
            }
        }
        return null;
    }

    public static String getDateString(String format, Date date) {
        if (date == null) {
            return " ";
        }
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        String str = sdf.format(date);
        return str;
    }

    public static int getMonths(Date d1, Date d2, boolean isCountDay) {
        if (d1 == null || d2 == null) {
            return 0;
        }
        LocalDate localDate1 = ZonedDateTime.ofInstant(d1.toInstant(), ZoneId.systemDefault()).toLocalDate();
        LocalDate localDate2 = ZonedDateTime.ofInstant(d2.toInstant(), ZoneId.systemDefault()).toLocalDate();
        Period period = Period.between(localDate1, localDate2);
        int months = Math.abs(period.getYears()) * 12 + Math.abs(period.getMonths());
        if (isCountDay && Math.abs(period.getDays()) > 0) {
            ++months;
        }
        return months;
    }

    public static Date setTransDate(JSONObject entryEntityJsonObject) {
        if (entryEntityJsonObject != null) {
            Date effect = entryEntityJsonObject.getDate("effectdate");
            String isProbation = entryEntityJsonObject.getString("isprobation");
            if (effect == null || "0".equals(isProbation) || FALSE.equals(isProbation)) {
                return null;
            }
            int probation = entryEntityJsonObject.getIntValue("probationtime");
            String perProbation = entryEntityJsonObject.getString("perprobationtime");
            String perProbationValue = DateUtils.getPerProbationValue(perProbation);
            if ("1".equals(perProbationValue)) {
                return DateUtils.selMon(effect, probation);
            }
            if ("2".equals(perProbationValue)) {
                return DateUtils.selDay(effect, 7 * probation);
            }
            if ("3".equals(perProbationValue)) {
                return DateUtils.selDay(effect, probation);
            }
        }
        return null;
    }

    private static String getPerProbationValue(String perProbation) {
        if (ResManager.loadKDString((String)"\u4e2a\u6708", (String)"DateUtils_2", (String)"hr-hom-common", (Object[])new Object[0]).equals(perProbation)) {
            return "1";
        }
        if (ResManager.loadKDString((String)"\u5468", (String)"DateUtils_3", (String)"hr-hom-common", (Object[])new Object[0]).equals(perProbation)) {
            return "2";
        }
        if (ResManager.loadKDString((String)"\u5929", (String)"DateUtils_1", (String)"hr-hom-common", (Object[])new Object[0]).equals(perProbation)) {
            return "3";
        }
        return "";
    }

    public static Date getDateEditMinDate() {
        try {
            return HRDateTimeUtils.parseDate((String)"1900-01-01");
        }
        catch (ParseException e) {
            logger.error("###DateUtils.getDateEditMinDate error:", (Throwable)e);
            return null;
        }
    }
}

