/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.common.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Base64;
import java.util.Locale;
import kd.bos.cache.CacheFactory;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.fileservice.extension.FileServiceExt;
import kd.bos.fileservice.extension.FileServiceExtFactory;
import kd.bos.form.control.UrlUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.attachment.AttachmentServiceImpl;
import kd.bos.url.UrlService;
import kd.hr.hbp.common.util.HRImageUrlUtil;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sdk.hr.hpfs.business.config.service.IDevParamConfigService;

public class FileServiceUtils {
    private static final Log logger = LogFactory.getLog(FileServiceUtils.class);

    public static byte[] urlToByte(String url) {
        return FileServiceUtils.urlToByte(url, "UTF-8");
    }

    public static byte[] urlToByte(String url, String enc) {
        try {
            String decode = URLDecoder.decode(url, enc);
            FileService attachmentFileService = FileServiceFactory.getAttachmentFileService();
            if (attachmentFileService.exists(decode)) {
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                attachmentFileService.download(decode, (OutputStream)outputStream, null);
                return outputStream.toByteArray();
            }
        }
        catch (UnsupportedEncodingException exception) {
            logger.error(String.format("urlToByte URLDecoder decode exception %s ", exception));
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getByteWithHttpUrl(String fileUrl) {
        logger.info("FileServiceUtils.getByteWithHttpUrl");
        InputStream is = null;
        ByteArrayOutputStream buffer = null;
        try {
            String[] fileServers;
            String tempURL;
            String httpUrlPrefix;
            if (fileUrl.contains("attachment/download.do")) {
                httpUrlPrefix = System.getProperty("attachmentServer.url");
                tempURL = fileUrl.substring(fileUrl.indexOf(61) + 1);
                tempURL = !httpUrlPrefix.endsWith("/") && !tempURL.startsWith("/") ? httpUrlPrefix + "/" + tempURL : httpUrlPrefix + tempURL;
            } else if (fileUrl.contains("/images/mobile")) {
                String suffixUrl = IDevParamConfigService.getInstance().queryBusinessValueByBusinessKey("hrfileforce.domain.contextUrl");
                tempURL = (HRStringUtils.isNotEmpty((String)suffixUrl) ? suffixUrl : UrlService.getDomainContextUrl()) + fileUrl;
                logger.info("tempURL is {}", (Object)tempURL);
            } else {
                tempURL = fileUrl.contains("fileserver") ? HRImageUrlUtil.getImageFullUrl((String)fileUrl) : (!(httpUrlPrefix = System.getProperty("imageServer.url")).endsWith("/") && !fileUrl.startsWith("/") ? httpUrlPrefix + "/" + fileUrl : httpUrlPrefix + fileUrl);
            }
            logger.info(tempURL);
            String[] split = tempURL.split("\\?");
            if (split != null && split.length == 2) {
                tempURL = split[0] + "?" + URLEncoder.encode(split[1], "UTF-8");
            }
            if ((fileServers = tempURL.split("/fileserver/")) != null && fileServers.length == 2) {
                tempURL = fileServers[0] + "/fileserver/" + URLEncoder.encode(fileServers[1], "UTF-8");
            }
            URL url = new URL(tempURL);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("GET");
            conn.setConnectTimeout(5000);
            is = conn.getInputStream();
            buffer = new ByteArrayOutputStream();
            byte[] bytes = new byte[1024];
            int lenRead = -1;
            while ((lenRead = is.read(bytes, 0, bytes.length)) != -1) {
                buffer.write(bytes, 0, lenRead);
            }
            buffer.flush();
            byte[] byArray = buffer.toByteArray();
            return byArray;
        }
        catch (IOException clientProtocolException) {
            logger.error((Throwable)clientProtocolException);
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                    logger.info("InputStream closed");
                }
                if (buffer != null) {
                    buffer.close();
                }
            }
            catch (IOException exception) {
                logger.error((Throwable)exception);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String imageToBase64ByOnline(String imgURL) throws IOException {
        InputStream is = null;
        ByteArrayOutputStream byteArrayOutputStream = null;
        byte[] byteData = null;
        try {
            logger.info(String.format(Locale.ROOT, "imageToBase64ByOnline %s", imgURL));
            String path = "path=/";
            AttachmentServiceImpl attachmentService = new AttachmentServiceImpl();
            boolean flag = false;
            if (attachmentService.isEncrptyPath() && imgURL.contains(path)) {
                int index = imgURL.indexOf(path);
                String first = imgURL.substring(0, index + path.length() - 1);
                String end = imgURL.substring(index + path.length());
                if (imgURL.contains("attachment/download.do")) {
                    flag = true;
                    imgURL = first + FileServiceExtFactory.getAttachFileServiceExt().getRealPath(end);
                }
            }
            if (!flag) {
                imgURL = FileServiceExtFactory.getImageFileServiceExt().getRealPath(imgURL);
            }
            logger.info(imgURL);
            if (imgURL.contains("tempfile/download.do?configKey")) {
                byteArrayOutputStream = new ByteArrayOutputStream();
                is = CacheFactory.getCommonCacheFactory().getTempFileCache().getInputStream(imgURL);
                byte[] by = new byte[1024];
                int len = -1;
                while ((len = is.read(by)) != -1) {
                    byteArrayOutputStream.write(by, 0, len);
                }
                byteData = byteArrayOutputStream.toByteArray();
                logger.info("CacheFactory.getCommonCacheFactory().getTempFileCache()");
            }
            if (is == null) {
                byteData = FileServiceUtils.getByteWithHttpUrl(imgURL);
            }
        }
        catch (IOException exception) {
            logger.error("imageToBase64ByOnline fail:", (Throwable)exception);
        }
        finally {
            if (is != null) {
                is.close();
            }
            if (byteArrayOutputStream != null) {
                byteArrayOutputStream.close();
            }
        }
        return Base64.getEncoder().encodeToString(byteData);
    }

    public static String getImageFullUrl(String relativeUrl) {
        String igameServerUrl = System.getProperty("imageServer.url");
        if (relativeUrl.startsWith("/")) {
            return igameServerUrl + relativeUrl;
        }
        return igameServerUrl + "/" + relativeUrl;
    }

    @Deprecated
    public static InputStream getInputStreamWithFileUrl(String fileUrl) {
        logger.info("FileServiceUtils.getInputStreamWithHttpUrl");
        try {
            fileUrl = URLDecoder.decode(fileUrl, "UTF-8");
        }
        catch (UnsupportedEncodingException exception) {
            logger.error((Throwable)exception);
        }
        String path = "path=/";
        AttachmentServiceImpl attachmentService = new AttachmentServiceImpl();
        boolean flag = false;
        if (attachmentService.isEncrptyPath() && fileUrl.contains(path)) {
            int index = fileUrl.indexOf(path);
            String first = fileUrl.substring(0, index + path.length() - 1);
            String end = fileUrl.substring(index + path.length());
            if (fileUrl.contains("attachment/download.do")) {
                flag = true;
                fileUrl = first + FileServiceExtFactory.getAttachFileServiceExt().getRealPath(end);
            }
        }
        if (!flag) {
            fileUrl = FileServiceExtFactory.getImageFileServiceExt().getRealPath(fileUrl);
        }
        logger.info(fileUrl);
        InputStream is = null;
        try {
            String[] fileServers;
            String tempURL;
            String httpUrlPrefix;
            if (fileUrl.contains("tempfile/download.do?configKey")) {
                is = CacheFactory.getCommonCacheFactory().getTempFileCache().getInputStream(fileUrl);
                logger.info("CacheFactory.getCommonCacheFactory().getTempFileCache()");
            }
            if (is != null) {
                return is;
            }
            logger.warn("InputStream is null");
            if (fileUrl.contains("attachment/download.do")) {
                httpUrlPrefix = System.getProperty("attachmentServer.url");
                tempURL = fileUrl.substring(fileUrl.indexOf(61) + 1);
                tempURL = !httpUrlPrefix.endsWith("/") && !tempURL.startsWith("/") ? httpUrlPrefix + "/" + tempURL : httpUrlPrefix + tempURL;
            } else {
                tempURL = fileUrl.contains("/images/mobile") || fileUrl.contains("fileserver") ? HRImageUrlUtil.getImageFullUrl((String)fileUrl) : (!(httpUrlPrefix = System.getProperty("imageServer.url")).endsWith("/") && !fileUrl.startsWith("/") ? httpUrlPrefix + "/" + fileUrl : httpUrlPrefix + fileUrl);
            }
            logger.info(tempURL);
            String[] split = tempURL.split("\\?");
            if (split != null && split.length == 2) {
                tempURL = split[0] + "?" + URLEncoder.encode(split[1], "UTF-8");
            }
            if ((fileServers = tempURL.split("/fileserver/")) != null && fileServers.length == 2) {
                tempURL = fileServers[0] + "/fileserver/" + URLEncoder.encode(fileServers[1], "UTF-8");
            }
            URL url = new URL(tempURL);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("GET");
            conn.setConnectTimeout(5000);
            return conn.getInputStream();
        }
        catch (Exception exception) {
            logger.error((Throwable)exception);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getImageByte(String imgUrl) {
        InputStream is = null;
        try {
            int len;
            FileServiceExt fileServiceExt = FileServiceExtFactory.getImageFileServiceExt();
            logger.info("imgUrl:{}", (Object)imgUrl);
            String realPath = fileServiceExt.getRealPath(imgUrl);
            logger.info("realPath:{}", (Object)realPath);
            is = FileServiceUtils.getInputStreamByUrl(realPath);
            if (is == null) {
                logger.warn("InputStreamEmpty");
                byte[] byArray = null;
                return byArray;
            }
            kd.bos.util.io.ByteArrayOutputStream data = new kd.bos.util.io.ByteArrayOutputStream();
            byte[] by = new byte[1024];
            while ((len = is.read(by)) != -1) {
                data.write(by, 0, len);
            }
            byte[] byArray = data.toByteArray();
            return byArray;
        }
        catch (IOException exception) {
            logger.error("imageToBase64 IOException, url:{}!", (Object)imgUrl, (Object)exception);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException ioException) {
                    logger.error("InputStream close exception!", (Throwable)ioException);
                }
            }
        }
        return null;
    }

    public static String getImageBase64(String url) throws IOException {
        String imageData;
        if (url.endsWith("-expAttach")) {
            String imgUrl = url.substring(0, url.lastIndexOf("-expAttach"));
            imageData = FileServiceUtils.imageToBase64ByOnline(url);
            logger.info("imageDataExp=={}==url=={}", (Object)imageData, (Object)imgUrl);
        } else {
            imageData = Base64.getEncoder().encodeToString(FileServiceUtils.getImageByte(url));
        }
        return imageData;
    }

    public static InputStream getInputStreamByUrl(String fileUrl) {
        try {
            logger.info("fileUrl\uff1a", (Object)fileUrl);
            fileUrl = URLDecoder.decode(fileUrl, "UTF-8");
        }
        catch (UnsupportedEncodingException exception) {
            logger.error((Throwable)exception);
        }
        logger.info("fileUrl\uff1a", (Object)fileUrl);
        InputStream is = null;
        if (fileUrl.contains("tempfile/download.do?configKey")) {
            logger.info("CacheFactory.getCommonCacheFactory().getTempFileCache()");
            is = CacheFactory.getCommonCacheFactory().getTempFileCache().getInputStream(fileUrl);
        } else if (fileUrl.contains("fileserver")) {
            logger.info("FileServiceFactory.getAttachmentFileService().getInputStream");
            is = FileServiceFactory.getAttachmentFileService().getInputStream(fileUrl);
        } else if (fileUrl.contains("path=")) {
            String[] pathSplit;
            String url = UrlUtil.getParam((String)fileUrl, (String)"path");
            if (fileUrl.contains("path=/") && (pathSplit = fileUrl.split("path=/")).length > 1) {
                url = pathSplit[1];
            }
            if (HRStringUtils.isNotEmpty((String)url)) {
                logger.info("FileServiceFactory.getAttachmentFileService().getInputStream url:{}", (Object)url);
                is = FileServiceFactory.getAttachmentFileService().getInputStream(url);
            }
        } else if (fileUrl.contains("/images/") || fileUrl.contains("/imglist/")) {
            logger.info("FileServiceFactory.getImageFileService().getInputStream fileUrl:{}", (Object)fileUrl);
            is = FileServiceFactory.getImageFileService().getInputStream(fileUrl);
        } else {
            logger.info("FileServiceFactory.getAttachmentFileService().getInputStream fileUrl:{}", (Object)fileUrl);
            is = FileServiceFactory.getAttachmentFileService().getInputStream(fileUrl);
            if (is == null) {
                logger.info("FileServiceFactory.getImageFileService().getInputStream fileUrl:{}", (Object)fileUrl);
                is = FileServiceFactory.getImageFileService().getInputStream(fileUrl);
            }
        }
        if (is != null) {
            return is;
        }
        logger.warn("InputStream is null");
        return FileServiceUtils.getInputStreamWithFileUrl(fileUrl);
    }
}

