/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.common.util;

import java.io.IOException;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IMetadata;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.util.StringUtils;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.common.util.HRJSONUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;

public class HOMObjectUtils {
    private static final Log LOGGER = LogFactory.getLog(HOMObjectUtils.class);

    public static boolean isEmpty(Object obj) {
        if (obj == null) {
            return true;
        }
        if (obj instanceof DynamicObject) {
            Object pkid = ((DynamicObject)obj).get("id");
            if (pkid instanceof String) {
                return pkid.toString().trim().equals("");
            }
            return ((DynamicObject)obj).getLong("id") == 0L;
        }
        if (obj instanceof String) {
            return obj.toString().trim().equals("");
        }
        if (obj instanceof OrmLocaleValue) {
            return ((OrmLocaleValue)obj).isEmpty();
        }
        if (obj instanceof Collection) {
            return ((Collection)obj).isEmpty();
        }
        if (obj instanceof Map) {
            return ((Map)obj).isEmpty();
        }
        if (obj.getClass().isArray()) {
            return Array.getLength(obj) == 0;
        }
        return false;
    }

    public static boolean isNotEmpty(Object obj) {
        return !HOMObjectUtils.isEmpty(obj);
    }

    public static boolean isEmptyWithDynamicObjectField(DynamicObject entity, String fieldName) {
        Object value = entity.get(fieldName);
        return HOMObjectUtils.isEmptyWithDynamicObjectField(value);
    }

    public static boolean isEmptyWithDynamicObjectField(Object fieldValue) {
        if (fieldValue == null) {
            return true;
        }
        if (fieldValue instanceof DynamicObject) {
            return ((DynamicObject)fieldValue).getLong("id") == 0L;
        }
        if (fieldValue instanceof Long) {
            return (Long)fieldValue == 0L;
        }
        return false;
    }

    public static long getDynamicObjectFieldId(DynamicObject entity, String fieldName) {
        Object fieldValue = entity.get(fieldName);
        if (fieldValue == null) {
            return 0L;
        }
        if (fieldValue instanceof DynamicObject) {
            return ((DynamicObject)fieldValue).getLong("id");
        }
        if (fieldValue instanceof Long) {
            return (Long)fieldValue;
        }
        return 0L;
    }

    public static long getLongValOfCustomParam(Object object) {
        if (object == null) {
            return 0L;
        }
        if (object instanceof Long) {
            return (Long)object;
        }
        if (object instanceof DynamicObject) {
            return ((DynamicObject)object).getLong("id");
        }
        return Long.parseLong(object.toString());
    }

    public static DynamicObject copyHcfHisDynamicObject(String entityNumber, DynamicObject fromObj) {
        DynamicObject hcfHisInfoCopy = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)entityNumber));
        HRDynamicObjectUtils.copy((DynamicObject)fromObj, (DynamicObject)hcfHisInfoCopy);
        hcfHisInfoCopy.set("id", (Object)0L);
        hcfHisInfoCopy.set("sourcevid", (Object)0L);
        return hcfHisInfoCopy;
    }

    public static DynamicObject newHcfHisDynamicObject(String entityNumber, Long candidateId) {
        DynamicObject hcfHisInfoCopy = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)entityNumber));
        hcfHisInfoCopy.set("id", (Object)0L);
        hcfHisInfoCopy.set("sourcevid", (Object)0L);
        hcfHisInfoCopy.set("candidate", (Object)candidateId);
        return hcfHisInfoCopy;
    }

    public static void setFieldValueIfEmpty(DynamicObject bizDataDy, String fieldName, Object fieldValue) {
        Object oldValue = bizDataDy.get(fieldName);
        if (!HOMObjectUtils.isEmpty(oldValue) || HOMObjectUtils.isEmpty(fieldValue)) {
            return;
        }
        if (fieldValue instanceof DynamicObject) {
            bizDataDy.set(fieldName, ((DynamicObject)fieldValue).get("id"));
        } else {
            bizDataDy.set(fieldName, fieldValue);
        }
    }

    public static void setFieldValueIfEmpty(IDataModel dataModel, String fieldName, Object fieldValue) {
        IDataEntityProperty property = dataModel.getProperty(fieldName);
        if (HRObjectUtils.isEmpty((Object)property)) {
            return;
        }
        Object oldValue = dataModel.getValue(fieldName);
        if (!HOMObjectUtils.isEmpty(oldValue) || HOMObjectUtils.isEmpty(fieldValue)) {
            return;
        }
        dataModel.setValue(fieldName, fieldValue);
    }

    public static void setDesDyValueIfNotEmpty(DynamicObject bizDataDy, String fieldName, Object fieldValue) {
        if (HOMObjectUtils.isEmptyWithDynamicObjectField(fieldValue)) {
            return;
        }
        bizDataDy.set(fieldName, fieldValue);
    }

    public static boolean checkIfInteger(String numStr) {
        if (HRStringUtils.isEmpty((String)numStr)) {
            return false;
        }
        String[] strSplit = numStr.replace('.', '-').split("-");
        return (strSplit.length <= 1 || strSplit[1].replace("0", "").length() <= 0) && strSplit.length <= 2 && StringUtils.isNumericString((String)strSplit[0]);
    }

    public static void changeBoidToVid(DynamicObject onbrdBillInfo, String fieldName) {
        long boid;
        DynamicObject fieldValue = onbrdBillInfo.getDynamicObject(fieldName);
        if (HOMObjectUtils.isEmpty(fieldValue)) {
            return;
        }
        Set propertyNames = fieldValue.getDataEntityType().getProperties().stream().map(IMetadata::getName).collect(Collectors.toSet());
        long fid = fieldValue.getLong("id");
        if (fid != (boid = fieldValue.getLong("boid"))) {
            LOGGER.info("The field has been history version ! " + fieldName);
            return;
        }
        long sourcevid = 0L;
        if (propertyNames.contains("sourcevid")) {
            sourcevid = fieldValue.getLong("sourcevid");
        } else if (propertyNames.contains("vid")) {
            sourcevid = fieldValue.getLong("vid");
        } else {
            LOGGER.error("The field cannot find history property ! {}", (Object)fieldName);
        }
        if (sourcevid != 0L) {
            onbrdBillInfo.set(fieldName, (Object)sourcevid);
        }
    }

    public static void setDynamicObjectId(DynamicObject onbrdBillInfo, String fieldName, Object id) {
        onbrdBillInfo.set(fieldName, id);
        onbrdBillInfo.set(fieldName + "_id", id);
    }

    public static String toJSONString(Object source) {
        if (source == null) {
            return "";
        }
        try {
            return HRJSONUtils.toString((Object)source);
        }
        catch (IOException exception) {
            LOGGER.error((Throwable)exception);
            return "";
        }
    }

    public static Long getBoid(DynamicObject dy) {
        if (Objects.isNull(dy)) {
            return null;
        }
        Long boid = null;
        try {
            boid = dy.getLong("boid");
        }
        catch (Exception e) {
            LOGGER.error("the object cannot find the boid property !, error:", (Throwable)e);
        }
        return boid;
    }

    public static String getUniquePageId(String formId, Object pkId, String appRootPageId) {
        return RequestContext.getOrCreate().getGlobalSessionId() + "_" + formId + "_" + pkId + "_" + appRootPageId;
    }

    public static IFormView getCurrAppHomeView(IFormView currView) {
        IFormView parentView = HOMObjectUtils.getParentView(currView);
        IFormView nextParentView = HOMObjectUtils.getParentView(parentView);
        while (parentView != null && nextParentView != null && !"pc_main_console".equals(nextParentView.getFormShowParameter().getFormId())) {
            parentView = nextParentView;
            nextParentView = HOMObjectUtils.getParentView(parentView);
        }
        return parentView;
    }

    public static IFormView getParentView(IFormView currView) {
        if (currView == null) {
            return null;
        }
        String parentPageId = currView.getFormShowParameter().getParentPageId();
        return currView.getViewNoPlugin(parentPageId);
    }

    public static boolean getBooleanValOfObject(Object object) {
        if (object == null) {
            return false;
        }
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        return Boolean.parseBoolean(object.toString());
    }
}

