/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.common.util;

import java.util.ArrayList;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dc.api.model.Account;
import kd.bos.dc.utils.AccountUtils;
import kd.bos.form.field.ComboItem;
import kd.bos.inte.api.EnabledLang;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.model.Language;
import kd.bos.login.user.LanguageService;
import kd.bos.servicehelper.inte.InteServiceHelper;
import kd.bos.session.SessionManager;
import kd.hr.hbp.common.util.HRStringUtils;

public class LanguageUtils {
    private static final Log LOGGER = LogFactory.getLog(LanguageUtils.class);

    public static List<ComboItem> getLangComboItemList() {
        List enabledLangs = InteServiceHelper.getEnabledLang();
        ArrayList<ComboItem> comboItemList = new ArrayList<ComboItem>(enabledLangs.size());
        for (EnabledLang enabledLang : enabledLangs) {
            ComboItem comboItem = new ComboItem();
            comboItem.setValue(enabledLang.getNumber());
            comboItem.setCaption(new LocaleString(enabledLang.getName()));
            comboItemList.add(comboItem);
        }
        return comboItemList;
    }

    public static boolean switchLanguage(String sysLang) {
        if (RequestContext.get() == null) {
            return false;
        }
        boolean needChange = false;
        if (!HRStringUtils.equals((String)sysLang, (String)RequestContext.get().getLang().name())) {
            LOGGER.info("before switchLanguage:" + RequestContext.get().getLang().name());
            String sessionId = RequestContext.get().getTenantCode();
            Account currentCenter = AccountUtils.getCorrectAccount((String)RequestContext.get().getAccountId(), (String)sessionId);
            List languageList = LanguageService.getAllLanguage((Account)currentCenter);
            for (Language langObj : languageList) {
                if (!sysLang.equalsIgnoreCase(langObj.getNumber())) continue;
                needChange = true;
                break;
            }
            if (needChange) {
                sessionId = RequestContext.get().getGlobalSessionId();
                SessionManager.editSessionValue((String)sessionId, (String)"language", (String)sysLang);
                RequestContext.get().setLang(Lang.from((String)sysLang));
                LOGGER.info("after switchLanguage:" + RequestContext.get().getLang().name());
            }
            LOGGER.info("sysLang:" + sysLang + ", needChange:" + needChange);
        }
        return needChange;
    }

    public static String getCurrentSysLangNumber() {
        String currentLangNumber = null;
        if (RequestContext.get() != null) {
            currentLangNumber = RequestContext.get().getLang().name();
        }
        if (HRStringUtils.isEmpty(currentLangNumber)) {
            currentLangNumber = "zh_CN";
        }
        return currentLangNumber;
    }
}

