/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.common.util;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.coderule.api.CodeRuleInfo;
import kd.bos.coderule.util.CodeRuleInfoUtil;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.entity.Tips;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.FieldProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.form.IFormView;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.MulBasedataEdit;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hom.common.util.HOMObjectUtils;

public class UpdateControlUtil {
    private static final String CACHEKEY_CUSTOM_MUSTINPUT = "hom_custom_mustinput";

    public static void changeCtrlName(IFormView formView, String key, String name) {
        UpdateControlUtil.changeCtrlName(formView, key, new LocaleString(name));
    }

    public static void changeCtrlName(IFormView formView, String key, LocaleString name) {
        HashMap ctrl = Maps.newHashMapWithExpectedSize((int)2);
        ctrl.put("text", name);
        formView.updateControlMetadata(key, (Map)ctrl);
    }

    public static void changeCtrlBcColor(IFormView formView, String key, String bcColor) {
        HashMap ctrl = Maps.newHashMapWithExpectedSize((int)2);
        ctrl.put("bc", bcColor);
        formView.updateControlMetadata(key, (Map)ctrl);
    }

    public static void setMustInput(IFormView formView, String key, boolean isMustInput) {
        DataEntityPropertyCollection properties = formView.getModel().getDataEntityType().getProperties();
        IDataEntityProperty property = (IDataEntityProperty)properties.get((Object)key);
        if (property instanceof FieldProp) {
            ((FieldProp)property).setMustInput(isMustInput);
        } else if (property instanceof BasedataProp) {
            ((BasedataProp)property).setMustInput(isMustInput);
        } else if (property instanceof MulBasedataProp) {
            ((MulBasedataProp)property).setMustInput(isMustInput);
        } else if (property instanceof EntryProp) {
            ((EntryProp)property).setEntryMustInput(isMustInput);
        }
    }

    public static void setMustInput(IFormView formView, String[] keys, boolean isMustInput) {
        DataEntityPropertyCollection properties = formView.getModel().getDataEntityType().getProperties();
        for (String key : keys) {
            IDataEntityProperty property = (IDataEntityProperty)properties.get((Object)key);
            if (property instanceof FieldProp) {
                FieldEdit fieldEdit = (FieldEdit)formView.getControl(key);
                fieldEdit.setMustInput(isMustInput);
                continue;
            }
            if (property instanceof BasedataProp) {
                BasedataEdit basedataEdit = (BasedataEdit)formView.getControl(key);
                basedataEdit.setMustInput(isMustInput);
                continue;
            }
            if (property instanceof MulBasedataProp) {
                MulBasedataEdit mulBasedataEdit = (MulBasedataEdit)formView.getControl(key);
                mulBasedataEdit.setMustInput(isMustInput);
                continue;
            }
            if (!(property instanceof EntryProp)) continue;
            ((EntryProp)property).setEntryMustInput(isMustInput);
        }
        String mustInputStr = formView.getPageCache().get(CACHEKEY_CUSTOM_MUSTINPUT);
        if (HRStringUtils.isEmpty((String)mustInputStr) && !isMustInput) {
            return;
        }
        Set<String> mustInputFields = new HashSet<String>(keys.length);
        if (HRStringUtils.isNotEmpty((String)mustInputStr)) {
            mustInputFields = (Set)JSONObject.parseObject((String)mustInputStr, Set.class);
        }
        if (isMustInput) {
            mustInputFields.addAll(Arrays.asList(keys));
        } else {
            mustInputFields.removeAll(Arrays.asList(keys));
        }
        formView.getPageCache().put(CACHEKEY_CUSTOM_MUSTINPUT, HOMObjectUtils.toJSONString(mustInputFields));
    }

    public static Set<String> getCustomMustInputFields(IFormView formView) {
        String mustInputStr = formView.getPageCache().get(CACHEKEY_CUSTOM_MUSTINPUT);
        Set<String> mustInputFields = new HashSet<String>();
        if (HRStringUtils.isNotEmpty((String)mustInputStr)) {
            mustInputFields = (Set)JSONObject.parseObject((String)mustInputStr, Set.class);
        }
        return mustInputFields;
    }

    public static Set<String> getViewMustInputFields(IFormView formView) {
        Set<String> mustInputFields = UpdateControlUtil.getCustomMustInputFields(formView);
        DynamicObject dynamicObjectPage = formView.getModel().getDataEntity();
        DataEntityPropertyCollection properties = dynamicObjectPage.getDataEntityType().getProperties();
        for (IDataEntityProperty property : properties) {
            boolean isMustInput = false;
            String mustInputCondition = null;
            if (property instanceof FieldProp) {
                FieldProp fieldProp = (FieldProp)property;
                isMustInput = fieldProp.isMustInput();
                mustInputCondition = fieldProp.getMustInputCondition();
            } else if (property instanceof BasedataProp) {
                BasedataProp basedataProp = (BasedataProp)property;
                isMustInput = basedataProp.isMustInput();
                mustInputCondition = basedataProp.getMustInputCondition();
            } else if (property instanceof MulBasedataProp) {
                MulBasedataProp mulBasedataProp = (MulBasedataProp)property;
                isMustInput = mulBasedataProp.isMustInput();
                mustInputCondition = mulBasedataProp.getMustInputCondition();
            } else if (property instanceof EntryProp) {
                EntryProp entryProp = (EntryProp)property;
                isMustInput = entryProp.isEntryMustInput();
            }
            if (isMustInput && HRStringUtils.isNotEmpty((String)mustInputCondition)) {
                CodeRuleInfo codeRuleInfo = new CodeRuleInfo();
                codeRuleInfo.setEnableCondition(mustInputCondition);
                isMustInput = CodeRuleInfoUtil.isMatchConditions((CodeRuleInfo)codeRuleInfo, (DynamicObject)dynamicObjectPage);
            }
            if (!isMustInput) continue;
            mustInputFields.add(property.getName());
        }
        return mustInputFields;
    }

    public static Tips getTextTips(String context) {
        Tips tips = new Tips();
        tips.setType("text");
        tips.setContent(new LocaleString(context));
        return tips;
    }

    public static void setFieldTips(IFormView formView, String key, Tips tips) {
        FieldEdit fieldEdit = (FieldEdit)formView.getControl(key);
        if (fieldEdit == null) {
            return;
        }
        fieldEdit.addTips(tips);
    }
}

