/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.business.application.common;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.cache.HRAppCache;
import kd.hr.hbp.common.cache.IHRAppCache;
import kd.hr.hom.business.domain.service.common.IHomDataMutexService;

public class CommonService {
    private static final Log LOGGER = LogFactory.getLog(CommonService.class);
    public static final String KEY_DATAMUTEX_ACTIVITY = "KEY_DATAMUTEX_ACTIVITY";
    private static final String KEY_DATAMUTEX_USERID = "hom:DataMutex:userId";
    private static final String KEY_DATAMUTEX_RELEASE = "pageId:userId";

    public static boolean tryRequireLockWithOnbrdBill(Long dataId, String operationKey, String lockKey, IFormView formView, String childPageNum) {
        if (dataId == null || dataId == 0L) {
            return false;
        }
        boolean flag = IHomDataMutexService.getInstance().requireLock(dataId.toString(), childPageNum, formView, operationKey, true, "1");
        if (flag) {
            IHRAppCache cache = HRAppCache.get((String)lockKey);
            JSONObject jsonObject = (JSONObject)cache.get(dataId.toString(), JSONObject.class);
            if (jsonObject == null || jsonObject.isEmpty()) {
                jsonObject = new JSONObject();
                IHRAppCache userIdCache = HRAppCache.get((String)lockKey);
                userIdCache.put(dataId.toString(), (Object)RequestContext.get().getCurrUserId());
            }
            jsonObject.put(childPageNum, (Object)System.currentTimeMillis());
            String releasekey = RequestContext.get().getCurrUserId() + formView.getPageId();
            jsonObject.put(KEY_DATAMUTEX_RELEASE, (Object)releasekey);
            cache.put(dataId.toString(), (Object)jsonObject);
            LOGGER.info(jsonObject.toJSONString());
            LOGGER.info(childPageNum + " Require_lock_cache_childview:" + dataId);
        }
        return flag;
    }

    public static boolean releaseLockWithOnbrdBill(Long dataId, String lockKey, String childPageNum, String opKey, IFormView formView) {
        IHRAppCache cache = HRAppCache.get((String)lockKey);
        JSONObject jsonObject = (JSONObject)cache.get(dataId.toString(), JSONObject.class);
        if (jsonObject != null && !jsonObject.isEmpty()) {
            String currReleaseKey;
            String releaseKey = null;
            if (jsonObject.get((Object)KEY_DATAMUTEX_RELEASE) != null) {
                releaseKey = jsonObject.get((Object)KEY_DATAMUTEX_RELEASE).toString();
            }
            if (!(currReleaseKey = RequestContext.get().getCurrUserId() + formView.getPageId()).equals(releaseKey)) {
                return false;
            }
            jsonObject.remove((Object)childPageNum);
            jsonObject.remove((Object)KEY_DATAMUTEX_RELEASE);
            LOGGER.info(jsonObject.toJSONString());
            LOGGER.info(childPageNum + " remove_lock_cache_childview:" + dataId);
            cache.put(dataId.toString(), (Object)jsonObject);
        }
        if (jsonObject == null || jsonObject.isEmpty()) {
            cache.remove(dataId.toString());
            IHRAppCache userIdCache = HRAppCache.get((String)KEY_DATAMUTEX_USERID);
            userIdCache.remove(dataId.toString());
            LOGGER.info("release_lock_by_allchildview:" + dataId);
            return IHomDataMutexService.getInstance().release(dataId.toString(), childPageNum, opKey);
        }
        LOGGER.info("cannot release_lock_by_allchildview:" + dataId);
        return false;
    }

    public static List<Long> getLongList(List<Object> Ids) {
        ArrayList<Long> ids = new ArrayList<Long>();
        if (Ids == null) {
            return ids;
        }
        Ids.forEach(obj -> ids.add(Long.valueOf(obj.toString())));
        return ids;
    }
}

