/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.business.application.impl.cvp;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.IFormView;
import kd.bos.form.events.ClientCallBackEvent;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.hr.hbp.common.cache.HRAppCache;
import kd.hr.hbp.common.cache.IHRAppCache;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hom.business.application.common.HROcrValidateServiceHelper;
import kd.hr.hom.business.application.cvp.IHomToCvpAppService;
import kd.hr.hom.business.application.utils.HomAppConfigUtil;
import kd.hr.hom.common.entity.ocr.AlgoResultData;
import kd.hr.hom.common.entity.ocr.CertificateOfDegreeResult;
import kd.hr.hom.common.entity.ocr.CertificateOfResignationResult;
import kd.hr.hom.common.entity.ocr.DiplomaResult;
import kd.hr.hom.common.entity.ocr.OcrBankCardResult;
import kd.hr.hom.common.entity.ocr.OcrIdCardResult;
import kd.hr.hom.common.util.FileServiceUtils;

public class HomToCvpAppServiceImpl
implements IHomToCvpAppService {
    private static final Log logger = LogFactory.getLog(HomToCvpAppServiceImpl.class);
    private static final ThreadPool threadPool = ThreadPools.newCachedThreadPool((String)"HomToCvpAppServiceImpl", (int)5, (int)1000);
    private static final Map<String, LocaleString> ocrTipInfo = ImmutableMap.builder().put((Object)"OPM-Diploma", (Object)ResManager.getLocaleString((String)"\u5b66\u5386\u8bc1", (String)"HomToCvpAppServiceImpl_2", (String)"hr-hom-business")).put((Object)"OPM-CertificateOfResignation", (Object)ResManager.getLocaleString((String)"\u79bb\u804c\u8bc1\u660e", (String)"HomToCvpAppServiceImpl_3", (String)"hr-hom-business")).put((Object)"OPM-CertificateOfDegree", (Object)ResManager.getLocaleString((String)"\u5b66\u4f4d\u8bc1", (String)"HomToCvpAppServiceImpl_4", (String)"hr-hom-business")).put((Object)"OPM-IDCardFront", (Object)ResManager.getLocaleString((String)"\u56fd\u5fbd\u9762", (String)"HomToCvpAppServiceImpl_7", (String)"hr-hom-business")).put((Object)"OPM-IdCardBack", (Object)ResManager.getLocaleString((String)"\u4eba\u50cf\u9762", (String)"HomToCvpAppServiceImpl_8", (String)"hr-hom-business")).put((Object)"OPM-BankCard", (Object)ResManager.getLocaleString((String)"\u94f6\u884c\u5361", (String)"HomToCvpAppServiceImpl_9", (String)"hr-hom-business")).build();

    @Override
    public Object getResultData(String templateNumber, AlgoResultData algoResultData) {
        if (ObjectUtils.isEmpty((Object)algoResultData.getData())) {
            return null;
        }
        switch (templateNumber) {
            case "OPM-IdCardBack": 
            case "OPM-IDCardFront": {
                return JSON.parseObject((String)JSON.toJSONString((Object)algoResultData.getData()), OcrIdCardResult.class);
            }
            case "OPM-CertificateOfDegree": {
                return JSON.parseObject((String)JSON.toJSONString((Object)algoResultData.getData()), CertificateOfDegreeResult.class);
            }
            case "OPM-Diploma": {
                return JSON.parseObject((String)JSONObject.toJSONString((Object)algoResultData.getData()), DiplomaResult.class);
            }
            case "OPM-CertificateOfResignation": {
                return JSON.parseObject((String)JSON.toJSONString((Object)algoResultData.getData()), CertificateOfResignationResult.class);
            }
            case "OPM-BankCard": {
                return JSON.parseObject((String)JSON.toJSONString((Object)algoResultData.getData()), OcrBankCardResult.class);
            }
        }
        return null;
    }

    @Override
    public AlgoResultData distinguishOcrImage(String businessObject, String templateNumber, String url) {
        try {
            Future result = IHomToCvpAppService.OCR_THREAD_POOL.submit(() -> this.syncDistinguishOcrImage(businessObject, templateNumber, url), RequestContext.get());
            String resultStr = (String)result.get(60L, TimeUnit.SECONDS);
            AlgoResultData algoResultData = (AlgoResultData)JSON.parseObject((String)resultStr, AlgoResultData.class);
            return algoResultData;
        }
        catch (TimeoutException exception) {
            logger.error(" OCR API request time out:{}, {}, {}.", new Object[]{businessObject, templateNumber, url});
            return new AlgoResultData(RequestContext.get().getTraceId(), 40000, ResManager.loadKDString((String)"OCR\u8c03\u7528\u8d85\u65f6\u3002", (String)"HomToCvpAppServiceImpl_0", (String)"hr-hom-business", (Object[])new Object[0]));
        }
        catch (Exception exception) {
            logger.error("ocr fail:{}, {}, {}.", new Object[]{businessObject, templateNumber, url});
            return new AlgoResultData(RequestContext.get().getTraceId(), 40000, ResManager.loadKDString((String)"OCR\u8c03\u7528\u5f02\u5e38\u3002", (String)"HomToCvpAppServiceImpl_1", (String)"hr-hom-business", (Object[])new Object[0]));
        }
    }

    private String syncDistinguishOcrImage(String businessObject, String templateNumber, String url) throws IOException {
        long start = System.currentTimeMillis();
        logger.info(MessageFormat.format("syncDistinguishOcrImage-start-businessObject {0}, templateNumber {1},imageData {2}", businessObject, templateNumber, url));
        String imageData = FileServiceUtils.getImageBase64((String)url);
        if (HRStringUtils.isEmpty((String)imageData)) {
            logger.error("imageToBase64 empty, url:{}!", (Object)url);
            return null;
        }
        logger.info("imageData base64: {}", (Object)imageData);
        logger.info("Base64 imageData.length():" + imageData.length());
        Object[] params = new Object[]{businessObject, templateNumber, imageData};
        String result = (String)DispatchServiceHelper.invokeBizService((String)"ai", (String)"cvp", (String)"OcrService", (String)"distinguishOcrImage", (Object[])params);
        logger.info(MessageFormat.format("syncDistinguishOcrImage-end-businessObject {0}, templateNumber {1},imageData {2} time {3}", businessObject, templateNumber, url, System.currentTimeMillis() - start));
        return result;
    }

    @Override
    public List<AlgoResultData> attachmentToDistinguishOcr(Object[] urls, String businessObject, String templateNumber) {
        ArrayList<AlgoResultData> resultDataList = new ArrayList<AlgoResultData>(urls.length);
        for (Object attachmentpanelapUrl : urls) {
            String imageFullUrl = null;
            if (attachmentpanelapUrl instanceof Map) {
                Map url = (Map)attachmentpanelapUrl;
                imageFullUrl = (String)url.get("url");
            } else if (attachmentpanelapUrl instanceof String) {
                imageFullUrl = (String)attachmentpanelapUrl;
            }
            if (!HRStringUtils.isNotEmpty(imageFullUrl)) continue;
            AlgoResultData algoResultData = this.distinguishOcrImage(businessObject, templateNumber, imageFullUrl);
            resultDataList.add(algoResultData);
        }
        return resultDataList;
    }

    @Override
    public List<Object> getResultData(List<AlgoResultData> algoResultDataList, String templateNumber, IFormView view) {
        ArrayList<Object> resultDataList = new ArrayList<Object>(algoResultDataList.size());
        StringBuilder messages = new StringBuilder();
        for (AlgoResultData algoResultData : algoResultDataList) {
            if (Integer.valueOf(0).equals(algoResultData.getErrorCode())) {
                resultDataList.add(this.getResultData(templateNumber, algoResultData));
                continue;
            }
            messages.append(algoResultData.getDescription());
        }
        this.showMessage(templateNumber, view, messages);
        return resultDataList;
    }

    private void showMessage(String templateNumber, IFormView view, StringBuilder messages) {
        String tip = ocrTipInfo.getOrDefault(templateNumber, new LocaleString()).getLocaleValue();
        if (StringUtils.isNotBlank((CharSequence)messages.toString())) {
            view.showErrorNotification(String.format(Locale.ROOT, "%s%s", tip, messages.toString()));
        } else {
            view.showSuccessNotification(String.format(Locale.ROOT, ResManager.loadKDString((String)"%s\u5185\u5bb9\u8bc6\u522b\u6210\u529f\u3002", (String)"HomToCvpAppServiceImpl_6", (String)"hr-hom-business", (Object[])new Object[0]), tip));
        }
    }

    @Override
    public void algoResultData(Object[] urls, String businessObject, String templateNumber, IFormView view) {
        threadPool.execute(() -> {
            logger.info("algoResultData-start");
            List<AlgoResultData> algoResultData = this.attachmentToDistinguishOcr(urls, businessObject, templateNumber);
            if (CollectionUtils.isEmpty(algoResultData)) {
                logger.error("algoResultData error");
                return;
            }
            HRAppCache.get((String)"hom:ocr").put(this.getCacheKey(view, templateNumber), algoResultData);
            logger.info("algoResultData-end");
        }, RequestContext.get());
    }

    @Override
    public List<Object> getOcrResult(ClientCallBackEvent event, IFormView view, String type) {
        String templateNumber;
        IHRAppCache ihrAppCache = HRAppCache.get((String)"hom:ocr");
        List resultList = (List)ihrAppCache.get(this.getCacheKey(view, templateNumber = event.getName()), List.class);
        if (CollectionUtils.isEmpty((Collection)resultList)) {
            view.addClientCallBack(event.getName(), Integer.valueOf(2000));
            if ("H5".equals(type)) {
                view.showTipNotification(ResManager.loadKDString((String)"OCR\u6587\u672c\u8bc6\u522b\u4e2d\uff0c\u8bf7\u7a0d\u5019\u3002", (String)"InfoGroupDynViewMobilePlugin_10", (String)"hr-hom-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
            }
            return Collections.EMPTY_LIST;
        }
        if ("PC".equals(type)) {
            view.hideLoading();
        }
        ihrAppCache.remove(this.getCacheKey(view, templateNumber));
        List algoResultDataList = JSON.parseArray((String)JSONObject.toJSONString((Object)resultList), AlgoResultData.class);
        return IHomToCvpAppService.getInstance().getResultData(algoResultDataList, templateNumber, view);
    }

    @Override
    public Boolean ocrIsEnable() {
        return Boolean.parseBoolean(System.getProperty("hr.ocr.enable", "false")) && this.enableOcr() != false;
    }

    @Override
    public Boolean isHasLicense() {
        return HROcrValidateServiceHelper.checkOcrLicenseGroup() && this.enableOcr() != false;
    }

    @Override
    public Boolean isEnableOcr(IFormView view) {
        String enableOcrStr = view.getPageCache().get("enableOcr");
        if (HRStringUtils.isEmpty((String)enableOcrStr)) {
            enableOcrStr = this.isHasLicense() != false ? "1" : "0";
            view.getPageCache().put("enableOcr", enableOcrStr);
        }
        return "1".equals(enableOcrStr);
    }

    @Override
    public Boolean isEnableOcr(IFormView view, long orgId) {
        String enableOcrStr = view.getPageCache().get("enableOcr");
        if (HRStringUtils.isEmpty((String)enableOcrStr)) {
            enableOcrStr = this.isHasLicenseMobile(orgId) != false ? "1" : "0";
            logger.info("{}==ocrenable=={}", (Object)view.getEntityId(), (Object)enableOcrStr);
            view.getPageCache().put("enableOcr", enableOcrStr);
        }
        return "1".equals(enableOcrStr);
    }

    private Boolean isHasLicenseMobile(long orgId) {
        return HROcrValidateServiceHelper.checkOcrLicenseGroup() && Boolean.parseBoolean(HomAppConfigUtil.getAppParam("1XL6VIDTDRXN", orgId, "homisocr") + "");
    }

    @Override
    public Boolean isEnableOcr() {
        return this.isHasLicense();
    }

    @Override
    public Boolean isCollectEnableOcr() {
        return HROcrValidateServiceHelper.checkOcrLicenseGroup();
    }

    @Override
    public Boolean isCollectEnableOcr(long orgId) {
        return HROcrValidateServiceHelper.checkOcrLicenseGroup() && Boolean.parseBoolean(HomAppConfigUtil.getAppParam("1XL6VIDTDRXN", orgId, "homisocr") + "");
    }

    public Boolean enableOcr() {
        return Boolean.valueOf(HomAppConfigUtil.getAppParam("1XL6VIDTDRXN", RequestContext.get().getOrgId(), "homisocr") + "");
    }

    private String getCacheKey(IFormView view, String templateNumber) {
        return String.format("%s-%s", templateNumber, view.getPageId());
    }
}

