/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.business.application.impl.extension;

import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hom.business.application.impl.extension.PersonInfoExService;
import kd.hr.hom.common.constant.HcfCandidateConstants;
import kd.hr.hom.common.util.PutValueToModelUtils;
import kd.sdk.hr.hom.business.personinfo.IContactInfoService;

public class ContactInfoServiceSdkImpl
implements IContactInfoService {
    private static final Log LOGGER = LogFactory.getLog(ContactInfoServiceSdkImpl.class);

    public String getExtPropertiesWithAddress() {
        return "candidate,addresstype,countrycode,addressinfo";
    }

    public void initViewWithAddress(IFormView formView, DynamicObjectCollection hcfAddressList) {
        if (CollectionUtils.isEmpty((Collection)hcfAddressList)) {
            return;
        }
        IDataModel model = formView.getModel();
        for (DynamicObject dynamicObject : hcfAddressList) {
            DynamicObject addressType = dynamicObject.getDynamicObject("addresstype");
            if (Objects.isNull(addressType)) continue;
            Long addressTypeId = addressType.getLong("id");
            if (addressTypeId.equals(HcfCandidateConstants.ADDRESSTYPE_CN_HUKOUID)) {
                model.setValue("regresidencecountry", dynamicObject.get("countrycode"));
                model.setValue("regresidenceaddressdetail", dynamicObject.get("addressinfo"));
                continue;
            }
            if (addressTypeId.equals(HcfCandidateConstants.ADDRESSTYPE_CN_PERSONID)) {
                model.setValue("livecountry", dynamicObject.get("countrycode"));
                model.setValue("liveaddressdetail", dynamicObject.get("addressinfo"));
                continue;
            }
            if (!addressTypeId.equals(HcfCandidateConstants.ADDRESSTYPE_CN_COMMUID)) continue;
            model.setValue("commucountry", dynamicObject.get("countrycode"));
            model.setValue("commuaddress", dynamicObject.get("addressinfo"));
        }
    }

    public void setValueBeforeSaveAddress(IFormView formView, DynamicObjectCollection hcfAddressList) {
        LOGGER.info("kd.hr.hom.business.application.impl.extension.ContactInfoServiceImpl.setValueBeforeSaveAddress");
    }

    public String getExtProperties() {
        return "candidate,phone,peremail";
    }

    public void initViewForExt(IFormView formView, DynamicObject hcfContactInfo) {
        IDataModel model = formView.getModel();
        if (!HRObjectUtils.isEmpty((Object)hcfContactInfo)) {
            LOGGER.info("===ContactInfoPlugin hcfContact==={}");
            model.setValue("phone", (Object)hcfContactInfo.getString("phone"));
            model.setValue("peremail", (Object)hcfContactInfo.getString("peremail"));
            Set<String> exFields = PersonInfoExService.getExFields(formView);
            if (!CollectionUtils.isEmpty(exFields)) {
                PutValueToModelUtils.putValueToModel((IFormView)formView, (DynamicObject)hcfContactInfo, (String[])exFields.toArray(new String[0]));
            }
        }
    }

    public void setValueBeforeSave(IFormView formView, DynamicObject hcfInfoDy) {
        IDataModel model = formView.getModel();
        hcfInfoDy.set("phone", model.getValue("phone"));
        hcfInfoDy.set("peremail", model.getValue("peremail"));
        PersonInfoExService.setExFieldValue(formView, hcfInfoDy);
    }
}

