/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.business.application.impl.hcf;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.InputStream;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.control.UrlUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.util.HRCollUtil;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hom.business.application.hcf.IHomToHcfAppService;
import kd.hr.hom.business.application.hrpi.IHomToHrpiAppService;
import kd.hr.hom.business.domain.repository.common.HomCommonRepository;
import kd.hr.hom.business.domain.service.ServiceFactory;
import kd.hr.hom.business.domain.service.base.IHomConfigDomainService;
import kd.hr.hom.business.domain.service.collect.ICollectService;
import kd.hr.hom.business.domain.service.impl.collect.SyncCollectToHcfImpl;
import kd.hr.hom.common.enums.InfoGroupFieldTypeEnum;
import kd.hr.hom.common.enums.ViewTypeEnum;
import kd.sdk.hr.hom.common.InfoGroupEntity;
import org.apache.commons.lang3.ObjectUtils;

public class HomToHcfAppServiceImpl
implements IHomToHcfAppService {
    private static final Log LOGGER = LogFactory.getLog(SyncCollectToHcfImpl.class);
    private static final HRBaseServiceHelper ATTACHEMENT_SERVICE_HELPER = new HRBaseServiceHelper("bos_attachment");
    private static final Set<String> IGNORE_FIELD = Sets.newHashSet((Object[])new String[]{"boid", "id", "sourcevid", "purposemulbase"});

    @Override
    public Map<String, DynamicObjectCollection> getCandidate(Long id, Map<String, String> entityFields, Long vid) {
        return (Map)HRMServiceHelper.invokeHRMPService((String)"hcf", (String)"IHCFService", (String)"getCandidate", (Object[])new Object[]{id, entityFields, vid});
    }

    @Override
    public DynamicObject getSingleRowEntity(Long id, String entityNumber) {
        return (DynamicObject)HRMServiceHelper.invokeHRMPService((String)"hcf", (String)"IHCFService", (String)"getSingleRowEntity", (Object[])new Object[]{id, entityNumber});
    }

    @Override
    public Map<String, Object> saveHisSingleRowEntity(Map<Long, DynamicObject> personMap, String entityNumber) {
        return (Map)HRMServiceHelper.invokeHRMPService((String)"hcf", (String)"IHCFService", (String)"saveHisSingleRowEntity", (Object[])new Object[]{personMap, entityNumber});
    }

    @Override
    public DynamicObjectCollection getHisMultiRowEntity(Long id, String entityNumber) {
        return (DynamicObjectCollection)HRMServiceHelper.invokeHRMPService((String)"hcf", (String)"IHCFService", (String)"getHisMultiRowEntity", (Object[])new Object[]{id, entityNumber});
    }

    @Override
    public Map<String, Object> saveMultiRowEntityWithoutDelete(Map<Long, DynamicObjectCollection> entities, String entityNumber) {
        return (Map)HRMServiceHelper.invokeHRMPService((String)"hcf", (String)"IHCFService", (String)"saveMultiRowEntityWithoutDelete", (Object[])new Object[]{entities, entityNumber});
    }

    @Override
    public Map<String, Object> saveMultiRowEntity(Map<Long, DynamicObjectCollection> entities, String entityNumber) {
        return (Map)HRMServiceHelper.invokeHRMPService((String)"hcf", (String)"IHCFService", (String)"saveMultiRowEntity", (Object[])new Object[]{entities, entityNumber});
    }

    @Override
    public Map<String, Object> saveHisMultiRowEntity(Map<Long, DynamicObjectCollection> entities, String entityNumber) {
        return (Map)HRMServiceHelper.invokeHRMPService((String)"hcf", (String)"IHCFService", (String)"saveHisMultiRowEntity", (Object[])new Object[]{entities, entityNumber});
    }

    @Override
    public List<DynamicObject> queryAttach(Long targetId, DynamicObject typeDy) {
        if (targetId == null || targetId == 0L) {
            return new ArrayList<DynamicObject>();
        }
        String entityName = typeDy.getString("entityname");
        String attachmentpanel = typeDy.getString("attachmentpanel");
        QFilter filter = new QFilter("finterid", "in", (Object)String.valueOf(targetId)).and(new QFilter("fbilltype", "=", (Object)entityName).and(new QFilter("fattachmentpanel", "=", (Object)attachmentpanel)));
        Object[] dys = ATTACHEMENT_SERVICE_HELPER.loadDynamicObjectArray(new QFilter[]{filter});
        return Lists.newArrayList((Object[])dys);
    }

    @Override
    public List<DynamicObject> queryAttach(Long targetId, Set<String> attachmentpanelKeys, String entityNumber) {
        if (targetId == null || targetId == 0L || CollectionUtils.isEmpty(attachmentpanelKeys)) {
            return new ArrayList<DynamicObject>();
        }
        QFilter filter = new QFilter("finterid", "=", (Object)String.valueOf(targetId)).and(new QFilter("fbilltype", "=", (Object)entityNumber).and(new QFilter("fattachmentpanel", "in", attachmentpanelKeys)));
        Object[] dys = ATTACHEMENT_SERVICE_HELPER.loadDynamicObjectArray(new QFilter[]{filter});
        return Lists.newArrayList((Object[])dys);
    }

    @Override
    public List<DynamicObject> queryAttach(Set<String> targetIds, DynamicObject typeDy, String attach) {
        String entityName = typeDy.getString("entityname");
        QFilter filter = new QFilter("finterid", "in", targetIds).and(new QFilter("fbilltype", "=", (Object)entityName).and(new QFilter("fattachmentpanel", "=", (Object)attach)));
        Object[] dys = ATTACHEMENT_SERVICE_HELPER.loadDynamicObjectArray(new QFilter[]{filter});
        return Lists.newArrayList((Object[])dys);
    }

    @Override
    public Map<String, Object> saveOrUpdateCandidates(List<Map<String, DynamicObjectCollection>> candidates) {
        return (Map)HRMServiceHelper.invokeHRMPService((String)"hcf", (String)"IHCFService", (String)"saveOrUpdateCandidates", (Object[])new Object[]{candidates});
    }

    @Override
    public Map<String, Object> deleteById(Long id, String entityName) {
        return (Map)HRMServiceHelper.invokeHRMPService((String)"hcf", (String)"IHCFService", (String)"deleteById", (Object[])new Object[]{id, entityName});
    }

    @Override
    public DynamicObjectCollection getHisMultiRowEntity(Long id, String entityNumber, QFilter[] filters) {
        return (DynamicObjectCollection)HRMServiceHelper.invokeHRMPService((String)"hcf", (String)"IHCFService", (String)"getHisMultiRowEntity", (Object[])new Object[]{id, entityNumber, filters});
    }

    @Override
    public Map<String, Object> deleteByIdNoHis(Long id, String entityName) {
        return (Map)HRMServiceHelper.invokeHRMPService((String)"hcf", (String)"IHCFService", (String)"deletebyidnohis", (Object[])new Object[]{id, entityName});
    }

    @Override
    public void deleteRowEntity(String entityName, List<Long> candidateIds) {
        HRMServiceHelper.invokeHRMPService((String)"hcf", (String)"IHCFService", (String)"deleteRowEntity", (Object[])new Object[]{entityName, candidateIds});
    }

    @Override
    public void saveCandidateInfo(Map<String, DynamicObjectCollection> candidateInfo, Long candidateId) {
        HRMServiceHelper.invokeHRMPService((String)"hcf", (String)"IHCFService", (String)"saveCandidateInfo", (Object[])new Object[]{candidateInfo, candidateId});
    }

    @Override
    public DynamicObjectCollection getHisMultiRowEntityById(Long id, Long candidateId, String entityName) {
        QFilter filter = new QFilter("id", "=", (Object)id);
        return this.getHisMultiRowEntity(candidateId, entityName, new QFilter[]{filter});
    }

    @Override
    public DynamicObject getById(Long id, String entityName) {
        return (DynamicObject)HRMServiceHelper.invokeHRMPService((String)"hcf", (String)"IHCFService", (String)"getById", (Object[])new Object[]{id, entityName});
    }

    @Override
    public void syncCandidateInfo(DynamicObject onbrdBill) {
        LOGGER.info("###syncCandidateInfo-start {}", (Object)onbrdBill.getString("id"));
        if (!ViewTypeEnum.AGAIN.getCode().equalsIgnoreCase(onbrdBill.getString("viewtype")) || !onbrdBill.getBoolean("automaticinfo") || HRObjectUtils.isEmpty((Object)onbrdBill.getDynamicObject("personfield")) || HRObjectUtils.isEmpty((Object)onbrdBill.getDynamicObject("personfield.candidate"))) {
            return;
        }
        LOGGER.info("start sync candidate info");
        Long originalCandidate = onbrdBill.getLong("personfield.candidate.id");
        if (originalCandidate == 0L) {
            LOGGER.info("candidate not exit");
            return;
        }
        Long targetCandidate = onbrdBill.getLong("candidate.id");
        List<InfoGroupEntity> allInfoGroupEntity = ServiceFactory.getService(ICollectService.class).getAllInfoGroupEntity();
        allInfoGroupEntity.forEach(infoGroupEntity -> {
            List infoGroupFieldList = infoGroupEntity.getInfoGroupFieldList();
            Map<String, List<InfoGroupEntity.InfoGroupField>> entityNameMap = infoGroupFieldList.stream().filter(infoGroupField -> infoGroupField.getPageKey().contains("hcf_")).collect(Collectors.groupingBy(InfoGroupEntity.InfoGroupField::getPageKey));
            if (entityNameMap.isEmpty()) {
                return;
            }
            for (Map.Entry<String, List<InfoGroupEntity.InfoGroupField>> entityNameEntry : entityNameMap.entrySet()) {
                String entityName = entityNameEntry.getKey();
                LOGGER.info("###syncCandidateInfo entity {}", (Object)entityName);
                List<InfoGroupEntity.InfoGroupField> fieldList = entityNameEntry.getValue();
                if (infoGroupEntity.isMultipleEntity()) {
                    this.saveCandidateMultiEntity(originalCandidate, targetCandidate, entityName, fieldList);
                    continue;
                }
                if ("hcf_canaddress".equals(entityName)) {
                    this.saveCandidateMultiEntity(originalCandidate, targetCandidate, entityName, fieldList);
                    continue;
                }
                this.saveCandidateSingleEntity(originalCandidate, targetCandidate, entityName, fieldList);
            }
        });
        LOGGER.info("sync candidate info success");
    }

    @Override
    public void syncPersonInfo(DynamicObject onbrdBill) {
        LOGGER.info("###syncPersonInfo-start {}", (Object)onbrdBill.getString("id"));
        if (!ViewTypeEnum.AGAIN.getCode().equalsIgnoreCase(onbrdBill.getString("viewtype")) || !onbrdBill.getBoolean("automaticinfo") || HRObjectUtils.isEmpty((Object)onbrdBill.getDynamicObject("personfield"))) {
            return;
        }
        LOGGER.info("start sync candidate info");
        long employeeId = onbrdBill.getLong("personfield.id");
        Map<String, List<DynamicObject>> personMap = IHomToHrpiAppService.getInstance().getHCFInfoForReOnboard(employeeId);
        if (personMap.isEmpty()) {
            return;
        }
        Long targetCandidate = onbrdBill.getLong("candidate.id");
        List<InfoGroupEntity> allInfoGroupEntity = ServiceFactory.getService(ICollectService.class).getAllInfoGroupEntity();
        allInfoGroupEntity.forEach(infoGroupEntity -> {
            List infoGroupFieldList = infoGroupEntity.getInfoGroupFieldList();
            Map<String, List<InfoGroupEntity.InfoGroupField>> homEntityNameMap = infoGroupFieldList.stream().filter(infoGroupField -> infoGroupField.getPageKey().contains("hom_")).collect(Collectors.groupingBy(InfoGroupEntity.InfoGroupField::getPageKey));
            for (Map.Entry<String, List<InfoGroupEntity.InfoGroupField>> homEntityName : homEntityNameMap.entrySet()) {
                List<InfoGroupEntity.InfoGroupField> fieldList = homEntityName.getValue();
                this.savePersonHomInfo(onbrdBill, personMap, fieldList);
            }
            Map<String, List<InfoGroupEntity.InfoGroupField>> entityNameMap = infoGroupFieldList.stream().filter(infoGroupField -> infoGroupField.getPageKey().contains("hcf_")).collect(Collectors.groupingBy(InfoGroupEntity.InfoGroupField::getPageKey));
            for (Map.Entry<String, List<InfoGroupEntity.InfoGroupField>> entityNameEntry : entityNameMap.entrySet()) {
                String entityName = entityNameEntry.getKey();
                LOGGER.info("###syncPersonInfo entity {}", (Object)entityName);
                List<InfoGroupEntity.InfoGroupField> fieldList = entityNameEntry.getValue();
                if (infoGroupEntity.isMultipleEntity()) {
                    this.savePersonMultiEntity(personMap, targetCandidate, entityName, fieldList);
                    continue;
                }
                if ("hcf_canaddress".equals(entityName)) {
                    this.savePersonMultiEntity(personMap, targetCandidate, entityName, fieldList);
                    continue;
                }
                this.savePersonSingleEntity(personMap, targetCandidate, entityName, fieldList);
            }
        });
        LOGGER.info("###syncPersonInfo-end {}", (Object)onbrdBill.getString("id"));
    }

    private void savePersonHomInfo(DynamicObject targetDyn, Map<String, List<DynamicObject>> personMap, List<InfoGroupEntity.InfoGroupField> fieldList) {
        LOGGER.info("###savePersonHomInfo-start");
        Map<String, List> homMap = personMap.keySet().stream().filter(item -> item.contains("hom_")).collect(Collectors.toMap(item -> item, personMap::get));
        for (List hisDyns : homMap.values()) {
            for (DynamicObject hisDyn : hisDyns) {
                String entityName = "hom_onbrdbillbase";
                for (InfoGroupEntity.InfoGroupField infoGroupField : fieldList) {
                    if (infoGroupField.getFieldType() == Integer.parseInt(InfoGroupFieldTypeEnum.ATTACH.getFieldType()) || !HRObjectUtils.isEmpty((Object)targetDyn.get(infoGroupField.getFieldKey()))) continue;
                    targetDyn.set(infoGroupField.getFieldKey(), hisDyn.get(infoGroupField.getFieldKey()));
                }
                HomCommonRepository.saveOne(entityName, targetDyn);
            }
        }
    }

    private void syncAttachment(DynamicObject targetDyn, String entityName, DynamicObject hisDyn, FileService attachmentFileService, InfoGroupEntity.InfoGroupField infoGroupField) {
        TempFileCache tempFileCache = CacheFactory.getCommonCacheFactory().getTempFileCache();
        HashMap<String, List> objectObjectHashMap = new HashMap<String, List>(2);
        List targetAttachments = AttachmentServiceHelper.getAttachments((String)infoGroupField.getPageKey(), (Object)targetDyn.getLong("id"), (String)infoGroupField.getFieldKey());
        List attachments = AttachmentServiceHelper.getAttachments((String)infoGroupField.getPageKey(), (Object)hisDyn.getLong("id"), (String)infoGroupField.getFieldKey());
        if (HRCollUtil.isEmpty((Collection)targetAttachments) && !HRCollUtil.isEmpty((Collection)attachments)) {
            attachments.forEach(attMap -> attMap.put("attPkId", targetDyn.getLong("id")));
            attachments.forEach(attMap -> attMap.put("billPkId", targetDyn.getLong("id")));
            attachments.forEach(attMap -> {
                String url;
                if (!Objects.isNull(attMap.get("lastModified"))) {
                    attMap.put("lastModified", ((Timestamp)attMap.get("lastModified")).getTime());
                }
                if (!(url = (String)attMap.get("url")).contains("&kdedcba")) {
                    return;
                }
                url = url.substring(0, url.indexOf("&kdedcba"));
                String path = UrlUtil.getParam((String)url, (String)"path");
                InputStream inputStream = attachmentFileService.getInputStream(path);
                String tempFileUrl = tempFileCache.saveAsFullUrl((String)attMap.get("name"), inputStream, 7200);
                attMap.put("url", tempFileUrl);
            });
            objectObjectHashMap.put(infoGroupField.getFieldKey(), attachments);
        }
        if (!objectObjectHashMap.isEmpty()) {
            for (Map.Entry stringObjectEntry : objectObjectHashMap.entrySet()) {
                AttachmentServiceHelper.upload((String)entityName, (Object)targetDyn.getLong("id"), (String)((String)stringObjectEntry.getKey()), (List)((List)stringObjectEntry.getValue()));
            }
        }
    }

    private void saveCandidateMultiEntity(Long originalCandidate, Long targetCandidate, String entityName, List<InfoGroupEntity.InfoGroupField> fieldList) {
        LOGGER.info("###saveCandidateMultiEntity-start");
        DynamicObjectCollection currentDyn = IHomToHcfAppService.getInstance().getHisMultiRowEntity(targetCandidate, entityName);
        DynamicObjectCollection hisDyn = IHomToHcfAppService.getInstance().getHisMultiRowEntity(originalCandidate, entityName);
        if (!HRCollUtil.isEmpty((Collection)currentDyn) || HRCollUtil.isEmpty((Collection)hisDyn)) {
            return;
        }
        LOGGER.info("start sync candidate info {}", (Object)entityName);
        FileService attachmentFileService = FileServiceFactory.getAttachmentFileService();
        TempFileCache tempFileCache = CacheFactory.getCommonCacheFactory().getTempFileCache();
        if ("hcf_educertificate".equalsIgnoreCase(entityName)) {
            DynamicObjectCollection currentEdu = IHomToHcfAppService.getInstance().getHisMultiRowEntity(targetCandidate, "hcf_caneduexp");
            DynamicObjectCollection hisEdu = IHomToHcfAppService.getInstance().getHisMultiRowEntity(originalCandidate, "hcf_caneduexp");
            HashMap eduMap = new HashMap();
            AtomicInteger index = new AtomicInteger(0);
            if (currentEdu.size() != hisEdu.size()) {
                return;
            }
            List currentEduList = currentEdu.stream().sorted(Comparator.comparing(dy -> dy.getDate("admissiondate"))).sorted(Comparator.comparing(dy -> dy.getString("graduateschool.number"))).sorted(Comparator.comparing(dy -> dy.getString("schoolrecord"))).sorted(Comparator.comparing(dy -> dy.getString("major"))).collect(Collectors.toList());
            List<DynamicObject> hisEduList = hisEdu.stream().sorted(Comparator.comparing(dy -> dy.getDate("admissiondate"))).sorted(Comparator.comparing(dy -> dy.getString("graduateschool.number"))).sorted(Comparator.comparing(dy -> dy.getString("schoolrecord"))).sorted(Comparator.comparing(dy -> dy.getString("major"))).collect(Collectors.toList());
            hisEduList.forEach(his -> eduMap.put(his.getLong("id"), ((DynamicObject)currentEduList.get(index.getAndIncrement())).getLong("id")));
            DynamicObjectCollection hisMultiRowEntity = new DynamicObjectCollection();
            HashMap<Long, DynamicObjectCollection> map = new HashMap<Long, DynamicObjectCollection>();
            hisDyn.forEach(originDyn -> {
                HashMap<String, List<Map<String, Object>>> objectObjectHashMap = new HashMap<String, List<Map<String, Object>>>(2);
                DynamicObject targetDyn = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)entityName));
                HRDynamicObjectUtils.copy((DynamicObject)originDyn, (DynamicObject)targetDyn, IGNORE_FIELD);
                targetDyn.set("candidate_id", (Object)targetCandidate);
                targetDyn.set("id", (Object)ORM.create().genLongId(entityName));
                targetDyn.set("edu_id", eduMap.get(originDyn.getLong("edu.id")));
                this.syncMultiAttachment(entityName, fieldList, attachmentFileService, tempFileCache, (DynamicObject)originDyn, (Map<String, List<Map<String, Object>>>)objectObjectHashMap, targetDyn);
                hisMultiRowEntity.add((Object)targetDyn);
            });
            map.put(targetCandidate, hisMultiRowEntity);
            IHomToHcfAppService.getInstance().saveMultiRowEntity(map, entityName);
            return;
        }
        DynamicObjectCollection hisMultiRowEntity = new DynamicObjectCollection();
        HashMap<Long, DynamicObjectCollection> map = new HashMap<Long, DynamicObjectCollection>();
        hisDyn.forEach(originDyn -> {
            HashMap<String, List<Map<String, Object>>> objectObjectHashMap = new HashMap<String, List<Map<String, Object>>>(2);
            DynamicObject targetDyn = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)entityName));
            HRDynamicObjectUtils.copy((DynamicObject)originDyn, (DynamicObject)targetDyn, IGNORE_FIELD);
            targetDyn.set("candidate_id", (Object)targetCandidate);
            targetDyn.set("id", (Object)ORM.create().genLongId(entityName));
            this.syncMultiAttachment(entityName, fieldList, attachmentFileService, tempFileCache, (DynamicObject)originDyn, (Map<String, List<Map<String, Object>>>)objectObjectHashMap, targetDyn);
            hisMultiRowEntity.add((Object)targetDyn);
        });
        map.put(targetCandidate, hisMultiRowEntity);
        Set<String> noHisTable = this.getConfigSet("no_his_table");
        if (noHisTable.contains(entityName)) {
            IHomToHcfAppService.getInstance().saveMultiRowEntity(map, entityName);
        } else {
            HashMap<String, DynamicObjectCollection> mapParam = new HashMap<String, DynamicObjectCollection>(2);
            mapParam.put(entityName, hisMultiRowEntity);
            ArrayList<Map<String, DynamicObjectCollection>> list = new ArrayList<Map<String, DynamicObjectCollection>>(1);
            list.add(mapParam);
            Map<String, Object> eduMap = IHomToHcfAppService.getInstance().saveOrUpdateCandidates(list);
            if (!((Boolean)eduMap.get("success")).booleanValue()) {
                LOGGER.info("save fail {}");
            }
        }
        LOGGER.info("sync candidate info {} success", (Object)entityName);
    }

    private void savePersonMultiEntity(Map<String, List<DynamicObject>> hisDynMap, Long targetCandidate, String entityName, List<InfoGroupEntity.InfoGroupField> fieldList) {
        LOGGER.info("###savePersonMultiEntity-start");
        DynamicObjectCollection currentDyn = IHomToHcfAppService.getInstance().getHisMultiRowEntity(targetCandidate, entityName);
        List<DynamicObject> hisDyn = hisDynMap.get(entityName);
        if (!HRCollUtil.isEmpty((Collection)currentDyn) || HRCollUtil.isEmpty(hisDyn)) {
            LOGGER.info("###savePersonMultiEntity is empty");
            return;
        }
        LOGGER.info("start sync candidate info {}", (Object)entityName);
        if ("hcf_educertificate".equalsIgnoreCase(entityName)) {
            DynamicObjectCollection currentEdu = IHomToHcfAppService.getInstance().getHisMultiRowEntity(targetCandidate, "hcf_caneduexp");
            List<DynamicObject> hisEdu = hisDynMap.get("hcf_caneduexp");
            HashMap eduMap = new HashMap();
            AtomicInteger index = new AtomicInteger(0);
            if (currentEdu.size() != hisEdu.size()) {
                return;
            }
            List currentEduList = currentEdu.stream().sorted(Comparator.comparing(dy -> dy.getDate("admissiondate"))).sorted(Comparator.comparing(dy -> dy.getString("graduateschool.number"))).sorted(Comparator.comparing(dy -> dy.getString("schoolrecord"))).sorted(Comparator.comparing(dy -> dy.getString("major"))).collect(Collectors.toList());
            List<DynamicObject> hisEduList = hisEdu.stream().sorted(Comparator.comparing(dy -> dy.getDate("admissiondate"))).sorted(Comparator.comparing(dy -> dy.getString("graduateschool.number"))).sorted(Comparator.comparing(dy -> dy.getString("schoolrecord"))).sorted(Comparator.comparing(dy -> dy.getString("major"))).collect(Collectors.toList());
            hisEduList.forEach(his -> eduMap.put(his.getLong("id"), ((DynamicObject)currentEduList.get(index.getAndIncrement())).getLong("id")));
            DynamicObjectCollection hisMultiRowEntity = new DynamicObjectCollection();
            HashMap<Long, DynamicObjectCollection> map = new HashMap<Long, DynamicObjectCollection>();
            hisDyn.forEach(originDyn -> {
                DynamicObject targetDyn = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)entityName));
                HRDynamicObjectUtils.copy((DynamicObject)originDyn, (DynamicObject)targetDyn, IGNORE_FIELD);
                targetDyn.set("candidate_id", (Object)targetCandidate);
                targetDyn.set("id", (Object)ORM.create().genLongId(entityName));
                targetDyn.set("edu_id", eduMap.get(originDyn.getLong("edu.id")));
                hisMultiRowEntity.add((Object)targetDyn);
            });
            map.put(targetCandidate, hisMultiRowEntity);
            IHomToHcfAppService.getInstance().saveMultiRowEntity(map, entityName);
            return;
        }
        DynamicObjectCollection hisMultiRowEntity = new DynamicObjectCollection();
        HashMap<Long, DynamicObjectCollection> map = new HashMap<Long, DynamicObjectCollection>();
        hisDyn.forEach(originDyn -> {
            DynamicObject targetDyn = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)entityName));
            HRDynamicObjectUtils.copy((DynamicObject)originDyn, (DynamicObject)targetDyn, IGNORE_FIELD);
            targetDyn.set("candidate_id", (Object)targetCandidate);
            targetDyn.set("id", (Object)ORM.create().genLongId(entityName));
            hisMultiRowEntity.add((Object)targetDyn);
        });
        map.put(targetCandidate, hisMultiRowEntity);
        Set<String> noHisTable = this.getConfigSet("no_his_table");
        if (noHisTable.contains(entityName)) {
            IHomToHcfAppService.getInstance().saveMultiRowEntity(map, entityName);
        } else {
            HashMap<String, DynamicObjectCollection> mapParam = new HashMap<String, DynamicObjectCollection>(2);
            mapParam.put(entityName, hisMultiRowEntity);
            ArrayList<Map<String, DynamicObjectCollection>> list = new ArrayList<Map<String, DynamicObjectCollection>>(1);
            list.add(mapParam);
            Map<String, Object> eduMap = IHomToHcfAppService.getInstance().saveOrUpdateCandidates(list);
            if (!((Boolean)eduMap.get("success")).booleanValue()) {
                LOGGER.info("save fail {}");
            }
        }
        LOGGER.info("sync candidate info {} success", (Object)entityName);
    }

    private Set<String> getConfigSet(String configKey) {
        return ServiceFactory.getService(IHomConfigDomainService.class).getConfigSet(null, configKey, configKey);
    }

    private void syncMultiAttachment(String entityName, List<InfoGroupEntity.InfoGroupField> fieldList, FileService attachmentFileService, TempFileCache tempFileCache, DynamicObject originDyn, Map<String, List<Map<String, Object>>> objectObjectHashMap, DynamicObject targetDyn) {
        for (InfoGroupEntity.InfoGroupField infoGroupField : fieldList) {
            List attachments;
            if (infoGroupField.getFieldType() != 2 || HRCollUtil.isEmpty((Collection)(attachments = AttachmentServiceHelper.getAttachments((String)infoGroupField.getPageKey(), (Object)originDyn.getLong("id"), (String)infoGroupField.getFieldKey())))) continue;
            attachments.forEach(attMap -> attMap.put("attPkId", targetDyn.getLong("id")));
            attachments.forEach(attMap -> attMap.put("billPkId", targetDyn.getLong("id")));
            attachments.forEach(attMap -> {
                String url;
                if (!Objects.isNull(attMap.get("lastModified"))) {
                    attMap.put("lastModified", ((Timestamp)attMap.get("lastModified")).getTime());
                }
                if (!(url = (String)attMap.get("url")).contains("&kdedcba")) {
                    return;
                }
                url = url.substring(0, url.indexOf("&kdedcba"));
                String path = UrlUtil.getParam((String)url, (String)"path");
                InputStream inputStream = attachmentFileService.getInputStream(path);
                String tempFileUrl = tempFileCache.saveAsFullUrl((String)attMap.get("name"), inputStream, 7200);
                attMap.put("url", tempFileUrl);
            });
            objectObjectHashMap.put(infoGroupField.getFieldKey(), attachments);
        }
        if (!objectObjectHashMap.isEmpty()) {
            for (Map.Entry entry : objectObjectHashMap.entrySet()) {
                AttachmentServiceHelper.upload((String)entityName, (Object)targetDyn.getLong("id"), (String)((String)entry.getKey()), (List)((List)entry.getValue()));
            }
        }
    }

    private void saveCandidateSingleEntity(Long originalCandidate, Long targetCandidate, String entityName, List<InfoGroupEntity.InfoGroupField> fieldList) {
        DynamicObject hisDyn;
        LOGGER.info("###saveCandidateSingleEntity-start");
        DynamicObject currentDyn = IHomToHcfAppService.getInstance().getSingleRowEntity(targetCandidate, entityName);
        if (ObjectUtils.isEmpty((Object)currentDyn)) {
            currentDyn = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)entityName));
        }
        if (HRObjectUtils.isEmpty((Object)(hisDyn = IHomToHcfAppService.getInstance().getSingleRowEntity(originalCandidate, entityName)))) {
            LOGGER.info("###saveCandidateSingleEntity is empty");
            return;
        }
        DynamicObject personBaseDyNew = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)entityName));
        if (HRObjectUtils.isEmpty((Object)currentDyn)) {
            HRDynamicObjectUtils.copy((DynamicObject)hisDyn, (DynamicObject)personBaseDyNew, IGNORE_FIELD);
        } else {
            HRDynamicObjectUtils.copy((DynamicObject)currentDyn, (DynamicObject)personBaseDyNew, IGNORE_FIELD);
            personBaseDyNew.set("boid", (Object)currentDyn.getLong("boid"));
        }
        personBaseDyNew.set("candidate", (Object)targetCandidate);
        FileService attachmentFileService = FileServiceFactory.getAttachmentFileService();
        for (InfoGroupEntity.InfoGroupField infoGroupField : fieldList) {
            if (infoGroupField.getFieldType() == Integer.parseInt(InfoGroupFieldTypeEnum.ATTACH.getFieldType())) {
                this.syncAttachment(currentDyn, entityName, hisDyn, attachmentFileService, infoGroupField);
                continue;
            }
            if (!HRObjectUtils.isEmpty((Object)currentDyn.get(infoGroupField.getFieldKey()))) continue;
            personBaseDyNew.set(infoGroupField.getFieldKey(), hisDyn.get(infoGroupField.getFieldKey()));
        }
        HashMap<Long, DynamicObject> personMap = new HashMap<Long, DynamicObject>(2);
        personMap.put(targetCandidate, personBaseDyNew);
        Map<String, Object> result = IHomToHcfAppService.getInstance().saveHisSingleRowEntity(personMap, entityName);
        if (!((Boolean)result.get("success")).booleanValue()) {
            LOGGER.error("candidate Info Save Fail, ", (Object)result.get("message").toString());
        }
    }

    private void savePersonSingleEntity(Map<String, List<DynamicObject>> hisDynsMap, Long targetCandidate, String entityName, List<InfoGroupEntity.InfoGroupField> fieldList) {
        List<DynamicObject> hisDyns;
        LOGGER.info("###savePersonSingleEntity-start");
        DynamicObject currentDyn = IHomToHcfAppService.getInstance().getSingleRowEntity(targetCandidate, entityName);
        if (ObjectUtils.isEmpty((Object)currentDyn)) {
            currentDyn = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)entityName));
        }
        if (HRCollUtil.isEmpty(hisDyns = hisDynsMap.get(entityName))) {
            LOGGER.info("###savePersonSingleEntity is empty");
            return;
        }
        DynamicObject hisDyn = hisDyns.get(0);
        DynamicObject personBaseDyNew = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)entityName));
        if (HRObjectUtils.isEmpty((Object)currentDyn)) {
            HRDynamicObjectUtils.copy((DynamicObject)hisDyn, (DynamicObject)personBaseDyNew, IGNORE_FIELD);
        } else {
            HRDynamicObjectUtils.copy((DynamicObject)currentDyn, (DynamicObject)personBaseDyNew, IGNORE_FIELD);
            personBaseDyNew.set("boid", (Object)currentDyn.getLong("boid"));
        }
        personBaseDyNew.set("candidate", (Object)targetCandidate);
        FileService attachmentFileService = FileServiceFactory.getAttachmentFileService();
        for (InfoGroupEntity.InfoGroupField infoGroupField : fieldList) {
            if (infoGroupField.getFieldType() == Integer.parseInt(InfoGroupFieldTypeEnum.ATTACH.getFieldType())) {
                this.syncAttachment(currentDyn, entityName, hisDyn, attachmentFileService, infoGroupField);
                continue;
            }
            if (!HRObjectUtils.isEmpty((Object)currentDyn.get(infoGroupField.getFieldKey()))) continue;
            personBaseDyNew.set(infoGroupField.getFieldKey(), hisDyn.get(infoGroupField.getFieldKey()));
        }
        HashMap<Long, DynamicObject> personMap = new HashMap<Long, DynamicObject>(2);
        personMap.put(targetCandidate, personBaseDyNew);
        Map<String, Object> result = IHomToHcfAppService.getInstance().saveHisSingleRowEntity(personMap, entityName);
        if (!((Boolean)result.get("success")).booleanValue()) {
            LOGGER.error("candidate Info Save Fail, ", (Object)result.get("message").toString());
        }
    }
}

