/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.business.application.impl.hpfs;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.service.diff.HRPlugInProxyFactory;
import kd.hr.hbp.business.service.diff.HRPluginProxy;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.business.servicehelper.HRProducerServiceHelper;
import kd.hr.hbp.common.cache.HRPageCache;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.hr.hbp.common.util.HRJSONUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hom.business.application.hpfs.IPersonFileIntegrateService;
import kd.hr.hom.business.application.impl.hpfs.helper.DirectLeaderHelper;
import kd.hr.hom.business.application.onbrd.IOnbrdConfirmAppService;
import kd.hr.hom.business.application.staff.IStaffUseService;
import kd.hr.hom.business.domain.service.handler.HPFSTemplatePropertyHandler;
import kd.hr.hom.business.domain.service.impl.hcf.HcfDataDomainService;
import kd.hr.hom.business.domain.service.integrate.IIntegrateService;
import kd.hr.hom.business.domain.service.onbrd.IOnbrdBillDomainService;
import kd.hr.hom.common.constant.HpfsChgConstants;
import kd.hr.hom.common.entity.SyncPersonEntity;
import kd.hr.hom.common.enums.IntegrateEnum;
import kd.hr.hom.common.enums.SynchStatusEnum;
import kd.sdk.hr.hom.business.onbrd.IPerChgBizParam;
import kd.sdk.hr.hpfs.business.perchg.bizentity.PerChgBizInfo;
import kd.sdk.hr.hpfs.business.perchg.bizentity.PerChgBizResult;
import kd.sdk.hr.hpfs.business.perchg.bizentity.PerChgParam;

public class PersonFileIntegrateServiceImpl
implements IPersonFileIntegrateService {
    private final Log LOGGER = LogFactory.getLog(PersonFileIntegrateServiceImpl.class);
    private static final ImmutableList<String> hcfEntityNameList = ImmutableList.of((Object)"hcf_canaddress", (Object)"hcf_canbaseinfo", (Object)"hcf_canotherinfo", (Object)"hcf_cancontact", (Object)"hcf_cancontactinfo", (Object)"hcf_cancre", (Object)"hcf_caneduexp", (Object)"hcf_educertificate", (Object)"hcf_canfamily", (Object)"hcf_canlgability", (Object)"hcf_canprework", (Object)"hcf_rsmpatinv", (Object[])new String[]{"hcf_canbankcard"});
    private static final ImmutableSet<String> attachmentEntityNameSet = ImmutableSet.of((Object)"hcf_cancre", (Object)"hcf_canprework", (Object)"hcf_canlgability", (Object)"hcf_rsmpatinv", (Object)"hcf_educertificate");
    private static final ImmutableList<String> BOID2VID_FIELD_LIST = ImmutableList.of((Object)"ajob", (Object)"jobseq", (Object)"jobfamily", (Object)"jobclass", (Object)"joblevelscm", (Object)"jobgradescm", (Object)"acompany", (Object)"aadminorg", (Object)"aposition", (Object)"stdposition");

    @Override
    public String getParamByOnbrdBills(Long userId, List<DynamicObject> onbrdBillInfoList, String personQueue, String resultCallBackQueue) {
        JSONObject paramJsonObject = new JSONObject();
        PerChgParam perChgParam = this.getPerChgParamByOnbrdBills(userId, onbrdBillInfoList, personQueue, resultCallBackQueue);
        paramJsonObject.put("billdata", (Object)perChgParam);
        paramJsonObject.put("operatetype", (Object)1020);
        try {
            return HRJSONUtils.toString((Object)paramJsonObject);
        }
        catch (IOException iOException) {
            this.LOGGER.error((Throwable)iOException);
            return null;
        }
    }

    @Override
    public List<String> getParamsByOnbrdBills(Long userId, List<DynamicObject> onbrdBillInfoList, String personQueue, String resultCallBackQueue) {
        ArrayList<String> params = new ArrayList<String>(onbrdBillInfoList.size());
        Map<Long, PerChgBizInfo> perChgBizInfoMap = this.getPerChgBizInfoByOnbrdBillInfos(onbrdBillInfoList);
        for (DynamicObject onbrdBillInfo : onbrdBillInfoList) {
            try {
                PerChgParam perChgParam = new PerChgParam();
                ArrayList<PerChgBizInfo> bizInfoList = new ArrayList<PerChgBizInfo>(onbrdBillInfoList.size());
                bizInfoList.add(perChgBizInfoMap.get(onbrdBillInfo.getLong("id")));
                perChgParam.setUserId(userId);
                perChgParam.setAppId("hom");
                perChgParam.setPersonQueue(personQueue);
                perChgParam.setResultCallBackQueue(resultCallBackQueue);
                perChgParam.setBizInfoList(bizInfoList);
                JSONObject paramJsonObject = new JSONObject();
                paramJsonObject.put("billdata", (Object)perChgParam);
                paramJsonObject.put("operatetype", (Object)1020);
                params.add(HRJSONUtils.toString((Object)paramJsonObject));
            }
            catch (IOException iOException) {
                this.LOGGER.error((Throwable)iOException);
                this.LOGGER.error("getParamsByOnbrdBills iOException");
            }
        }
        return params;
    }

    @Override
    public List<String> getParamsByOnbrdBills(Long userId, List<DynamicObject> onbrdBillInfoList, String personQueue, String resultCallBackQueue, Long defaultChgActionConfigId) {
        ArrayList<String> params = new ArrayList<String>(onbrdBillInfoList.size());
        Map<Long, PerChgBizInfo> perChgBizInfoMap = this.getPerChgBizInfoByOnbrdBillInfos(onbrdBillInfoList, defaultChgActionConfigId);
        for (DynamicObject onbrdBillInfo : onbrdBillInfoList) {
            try {
                PerChgParam perChgParam = new PerChgParam();
                ArrayList<PerChgBizInfo> bizInfoList = new ArrayList<PerChgBizInfo>(onbrdBillInfoList.size());
                bizInfoList.add(perChgBizInfoMap.get(onbrdBillInfo.getLong("id")));
                perChgParam.setUserId(userId);
                perChgParam.setAppId("hom");
                perChgParam.setPersonQueue(personQueue);
                perChgParam.setResultCallBackQueue(resultCallBackQueue);
                perChgParam.setBizInfoList(bizInfoList);
                JSONObject paramJsonObject = new JSONObject();
                paramJsonObject.put("billdata", (Object)perChgParam);
                paramJsonObject.put("operatetype", (Object)1020);
                params.add(HRJSONUtils.toString((Object)paramJsonObject));
            }
            catch (IOException iOException) {
                this.LOGGER.error((Throwable)iOException);
                this.LOGGER.error("getParamsByOnbrdBills iOException");
            }
        }
        return params;
    }

    @Override
    public void updateMessageRecordToDB(List<PerChgBizResult> resultList) {
        if (CollectionUtils.isEmpty(resultList)) {
            return;
        }
        Map<Long, PerChgBizResult> resultMap = resultList.stream().collect(Collectors.toMap(PerChgBizResult::getBillId, perChgBizResult -> perChgBizResult, (oldValue, newValue) -> newValue));
        DynamicObject[] onbrdBillArray = this.getOnbrdInfo(resultMap);
        IOnbrdBillDomainService onbrdBillDomainService = IOnbrdBillDomainService.getInstance();
        IOnbrdConfirmAppService onbrdConfirmAppService = IOnbrdConfirmAppService.getInstance();
        if (!Objects.isNull(onbrdBillArray)) {
            ArrayList<Map<String, Object>> posDisableList = new ArrayList<Map<String, Object>>();
            ArrayList<Map<String, Object>> posEnableList = new ArrayList<Map<String, Object>>();
            HashMap<Long, SyncPersonEntity> logMaps = new HashMap<Long, SyncPersonEntity>(onbrdBillArray.length);
            for (DynamicObject onbrdBill : onbrdBillArray) {
                Long onbrdBillId = onbrdBill.getLong("id");
                PerChgBizResult perChgBizResult2 = resultMap.get(onbrdBillId);
                if (!perChgBizResult2.getSuccess().booleanValue()) {
                    onbrdBill.set("synchstatus", (Object)SynchStatusEnum.SYNCH_FAIL.getValue());
                    logMaps.put(onbrdBillId, new SyncPersonEntity(onbrdBillId, IntegrateEnum.CONSUME_FAIL.getValue(), JSONObject.toJSONString((Object)perChgBizResult2)));
                    this.setPositionList(posDisableList, onbrdBill);
                } else {
                    onbrdBill.set("synchstatus", (Object)SynchStatusEnum.SYNCH_SUCCESS.getValue());
                    logMaps.put(onbrdBillId, new SyncPersonEntity(onbrdBillId, IntegrateEnum.CONSUME_SUCCES.getValue(), JSONObject.toJSONString((Object)perChgBizResult2)));
                    this.setPositionList(posEnableList, onbrdBill);
                    onbrdConfirmAppService.changeBoidToVid(onbrdBill);
                }
                onbrdBill.set("affrecord", (Object)perChgBizResult2.getRecordId());
            }
            this.LOGGER.info("Start sending msg for staff");
            IStaffUseService.getInstance().sendMsgForOnbrdConfirm(resultList);
            this.LOGGER.info("End sending msg for staff");
            onbrdBillDomainService.saveOnbrdBillInfos(onbrdBillArray);
            IIntegrateService.getInstance().saveOrUpdIntegraLog(logMaps, IntegrateEnum.INTEGRATE_SPOT_PERSON.getValue());
            this.LOGGER.info("Start sending onbrdInfo to Payment");
            for (DynamicObject bill : onbrdBillArray) {
                PerChgBizResult perChgBizResult3;
                if (bill.getBoolean("affaction.isnewchgaction") || !(perChgBizResult3 = resultMap.get(bill.getLong("id"))).getSuccess().booleanValue()) continue;
                this.sendMsgForPayment(perChgBizResult3);
            }
            this.LOGGER.info("===Start createPosition===");
            this.enDisEnablePosition(posDisableList, "disableDarkPosition");
            this.enDisEnablePosition(posEnableList, "enableDarkPosition");
            this.LOGGER.info("===End createPosition===");
        }
    }

    @Override
    public void updateMessageRecord(List<PerChgBizResult> resultList) {
        if (CollectionUtils.isEmpty(resultList)) {
            return;
        }
        Map<Long, PerChgBizResult> resultMap = resultList.stream().collect(Collectors.toMap(PerChgBizResult::getBillId, perChgBizResult -> perChgBizResult, (oldValue, newValue) -> newValue));
        DynamicObject[] onbrdBillArray = this.getOnbrdInfo(resultMap);
        if (!Objects.isNull(onbrdBillArray)) {
            HashMap<Long, SyncPersonEntity> logMaps = new HashMap<Long, SyncPersonEntity>(onbrdBillArray.length);
            for (DynamicObject onbrdBill : onbrdBillArray) {
                Long onbrdBillId = onbrdBill.getLong("id");
                PerChgBizResult perChgBizResult2 = resultMap.get(onbrdBillId);
                if (!perChgBizResult2.getSuccess().booleanValue()) {
                    logMaps.put(onbrdBillId, new SyncPersonEntity(onbrdBillId, IntegrateEnum.CONSUME_FAIL.getValue(), JSONObject.toJSONString((Object)perChgBizResult2)));
                    continue;
                }
                logMaps.put(onbrdBillId, new SyncPersonEntity(onbrdBillId, IntegrateEnum.CONSUME_SUCCES.getValue(), JSONObject.toJSONString((Object)perChgBizResult2)));
            }
            IIntegrateService.getInstance().saveOrUpdIntegraLog(logMaps, IntegrateEnum.INTEGRATE_SPOT_NUMBER_REPLACE.getValue());
        }
    }

    private DynamicObject[] getOnbrdInfo(Map<Long, PerChgBizResult> resultMap) {
        IOnbrdBillDomainService onbrdBillDomainService = IOnbrdBillDomainService.getInstance();
        QFilter filter = new QFilter("id", "in", resultMap.keySet());
        String selectProperties = "aadminorg" + "," + "affrecord" + "," + "affaction" + "," + "apositiontype" + "," + "enrollstatus" + "," + "synchstatus" + "," + "darkposition" + "," + "ajob" + "," + "jobseq" + "," + "jobfamily" + "," + "jobclass" + "," + "joblevelscm" + "," + "jobgradescm" + "," + "acompany" + "," + "aposition" + "," + "effectdate" + "," + "billno" + "," + "stdposition";
        return onbrdBillDomainService.findOnbrdBills(selectProperties, new QFilter[]{filter});
    }

    private void setPositionList(List<Map<String, Object>> posList, DynamicObject onbrdBill) {
        HashMap<String, Long> posMap = new HashMap<String, Long>(2);
        if ("0".equals(onbrdBill.getString("apositiontype")) && onbrdBill.get("stdposition") != null && onbrdBill.get("darkposition") != null) {
            posMap.put("standardposition", onbrdBill.getDynamicObject("stdposition").getLong("id"));
            posMap.put("position", onbrdBill.getDynamicObject("darkposition").getLong("id"));
            posList.add(posMap);
        }
    }

    private void enDisEnablePosition(List<Map<String, Object>> posList, String methodCode) {
        if (!CollectionUtils.isEmpty(posList)) {
            this.LOGGER.info("===createPosition posList:{}==", (Object)posList.toString());
            Map resMap = (Map)HRMServiceHelper.invokeHRMPService((String)"hbpm", (String)"IStandardPositionService", (String)methodCode, (Object[])new Object[]{posList});
            this.LOGGER.info("===createPosition resMap:{}===", (Object)resMap.toString());
        }
    }

    public PerChgParam getPerChgParamByOnbrdBills(Long userId, List<DynamicObject> onbrdBillInfoList, String personQueue, String resultCallBackQueue) {
        PerChgParam perChgParam = new PerChgParam();
        ArrayList<PerChgBizInfo> bizInfoList = new ArrayList<PerChgBizInfo>(onbrdBillInfoList.size());
        Map<Long, PerChgBizInfo> perChgBizInfoMap = this.getPerChgBizInfoByOnbrdBillInfos(onbrdBillInfoList);
        bizInfoList.addAll(perChgBizInfoMap.values());
        perChgParam.setUserId(userId);
        perChgParam.setAppId("hom");
        perChgParam.setPersonQueue(personQueue);
        perChgParam.setResultCallBackQueue(resultCallBackQueue);
        perChgParam.setBizInfoList(bizInfoList);
        return perChgParam;
    }

    private Map<Long, PerChgBizInfo> getPerChgBizInfoByOnbrdBillInfos(List<DynamicObject> onbrdBillInfoList) {
        HashMap perChgBizInfoMap = Maps.newHashMapWithExpectedSize((int)onbrdBillInfoList.size());
        Map<Long, Long> onbrdCandiateIdMap = onbrdBillInfoList.stream().collect(Collectors.toMap(onbrdBillInfo -> onbrdBillInfo.getLong("id"), onbrdBillInfo -> onbrdBillInfo.getLong("candidate.id"), (oldValue, newValue) -> newValue));
        Map<Long, Map<String, List<Long>>> allHcfRecordIdsMap = this.getAllHcfRecordIdByCandidateId(onbrdCandiateIdMap.values());
        for (DynamicObject onbrdBillInfo2 : onbrdBillInfoList) {
            Long billId = onbrdBillInfo2.getLong("id");
            PerChgBizInfo perChgBizInfo = new PerChgBizInfo();
            perChgBizInfo.setBillId(billId);
            perChgBizInfo.setBillNo(onbrdBillInfo2.getString("billno"));
            perChgBizInfo.setBsed(onbrdBillInfo2.getDate("effectdate"));
            perChgBizInfo.setBillSource("hom_onbrdbillbase");
            Long chgActionConfigId = onbrdBillInfo2.getLong("affaction.id");
            this.LOGGER.info(billId.toString() + " chgActionConfigId:" + chgActionConfigId);
            perChgBizInfo.setActionId(chgActionConfigId);
            Long candidateId = onbrdCandiateIdMap.get(billId);
            Map<Object, Object> dataRow = Maps.newHashMapWithExpectedSize((int)hcfEntityNameList.size());
            if (candidateId != null && candidateId != 0L) {
                dataRow = allHcfRecordIdsMap.get(candidateId);
            }
            ArrayList<Long> onbrdBillIdList = new ArrayList<Long>(1);
            onbrdBillIdList.add(billId);
            dataRow.put("hom_onbrdbillbase", onbrdBillIdList);
            HRPluginProxy hrPluginProxy = HRPlugInProxyFactory.create(null, IPerChgBizParam.class, (String)"kd.sdk.hr.hom.business.onbrd.IPerChgBizParam", null);
            Map<Object, Object> finalDataRow = dataRow;
            hrPluginProxy.callReplace(hrPlugin -> {
                hrPlugin.setPerChgBizParam(onbrdBillInfo2, finalDataRow);
                return null;
            });
            perChgBizInfo.setDataRow(finalDataRow);
            perChgBizInfoMap.put(billId, perChgBizInfo);
        }
        return perChgBizInfoMap;
    }

    private Map<Long, PerChgBizInfo> getPerChgBizInfoByOnbrdBillInfos(List<DynamicObject> onbrdBillInfoList, Long defaultChgActionConfigId) {
        HashMap perChgBizInfoMap = Maps.newHashMapWithExpectedSize((int)onbrdBillInfoList.size());
        Map<Long, Long> onbrdCandiateIdMap = onbrdBillInfoList.stream().collect(Collectors.toMap(onbrdBillInfo -> onbrdBillInfo.getLong("id"), onbrdBillInfo -> onbrdBillInfo.getLong("candidate.id"), (oldValue, newValue) -> newValue));
        Map<Long, Map<String, List<Long>>> allHcfRecordIdsMap = this.getAllHcfRecordIdByCandidateId(onbrdCandiateIdMap.values());
        for (DynamicObject onbrdBillInfo2 : onbrdBillInfoList) {
            Long billId = onbrdBillInfo2.getLong("id");
            PerChgBizInfo perChgBizInfo = new PerChgBizInfo();
            perChgBizInfo.setBillId(billId);
            perChgBizInfo.setBillNo(onbrdBillInfo2.getString("billno"));
            perChgBizInfo.setBsed(onbrdBillInfo2.getDate("effectdate"));
            perChgBizInfo.setBillSource("hom_onbrdbillbase");
            perChgBizInfo.setOldEmployeeId(Long.valueOf(onbrdBillInfo2.getLong("personfield.id")));
            long personId = onbrdBillInfo2.getDynamicObject("personfield") == null ? 0L : onbrdBillInfo2.getDynamicObject("personfield").getLong("person.id");
            perChgBizInfo.setOldPersonId(Long.valueOf(personId));
            Long chgActionConfigId = onbrdBillInfo2.getLong("affaction.id");
            this.LOGGER.info(billId.toString() + " chgActionConfigId:" + chgActionConfigId);
            perChgBizInfo.setActionId(defaultChgActionConfigId != null ? defaultChgActionConfigId : chgActionConfigId);
            Long candidateId = onbrdCandiateIdMap.get(billId);
            Map<Object, Object> dataRow = Maps.newHashMapWithExpectedSize((int)hcfEntityNameList.size());
            if (candidateId != null && candidateId != 0L) {
                dataRow = allHcfRecordIdsMap.get(candidateId);
            }
            ArrayList<Long> onbrdBillIdList = new ArrayList<Long>(1);
            onbrdBillIdList.add(billId);
            dataRow.put("hom_onbrdbillbase", onbrdBillIdList);
            HRPluginProxy hrPluginProxy = HRPlugInProxyFactory.create(null, IPerChgBizParam.class, (String)"kd.sdk.hr.hom.business.onbrd.IPerChgBizParam", null);
            Map<Object, Object> finalDataRow = dataRow;
            hrPluginProxy.callReplace(hrPlugin -> {
                hrPlugin.setPerChgBizParam(onbrdBillInfo2, finalDataRow);
                return null;
            });
            perChgBizInfo.setDataRow(finalDataRow);
            perChgBizInfoMap.put(billId, perChgBizInfo);
        }
        return perChgBizInfoMap;
    }

    private Map<Long, Map<String, List<Long>>> getAllHcfRecordIdByCandidateId(Collection<Long> candidateIds) {
        HashMap dataRowMap = Maps.newHashMapWithExpectedSize((int)candidateIds.size());
        for (String hcfEntityName : hcfEntityNameList) {
            Map<Long, List<Long>> hcfRecordIdsMap = this.getHcfRecordIdByCandidateId(hcfEntityName, candidateIds);
            for (Long candidateId : candidateIds) {
                Set<String> interIds;
                List<Long> attachmentIdList;
                HashMap<String, List> dataRow = (HashMap<String, List>)dataRowMap.get(candidateId);
                if (CollectionUtils.isEmpty((Map)dataRow)) {
                    dataRow = new HashMap<String, List>();
                }
                List hcfRecordIds = hcfRecordIdsMap.getOrDefault(candidateId, new ArrayList());
                dataRow.put(hcfEntityName, hcfRecordIds);
                dataRowMap.put(candidateId, dataRow);
                if (!attachmentEntityNameSet.contains((Object)hcfEntityName) || CollectionUtils.isEmpty((Collection)hcfRecordIds) || CollectionUtils.isEmpty(attachmentIdList = this.getAttachmentIds(hcfEntityName, interIds = hcfRecordIds.stream().map(String::valueOf).collect(Collectors.toSet())))) continue;
                List attachmentIdAllList = dataRow.getOrDefault("bos_attachment", new ArrayList());
                attachmentIdAllList.addAll(attachmentIdList);
                dataRow.put("bos_attachment", attachmentIdAllList);
            }
        }
        for (Map.Entry entry : dataRowMap.entrySet()) {
            Map dataRow = (Map)entry.getValue();
            ArrayList attachmentIdAllList = (ArrayList)dataRow.get("bos_attachment");
            if (!CollectionUtils.isEmpty((Collection)attachmentIdAllList)) continue;
            attachmentIdAllList = new ArrayList();
            dataRow.put("bos_attachment", attachmentIdAllList);
        }
        return dataRowMap;
    }

    private Map<Long, List<Long>> transferToIdMap(Map<Long, DynamicObjectCollection> hcfRecordMap) {
        HashMap hcfRecordIdsMap = Maps.newHashMapWithExpectedSize((int)hcfRecordMap.size());
        if (!CollectionUtils.isEmpty(hcfRecordMap)) {
            for (Map.Entry<Long, DynamicObjectCollection> entry : hcfRecordMap.entrySet()) {
                DynamicObjectCollection collection = entry.getValue();
                if (CollectionUtils.isEmpty((Collection)collection)) {
                    hcfRecordIdsMap.put(entry.getKey(), new ArrayList(2));
                    continue;
                }
                List recordIdList = collection.stream().map(dynamicObject -> dynamicObject.getLong("id")).collect(Collectors.toList());
                hcfRecordIdsMap.put(entry.getKey(), recordIdList);
            }
        }
        return hcfRecordIdsMap;
    }

    private Map<Long, List<Long>> getHcfRecordIdByCandidateId(String hcfEntityName, Collection<Long> candidateIds) {
        Map<Long, DynamicObjectCollection> collectionMap = new HcfDataDomainService().queryMultiRowEntity(candidateIds, hcfEntityName, "id,candidate");
        return this.transferToIdMap(collectionMap);
    }

    private List<Long> getAttachmentIds(String hcfEntityName, Collection<String> interIds) {
        HRBaseServiceHelper attachementServiceHelper = new HRBaseServiceHelper("bos_attachment");
        QFilter filter = new QFilter("finterid", "in", interIds).and(new QFilter("fbilltype", "=", (Object)hcfEntityName));
        Object[] attachementInfos = attachementServiceHelper.query("id", new QFilter[]{filter});
        if (HRArrayUtils.isEmpty((Object[])attachementInfos)) {
            return new ArrayList<Long>();
        }
        return Stream.of(attachementInfos).map(attachementInfo -> attachementInfo.getLong("id")).collect(Collectors.toList());
    }

    private void sendMsgForPayment(PerChgBizResult perChgBizResult) {
        try {
            String confirmEntry = "MP20220117000056";
            QFilter filter = new QFilter("id", "=", (Object)perChgBizResult.getBillId());
            String properties = "candidate" + ',' + "name" + ',' + "affaction" + ',' + "viewtype";
            DynamicObject onbrdBillInfo = IOnbrdBillDomainService.getInstance().findOnbrdBill(properties, new QFilter[]{filter});
            if (HRObjectUtils.isEmpty((Object)onbrdBillInfo)) {
                this.LOGGER.info("====sendMsgForPayment cannot find onbrdbill:{}===", (Object)perChgBizResult.getBillId());
                return;
            }
            long affActionId = onbrdBillInfo.getLong("affaction.id");
            if (affActionId != HpfsChgConstants.CHANGE_ACTION_ID_FORMAL && affActionId != HpfsChgConstants.CHANGE_ACTION_ID_INTERN) {
                this.LOGGER.info("affActionId:{} not send message", (Object)affActionId);
                return;
            }
            HashMap actionInfo = Maps.newHashMapWithExpectedSize((int)10);
            actionInfo.put("msgNumber", perChgBizResult.getBillId().toString());
            actionInfo.put("msgPubNo", confirmEntry);
            String title = String.format(ResManager.loadKDString((String)"%s\u786e\u8ba4\u5165\u804c", (String)"PersonFileIntegrateServiceImpl_0", (String)"hr-hom-business", (Object[])new Object[0]), onbrdBillInfo.getString("name"));
            actionInfo.put("msgTitle", title.length() > 50 ? title.substring(0, 50) : title);
            actionInfo.put("msgDesc", ResManager.loadKDString((String)"\u786e\u8ba4\u5165\u804c\u6d88\u606f", (String)"PersonFileIntegrateServiceImpl_1", (String)"hr-hom-business", (Object[])new Object[0]));
            actionInfo.put("actionId", perChgBizResult.getMsgSynActionId());
            actionInfo.put("msgTag", "");
            actionInfo.put("senderId", RequestContext.get().getCurrUserId());
            actionInfo.put("sendTime", new Date());
            Map<String, Object> paramsInfo = this.getParamsForPayment(perChgBizResult, onbrdBillInfo);
            this.LOGGER.info("paramsInfo:" + paramsInfo);
            actionInfo.put("params", SerializationUtils.serializeToBase64(paramsInfo));
            HRProducerServiceHelper.publishAction((Map)actionInfo);
        }
        catch (Exception exception) {
            this.LOGGER.error("fail to sendMsgForPayment:", (Throwable)exception);
        }
    }

    private Map<String, Object> getParamsForPayment(PerChgBizResult perChgBizResult, DynamicObject onbrdBillInfo) {
        HashMap<String, Object> paramsInfo = new HashMap<String, Object>();
        paramsInfo.put("affactionId", onbrdBillInfo.getLong("affaction.id"));
        DynamicObject chgcategory = onbrdBillInfo.getDynamicObject("affaction.chgcategory");
        paramsInfo.put("chgcategoryId", chgcategory == null ? 0L : chgcategory.getLong("id"));
        paramsInfo.put("recordId", perChgBizResult.getRecordId());
        paramsInfo.put("viewtype", onbrdBillInfo.getString("viewtype"));
        paramsInfo.put("opTag", 0L);
        paramsInfo.put("backoutEventRecord", Boolean.FALSE);
        paramsInfo.put("backoutEventRecordId", 0L);
        return paramsInfo;
    }

    @Override
    public void getLeader(IFormView view) {
        try {
            this.LOGGER.info("===start getLeader impl===");
            view.getModel().setValue("leader", null);
            view.setEnable(Boolean.FALSE, new String[]{"leader"});
            String apositionType = view.getModel().getDataEntity().getString("apositiontype");
            if (HRStringUtils.isEmpty((String)apositionType)) {
                return;
            }
            this.setLeader(view);
        }
        catch (Exception exp) {
            this.LOGGER.error("===getLeader===", (Throwable)exp);
        }
    }

    private void setLeader(IFormView view) {
        long dummyId = ORM.create().genLongId("hrpi_person");
        DynamicObject dataEntity = view.getModel().getDataEntity();
        LinkedHashMap dynVsIdMap = Maps.newLinkedHashMapWithExpectedSize((int)1);
        dynVsIdMap.put(dataEntity, dummyId);
        List<Map<String, Object>> paramList = DirectLeaderHelper.buildParamMap(new DynamicObject[]{dataEntity}, dynVsIdMap);
        Map<Long, List<Map<String, Object>>> leaderByRuleMap = this.getLeaderByRuleFromHRPI(paramList);
        List<Map<String, Object>> leaderList = leaderByRuleMap.getOrDefault(dummyId, Lists.newArrayListWithExpectedSize((int)0));
        if (!CollectionUtils.isEmpty(leaderList)) {
            Object[] objs = leaderList.stream().map(map -> map.get("person.id")).toArray();
            this.LOGGER.info("===leaderList:{}===", objs);
            view.getModel().setValue("leader", (Object)objs);
        }
    }

    @Override
    public List<Map<String, Object>> getLeaderByRoleIdHrpi(List<Long> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<Map<String, Object>>(1);
        }
        return (List)HRMServiceHelper.invokeHRMPService((String)"hrpi", (String)"IHRPIWorkRoleService", (String)"getSuperiorByRole", (Object[])new Object[]{ids});
    }

    @Override
    public Map<Long, List<Map<String, Object>>> getLeaderByRuleFromHRPI(List<Map<String, Object>> paramList) {
        if (CollectionUtils.isEmpty(paramList)) {
            return Maps.newHashMapWithExpectedSize((int)1);
        }
        return (Map)HRMServiceHelper.invokeHRMPService((String)"hrpi", (String)"IHRPIWorkRoleService", (String)"listSuperior", (Object[])new Object[]{paramList});
    }

    @Override
    public List<Map<String, Object>> getMainChargeInfoByOrg(DynamicObject[] dys) {
        if (dys == null || dys.length == 0) {
            return new ArrayList<Map<String, Object>>(1);
        }
        ArrayList<Long> orgIds = new ArrayList<Long>(dys.length);
        for (DynamicObject dy : dys) {
            DynamicObject orgDy = dy.getDynamicObject("aadminorg");
            if (orgDy == null) continue;
            Long orgId = orgDy.getLong("id");
            orgIds.add(orgId);
        }
        this.LOGGER.info("===start getResponsible ===");
        List orgList = (List)HRMServiceHelper.invokeHRMPService((String)"hrpi", (String)"IHRPIWorkRoleService", (String)"getMainChargeInfoByOrg", (Object[])new Object[]{orgIds, new Date()});
        this.LOGGER.info("===orgList:{}===", (Object)orgList);
        return orgList;
    }

    @Override
    public Map<Long, List<Map<String, Object>>> getListMainChargeInfoByOrg(DynamicObject[] dys) {
        List<Map<String, Object>> mainChargeInfoByOrg = this.getMainChargeInfoByOrg(dys);
        if (CollectionUtils.isEmpty(mainChargeInfoByOrg)) {
            return new HashMap<Long, List<Map<String, Object>>>(1);
        }
        return mainChargeInfoByOrg.stream().collect(Collectors.groupingBy(map -> (Long)map.get("adminorg")));
    }

    @Override
    public void getResponsible(IFormView view) {
        try {
            DynamicObject dy = view.getModel().getDataEntity();
            if (dy != null) {
                List<Map<String, Object>> orgList = this.getMainChargeInfoByOrg(new DynamicObject[]{dy});
                this.setResponsible(view, orgList);
            }
        }
        catch (Exception exp) {
            view.showErrorNotification(ResManager.loadKDString((String)"\u8c03\u7528\u201c\u83b7\u53d6\u90e8\u95e8\u8d1f\u8d23\u4eba\u201d\u63a5\u53e3\u5931\u8d25\u3002", (String)"PersonFileIntegrateServiceImpl_3", (String)"hr-hom-business", (Object[])new Object[0]));
            this.LOGGER.error("===getResponsible error ===", (Throwable)exp);
        }
    }

    private void setResponsible(IFormView view, List<Map<String, Object>> orgList) {
        String apositionType = view.getModel().getDataEntity().getString("apositiontype");
        if (!CollectionUtils.isEmpty(orgList)) {
            this.LOGGER.info("===orgList:{}===", orgList);
            Object[] objs = orgList.stream().map(map -> map.get("person")).toArray();
            view.getModel().setValue("responsible", (Object)objs);
        } else {
            view.getModel().setValue("responsible", null);
            if (HRStringUtils.equals((String)apositionType, (String)"0")) {
                view.getModel().setValue("leader", null);
            }
        }
    }

    @Override
    public void setLeaderPageCache(IFormView view, String key) {
    }

    @Override
    public Object[] getLeaderPageCache(IFormView view, String key) {
        HRPageCache pageCache = new HRPageCache(view);
        List list = (List)pageCache.get(key, List.class);
        if (!CollectionUtils.isEmpty((Collection)list)) {
            return list.toArray();
        }
        return null;
    }

    @Override
    public Map<Long, List<Map<String, Object>>> getListSuperiorByOrg(List<Long> orgIds) {
        if (CollectionUtils.isEmpty(orgIds)) {
            return new HashMap<Long, List<Map<String, Object>>>(1);
        }
        return (Map)HRMServiceHelper.invokeHRMPService((String)"hrpi", (String)"IHRPIWorkRoleService", (String)"listSuperiorByOrg", (Object[])new Object[]{orgIds});
    }

    @Override
    public Map<Long, Map<String, DynamicObjectCollection>> getChgRuleByActionIds(List<Long> actionIds) {
        this.LOGGER.info("getChgRuleByActionIds_actionIds:{}", (Object)(actionIds == null ? "null" : actionIds.toString()));
        try {
            boolean businessValue = HPFSTemplatePropertyHandler.isNewChgAction("hom_onbrd_hpfs_new");
            Map res = businessValue ? (Map)HRMServiceHelper.invokeHRService((String)"hpfs", (String)"IHPFSNewChgService", (String)"getNewChgRuleByActionIds", (Object[])new Object[]{actionIds}) : (Map)HRMServiceHelper.invokeHRService((String)"hpfs", (String)"IHPFSPersonChgService", (String)"getChgRuleByActionIds", (Object[])new Object[]{actionIds});
            if (res == null) {
                this.LOGGER.info("getChgRuleByActionIds_res:null");
                return new HashMap<Long, Map<String, DynamicObjectCollection>>(0);
            }
            this.LOGGER.info("getChgRuleByActionIds_res:{}", (Object)res.toString());
            if (res == null || res.get("errorMsg") != null) {
                this.LOGGER.info("getChgRuleByActionIds_error:{}", (Object)res.get("errorMsg").toString());
            }
            if (res.get("data") == null || ((Map)res.get("data")).isEmpty()) {
                return new HashMap<Long, Map<String, DynamicObjectCollection>>(0);
            }
            if (businessValue) {
                return (Map)res.get("data");
            }
            Map data = (Map)res.get("data");
            HashMap<Long, Map<String, DynamicObjectCollection>> reMap = new HashMap<Long, Map<String, DynamicObjectCollection>>(data.size());
            data.forEach((key, value) -> {
                if (value != null && value.size() >= 2) {
                    reMap.put((Long)key, (Map<String, DynamicObjectCollection>)value.get(1));
                }
            });
            return reMap;
        }
        catch (Exception exception) {
            this.LOGGER.error("getChgRuleByActionIds_res_error:", (Throwable)exception);
            throw new KDBizException(exception.getMessage());
        }
    }

    @Override
    public Tuple<Map<Long, Map<String, List<Long>>>, Map<Long, Map<String, String>>> getChgRuleInfo(List<Long> actionIds) {
        Map<Long, Map<String, DynamicObjectCollection>> chgRuleByActionIds = this.getChgRuleByActionIds(actionIds);
        if (chgRuleByActionIds == null || chgRuleByActionIds.isEmpty()) {
            return new Tuple(new HashMap(0), new HashMap(0));
        }
        HashMap<Long, Map<String, List<Long>>> chgMap = new HashMap<Long, Map<String, List<Long>>>(actionIds.size());
        HashMap<Long, Map<String, String>> tipsMap = new HashMap<Long, Map<String, String>>();
        this.setChgRuleMapInfo(chgRuleByActionIds, chgMap, tipsMap);
        return new Tuple(chgMap, tipsMap);
    }

    private void setChgRuleMapInfo(Map<Long, Map<String, DynamicObjectCollection>> chgRuleByActionIds, Map<Long, Map<String, List<Long>>> chgMap, Map<Long, Map<String, String>> tipsMap) {
        if (chgRuleByActionIds == null) {
            return;
        }
        chgRuleByActionIds.forEach((key, value) -> {
            HashMap<String, List<Long>> chg = new HashMap<String, List<Long>>();
            HashMap<String, String> tips = new HashMap<String, String>();
            this.setMapInfo((Map<String, DynamicObjectCollection>)value, (Map<String, List<Long>>)chg, (Map<String, String>)tips);
            chgMap.put((Long)key, (Map<String, List<Long>>)chg);
            tipsMap.put((Long)key, (Map<String, String>)tips);
        });
    }

    private void setMapInfo(Map<String, DynamicObjectCollection> dyMap, Map<String, List<Long>> chg, Map<String, String> tips) {
        if (dyMap == null || dyMap.isEmpty()) {
            return;
        }
        dyMap.forEach((key, value) -> {
            if (CollectionUtils.isEmpty((Collection)value)) {
                return;
            }
            ArrayList<Long> longs = new ArrayList<Long>(value.size());
            StringBuilder stringBuilder = new StringBuilder();
            this.setInfoFromCollection((DynamicObjectCollection)value, (List<Long>)longs, stringBuilder);
            if (stringBuilder.length() > 0) {
                stringBuilder.deleteCharAt(stringBuilder.length() - 1);
                chg.put((String)key, (List<Long>)longs);
                tips.put((String)key, stringBuilder.toString());
            }
        });
    }

    private void setInfoFromCollection(DynamicObjectCollection collection, List<Long> longs, StringBuilder stringBuilder) {
        if (CollectionUtils.isEmpty((Collection)collection)) {
            return;
        }
        collection.stream().forEach(dy -> {
            if (dy.get("id") instanceof Long) {
                longs.add(dy.getLong("id"));
                stringBuilder.append(dy.getString("name")).append(',');
            }
        });
    }
}

