/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.business.application.impl.mq;

import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MessageAcker;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.service.message.HRMessageConsumer;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.enums.AnonymousTypeEnum;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.privacy.rule.IPrivacyRule;

public class DuePersonConsumer
extends HRMessageConsumer {
    private static final Log logger = LogFactory.getLog(DuePersonConsumer.class);

    protected void consumeMessage(Object message, String messageId, boolean resend, MessageAcker acker) {
        Object[] pks;
        Map body = (Map)message;
        String bizAppId = (String)body.get("bizAppId");
        String dataSubjectIdType = (String)body.get("dataSubjectIdType");
        List dataSubjectIds = (List)body.get("dataSubjectIds");
        if (StringUtils.isEmpty((CharSequence)bizAppId) || StringUtils.isEmpty((CharSequence)dataSubjectIdType) || CollectionUtils.isEmpty((Collection)dataSubjectIds)) {
            logger.error("message is invalid, body:{}, msgId:{}", (Object)body.toString(), (Object)messageId);
            throw new RuntimeException("message is invalid!");
        }
        DynamicObject[] privacyConfigs = (DynamicObject[])HRMServiceHelper.invokeHRMPService((String)"hrcs", (String)"IHRCSPrivacyService", (String)"getPrivacyRelation", (Object[])new Object[]{bizAppId, dataSubjectIdType});
        if (privacyConfigs == null || privacyConfigs.length == 0) {
            logger.error("getPrivacyRelation return null, bizAppId:{}, dataSubjectIdType:{}", (Object)bizAppId, (Object)dataSubjectIdType);
            throw new RuntimeException("getPrivacyRelation return null!");
        }
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)privacyConfigs.length);
        HashMap entityMap = Maps.newHashMapWithExpectedSize((int)privacyConfigs.length);
        for (DynamicObject privacyConfig : privacyConfigs) {
            DynamicObject anonymousRule = privacyConfig.getDynamicObject("anonymousid");
            String anonymousType = anonymousRule.getString("anonymoustype");
            if (AnonymousTypeEnum.CUSTOM.getName().equals(anonymousType)) continue;
            Object result = this.getProcessResult(resultMap, anonymousRule);
            DynamicObjectCollection privacyObjects = privacyConfig.getDynamicObjectCollection("entityentry");
            if (CollectionUtils.isEmpty((Collection)privacyObjects)) continue;
            this.processPrivacyObjects(privacyObjects, entityMap, result);
        }
        if (entityMap.size() > 0) {
            this.updateByEntity(entityMap, dataSubjectIds, dataSubjectIdType);
        }
        if ((pks = (Object[])HRMServiceHelper.invokeHRMPService((String)"hrcs", (String)"IHRCSPrivacyService", (String)"setExecStatueCompletedBatch", (Object[])new Object[]{bizAppId, dataSubjectIdType, dataSubjectIds, new Date()})) == null || pks.length == 0) {
            logger.error("setExecStatueCompleted failed!");
        } else if (pks.length != dataSubjectIds.size()) {
            logger.error("setExecStatueCompleted partial success, pks:{}", (Object)Arrays.toString(pks));
        }
    }

    private Object getProcessResult(Map<String, Object> resultMap, DynamicObject anonymousRule) {
        String id = anonymousRule.getString("id");
        Object value = resultMap.get(id);
        if (value != null) {
            return value;
        }
        String params = anonymousRule.getString("params");
        String handleClass = anonymousRule.getString("handleclass");
        IPrivacyRule privacyRule = (IPrivacyRule)TypesContainer.createInstance((String)handleClass);
        Object result = privacyRule.getPrivacyRuleResult(params, null);
        resultMap.put(id, result);
        return result;
    }

    private void processPrivacyObjects(DynamicObjectCollection privacyObjects, Map<String, Map<String, Object>> entityMap, Object result) {
        for (DynamicObject privacyObject : privacyObjects) {
            DynamicObject entityDy = privacyObject.getDynamicObject("entity");
            String privacyField = privacyObject.getString("privacyfield");
            String personField = privacyObject.getString("personfield");
            String personFieldIdType = privacyObject.getString("personfieldtype");
            if (entityDy == null || !HRStringUtils.isNotEmpty((String)privacyField) || !HRStringUtils.isNotEmpty((String)personField) || !HRStringUtils.isNotEmpty((String)personFieldIdType)) continue;
            String key = this.getMapKey(entityDy.getString("number"), personField, personFieldIdType);
            Map<String, Object> fieldMap = entityMap.getOrDefault(key, Maps.newHashMapWithExpectedSize((int)4));
            fieldMap.put(privacyField, result);
            entityMap.put(key, fieldMap);
        }
    }

    private void updateByEntity(Map<String, Map<String, Object>> entityMap, List<Object> dataSubjectIds, String dataSubjectIdType) {
        logger.info("entityMap:{}", (Object)entityMap.toString());
        for (Map.Entry<String, Map<String, Object>> entityEntry : entityMap.entrySet()) {
            DynamicObject[] dys;
            String[] keys = entityEntry.getKey().split(",");
            HRBaseServiceHelper helper = new HRBaseServiceHelper(keys[0]);
            List<Object> ids = this.idTransformation(dataSubjectIds, dataSubjectIdType, keys[2]);
            QFilter filter = new QFilter(keys[1], "in", ids);
            for (DynamicObject dy : dys = helper.loadDynamicObjectArray(new QFilter[]{filter})) {
                for (Map.Entry<String, Object> fieldEntry : entityEntry.getValue().entrySet()) {
                    dy.set(fieldEntry.getKey(), fieldEntry.getValue());
                }
            }
            helper.save(dys);
        }
    }

    private List<Object> idTransformation(List<Object> dataSubjectIds, String dataSubjectIdType, String personFieldIdType) {
        return dataSubjectIds;
    }

    private String getMapKey(Object ... args) {
        return String.format(Locale.ROOT, "%s,%s,%s", args);
    }
}

