/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.business.application.impl.mq;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MQFactory;
import kd.bos.mq.MessagePublisher;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hom.business.application.hpfs.IPerChgBizService;
import kd.hr.hom.business.application.hpfs.IPersonFileIntegrateService;
import kd.hr.hom.business.domain.service.integrate.IIntegrateService;
import kd.hr.hom.business.domain.service.onbrd.IOnbrdBillDomainService;
import kd.hr.hom.common.enums.IntegrateEnum;
import kd.hr.hom.common.enums.PositionTypeEnum;
import kd.hr.hom.common.enums.SynchStatusEnum;
import kd.hr.hom.common.util.HOMObjectUtils;

public class HomPersonFilePublisher {
    private static final Log LOGGER = LogFactory.getLog(HomPersonFilePublisher.class);
    private static final String selProperties = "onbrd" + "," + "sendstatus" + "," + "sendtext" + "," + "sendtext_tag" + "," + "modifier" + "," + "modifytime";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void publish(Long userId, List<DynamicObject> onbrdBillInfoList) {
        IIntegrateService service = IIntegrateService.getInstance();
        IOnbrdBillDomainService onbrdService = IOnbrdBillDomainService.getInstance();
        LOGGER.info("Start publish");
        MessagePublisher pub = MQFactory.get().createSimplePublisher("hr", "hpfs_perchg_queue_onbrd");
        List<String> paramInfos = IPersonFileIntegrateService.getInstance().getParamsByOnbrdBills(userId, onbrdBillInfoList, "hpfs_perchg_queue_onbrd", "hom_perchg_result_queue", null);
        HashMap<Long, String> ids = new HashMap<Long, String>(onbrdBillInfoList.size());
        try {
            LOGGER.info("paramInfos.size():" + paramInfos.size());
            HomPersonFilePublisher.saveOnbrd(onbrdService, onbrdBillInfoList);
            for (int i = 0; i < paramInfos.size(); ++i) {
                String paramInfo = paramInfos.get(i);
                Long onbrdId = onbrdBillInfoList.get(i) != null ? onbrdBillInfoList.get(i).getLong("id") : 0L;
                LOGGER.info(paramInfo);
                try {
                    boolean isnewchgaction = onbrdBillInfoList.get(i).getBoolean("affaction.isnewchgaction");
                    if (isnewchgaction) {
                        IPerChgBizService.getInstance().executeNewPersonChangeEffect(Collections.singletonList(onbrdBillInfoList.get(i)));
                    } else {
                        pub.publish(paramInfo);
                    }
                    ids.put(onbrdId, paramInfo);
                    continue;
                }
                catch (Exception exp) {
                    LOGGER.error("==HomPersonFilePublisher.exp==", (Throwable)exp);
                    HomPersonFilePublisher.saveFailIntegrateLog(service, paramInfo, onbrdId, IntegrateEnum.INTEGRATE_SPOT_PERSON.getValue());
                    QFilter onbrdFilter = new QFilter("id", "=", (Object)onbrdId);
                    DynamicObject onbrdBill = onbrdService.findOnbrdBill("synchstatus", new QFilter[]{onbrdFilter});
                    if (HRObjectUtils.isEmpty((Object)onbrdBill)) continue;
                    onbrdBill.set("synchstatus", (Object)SynchStatusEnum.SYNCH_FAIL.getValue());
                    onbrdService.saveOnbrdBillInfo(onbrdBill);
                }
            }
            HomPersonFilePublisher.saveSuccessLogs(service, ids, IntegrateEnum.INTEGRATE_SPOT_PERSON.getValue());
        }
        catch (Exception exp) {
            LOGGER.error("===sendMessage error===", (Throwable)exp);
        }
        finally {
            pub.close();
            LOGGER.info("MessagePublisher.close");
        }
        LOGGER.info("End publish");
    }

    private static void saveOnbrd(IOnbrdBillDomainService onbrdService, List<DynamicObject> onbrdBillInfoList) {
        if (!CollectionUtils.isEmpty(onbrdBillInfoList)) {
            DynamicObject[] onbrdBills;
            Set ids = onbrdBillInfoList.stream().map(dy -> dy.getLong("id")).collect(Collectors.toSet());
            if (CollectionUtils.isEmpty(ids)) {
                return;
            }
            QFilter onbrdFilter = new QFilter("id", "in", ids);
            String selectFields = "synchstatus,isprobation,probationtime,perprobationtime,ajobscmorg,ajoblevel,ajobgrade,apositiontype,aposition,aposition.org,stdposition";
            for (DynamicObject onbrd : onbrdBills = onbrdService.findOnbrdBills(selectFields, new QFilter[]{onbrdFilter})) {
                boolean isprobation;
                String syncStatus = onbrd.getString("synchstatus");
                if (!SynchStatusEnum.SYNCH_SUCCESS.getValue().equals(syncStatus)) {
                    onbrd.set("synchstatus", (Object)SynchStatusEnum.SYNCH_DOING.getValue());
                }
                if (!(isprobation = onbrd.getBoolean("isprobation"))) {
                    onbrd.set("probationtime", (Object)0);
                    onbrd.set("perprobationtime", (Object)"");
                }
                long ajobscmorgId = onbrd.getLong("ajobscmorg.id");
                DynamicObject ajobLevel = onbrd.getDynamicObject("ajoblevel");
                DynamicObject ajobGrade = onbrd.getDynamicObject("ajobgrade");
                if (!HOMObjectUtils.isEmptyWithDynamicObjectField((Object)ajobscmorgId) || HRObjectUtils.isEmpty((Object)ajobGrade) && HRObjectUtils.isEmpty((Object)ajobLevel)) continue;
                String positionType = onbrd.getString("apositiontype");
                if (PositionTypeEnum.POSITIONTYPE_POSITION.getValue().equals(positionType)) {
                    DynamicObject positionDy = onbrd.getDynamicObject("aposition");
                    onbrd.set("ajobscmorg", (Object)positionDy.getDynamicObject("org"));
                }
                if (!PositionTypeEnum.POSITIONTYPE_STDPOSITION.getValue().equals(positionType)) continue;
                DynamicObject stdPosition = onbrd.getDynamicObject("stdposition");
                onbrd.set("ajobscmorg", (Object)stdPosition.getDynamicObject("createorg"));
            }
            onbrdService.saveOnbrdBillInfos(onbrdBills);
        }
    }

    private static void saveSuccessLogs(IIntegrateService service, Map<Long, String> ids, String integratemethod) {
        QFilter filter = new QFilter("onbrd.id", "in", ids.keySet()).and("integratemethod", "=", (Object)integratemethod);
        DynamicObject[] integrateLogs = service.findIntegrateLogs(selProperties, new QFilter[]{filter});
        if (!HRObjectUtils.isEmpty((Object)integrateLogs) && integrateLogs.length > 0) {
            for (int i = 0; i < integrateLogs.length; ++i) {
                DynamicObject integrateLog = integrateLogs[i];
                integrateLog.set("sendstatus", (Object)IntegrateEnum.SEND_SUCCESS.getValue());
                HomPersonFilePublisher.setIntegrateLog(ids.get(integrateLog.getLong("onbrd.id")), integrateLog);
                ids.remove(integrateLog.getLong("onbrd.id"));
            }
            service.saveIntegrateLogs(integrateLogs);
        }
        if (!CollectionUtils.isEmpty(ids)) {
            ArrayList<DynamicObject> dyList = new ArrayList<DynamicObject>(ids.size());
            for (Map.Entry<Long, String> entry : ids.entrySet()) {
                Long onbrdId = entry.getKey();
                String paramInfo = entry.getValue();
                HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hom_integratelog");
                DynamicObject logDy = HomPersonFilePublisher.getIntegrateDy(onbrdId, serviceHelper, paramInfo, integratemethod);
                logDy.set("sendstatus", (Object)IntegrateEnum.SEND_SUCCESS.getValue());
                dyList.add(logDy);
            }
            service.saveIntegrateLogs(dyList.toArray(new DynamicObject[dyList.size()]));
        }
    }

    private static void saveFailIntegrateLog(IIntegrateService service, String paramInfo, Long onbrdId, String integratemethod) {
        QFilter filter = new QFilter("onbrd.id", "=", (Object)onbrdId).and("integratemethod", "=", (Object)integratemethod);
        DynamicObject integrateLog = service.findIntegrateLog(selProperties, new QFilter[]{filter});
        if (!HRObjectUtils.isEmpty((Object)integrateLog)) {
            integrateLog.set("sendstatus", (Object)"-1");
            HomPersonFilePublisher.setIntegrateLog(paramInfo, integrateLog);
            service.saveIntegrateLog(integrateLog);
        } else {
            HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hom_integratelog");
            DynamicObject logDy = HomPersonFilePublisher.getIntegrateDy(onbrdId, serviceHelper, paramInfo, integratemethod);
            logDy.set("sendstatus", (Object)IntegrateEnum.SEND_FAIL.getValue());
            service.saveIntegrateLog(logDy);
        }
    }

    private static DynamicObject getIntegrateDy(Long onbrdId, HRBaseServiceHelper serviceHelper, String sendText, String integratemethod) {
        DynamicObject logDy = serviceHelper.generateEmptyDynamicObject();
        logDy.set("onbrd", (Object)onbrdId);
        logDy.set("createtime", (Object)new Date());
        logDy.set("creator", (Object)RequestContext.get().getCurrUserId());
        logDy.set("modifytime", (Object)new Date());
        logDy.set("modifier", (Object)RequestContext.get().getCurrUserId());
        logDy.set("sendtime", (Object)new Date());
        logDy.set("sendtext_tag", (Object)sendText);
        logDy.set("consumestatus", (Object)IntegrateEnum.CONSUME_WAIT.getValue());
        logDy.set("integratespot", (Object)integratemethod);
        logDy.set("integratemethod", (Object)IntegrateEnum.INTEGRATE_MQ.getValue());
        return logDy;
    }

    private static void setIntegrateLog(String paramInfo, DynamicObject integrateLog) {
        integrateLog.set("sendtext_tag", (Object)paramInfo);
        integrateLog.set("modifier", (Object)RequestContext.get().getCurrUserId());
        integrateLog.set("modifytime", (Object)new Date());
    }
}

