/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.business.application.impl.onbrd;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.cache.CacheFactory;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.fileservice.extension.FileServiceExt;
import kd.bos.fileservice.extension.FileServiceExtFactory;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.url.UrlService;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hom.business.application.onbrd.IAttachmentAppService;
import kd.hr.hom.business.domain.service.base.IUploadConfigDomainService;
import kd.hr.hom.common.util.FileServiceUtils;

public class AttachmentAppServiceImpl
implements IAttachmentAppService {
    private static final Log LOGGER = LogFactory.getLog(AttachmentAppServiceImpl.class);

    @Override
    public void bindAttachmentInfo(List<DynamicObject> infoList, IFormView view, String fattachmentpanel) {
        ArrayList linkedHashMaps = Lists.newArrayListWithCapacity((int)8);
        for (DynamicObject dynamicObject : infoList) {
            LinkedHashMap<String, Object> linkedHashMap = this.getAttachmentInfoMap(dynamicObject);
            linkedHashMaps.add(linkedHashMap);
        }
        AttachmentPanel attachmentpanelap = (AttachmentPanel)view.getControl(fattachmentpanel);
        List attachmentData = attachmentpanelap.getAttachmentData();
        attachmentData.addAll(linkedHashMaps);
        attachmentpanelap.bindData(attachmentData);
        HashMap<String, List> maps = new HashMap<String, List>(2);
        maps.put(fattachmentpanel, attachmentData);
        IPageCache cache = (IPageCache)view.getService(IPageCache.class);
        cache.put("TampAttCache" + view.getPageId(), JSON.toJSONString(maps));
    }

    private LinkedHashMap<String, Object> getAttachmentInfoMap(DynamicObject dynamicObject) {
        LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>(20);
        linkedHashMap.put("attPkId", dynamicObject.getLong("id"));
        linkedHashMap.put("billPkId", dynamicObject.getString("finterid"));
        linkedHashMap.put("name", dynamicObject.getString("fattachmentname"));
        linkedHashMap.put("uid", dynamicObject.getString("fnumber"));
        linkedHashMap.put("size", HRStringUtils.isNotEmpty((String)dynamicObject.getString("fattachmentsize")) ? dynamicObject.getString("fattachmentsize") : "0");
        linkedHashMap.put("description", dynamicObject.getString("fdescription"));
        linkedHashMap.put("entityNum", dynamicObject.getString("fbilltype"));
        linkedHashMap.put("type", dynamicObject.getString("fextname"));
        linkedHashMap.put("fattachmentpanel", dynamicObject.getString("fattachmentpanel"));
        try {
            String url = URLEncoder.encode(AttachmentServiceHelper.removeUrlVersion((String)String.valueOf(dynamicObject.get("FFileId"))), "UTF-8");
            String attUrl = UrlService.getAttachmentFullUrl((String)url);
            linkedHashMap.put("url", attUrl);
        }
        catch (UnsupportedEncodingException exception) {
            LOGGER.error("getAttachmentInfoMap attachmentName = {}", (Object)dynamicObject.getString("fattachmentname"), (Object)exception);
        }
        linkedHashMap.put("status", "success");
        Date fcreatetime = dynamicObject.getDate("fcreatetime");
        linkedHashMap.put("createdate", HRObjectUtils.isEmpty((Object)fcreatetime) ? "" : Long.valueOf(fcreatetime.getTime()));
        DynamicObject fcreatemen = dynamicObject.getDynamicObject("fcreatemen");
        HashMap map = Maps.newHashMap();
        if (!HRObjectUtils.isEmpty((Object)fcreatemen)) {
            OrmLocaleValue name = (OrmLocaleValue)dynamicObject.get("fcreatemen.name");
            map.put("zh_CN", name.get((Object)Lang.zh_CN.toString()));
            map.put("zh_TW", name.get((Object)Lang.zh_TW.toString()));
        }
        linkedHashMap.put("creator", map);
        linkedHashMap.put("lastModified", dynamicObject.getDate("fmodifytime"));
        return linkedHashMap;
    }

    @Override
    public void bindAttachmentInfo(Map<String, List<DynamicObject>> infoListMap, IFormView view) {
        HashMap maps = new HashMap(infoListMap.size());
        infoListMap.forEach((attachmentpanelKey, list) -> {
            ArrayList linkedHashMaps = Lists.newArrayListWithCapacity((int)8);
            list.forEach(attachmentDy -> {
                LinkedHashMap<String, Object> linkedHashMap = this.getAttachmentInfoMap((DynamicObject)attachmentDy);
                linkedHashMaps.add(linkedHashMap);
            });
            AttachmentPanel attachmentpanelap = (AttachmentPanel)view.getControl(attachmentpanelKey);
            List attachmentData = attachmentpanelap.getAttachmentData();
            attachmentData.addAll(linkedHashMaps);
            attachmentpanelap.bindData(attachmentData);
            maps.put(attachmentpanelKey, attachmentData);
        });
        IPageCache cache = (IPageCache)view.getService(IPageCache.class);
        cache.put("TampAttCache" + view.getPageId(), JSON.toJSONString(maps));
    }

    @Override
    public void saveAttachmentToHcf(List<Map<String, Object>> attachmentData, long id, long attachmentTypeId) {
        DynamicObject attachmentType = IUploadConfigDomainService.getInstance().getAttachmentType(attachmentTypeId);
        HashMap<String, List<Map<String, Object>>> objectObjectHashMap = new HashMap<String, List<Map<String, Object>>>(2);
        objectObjectHashMap.put(attachmentType.getString("attachmentpanel"), attachmentData);
        AttachmentServiceHelper.saveTempAttachments((String)attachmentType.getString("entityname"), (Object)id, (String)"hcf", objectObjectHashMap);
    }

    @Override
    public List<Map<String, Object>> getAttachments(String formId, Object pkId, String attachKey) {
        List attachmentData = AttachmentServiceHelper.getAttachments((String)formId, (Object)pkId, (String)attachKey);
        attachmentData.forEach(attach -> {
            String uid;
            String string = uid = attach.get("uid") == null ? "" : attach.get("uid").toString();
            if (HRStringUtils.isEmpty((String)uid)) {
                uid = this.getUid().toString();
            }
            attach.put("uid", uid);
            attach.put("entityNum", formId);
            attach.put("billPkId", String.valueOf(pkId));
        });
        return attachmentData;
    }

    @Override
    public void changeAttachmentPanelUrl(List<Map<String, Object>> attachmentDataPanels) {
        Iterator<Map<String, Object>> iterator = attachmentDataPanels.iterator();
        while (iterator.hasNext()) {
            Map<String, Object> attachmentDataPanel;
            Object urlObject = (attachmentDataPanel = iterator.next()).get("url");
            attachmentDataPanel.put("url", this.getShortAttachmentFieldUrl(urlObject == null ? "" : urlObject.toString()));
        }
    }

    @Override
    public String getShortAttachmentFieldUrl(String fileUrl) {
        if (fileUrl.contains("attachment/download.do")) {
            String relativeUrl = fileUrl.substring(fileUrl.indexOf(61) + 1);
            try {
                relativeUrl = URLDecoder.decode(relativeUrl, "UTF-8");
            }
            catch (UnsupportedEncodingException exception) {
                LOGGER.error((Throwable)exception);
            }
            LOGGER.info("relativeUrl:" + relativeUrl);
            return relativeUrl;
        }
        return fileUrl;
    }

    @Override
    public List<Map<String, Object>> buildAttachmentDataFromEdit(String entityNum, String pkId, DynamicObjectCollection sourceAttachCol) {
        ArrayList<Map<String, Object>> attachDataList = new ArrayList<Map<String, Object>>();
        sourceAttachCol.forEach(attach -> {
            InputStream inputStream = null;
            try {
                DynamicObject attachObj = attach.getDynamicObject("fbasedataid");
                HashMap<String, Object> attachMap = new HashMap<String, Object>();
                attachMap.put("description", attachObj.getString("description"));
                attachMap.put("type", attachObj.getString("type"));
                String fileUrl = attachObj.getString("url");
                FileServiceExt fileServiceExt = FileServiceExtFactory.getAttachFileServiceExt();
                LOGGER.info("fileUrl:{}", (Object)fileUrl);
                String realPath = fileServiceExt.getRealPath(fileUrl);
                LOGGER.info("realPath:{}", (Object)realPath);
                inputStream = FileServiceUtils.getInputStreamByUrl((String)realPath);
                if (inputStream == null) {
                    LOGGER.warn("FileServiceUtils.getInputStreamWithFileUrl, inputStream==null");
                    return;
                }
                String fileName = attachObj.getString("name");
                String saveTempUrl = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsFullUrl(fileName, (InputStream)new BufferedInputStream(inputStream), 7200);
                LOGGER.info(saveTempUrl);
                attachMap.put("url", saveTempUrl);
                String uid = attachObj.getString("uid");
                if (HRStringUtils.isEmpty((String)uid)) {
                    uid = this.getUid().toString();
                }
                attachMap.put("uid", uid);
                attachMap.put("name", fileName);
                attachMap.put("size", attachObj.get("size"));
                attachMap.put("fattachmentpanel", "attachmentpanel");
                attachMap.put("entityNum", entityNum);
                attachMap.put("billPkId", pkId);
                attachMap.put("lastModified", new Date().getTime());
                attachMap.put("status", "success");
                attachMap.put("client", null);
                attachDataList.add(attachMap);
            }
            catch (Exception exception) {
                LOGGER.error((Throwable)exception);
            }
            finally {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException exception) {
                        LOGGER.error((Throwable)exception);
                    }
                }
            }
        });
        return attachDataList;
    }

    private StringBuffer getUid() {
        StringBuffer uid = new StringBuffer("rc-upload-");
        uid.append(new Date().getTime());
        uid.append('-');
        int index = new SecureRandom().nextInt(10);
        uid.append(index);
        return uid;
    }
}

