/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.business.application.impl.onbrd;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.hr.hbp.business.service.diff.HRPlugInProxyFactory;
import kd.hr.hbp.business.service.diff.HRPluginProxy;
import kd.hr.hbp.business.servicehelper.HRExportHeadObject;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hom.business.application.hrcs.IHomToHrcsAppService;
import kd.hr.hom.business.application.onbrd.IOnbrdBreakupAppService;
import kd.hr.hom.business.application.staff.IStaffUseService;
import kd.hr.hom.business.application.tsc.IBreakupOnbrdBillService;
import kd.hr.hom.business.domain.repository.common.HomCommonRepository;
import kd.hr.hom.business.domain.service.ServiceFactory;
import kd.hr.hom.business.domain.service.activity.IActivityDomainService;
import kd.hr.hom.business.domain.service.common.ISendMessageService;
import kd.hr.hom.business.domain.service.hcf.IHcfDataDomainService;
import kd.hr.hom.business.domain.service.onbrd.IOnbrdBillDomainService;
import kd.hr.hom.business.mq.action.MessagePublisher;
import kd.hr.hom.common.constant.ActionMessageConstants;
import kd.hr.hom.common.enums.AuditStatusEnum;
import kd.hr.hom.common.enums.BillStatusEnum;
import kd.hr.hom.common.enums.OnbrdStatusEnum;
import kd.hr.hom.common.enums.ProcessStatusEnum;
import kd.hr.hom.common.enums.RuleEngineSceneNumberEnum;
import kd.hr.hom.common.util.HOMObjectUtils;
import kd.sdk.hr.common.entity.ValidResult;
import kd.sdk.hr.common.enums.TipTypeEnum;
import kd.sdk.hr.hom.business.onbrd.IShareTaskService;

public class OnbrdBreakupAppServiceImpl
implements IOnbrdBreakupAppService {
    private static final Log logger = LogFactory.getLog(OnbrdBreakupAppServiceImpl.class);
    private static final ThreadPool threadPool = ThreadPools.newCachedThreadPool((String)"OnbrdBreakupAppServiceImpl", (int)5, (int)1000);
    private static final String properties = "id,candidate,enrollstatus,processstatus,breakupdate,breakuptype,breakupreason,breakupremarks,name,resumeno,employeeno,effectdate,billstatus,onbrdtype,auditstatus,datasource,offernumber,offerid,billno";

    @Override
    public DynamicObject[] queryOnbrdBillsForBreakup(List<Object> breakupOnbrdBillIds) {
        QFilter qFilter = new QFilter("id", "in", breakupOnbrdBillIds);
        return IOnbrdBillDomainService.getInstance().findOnbrdBills(properties, new QFilter[]{qFilter});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean breakupOnBrd(DynamicObject[] onbrdBillArray, DynamicObject breakupType, DynamicObject breakupReason, String breakupRemarks, DynamicObject[] collectArray) {
        boolean flag = true;
        try (TXHandle txHandle = TX.required();){
            for (DynamicObject onbrdBill : onbrdBillArray) {
                onbrdBill.set("enrollstatus", (Object)OnbrdStatusEnum.BREAK_UP.toString());
                if (!BillStatusEnum.AUDIT_NO_PASS.getCode().equals(onbrdBill.get("billstatus"))) {
                    onbrdBill.set("billstatus", (Object)BillStatusEnum.DISCARD.getCode());
                }
                onbrdBill.set("auditstatus", (Object)AuditStatusEnum.DISCARD.getCode());
                onbrdBill.set("processstatus", (Object)ProcessStatusEnum.END_PROCESS.getValue());
                onbrdBill.set("breakupdate", (Object)new Date());
                onbrdBill.set("breakuptype", (Object)(breakupType == null ? 0L : breakupType.getLong("id")));
                onbrdBill.set("breakupreason", (Object)(breakupReason == null ? 0L : breakupReason.getLong("id")));
                onbrdBill.set("breakupremarks", (Object)breakupRemarks);
            }
            IOnbrdBillDomainService.getInstance().saveOnbrdBillInfos(onbrdBillArray);
            if (!HRArrayUtils.isEmpty((Object[])collectArray)) {
                for (DynamicObject collect : collectArray) {
                    collect.set("acceptstatus", (Object)"40");
                    collect.set("acceptmodifytime", (Object)new Date());
                }
                HomCommonRepository.updateDynamicObjects("hom_collect", collectArray);
            }
        }
        return flag;
    }

    @Override
    public void showOnbrdBreakupPage(IFormView formView, Long[] onbrdIdArray, CloseCallBack closeCallBack) {
        QFilter idFilter = new QFilter("id", "in", (Object)onbrdIdArray);
        Object[] onbrdBills = IOnbrdBillDomainService.getInstance().findOnbrdBills("id", new QFilter[]{idFilter});
        if (HRArrayUtils.isEmpty((Object[])onbrdBills)) {
            formView.showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u5e93\u4e2d\u627e\u4e0d\u5230\u5bf9\u5e94\u8bb0\u5f55\u3002", (String)"OnbrdBreakupAppServiceImpl_0", (String)"hr-hom-business", (Object[])new Object[0]));
            return;
        }
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setFormId("hom_onbrdbreakup");
        formShowParameter.setStatus(OperationStatus.EDIT);
        formShowParameter.setCustomParam("breakup_onbrd_person_ids", (Object)onbrdIdArray);
        formShowParameter.setCloseCallBack(closeCallBack);
        formView.showForm(formShowParameter);
    }

    @Override
    public void syncPreserveStartDate(DynamicObject[] onbrdBillArray) {
        IHcfDataDomainService hcfDataDomainService = IHcfDataDomainService.getInstance();
        List candidateIds = Stream.of(onbrdBillArray).map(onbrdBill -> onbrdBill.getLong("candidate.id")).collect(Collectors.toList());
        String properties = "id" + "," + "name" + "," + "number" + "," + "preservestartdate" + "," + "datasource" + "," + "entrynumber" + "," + "appfileid";
        QFilter qFilter = new QFilter("id", "in", candidateIds);
        Map<String, DynamicObject> candidateMap = hcfDataDomainService.queryCandidate(properties, new QFilter[]{qFilter});
        if (CollectionUtils.isEmpty(candidateMap)) {
            return;
        }
        ArrayList candidateUpdateList = Lists.newArrayListWithExpectedSize((int)onbrdBillArray.length);
        for (DynamicObject onbrdBill2 : onbrdBillArray) {
            String candidateNumber = onbrdBill2.getString("candidate.number");
            DynamicObject candidateDB = candidateMap.get(candidateNumber);
            if (HOMObjectUtils.isEmpty((Object)candidateDB)) continue;
            DynamicObject candidateUpdate = HOMObjectUtils.copyHcfHisDynamicObject((String)"hcf_candidate", (DynamicObject)candidateDB);
            candidateUpdate.set("preservestartdate", onbrdBill2.get("breakupdate"));
            candidateUpdateList.add(candidateUpdate);
        }
        hcfDataDomainService.saveCandidateWithResult(candidateUpdateList.toArray(new DynamicObject[0]));
    }

    @Override
    public boolean doSomethingsWithBreakup(List<Object> breakupOnbrdBillIds, DynamicObject breakupType, DynamicObject breakupReason, String breakupRemarks, AbstractFormPlugin formPlugin) {
        Object[] onbrdBillArray = this.queryOnbrdBillsForBreakup(breakupOnbrdBillIds);
        QFilter filter = new QFilter("acceptstatus", "!=", (Object)" ").and("onboard", "in", breakupOnbrdBillIds);
        DynamicObject[] collectArray = HomCommonRepository.queryDynamicObjects("hom_collect", "acceptstatus,acceptmodifytime", filter);
        ArrayList allBillDynamicObjects = Lists.newArrayList((Object[])onbrdBillArray);
        ArrayList successBillDynamicObjects = new ArrayList();
        logger.info("doSomethingsWithBreakup start baterminateOrDeleteTask");
        List<Long> onbrdIds = breakupOnbrdBillIds.stream().map(Long.class::cast).collect(Collectors.toList());
        Map<String, Object> terminateResult = IHomToHrcsAppService.getInstance().terminateOrDeleteTask(onbrdIds);
        if (!Boolean.TRUE.toString().equals(terminateResult.get("success"))) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8be5\u5165\u804c\u6d41\u7a0b\u4e2d\u5b58\u5728\u5171\u4eab\u4efb\u52a1\u7ec8\u6b62\u5931\u8d25\u5bfc\u81f4\u7ec8\u6b62\u5165\u804c\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\u89e6\u53d1\u3002", (String)"OnbrdBreakupAppServiceImpl_13", (String)"hr-hom-business", (Object[])new Object[0]));
        }
        boolean flag = this.breakupOnBrd((DynamicObject[])onbrdBillArray, breakupType, breakupReason, breakupRemarks, collectArray);
        if (flag) {
            successBillDynamicObjects = allBillDynamicObjects;
            this.syncPreserveStartDate((DynamicObject[])onbrdBillArray);
            ArrayList finalSuccessBillDynamicObjects = successBillDynamicObjects;
            threadPool.execute(() -> IBreakupOnbrdBillService.getInstance().sendBreakupOnbrdMsg(finalSuccessBillDynamicObjects));
            threadPool.execute(() -> finalSuccessBillDynamicObjects.forEach(onBrdBill -> {
                try {
                    HashMap<String, Long> messageInfo = new HashMap<String, Long>(2);
                    messageInfo.put("onbrdbill", onBrdBill.getLong("id"));
                    String msgNumber = String.format("%s_%s", onBrdBill.getString("id"), System.currentTimeMillis());
                    MessagePublisher.sendActionMessage(msgNumber, "MP20230719001092", String.format(Locale.ROOT, ResManager.loadKDString((String)"\u5165\u804c\u5355\u636e%s\u7ec8\u6b62", (String)"OnbrdBreakupAppServiceImpl_12", (String)"hr-hom-business", (Object[])new Object[0]), onBrdBill.getString("billno")), ActionMessageConstants.ACTION_ID_BREAK_UP_ON_BRD_ROLLBACK, Lists.newArrayList((Object[])new Map[]{messageInfo}));
                }
                catch (Exception e) {
                    logger.error("send msg error", (Throwable)e);
                }
            }));
            List successIds = successBillDynamicObjects.stream().map(onbrdBill -> onbrdBill.getLong("id")).collect(Collectors.toList());
            threadPool.execute(() -> IStaffUseService.getInstance().sendMsgForOnbrdBreakUp(successIds), RequestContext.getOrCreate());
        }
        logger.info("breakupOnBrdFinally");
        if (formPlugin != null) {
            this.showPageBreakupResult(allBillDynamicObjects, successBillDynamicObjects, formPlugin);
        }
        List successIds = successBillDynamicObjects.stream().map(onbrdBill -> onbrdBill.getLong("id")).collect(Collectors.toList());
        logger.info("dealShareTask");
        HRPluginProxy hrPluginProxy = HRPlugInProxyFactory.create(null, IShareTaskService.class, (String)"kd.sdk.hr.hom.business.onbrd.IShareTaskService", null);
        hrPluginProxy.callReplace(hrPlugin -> {
            hrPlugin.dealShareTask("breakup", "hom_onbrdinfo", successIds);
            return null;
        });
        threadPool.execute(() -> ServiceFactory.getService(ISendMessageService.class).sendMessage(successIds, RuleEngineSceneNumberEnum.NOTICE_TERMINATION), RequestContext.getOrCreate());
        threadPool.execute(() -> {
            logger.info("batchTerminateTask start to abandon workflow");
            try {
                IActivityDomainService.getInstance().batchTerminateTask(successIds);
            }
            catch (Exception exception) {
                logger.warn("batchTerminateTask catch to abandon workflow:", (Throwable)exception);
            }
            logger.info("batchTerminateFlow start to abandon workflow");
            IActivityDomainService.getInstance().batchTerminateFlow(successIds);
            logger.info("batchTerminateFlow success to abandon workflow");
        }, RequestContext.getOrCreate());
        logger.info("End breakupOnBrd");
        return flag;
    }

    @Override
    public void showPageBreakupResult(List<DynamicObject> allBills, List<DynamicObject> successBills, AbstractFormPlugin formPlugin) {
        int sumPerson = allBills.size();
        int successPerson = successBills.size();
        int failPerson = sumPerson - successPerson;
        Set successIdList = successBills.stream().map(onbrdBill -> onbrdBill.getString("id")).collect(Collectors.toSet());
        List<HRExportHeadObject> headDataList = this.getHeadDataList();
        List<Map<String, Object>> templateExportDataList = this.getTemplateExportDataList(allBills);
        Iterator<Map<String, Object>> iterator = templateExportDataList.iterator();
        while (iterator.hasNext()) {
            Map<String, Object> exportData;
            String id = (exportData = iterator.next()).get("id").toString();
            exportData.put("breakup_result", successIdList.contains(id) ? ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f", (String)"OnbrdBreakupAppServiceImpl_2", (String)"hr-hom-business", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25", (String)"OnbrdBreakupAppServiceImpl_3", (String)"hr-hom-business", (Object[])new Object[0]));
        }
        this.showPageBatchBreakupResult(successPerson, failPerson, templateExportDataList, headDataList, formPlugin);
    }

    @Override
    public void showPageBatchBreakupResult(int successPerson, int failPerson, List<Map<String, Object>> exportDataList, List<HRExportHeadObject> headDataList, AbstractFormPlugin formPlugin) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        String excelName = ResManager.loadKDString((String)"\u6279\u91cf\u7ec8\u6b62\u5165\u804c\u5904\u7406\u7ed3\u679c", (String)"OnbrdBreakupAppServiceImpl_5", (String)"hr-hom-business", (Object[])new Object[0]);
        formShowParameter.setFormId("hom_result");
        formShowParameter.setCustomParam("hasoperation", (Object)Boolean.FALSE);
        formShowParameter.setCustomParam("successperson", (Object)String.valueOf(successPerson));
        formShowParameter.setCustomParam("successoperation", (Object)ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f", (String)"OnbrdBreakupAppServiceImpl_2", (String)"hr-hom-business", (Object[])new Object[0]));
        formShowParameter.setCustomParam("failperson", (Object)String.valueOf(failPerson));
        formShowParameter.setCustomParam("failoperation", (Object)ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25", (String)"OnbrdBreakupAppServiceImpl_3", (String)"hr-hom-business", (Object[])new Object[0]));
        formShowParameter.setCaption(ResManager.loadKDString((String)"\u64cd\u4f5c\u63d0\u793a", (String)"OnbrdBreakupAppServiceImpl_4", (String)"hr-hom-business", (Object[])new Object[0]));
        formShowParameter.setCustomParam("excelname", (Object)excelName);
        formShowParameter.setCustomParam("headdatalist", headDataList);
        formShowParameter.setCustomParam("exportdatalist", exportDataList);
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)formPlugin, "hom_result"));
        IFormView formView = formPlugin.getView();
        formView.getParentView().showForm(formShowParameter);
        formView.sendFormAction(formView.getParentView());
    }

    @Override
    public Map<Long, ValidResult> validateBreakupData(List<Object> breakupOnbrdBillIds, DynamicObject dataEntity) {
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)breakupOnbrdBillIds.size());
        DynamicObject[] onbrdBillArray = IOnbrdBreakupAppService.getInstance().queryOnbrdBillsForBreakup(breakupOnbrdBillIds);
        List changedBillDys = Stream.of(onbrdBillArray).filter(onbrdBill -> {
            String processStatus = onbrdBill.getString("processstatus");
            return HRStringUtils.equals((String)ProcessStatusEnum.END_PROCESS.getValue(), (String)processStatus);
        }).collect(Collectors.toList());
        String message = ResManager.loadKDString((String)"\u6d41\u7a0b\u72b6\u6001\u5df2\u53d1\u751f\u53d8\u66f4\uff0c\u4e0d\u80fd\u91cd\u590d\u6267\u884c\u64cd\u4f5c\uff1b", (String)"OnbrdBreakupEdit_16", (String)"hr-hom-business", (Object[])new Object[0]);
        for (DynamicObject changedBillDy : changedBillDys) {
            resultMap.put(changedBillDy.getLong("id"), new ValidResult(Long.valueOf(changedBillDy.getLong("id")), TipTypeEnum.ERROR.getName(), message, false));
        }
        DynamicObject breakupType = dataEntity.getDynamicObject("breakuptype");
        DynamicObject breakupReason = dataEntity.getDynamicObject("breakupreason");
        if (breakupReason == null || breakupType == null) {
            String modelMessage = ResManager.loadKDString((String)"\u6709\u5185\u5bb9\u672a\u6309\u8981\u6c42\u586b\u5199\uff1a\u653e\u5f03\u539f\u56e0\u3002", (String)"OnbrdBreakupEdit_3", (String)"hr-hom-business", (Object[])new Object[0]);
            for (DynamicObject dynamicObject : onbrdBillArray) {
                resultMap.putIfAbsent(dynamicObject.getLong("id"), new ValidResult(Long.valueOf(dynamicObject.getLong("id")), TipTypeEnum.WARNING.getName(), modelMessage, false));
            }
        }
        return resultMap;
    }

    private List<HRExportHeadObject> getHeadDataList() {
        ArrayList<HRExportHeadObject> headDataList = new ArrayList<HRExportHeadObject>(6);
        headDataList.add(new HRExportHeadObject("name", ResManager.loadKDString((String)"\u59d3\u540d", (String)"OnbrdBreakupAppServiceImpl_6", (String)"hr-hom-business", (Object[])new Object[0])));
        headDataList.add(new HRExportHeadObject("resumeno", ResManager.loadKDString((String)"\u7b80\u5386\u7f16\u53f7", (String)"OnbrdBreakupAppServiceImpl_7", (String)"hr-hom-business", (Object[])new Object[0])));
        headDataList.add(new HRExportHeadObject("employeeno", ResManager.loadKDString((String)"\u5de5\u53f7", (String)"OnbrdBreakupAppServiceImpl_8", (String)"hr-hom-business", (Object[])new Object[0])));
        headDataList.add(new HRExportHeadObject("effectdate", ResManager.loadKDString((String)"\u5165\u804c\u65e5\u671f", (String)"OnbrdBreakupAppServiceImpl_9", (String)"hr-hom-business", (Object[])new Object[0])));
        headDataList.add(new HRExportHeadObject("onbrdtype", ResManager.loadKDString((String)"\u5165\u804c\u7c7b\u578b", (String)"OnbrdBreakupAppServiceImpl_10", (String)"hr-hom-business", (Object[])new Object[0])));
        headDataList.add(new HRExportHeadObject("breakup_result", ResManager.loadKDString((String)"\u64cd\u4f5c\u7ed3\u679c", (String)"OnbrdBreakupAppServiceImpl_11", (String)"hr-hom-business", (Object[])new Object[0])));
        return headDataList;
    }

    private List<Map<String, Object>> getTemplateExportDataList(List<DynamicObject> onbrdBillList) {
        ArrayList<Map<String, Object>> exportDataList = new ArrayList<Map<String, Object>>(onbrdBillList.size());
        for (DynamicObject dynamicObject : onbrdBillList) {
            HashMap<String, Object> exportData = new HashMap<String, Object>();
            exportData.put("id", dynamicObject.getString("id"));
            OrmLocaleValue name = (OrmLocaleValue)dynamicObject.get("name");
            exportData.put("name", name == null ? "" : name.getLocaleValue());
            exportData.put("resumeno", dynamicObject.get("resumeno"));
            exportData.put("employeeno", dynamicObject.get("employeeno"));
            exportData.put("effectdate", dynamicObject.get("effectdate"));
            DynamicObject onbrdType = dynamicObject.getDynamicObject("onbrdtype");
            exportData.put("onbrdtype", HRObjectUtils.isEmpty((Object)onbrdType) ? "" : onbrdType.getString("name"));
            exportDataList.add(exportData);
        }
        return exportDataList;
    }
}

