/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.business.application.impl.onbrd;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.security.SecureRandom;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.ext.hr.web.dto.SafeUrlDTO;
import kd.bos.ext.hr.web.util.HrGuestUrlUtil;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.i18n.api.model.TelephoneParseResult;
import kd.bos.i18n.mservice.I18nServiceHelper;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.hr.hbp.common.cache.HRAppCache;
import kd.hr.hbp.common.cache.IHRAppCache;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hom.business.application.common.ReentryRuleService;
import kd.hr.hom.business.application.hrcs.IHomToHrcsAppService;
import kd.hr.hom.business.application.hrpi.IHomToHrpiAppService;
import kd.hr.hom.business.application.impl.page.CertificatePageServiceImpl;
import kd.hr.hom.business.application.onbrd.IOnbrdCommonAppService;
import kd.hr.hom.business.domain.repository.common.HomCommonRepository;
import kd.hr.hom.business.domain.service.ServiceFactory;
import kd.hr.hom.business.domain.service.activity.IActivityDomainService;
import kd.hr.hom.business.domain.service.common.IBaseDataDomainService;
import kd.hr.hom.business.domain.service.common.IHomConfigService;
import kd.hr.hom.business.domain.service.common.IHomDataMutexService;
import kd.hr.hom.business.domain.service.common.IHomRuleEngineService;
import kd.hr.hom.business.domain.service.onbrd.IOnbrdBillDomainService;
import kd.hr.hom.common.enums.AcceptManageEnum;
import kd.hr.hom.common.enums.ActivityNumberEnum;
import kd.hr.hom.common.enums.ActivityStatusEnum;
import kd.hr.hom.common.enums.CollectApproveStatusEnum;
import kd.hr.hom.common.enums.CollectManageStatusEnum;
import kd.hr.hom.common.enums.OnbrdStatusEnum;
import kd.hr.hom.common.enums.PositionTypeEnum;
import kd.hr.hom.common.enums.PreEnrollStatusEnum;
import kd.hr.hom.common.enums.RuleEngineSceneNumberEnum;
import kd.hr.hom.common.enums.SynchStatusEnum;
import kd.hr.hom.common.enums.ViewTypeEnum;
import kd.hr.hom.common.util.HOMObjectUtils;
import kd.hr.hom.common.util.PreOnBrdCommonUtil;
import org.apache.commons.collections.CollectionUtils;

public class OnbrdCommonAppServiceImpl
implements IOnbrdCommonAppService {
    private static final Log logger = LogFactory.getLog(OnbrdCommonAppServiceImpl.class);
    private static final String KEY_DATAMUTEX_ONBRDBILL = "hom:DataMutex:onbrdbill";
    private static final String KEY_DATAMUTEX_USERID = "hom:DataMutex:userId";
    private static final String KEY_DATAMUTEX_CHECK = "hom:DataMutex:check";
    private static final String KEY_DATAMUTEX_CHECK_USERID = "hom:DataMutex-check:userId";
    private static final String PROPERTIES_ACTIVITYINFO = "id,onbrd,activityscheme,entryentity.activity,entryentity.activityins,entryentity.createtime,entryentity.latestdeadline";
    public static final String SELECT_PROPERTIES = "billno,candidatenumber,certificatenumber,phone,peremail,certificatetype,certificatetype.id";

    @Override
    public boolean validateDuplicateWithCandidateNum(String candidateNumber) {
        QFilter qFilter = new QFilter("candidate.number", "=", (Object)candidateNumber);
        Object[] onbrdBills = IOnbrdBillDomainService.getInstance().findOnbrdBills("candidate", new QFilter[]{qFilter});
        return !HRArrayUtils.isEmpty((Object[])onbrdBills);
    }

    @Override
    public boolean validateDuplicateWithCertificate(long certificateTypeId, String certificateNumber) {
        QFilter qFilter = new QFilter("certificatetype", "=", (Object)certificateTypeId);
        qFilter.and("certificatenumber", "=", (Object)certificateNumber);
        HashSet enrollStatusSet = Sets.newHashSetWithExpectedSize((int)2);
        enrollStatusSet.add(OnbrdStatusEnum.WAIT_START.toString());
        enrollStatusSet.add(OnbrdStatusEnum.WAIT_ONBRD.toString());
        qFilter.and("enrollstatus", "in", (Object)enrollStatusSet);
        Object[] onbrdBills = IOnbrdBillDomainService.getInstance().findOnbrdBills("candidate", new QFilter[]{qFilter});
        return !HRArrayUtils.isEmpty((Object[])onbrdBills);
    }

    @Override
    public void showMutexMsgWithOnbrdBill(IFormView formView, Collection<Long> onbrdBillIds, String opName) {
        QFilter qFilter = new QFilter("id", "in", onbrdBillIds);
        Object[] onbrdBills = IOnbrdBillDomainService.getInstance().findOnbrdBills("name", new QFilter[]{qFilter});
        if (HRArrayUtils.isEmpty((Object[])onbrdBills)) {
            return;
        }
        StringBuilder nameStr = new StringBuilder();
        Stream.of(onbrdBills).forEach(onbrdBill -> nameStr.append(onbrdBill.getLocaleString("name").getLocaleValue()).append(','));
        String name = nameStr.substring(0, nameStr.length() - 1);
        formView.showErrorNotification(String.format(ResManager.loadKDString((String)"%1$s\u7684\u4fe1\u606f\u6b63\u5728\u88ab\u7f16\u8f91\uff0c\u65e0\u6cd5\u6267\u884c\u201c%2$s\u201d\u64cd\u4f5c\u3002", (String)"OnbrdCommonAppServiceImpl_0", (String)"hr-hom-business", (Object[])new Object[0]), name, opName));
    }

    @Override
    public DynamicObject getOnBrdDyo(long onbrdId, String properties) {
        return IOnbrdBillDomainService.getInstance().findOnbrdBillById(properties, onbrdId);
    }

    @Override
    public Map<Long, Boolean> refreshOnbrdCondition(Long[] onbrdIds) {
        logger.info("Start refreshOnbrdCondition");
        if (HRArrayUtils.isEmpty((Object[])onbrdIds)) {
            return new HashMap<Long, Boolean>();
        }
        HashMap result = Maps.newHashMapWithExpectedSize((int)onbrdIds.length);
        QFilter qFilter = new QFilter("id", "in", (Object)onbrdIds);
        String properties = "iseligibleonboard" + ',' + "preenrollstatus";
        DynamicObject[] onbrdInfos = IOnbrdBillDomainService.getInstance().findOnbrdBills(properties, new QFilter[]{qFilter});
        QFilter onbrdFilter = new QFilter("onbrd", "in", (Object)onbrdIds);
        DynamicObject[] activityOverviewDys = IActivityDomainService.getInstance().findActivityInfos("id,onbrd.id,activityscheme,entryentity.activity,entryentity.activityins,entryentity.taskstatus,entryentity.createtime,entryentity.latestdeadline,entryentity.bindbizbillid", onbrdFilter);
        Map<Long, DynamicObject> activityInfoMap = Stream.of(activityOverviewDys).collect(Collectors.toMap(activityInfo -> activityInfo.getDynamicObject("onbrd").getLong("id"), activityInfo -> activityInfo, (oldValue, newValue) -> newValue));
        Map<Long, String> appointStatusMap = Stream.of(onbrdInfos).collect(Collectors.toMap(onbrdBill -> onbrdBill.getLong("id"), onbrdBill -> onbrdBill.getString("preenrollstatus"), (oldValue, newValue) -> newValue));
        DynamicObject[] collectActivitys = HomCommonRepository.queryDynamicObjects("hom_collect", "onboard,collectstatus,approvestatus,acceptstatus", new QFilter("onboard", "in", (Object)onbrdIds));
        Map<Long, String> collectStatusMap = Stream.of(collectActivitys).collect(Collectors.toMap(collectInfo -> collectInfo.getLong("onboard.id"), collectInfo -> collectInfo.getString("collectstatus"), (oldValue, newValue) -> newValue));
        Map<Long, String> auditStatusMap = Stream.of(collectActivitys).collect(Collectors.toMap(collectInfo -> collectInfo.getLong("onboard.id"), collectInfo -> collectInfo.getString("approvestatus"), (oldValue, newValue) -> newValue));
        Map<Long, String> acceptanceStatusMap = Stream.of(collectActivitys).collect(Collectors.toMap(collectInfo -> collectInfo.getLong("onboard.id"), collectInfo -> collectInfo.getString("acceptstatus"), (oldValue, newValue) -> newValue));
        for (DynamicObject onbrdBill2 : onbrdInfos) {
            Long onbrdId = onbrdBill2.getLong("id");
            DynamicObject activityOverviewDy = activityInfoMap.get(onbrdId);
            if (HRObjectUtils.isEmpty((Object)activityOverviewDy)) {
                onbrdBill2.set("iseligibleonboard", (Object)Boolean.TRUE);
                result.put(onbrdId, Boolean.TRUE);
                continue;
            }
            DynamicObjectCollection entryEntityDys = activityOverviewDy.getDynamicObjectCollection("entryentity");
            Boolean isEligibleOnboard = this.isEligibleOnboard(entryEntityDys, appointStatusMap.get(onbrdId), collectStatusMap.get(onbrdId), auditStatusMap.get(onbrdId), acceptanceStatusMap.get(onbrdId));
            onbrdBill2.set("iseligibleonboard", (Object)isEligibleOnboard);
            result.put(onbrdId, isEligibleOnboard);
        }
        IOnbrdBillDomainService.getInstance().saveOnbrdBillInfos(onbrdInfos);
        logger.info("End refreshOnbrdCondition");
        return result;
    }

    @Override
    public Optional<String> validatePhone(String phone) {
        if (HRStringUtils.isEmpty((String)phone)) {
            return Optional.empty();
        }
        String validateErrorMsg = ResManager.loadKDString((String)"\u201c\u8054\u7cfb\u7535\u8bdd\u201d\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u8bf7\u4fee\u6539\u3002", (String)"OnbrdCommonAppServiceImpl_7", (String)"hr-hom-business", (Object[])new Object[0]);
        try {
            TelephoneParseResult telephoneParseResult = I18nServiceHelper.parseTelephone((String)phone);
            if (telephoneParseResult == null || !telephoneParseResult.isSuccess()) {
                logger.info("Fail I18nServiceHelper.parseTelephone");
                return Optional.of(validateErrorMsg);
            }
            Map validateResult = I18nServiceHelper.verifyTelephoneNumberFormat((String)telephoneParseResult.getTelephone(), (String[])telephoneParseResult.getCountryList().toArray(new String[0]));
            if (validateResult != null) {
                logger.info("validateResult:" + JSONObject.toJSONString((Object)validateResult));
            }
            if (validateResult == null || !Boolean.parseBoolean(validateResult.getOrDefault("code", Boolean.TRUE.toString()))) {
                logger.info("Fail I18nServiceHelper.verifyTelephoneNumberFormat");
                return Optional.of(validateErrorMsg);
            }
        }
        catch (Exception exception) {
            logger.error((Throwable)exception);
            return Optional.of(validateErrorMsg);
        }
        if (phone.length() > 30) {
            String msg = ResManager.loadKDString((String)"\u5b57\u6bb5\u201c\u8054\u7cfb\u7535\u8bdd\u201d\u8f93\u5165\u957f\u5ea6\u8d85\u51fa\u9650\u5b9a\u8303\u56f4[0\uff0c30]\uff0c\u8bf7\u4fee\u6539\u3002", (String)"OnbrdCommonAppServiceImpl_2", (String)"hr-hom-business", (Object[])new Object[0]);
            return Optional.of(msg);
        }
        return Optional.empty();
    }

    @Override
    public Optional<String> validatePhone(String phone, String fieldName) {
        if (HRStringUtils.isEmpty((String)phone)) {
            return Optional.empty();
        }
        String validateErrorMsg = MessageFormat.format(ResManager.loadKDString((String)"{0}\u683c\u5f0f\u9519\u8bef\uff0c\u8bf7\u91cd\u65b0\u586b\u5199;", (String)"OnbrdCommonAppServiceImpl_11", (String)"hr-hom-business", (Object[])new Object[0]), fieldName);
        try {
            TelephoneParseResult telephoneParseResult = I18nServiceHelper.parseTelephone((String)phone);
            if (telephoneParseResult == null || !telephoneParseResult.isSuccess()) {
                logger.info("Fail I18nServiceHelper.parseTelephone");
                return Optional.of(validateErrorMsg);
            }
            Map validateResult = I18nServiceHelper.verifyTelephoneNumberFormat((String)telephoneParseResult.getTelephone(), (String[])telephoneParseResult.getCountryList().toArray(new String[0]));
            if (validateResult != null) {
                logger.info("validateResult:" + JSONObject.toJSONString((Object)validateResult));
            }
            if (validateResult == null || !Boolean.parseBoolean(validateResult.getOrDefault("code", Boolean.TRUE.toString()))) {
                logger.info("Fail I18nServiceHelper.verifyTelephoneNumberFormat");
                return Optional.of(validateErrorMsg);
            }
        }
        catch (Exception exception) {
            logger.error((Throwable)exception);
            return Optional.of(validateErrorMsg);
        }
        if (phone.length() > 30) {
            String msg = ResManager.loadKDString((String)"\u5b57\u6bb5\u201c\u8054\u7cfb\u7535\u8bdd\u201d\u8f93\u5165\u957f\u5ea6\u8d85\u51fa\u9650\u5b9a\u8303\u56f4[0\uff0c30]\uff0c\u8bf7\u4fee\u6539\u3002", (String)"OnbrdCommonAppServiceImpl_2", (String)"hr-hom-business", (Object[])new Object[0]);
            return Optional.of(msg);
        }
        return Optional.empty();
    }

    @Override
    public Optional<String> checkAccount(String account) {
        Pattern pattern = Pattern.compile("\\d{13,19}");
        Matcher isNum = pattern.matcher(account);
        if (!isNum.matches()) {
            String msg = ResManager.loadKDString((String)"\u94f6\u884c\u5361\u53f7\u5e94\u4e3a13-19\u4f4d\u6570\u5b57\uff0c\u8bf7\u4fee\u6539\u3002", (String)"Bankcard_4", (String)"hr-hom-formplugin", (Object[])new Object[0]);
            return Optional.of(msg);
        }
        return Optional.empty();
    }

    @Override
    public Optional<String> validateEmail(String email) {
        if (HRStringUtils.isEmpty((String)email)) {
            return Optional.empty();
        }
        if (email.length() > 100) {
            String msg = ResManager.loadKDString((String)"\u5b57\u6bb5\u201c\u90ae\u7bb1\u201d\u8f93\u5165\u957f\u5ea6\u8d85\u51fa\u9650\u5b9a\u8303\u56f4[0\uff0c100]\uff0c\u8bf7\u4fee\u6539\u3002", (String)"OnbrdCommonAppServiceImpl_3", (String)"hr-hom-business", (Object[])new Object[0]);
            return Optional.of(msg);
        }
        if (!StringUtils.isEmail((String)email)) {
            String msg = ResManager.loadKDString((String)"\u201c\u7535\u5b50\u90ae\u7bb1\u201d\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u8bf7\u4fee\u6539\u3002", (String)"OnbrdCommonAppServiceImpl_6", (String)"hr-hom-business", (Object[])new Object[0]);
            return Optional.of(msg);
        }
        return Optional.empty();
    }

    @Override
    public Optional<String> validateEmail(String email, String emailName) {
        if (HRStringUtils.isEmpty((String)email)) {
            return Optional.empty();
        }
        if (email.length() > 100) {
            String msg = MessageFormat.format(ResManager.loadKDString((String)"\u5b57\u6bb5\u201c{0}\u201d\u8f93\u5165\u957f\u5ea6\u8d85\u51fa\u9650\u5b9a\u8303\u56f4[0\uff0c100]\u3002", (String)"CollectFieldVerifyServiceImpl_20", (String)"hr-hom-business", (Object[])new Object[0]), emailName);
            return Optional.of(msg);
        }
        if (!StringUtils.isEmail((String)email)) {
            String msg = MessageFormat.format(ResManager.loadKDString((String)"\u5b57\u6bb5\u201c{0}\u201d\u683c\u5f0f\u9519\u8bef\uff0c\u8bf7\u91cd\u65b0\u586b\u5199\u3002", (String)"CollectFieldVerifyServiceImpl_21", (String)"hr-hom-business", (Object[])new Object[0]), emailName);
            return Optional.of(msg);
        }
        return Optional.empty();
    }

    @Override
    public Optional<String> validateCertificateNum(DynamicObject credentialsType, String credentialsNumber) {
        boolean isPass = new CertificatePageServiceImpl().validateCreNumber(credentialsType, credentialsNumber);
        if (!isPass) {
            String msg = ResManager.loadKDString((String)"\u8bc1\u4ef6\u53f7\u7801\u683c\u5f0f\u6709\u8bef\uff0c\u8bf7\u91cd\u65b0\u586b\u5199\u3002", (String)"OnbrdCommonAppServiceImpl_5", (String)"hr-hom-business", (Object[])new Object[0]);
            return Optional.of(msg);
        }
        return Optional.empty();
    }

    @Override
    public boolean checkPermission(String entityNum, String permItemId) {
        return this.checkPermission(entityNum, permItemId, "hom");
    }

    @Override
    public boolean checkPermission(String entityNum, String permItemId, String appId) {
        Long userId = RequestContext.get().getCurrUserId();
        return PermissionServiceHelper.checkPermission((Long)userId, (String)appId, (String)entityNum, (String)permItemId);
    }

    @Override
    public boolean checkPermissionByNum(String entityId, String permNumber) {
        return IOnbrdCommonAppService.getInstance().checkPermission(entityId, IHomToHrcsAppService.getInstance().getPermPermitemId(permNumber));
    }

    @Override
    public boolean checkPermissionAndShowTips(String entityNum, String permItemId, IFormView formView) {
        String appId = formView.getFormShowParameter().getAppId();
        if (this.checkPermission(entityNum, permItemId, appId)) {
            logger.info("checkPermission pass " + entityNum + ',' + permItemId + ',' + RequestContext.get().getCurrUserId());
            return true;
        }
        String entityName = FormMetadataCache.getFormConfig((String)entityNum).getCaption().getLocaleValue();
        String permItemName = IBaseDataDomainService.getInstance().getPermItemNameById(permItemId);
        String msg = String.format(ResManager.loadKDString((String)"\u6ca1\u6709\u201c%1$s\u201d\u529f\u80fd\u7684\u201c%2$s\u201d\u64cd\u4f5c\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"OnbrdCommonAppServiceImpl_8", (String)"hr-hom-business", (Object[])new Object[0]), entityName, permItemName);
        logger.error(msg);
        formView.showErrorNotification(msg);
        return false;
    }

    @Override
    public boolean tryRequireLockWithOnbrdBill(Long onbrdId, IFormView formView, String childPageNum) {
        if (onbrdId == null || onbrdId == 0L) {
            return false;
        }
        boolean flag = IHomDataMutexService.getInstance().requireLock(onbrdId.toString(), "hom_onbrdinfo", formView, "modify", false, "1");
        if (flag) {
            IHRAppCache cache = HRAppCache.get((String)KEY_DATAMUTEX_ONBRDBILL);
            JSONObject jsonObject = (JSONObject)cache.get(onbrdId.toString(), JSONObject.class);
            if (jsonObject == null || jsonObject.isEmpty()) {
                jsonObject = new JSONObject();
                IHRAppCache userIdCache = HRAppCache.get((String)KEY_DATAMUTEX_USERID);
                userIdCache.put(onbrdId.toString(), (Object)RequestContext.get().getCurrUserId());
            }
            jsonObject.put(childPageNum, (Object)System.currentTimeMillis());
            jsonObject.put("user", (Object)RequestContext.get().getCurrUserId());
            cache.put(onbrdId.toString(), (Object)jsonObject);
            logger.info(jsonObject.toJSONString());
            logger.info(childPageNum + " Require_lock_cache_childview:" + onbrdId);
        }
        return flag;
    }

    @Override
    public boolean releaseLockWithOnbrdBill(Long onbrdId, String childPageNum) {
        IHRAppCache cache = HRAppCache.get((String)KEY_DATAMUTEX_ONBRDBILL);
        JSONObject jsonObject = (JSONObject)cache.get(onbrdId.toString(), JSONObject.class);
        Long userId = null;
        if (jsonObject != null && !jsonObject.isEmpty()) {
            if (jsonObject.get((Object)"user") != null) {
                userId = Long.valueOf(jsonObject.get((Object)"user").toString());
            }
            Long currUserId = RequestContext.get().getCurrUserId();
            if (userId == null || currUserId == null || currUserId.compareTo(userId) != 0) {
                return false;
            }
            jsonObject.remove((Object)childPageNum);
            jsonObject.remove((Object)"user");
            logger.info(jsonObject.toJSONString());
            logger.info(childPageNum + " remove_lock_cache_childview:" + onbrdId);
            cache.put(onbrdId.toString(), (Object)jsonObject);
        }
        if (jsonObject == null || jsonObject.isEmpty()) {
            cache.remove(onbrdId.toString());
            IHRAppCache userIdCache = HRAppCache.get((String)KEY_DATAMUTEX_USERID);
            userIdCache.remove(onbrdId.toString());
            logger.info("release_lock_by_allchildview:" + onbrdId);
            return IHomDataMutexService.getInstance().release(onbrdId.toString(), "hom_onbrdinfo", "modify");
        }
        logger.info("cannot release_lock_by_allchildview:" + onbrdId);
        return false;
    }

    @Override
    @Deprecated
    public boolean releaseLockWithOnbrdBill(Long onbrdId) {
        if (onbrdId == null || onbrdId == 0L) {
            return false;
        }
        IHRAppCache userIdCache = HRAppCache.get((String)KEY_DATAMUTEX_USERID);
        Long userId = (Long)userIdCache.get(onbrdId.toString(), Long.class);
        long currentUserId = RequestContext.get().getCurrUserId();
        if (userId == null || userId != currentUserId) {
            return false;
        }
        logger.info(userId.toString() + " releaseLockWithOnbrdBill:" + onbrdId);
        userIdCache.remove(onbrdId.toString());
        IHRAppCache cache = HRAppCache.get((String)KEY_DATAMUTEX_ONBRDBILL);
        cache.remove(onbrdId.toString());
        return IHomDataMutexService.getInstance().release(onbrdId.toString(), "hom_onbrdinfo", "edit");
    }

    @Override
    public Map<Long, DynamicObject> getActivityInsInfoMap(Collection<Long> onbrdIds, String activityNumber) {
        DynamicObject[] activityOverviewDys;
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)onbrdIds.size());
        QFilter onbrdFilter = new QFilter("onbrd", "in", onbrdIds);
        for (DynamicObject activityOverviewDy : activityOverviewDys = IActivityDomainService.getInstance().findActivityInfos(PROPERTIES_ACTIVITYINFO, onbrdFilter)) {
            Long onbrdId = activityOverviewDy.getDynamicObject("onbrd").getLong("id");
            DynamicObject activityInsDy = this.getActivityInsDy(activityOverviewDy, activityNumber);
            if (HRObjectUtils.isEmpty((Object)activityInsDy)) {
                logger.info(onbrdId.toString() + " activityInsDy is empty " + activityOverviewDy.getString("id"));
                continue;
            }
            resultMap.put(onbrdId, activityInsDy);
        }
        return resultMap;
    }

    @Override
    public Map<Long, DynamicObject> getActivityInsInfoMap(Collection<Long> onbrdIds, Long activityId) {
        DynamicObject[] activityOverviewDys;
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)onbrdIds.size());
        QFilter onbrdFilter = new QFilter("onbrd", "in", onbrdIds);
        for (DynamicObject activityOverviewDy : activityOverviewDys = IActivityDomainService.getInstance().findActivityInfos(PROPERTIES_ACTIVITYINFO, onbrdFilter)) {
            Long onbrdId = activityOverviewDy.getDynamicObject("onbrd").getLong("id");
            DynamicObject activityInsDy = this.getActivityInsDy(activityOverviewDy, activityId);
            if (HRObjectUtils.isEmpty((Object)activityInsDy)) {
                logger.info(onbrdId.toString() + " activityInsDy is empty " + activityOverviewDy.getString("id"));
                continue;
            }
            resultMap.put(onbrdId, activityInsDy);
        }
        return resultMap;
    }

    private DynamicObject getActivityInsDy(DynamicObject activityOverviewDy, String activityNumber) {
        DynamicObjectCollection entryEntityDys = activityOverviewDy.getDynamicObjectCollection("entryentity");
        for (DynamicObject entryEntityDy : entryEntityDys) {
            String entryActivityNumber = entryEntityDy.getString("activity.number");
            if (!HRStringUtils.equals((String)activityNumber, (String)entryActivityNumber)) continue;
            DynamicObject activityInsDy = entryEntityDy.getDynamicObject("activityins");
            logger.info("activityNumber:" + activityNumber + ",entryActivityNumber:" + entryActivityNumber);
            if (HRObjectUtils.isEmpty((Object)activityInsDy)) {
                logger.info("entryEntityId:" + entryEntityDy.getString("id") + " activityInsDy is empty:" + entryEntityDy.getString("activityins_id"));
                continue;
            }
            return activityInsDy;
        }
        return null;
    }

    private DynamicObject getActivityInsDy(DynamicObject activityOverviewDy, Long activityId) {
        DynamicObjectCollection entryEntityDys = activityOverviewDy.getDynamicObjectCollection("entryentity");
        for (DynamicObject entryEntityDy : entryEntityDys) {
            Long entryActivityId = entryEntityDy.getLong("activity.id");
            if (!activityId.equals(entryActivityId)) continue;
            DynamicObject activityInsDy = entryEntityDy.getDynamicObject("activityins");
            logger.info("activityId:" + activityId + ",entryActivityId:" + entryActivityId);
            if (HRObjectUtils.isEmpty((Object)activityInsDy)) {
                logger.info("entryEntityId:" + entryEntityDy.getString("id") + " activityInsDy is empty:" + entryEntityDy.getString("activityins_id"));
                continue;
            }
            return activityInsDy;
        }
        return null;
    }

    @Override
    public Map<Long, String> getActTaskStatusMap(Collection<Long> onbrdIds, String activityNumber) {
        Map<Long, DynamicObject> activityInsInfoMap = this.getActivityInsInfoMap(onbrdIds, activityNumber);
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)onbrdIds.size());
        for (Map.Entry<Long, DynamicObject> entry : activityInsInfoMap.entrySet()) {
            DynamicObject activityInsDy = entry.getValue();
            if (HRObjectUtils.isEmpty((Object)activityInsDy)) {
                logger.info("activityInsDy is empty");
                continue;
            }
            resultMap.put(entry.getKey(), activityInsDy.getString("taskstatus"));
        }
        return resultMap;
    }

    @Override
    public Map<Long, String> getActTaskStatusMap(Collection<Long> onbrdIds, Long activityId) {
        Map<Long, DynamicObject> activityInsInfoMap = this.getActivityInsInfoMap(onbrdIds, activityId);
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)onbrdIds.size());
        for (Map.Entry<Long, DynamicObject> entry : activityInsInfoMap.entrySet()) {
            DynamicObject activityInsDy = entry.getValue();
            if (HRObjectUtils.isEmpty((Object)activityInsDy)) {
                logger.info("activityInsDy is empty");
                continue;
            }
            resultMap.put(entry.getKey(), activityInsDy.getString("taskstatus"));
        }
        return resultMap;
    }

    @Override
    public String getActTaskStatus(Long onbrdId, String activityNumber) {
        Map<Long, String> actTaskStatusMap = this.getActTaskStatusMap((Collection<Long>)ImmutableSet.of((Object)onbrdId), activityNumber);
        return actTaskStatusMap.get(onbrdId);
    }

    @Override
    public String getActTaskStatus(Long onbrdId, Long activityId) {
        Map<Long, String> actTaskStatusMap = this.getActTaskStatusMap((Collection<Long>)ImmutableSet.of((Object)onbrdId), activityId);
        return actTaskStatusMap.get(onbrdId);
    }

    @Override
    public String getPhoneVerifyCode() {
        SecureRandom random = new SecureRandom();
        StringBuilder verifyCode = new StringBuilder();
        for (int i = 0; i < 6; ++i) {
            verifyCode.append(random.nextInt(10));
        }
        return verifyCode.toString();
    }

    @Override
    public Map<Long, String> getMobLoginConfigMap(Collection<Long> onbrdIds) {
        HashMap mobLoginConfigMap = Maps.newHashMapWithExpectedSize((int)onbrdIds.size());
        Map<Long, Long> onbrdLoginConfigIdMap = this.getOnbrdLoginConfigIdMap(onbrdIds);
        Map<Long, DynamicObject> loginConfigInfoMap = IBaseDataDomainService.getInstance().getLoginConfigById(onbrdLoginConfigIdMap.values(), "number");
        for (Map.Entry<Long, Long> entry : onbrdLoginConfigIdMap.entrySet()) {
            DynamicObject loginConfig = loginConfigInfoMap.get(entry.getValue());
            mobLoginConfigMap.put(entry.getKey(), loginConfig.getString("number"));
        }
        return mobLoginConfigMap;
    }

    @Override
    public Map<Long, Long> getOnbrdLoginConfigIdMap(Collection<Long> onbrdIds) {
        QFilter qFilter = new QFilter("id", "in", onbrdIds);
        DynamicObject[] onbrdBills = IOnbrdBillDomainService.getInstance().findOnbrdBills(null, new QFilter[]{qFilter});
        HashMap onbrdLoginConfigIdMap = Maps.newHashMapWithExpectedSize((int)onbrdIds.size());
        IHomRuleEngineService service = ServiceFactory.getService(IHomRuleEngineService.class);
        for (DynamicObject onbrdBill : onbrdBills) {
            String buNumber = onbrdBill.getString("org.number");
            HashMap map = Maps.newHashMapWithExpectedSize((int)2);
            map.put("onbrdbill", onbrdBill);
            try {
                Map<String, Object> resultResp = service.callRuleEngineResult(RuleEngineSceneNumberEnum.HOMSCE_LOGIN_CONGIF.getSceneNumber(), buNumber, map);
                if (!HRObjectUtils.isEmpty(resultResp)) {
                    DynamicObject loginConfig = (DynamicObject)resultResp.get("result");
                    onbrdLoginConfigIdMap.put(onbrdBill.getLong("id"), loginConfig.getLong("id"));
                    continue;
                }
                logger.error("\u89c4\u5219\u5f15\u64ce\u83b7\u53d6\u767b\u5f55\u914d\u7f6e\u65b9\u6848\u5931\u8d25");
            }
            catch (Exception exception) {
                logger.error("\u89c4\u5219\u5f15\u64ce\u83b7\u53d6\u767b\u5f55\u914d\u7f6e\u65b9\u6848\u5931\u8d25", (Throwable)exception);
            }
        }
        return onbrdLoginConfigIdMap;
    }

    @Override
    public Map<Long, Map<String, Object>> onbrdToRuleEngineResult(DynamicObject[] onbrdBills, RuleEngineSceneNumberEnum ruleEngineSceneNumberEnum) {
        HashMap onbrdLoginConfigIdMap = Maps.newHashMapWithExpectedSize((int)onbrdBills.length);
        IHomRuleEngineService service = ServiceFactory.getService(IHomRuleEngineService.class);
        for (DynamicObject onbrdBill : onbrdBills) {
            String buNumber = onbrdBill.getString("org.number");
            HashMap map = Maps.newHashMapWithExpectedSize((int)2);
            map.put("onbrdbill", onbrdBill);
            try {
                Map<String, Object> resultResp = service.callRuleEngineResult(ruleEngineSceneNumberEnum.getSceneNumber(), buNumber, map);
                if (!HRObjectUtils.isEmpty(resultResp)) {
                    onbrdLoginConfigIdMap.put(onbrdBill.getLong("id"), resultResp);
                    continue;
                }
                logger.error("\u89c4\u5219\u5f15\u64ce\u83b7\u53d6\u767b\u5f55\u914d\u7f6e\u65b9\u6848\u5931\u8d25");
            }
            catch (Exception exception) {
                logger.error("\u89c4\u5219\u5f15\u64ce\u83b7\u53d6\u767b\u5f55\u914d\u7f6e\u65b9\u6848\u5931\u8d25", (Throwable)exception);
            }
        }
        return onbrdLoginConfigIdMap;
    }

    @Override
    public String getMobLoginUrl(Long onbrdId) {
        Map<Long, String> mobLoginConfigMap = this.getMobLoginConfigMap((Collection<Long>)ImmutableSet.of((Object)onbrdId));
        return this.getMobLoginUrls(mobLoginConfigMap).get(onbrdId);
    }

    @Override
    public Map<Long, String> getMobLoginUrls(Map<Long, String> mobLoginConfigMap) {
        DynamicObject[] onbrdBills;
        HashMap mobLoginUrlMap = Maps.newHashMapWithExpectedSize((int)mobLoginConfigMap.size());
        QFilter qFilter = new QFilter("id", "in", mobLoginConfigMap.keySet());
        String properties = "id" + ',' + "candidate";
        for (DynamicObject onbrdBill : onbrdBills = IOnbrdBillDomainService.getInstance().findOnbrdBills(properties, new QFilter[]{qFilter})) {
            Long onbrdBillId = onbrdBill.getLong("id");
            String loginConfigNumber = mobLoginConfigMap.get(onbrdBillId);
            String accountId = RequestContext.get().getAccountId();
            String bizUserId = onbrdBill.getString("candidate.id");
            logger.info("loginConfigNumber:" + loginConfigNumber);
            mobLoginUrlMap.put(onbrdBill.getLong("id"), HrGuestUrlUtil.getMobileHtmlUrl((String)accountId, (String)loginConfigNumber, (String)bizUserId, (String)""));
        }
        return mobLoginUrlMap;
    }

    @Override
    public String transToSafeLoginUrl(String mobileHtmlUrl, String safeTimeConfigNumber, String candidateId) {
        SafeUrlDTO safeUrlDTO = (SafeUrlDTO)DispatchServiceHelper.invokeBizService((String)"hrmp", (String)"hbss", (String)"IHBSSSafeUrlService", (String)"longToShortByConfig", (Object[])new Object[]{mobileHtmlUrl, safeTimeConfigNumber, candidateId});
        logger.info(safeUrlDTO.toString());
        return safeUrlDTO.getSafeUrl();
    }

    @Override
    public String transToSafeLoginUrl(String mobileHtmlUrl, String safeTimeConfigNumber, String candidateId, Map<String, Object> args) {
        SafeUrlDTO safeUrlDTO = (SafeUrlDTO)DispatchServiceHelper.invokeBizService((String)"hrmp", (String)"hbss", (String)"IHBSSSafeUrlService", (String)"longToShortByConfigByArg", (Object[])new Object[]{mobileHtmlUrl, safeTimeConfigNumber, candidateId, args});
        logger.info(safeUrlDTO.toString());
        return safeUrlDTO.getSafeUrl();
    }

    @Override
    public Optional<String> validateCheckinInfo(DynamicObject dynamicObject) {
        Date effectDate = HRDateTimeUtils.truncateDate((Date)dynamicObject.getDate("effectdate"));
        DynamicObject onbrdtCity = dynamicObject.getDynamicObject("onbrdtcity");
        if (effectDate != null && onbrdtCity == null) {
            String msg = ResManager.loadKDString((String)"\u8bf7\u5b8c\u6574\u5f55\u5165\u62a5\u5230\u4fe1\u606f\u201c\u5165\u804c\u5730\u70b9\u201d\u3002", (String)"OnbrdCommonAppServiceImpl_9", (String)"hr-hom-business", (Object[])new Object[0]);
            return Optional.of(msg);
        }
        if (effectDate == null && onbrdtCity != null) {
            String msg = ResManager.loadKDString((String)"\u8bf7\u5b8c\u6574\u5f55\u5165\u62a5\u5230\u4fe1\u606f\u201c\u5165\u804c\u65e5\u671f\u201d\u3002", (String)"OnbrdCommonAppServiceImpl_10", (String)"hr-hom-business", (Object[])new Object[0]);
            return Optional.of(msg);
        }
        return Optional.empty();
    }

    @Override
    public Map<Long, String> checkPersonIfExisted(DynamicObject[] onbrdBills) {
        ArrayList<String> fieldList = new ArrayList<String>(8);
        fieldList.add("certificatetype.id");
        fieldList.add("certificatenumber");
        fieldList.add("employeeno");
        fieldList.add("peremail");
        fieldList.add("phone");
        return IHomToHrpiAppService.getInstance().validAllPersonWithTip(Arrays.asList(onbrdBills), fieldList);
    }

    private Boolean isEligibleOnboard(DynamicObjectCollection entryEntityDys, String appointStatus, String collectStatus, String auditStatus, String acceptanceStatus) {
        boolean checkinIfStarted = false;
        boolean appointmentIfPass = true;
        boolean collectionIfPass = true;
        boolean auditIfPass = true;
        boolean acceptanceIfPass = true;
        for (DynamicObject entryEntityDy : entryEntityDys) {
            DynamicObject activityDy = entryEntityDy.getDynamicObject("activity");
            Long activityId = activityDy.getLong("id");
            logger.info("activityId:" + activityId);
            DynamicObject activityInsDy = entryEntityDy.getDynamicObject("activityins");
            if (HRObjectUtils.isEmpty((Object)activityInsDy)) continue;
            String taskStatus = activityInsDy.getString("taskstatus");
            logger.info("taskStatus:" + taskStatus);
            boolean waitAssign = HRStringUtils.equals((String)ActivityStatusEnum.TOASSIGN.getValue(), (String)taskStatus);
            if (waitAssign) continue;
            if (ActivityNumberEnum.APPOINTMENT.getId().equals(activityId)) {
                appointmentIfPass = HRStringUtils.equals((String)PreEnrollStatusEnum.HAS_RESERVATION.getValue(), (String)appointStatus);
                continue;
            }
            if (ActivityNumberEnum.INFOCOLLECTION.getId().equals(activityId)) {
                collectionIfPass = HRStringUtils.equals((String)CollectManageStatusEnum.FINISH.getStatus(), (String)collectStatus);
                continue;
            }
            if (ActivityNumberEnum.INFOAUDIT.getId().equals(activityId)) {
                auditIfPass = HRStringUtils.equals((String)CollectApproveStatusEnum.PASS.getStatus(), (String)auditStatus);
                continue;
            }
            if (ActivityNumberEnum.DATAACCEPTANCE.getId().equals(activityId)) {
                acceptanceIfPass = HRStringUtils.equals((String)AcceptManageEnum.ACCEPTMANAGEPASS.getStatus(), (String)acceptanceStatus);
                continue;
            }
            if (!ActivityNumberEnum.CHECKININFO.getId().equals(activityId)) continue;
            checkinIfStarted = true;
            break;
        }
        if (checkinIfStarted && appointmentIfPass && collectionIfPass && auditIfPass && acceptanceIfPass) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    @Override
    public String validCandidate(Set<Long> candidateId) {
        if (CollectionUtils.isEmpty(candidateId)) {
            return null;
        }
        QFilter qFilter = new QFilter("candidate", "in", candidateId);
        HashSet enrollStatusSet = Sets.newHashSetWithExpectedSize((int)3);
        enrollStatusSet.add(OnbrdStatusEnum.WAIT_START.toString());
        enrollStatusSet.add(OnbrdStatusEnum.WAIT_ONBRD.toString());
        enrollStatusSet.add(OnbrdStatusEnum.HAS_ONBRD.toString());
        qFilter.and("enrollstatus", "in", (Object)enrollStatusSet).and("synchstatus", "!=", (Object)SynchStatusEnum.SYNCH_SUCCESS.getValue());
        Object[] onbrdBillDBs = IOnbrdBillDomainService.getInstance().findOnbrdBills("candidatenumber", new QFilter[]{qFilter});
        String candidateNumStr = null;
        if (!HRArrayUtils.isEmpty((Object[])onbrdBillDBs)) {
            StringBuilder candidateNums = new StringBuilder();
            for (Object onbrdBill : onbrdBillDBs) {
                candidateNums.append(onbrdBill.getString("candidatenumber")).append(' ');
            }
            candidateNumStr = candidateNums.toString().trim();
        }
        return candidateNumStr;
    }

    @Override
    public String validPhoneAndNum(DynamicObject dynamicObjectPage, String key, String value) {
        DynamicObject credentialsType;
        if (HRStringUtils.isEmpty((String)value)) {
            return null;
        }
        QFilter qFilter = "personfield".equals(key) ? new QFilter(key, "=", (Object)Long.valueOf(value)) : new QFilter(key, "=", (Object)value);
        HashSet enrollStatusSet = Sets.newHashSetWithExpectedSize((int)3);
        enrollStatusSet.add(OnbrdStatusEnum.WAIT_START.toString());
        enrollStatusSet.add(OnbrdStatusEnum.WAIT_ONBRD.toString());
        enrollStatusSet.add(OnbrdStatusEnum.HAS_ONBRD.toString());
        qFilter.and("enrollstatus", "in", (Object)enrollStatusSet).and("synchstatus", "!=", (Object)SynchStatusEnum.SYNCH_SUCCESS.getValue());
        if (key.equals("certificatenumber") && !HRObjectUtils.isEmpty((Object)(credentialsType = dynamicObjectPage.getDynamicObject("certificatetype")))) {
            qFilter.and("certificatetype", "=", (Object)credentialsType.getLong("id"));
        }
        Object[] onbrdBillDBs = IOnbrdBillDomainService.getInstance().findOnbrdBills("candidatenumber", new QFilter[]{qFilter});
        String candidateNumStr = null;
        int count = 0;
        if (!HRArrayUtils.isEmpty((Object[])onbrdBillDBs)) {
            StringBuilder candidateNums = new StringBuilder();
            for (Object onbrdBill : onbrdBillDBs) {
                if (onbrdBill.getLong("id") == dynamicObjectPage.getLong("id")) continue;
                if (count == 0) {
                    candidateNums.append(onbrdBill.getString("candidatenumber"));
                } else {
                    candidateNums.append(' ').append(onbrdBill.getString("candidatenumber"));
                }
                ++count;
            }
            candidateNumStr = candidateNums.toString();
        }
        return candidateNumStr;
    }

    @Override
    public Optional<String> vaildSameFieldByHom(String key, IFormView view) {
        DynamicObject onbrd = view.getModel().getDataEntity();
        String value = "";
        value = "personfield".equals(key) ? onbrd.getDynamicObject("personfield").getString("id") : onbrd.getString(key);
        if (HRStringUtils.isEmpty((String)value)) {
            return Optional.empty();
        }
        String candidateNumStr = IOnbrdCommonAppService.getInstance().validPhoneAndNum(onbrd, key, value);
        if (HRStringUtils.isNotEmpty((String)candidateNumStr)) {
            String msg = "";
            if (key.equals("peremail")) {
                msg = String.format(ResManager.loadKDString((String)"\u201c\u90ae\u7bb1\u201d\u4e0e\u5df2\u6709\u5019\u9009\u4eba\uff08\u5019\u9009\u4eba\u7f16\u53f7\u4e3a%s\uff09\u6570\u636e\u91cd\u590d\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"OnbrdInfoEdit_17", (String)"hr-hom-business", (Object[])new Object[0]), candidateNumStr);
            } else if (key.equals("employeeno")) {
                msg = String.format(ResManager.loadKDString((String)"\u201c\u5de5\u53f7\u201d\u4e0e\u5df2\u6709\u5019\u9009\u4eba\uff08\u5019\u9009\u4eba\u7f16\u53f7\u4e3a%s\uff09\u6570\u636e\u91cd\u590d\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"OnbrdInfoEdit_14", (String)"hr-hom-business", (Object[])new Object[0]), candidateNumStr);
            } else if (key.equals("phone")) {
                msg = String.format(ResManager.loadKDString((String)"\u201c\u8054\u7cfb\u7535\u8bdd\u201d\u4e0e\u5df2\u6709\u5019\u9009\u4eba\uff08\u5019\u9009\u4eba\u7f16\u53f7\u4e3a%s\uff09\u6570\u636e\u91cd\u590d\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"OnbrdInfoEdit_16", (String)"hr-hom-business", (Object[])new Object[0]), candidateNumStr);
            } else if (key.equals("certificatenumber")) {
                msg = String.format(ResManager.loadKDString((String)"\u201c\u8bc1\u4ef6\u53f7\u7801\u201d\u4e0e\u5df2\u6709\u5019\u9009\u4eba\uff08\u5019\u9009\u4eba\u7f16\u53f7\u4e3a%s\uff09\u6570\u636e\u91cd\u590d\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"OnbrdInfoEdit_15", (String)"hr-hom-business", (Object[])new Object[0]), candidateNumStr);
            } else if ("personfield".equals(key)) {
                msg = String.format(ResManager.loadKDString((String)"\u201c\u59d3\u540d\u201d\u4e0e\u5df2\u6709\u5019\u9009\u4eba\uff08\u5019\u9009\u4eba\u7f16\u53f7\u4e3a%s\uff09\u6570\u636e\u91cd\u590d\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"OnbrdInfoEdit_18", (String)"hr-hom-business", (Object[])new Object[0]), candidateNumStr);
            }
            if (!HRStringUtils.isEmpty((String)msg)) {
                view.showTipNotification(msg);
                return Optional.of(msg);
            }
        }
        return Optional.empty();
    }

    @Override
    public Set<DynamicObject> validSameFieldByHomForPre(List<String> validateFields, List<DynamicObject> onBrdList) {
        return IOnbrdCommonAppService.getInstance().batchValidField(onBrdList, validateFields);
    }

    @Override
    public boolean tryRequireLockWithOnbrdCheck(Long onbrdId, IFormView formView, String childPageNum) {
        if (onbrdId == null || onbrdId == 0L) {
            return false;
        }
        boolean flag = IHomDataMutexService.getInstance().requireLock(onbrdId.toString(), "hom_checkinbilltpl", formView, "save", false, "1");
        if (flag) {
            IHRAppCache cache = HRAppCache.get((String)KEY_DATAMUTEX_CHECK);
            JSONObject jsonObject = (JSONObject)cache.get(onbrdId.toString(), JSONObject.class);
            if (jsonObject == null || jsonObject.isEmpty()) {
                jsonObject = new JSONObject();
                IHRAppCache userIdCache = HRAppCache.get((String)KEY_DATAMUTEX_CHECK_USERID);
                userIdCache.put(onbrdId.toString(), (Object)RequestContext.get().getCurrUserId());
            }
            jsonObject.put(childPageNum, (Object)System.currentTimeMillis());
            cache.put(onbrdId.toString(), (Object)jsonObject);
            logger.info(jsonObject.toJSONString());
            logger.info(childPageNum + " Require_lock_cache_childview:" + onbrdId);
        }
        return flag;
    }

    @Override
    public boolean releaseLockWithOnbrdCheck(Long onbrdId, String childPageNum) {
        IHRAppCache cache = HRAppCache.get((String)KEY_DATAMUTEX_CHECK);
        JSONObject jsonObject = (JSONObject)cache.get(onbrdId.toString(), JSONObject.class);
        if (jsonObject != null && !jsonObject.isEmpty()) {
            jsonObject.remove((Object)childPageNum);
            logger.info(jsonObject.toJSONString());
            logger.info(childPageNum + " remove_lock_cache_childview:" + onbrdId);
            cache.put(onbrdId.toString(), (Object)jsonObject);
        }
        if (jsonObject == null || jsonObject.isEmpty()) {
            cache.remove(onbrdId.toString());
            IHRAppCache userIdCache = HRAppCache.get((String)KEY_DATAMUTEX_CHECK_USERID);
            userIdCache.remove(onbrdId.toString());
            logger.info("release_lock_by_allchildview:" + onbrdId);
            return IHomDataMutexService.getInstance().release(onbrdId.toString(), "hom_checkinbilltpl", "save");
        }
        logger.info("cannot release_lock_by_allchildview:" + onbrdId);
        return false;
    }

    @Override
    public String saveOnbrdLoginConfig(Long onbrdbillId, Map<Long, Long> onbrdLoginConfigIdMap) {
        IOnbrdBillDomainService onbrdBillDomainService = IOnbrdBillDomainService.getInstance();
        String properties = "loginconfig" + ',' + "url";
        DynamicObject onbrdBillInfo = onbrdBillDomainService.findOnbrdBillById(properties, onbrdbillId);
        HashMap mobLoginConfigMap = Maps.newHashMapWithExpectedSize((int)ImmutableSet.of((Object)onbrdbillId).size());
        Map<Long, DynamicObject> loginConfigInfoMap = IBaseDataDomainService.getInstance().getLoginConfigById(onbrdLoginConfigIdMap.values(), "number");
        for (Map.Entry<Long, Long> entry : onbrdLoginConfigIdMap.entrySet()) {
            DynamicObject loginConfig = loginConfigInfoMap.get(entry.getValue());
            mobLoginConfigMap.put(entry.getKey(), loginConfig.getString("number"));
        }
        Map<Long, String> mobLoginUrlMap = IOnbrdCommonAppService.getInstance().getMobLoginUrls(mobLoginConfigMap);
        onbrdBillInfo.set("loginconfig", mobLoginConfigMap.get(onbrdbillId));
        onbrdBillInfo.set("url", (Object)mobLoginUrlMap.get(onbrdbillId));
        onbrdBillDomainService.saveOnbrdBillInfo(onbrdBillInfo);
        return mobLoginUrlMap.get(onbrdbillId);
    }

    @Override
    public boolean isEnrolledWithTip(IFormView view, Long onbrdId) {
        boolean isEnroll = IOnbrdBillDomainService.getInstance().isEnrolled(onbrdId);
        if (isEnroll) {
            view.showErrorNotification(ResManager.loadKDString((String)"\u4e0d\u80fd\u5bf9\u5165\u804c\u72b6\u6001\u4e3a\u201c\u5df2\u5165\u804c\u201d\u201c\u5165\u804c\u7ec8\u6b62\u201d\u7684\u6570\u636e\u8fdb\u884c\u64cd\u4f5c\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ACCEPTMANAGE_12", (String)"hr-hom-formplugin", (Object[])new Object[0]));
        }
        return isEnroll;
    }

    @Override
    public String validateEffectDateWithOrgField(DynamicObject onbrdBillInfo) {
        Map<Long, String> resultMap = this.validateEffectDateWithOrgField(new DynamicObject[]{onbrdBillInfo});
        return resultMap.get(onbrdBillInfo.getLong("id"));
    }

    @Override
    public Map<Long, String> validateEffectDateWithOrgField(DynamicObject[] onbrdBillInfos) {
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)onbrdBillInfos.length);
        HashMap errMsgListMap = Maps.newHashMapWithExpectedSize((int)onbrdBillInfos.length);
        this.validateEffectDateWithOrgField(onbrdBillInfos, errMsgListMap, "haos_adminorghr", (Tuple<String, String>)Tuple.create((Object)"aadminorg", (Object)ResManager.loadKDString((String)"\u5165\u804c\u90e8\u95e8", (String)"OnbrdCommonAppServiceImpl_12", (String)"hr-hom-business", (Object[])new Object[0])), "establishmentdate");
        this.validateEffectDateWithOrgField(onbrdBillInfos, errMsgListMap, "hbpm_positionhr", (Tuple<String, String>)Tuple.create((Object)"aposition", (Object)ResManager.loadKDString((String)"\u5c97\u4f4d", (String)"OnbrdCommonAppServiceImpl_13", (String)"hr-hom-business", (Object[])new Object[0])), "firstbsed");
        this.validateEffectDateWithOrgField(onbrdBillInfos, errMsgListMap, "hbpm_stposition", (Tuple<String, String>)Tuple.create((Object)"stdposition", (Object)ResManager.loadKDString((String)"\u6807\u51c6\u5c97\u4f4d", (String)"OnbrdCommonAppServiceImpl_14", (String)"hr-hom-business", (Object[])new Object[0])), "firstbsed");
        this.validateEffectDateWithOrgField(onbrdBillInfos, errMsgListMap, "hbjm_jobhr", (Tuple<String, String>)Tuple.create((Object)"ajob", (Object)ResManager.loadKDString((String)"\u804c\u4f4d", (String)"OnbrdCommonAppServiceImpl_15", (String)"hr-hom-business", (Object[])new Object[0])), "firstbsed");
        for (DynamicObject onbrdBillInfo : onbrdBillInfos) {
            String fieldStr;
            long onbrdId = onbrdBillInfo.getLong("id");
            List errMsgList = (List)errMsgListMap.get(onbrdId);
            if (errMsgList == null || errMsgList.isEmpty() || !HRStringUtils.isNotEmpty((String)(fieldStr = String.join((CharSequence)"\u3001", errMsgList)))) continue;
            resultMap.put(onbrdId, String.format(ResManager.loadKDString((String)"\u5165\u804c\u65e5\u671f\u5e94\u665a\u4e8e%s\u7684\u751f\u6548\u65e5\u671f\u3002", (String)"OnbrdCommonAppServiceImpl_16", (String)"hr-hom-business", (Object[])new Object[0]), fieldStr));
        }
        return resultMap;
    }

    private void validateEffectDateWithOrgField(DynamicObject[] onbrdBillInfos, Map<Long, List<String>> errMsgListMap, String fieldEntityNumber, Tuple<String, String> orgField, String firstbsedPropertyKey) {
        String orgFieldKey = (String)orgField.item1;
        String displayName = (String)orgField.item2;
        Set<Long> baseDataIds = Stream.of(onbrdBillInfos).map(onbrdBillInfo -> HOMObjectUtils.getDynamicObjectFieldId((DynamicObject)onbrdBillInfo, (String)orgFieldKey)).collect(Collectors.toSet());
        Map<Long, DynamicObject> baseDataInfoMap = IBaseDataDomainService.getInstance().getBaseDataInfoByIds(fieldEntityNumber, baseDataIds, firstbsedPropertyKey);
        for (DynamicObject onbrdBillInfo2 : onbrdBillInfos) {
            String apositiontype = onbrdBillInfo2.getString("apositiontype");
            if (PositionTypeEnum.POSITIONTYPE_STDPOSITION.getValue().equals(apositiontype) ? "aposition".equals(orgFieldKey) || "ajob".equals(orgFieldKey) : (PositionTypeEnum.POSITIONTYPE_POSITION.getValue().equals(apositiontype) ? "stdposition".equals(orgFieldKey) || "ajob".equals(orgFieldKey) : PositionTypeEnum.POSITIONTYPE_JOB.getValue().equals(apositiontype) && ("stdposition".equals(orgFieldKey) || "aposition".equals(orgFieldKey)))) continue;
            long onbrdId = onbrdBillInfo2.getLong("id");
            Date effectdate = onbrdBillInfo2.getDate("effectdate");
            if (effectdate == null) continue;
            List<String> errMsgList = errMsgListMap.get(onbrdId);
            if (errMsgList == null) {
                errMsgList = new ArrayList<String>();
            }
            long baseDataId = HOMObjectUtils.getDynamicObjectFieldId((DynamicObject)onbrdBillInfo2, (String)orgFieldKey);
            DynamicObject baseDataInfo = baseDataInfoMap.get(baseDataId);
            Date firstbsed = null;
            if (baseDataInfo != null) {
                firstbsed = baseDataInfo.getDate(firstbsedPropertyKey);
            }
            if (firstbsed != null && HRDateTimeUtils.dayBefore((Date)effectdate, (Date)firstbsed)) {
                errMsgList.add(displayName);
            }
            errMsgListMap.put(onbrdId, errMsgList);
        }
    }

    @Override
    public Optional<String> validateF7Name(IFormView view) {
        DynamicObject dynamicObjectPage = view.getModel().getDataEntity();
        String name = dynamicObjectPage.getString("personfield");
        if (HRStringUtils.isEmpty((String)name)) {
            return Optional.empty();
        }
        return IOnbrdCommonAppService.getInstance().vaildSameFieldByHom("personfield", view);
    }

    @Override
    public Optional<String> validNumber(DynamicObject dataEntity, IFormView view) {
        String number = dataEntity.getString("employeeno");
        dataEntity.set("isreplacenumber", (Object)"0");
        if (StringUtils.isBlank((CharSequence)number)) {
            return Optional.empty();
        }
        boolean replaceNumber = ReentryRuleService.getInstance().isReplaceNumber(dataEntity);
        boolean replaceNumberSwitch = ReentryRuleService.getInstance().queryReplaceNumberSwitch();
        if (replaceNumber) {
            DynamicObject[] dynamicObjects = ReentryRuleService.getInstance().queryEmpentrelInfoByNumber(number);
            if (dynamicObjects == null || dynamicObjects.length == 0) {
                return Optional.empty();
            }
            if (replaceNumberSwitch) {
                String oldName = dynamicObjects[0].getString("name") == null ? "" : dynamicObjects[0].getString("name");
                String newName = dataEntity.getString("name") == null ? "" : dataEntity.getString("name");
                String msg = ResManager.loadKDString((String)"%1$s\u5c06\u53d6\u4ee3%2$s\u7684\u5de5\u53f7%3$s", (String)"OnbrdInfoEdit_20", (String)"hr-hom-business", (Object[])new Object[0]);
                String format = String.format(Locale.ROOT, msg, newName, oldName, number).trim();
                dataEntity.set("isreplacenumber", (Object)"1");
                if (view != null) {
                    view.showTipNotification(format);
                }
                return Optional.empty();
            }
            String msg = ResManager.loadKDString((String)"\u201c\u5de5\u53f7\u201d\u4e0e\u7cfb\u7edf\u5df2\u6709\u6570\u636e\u91cd\u590d\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"OnbrdInfoEdit_21", (String)"hr-hom-business", (Object[])new Object[0]);
            if (view != null) {
                view.showTipNotification(msg);
            }
            return Optional.of(msg);
        }
        return Optional.empty();
    }

    @Override
    public void openOnbrdCandidateInfoPage(IFormView currView, DynamicObject onbrdBill) {
        if (HRObjectUtils.isEmpty((Object)onbrdBill)) {
            String warnMsg = ResManager.loadKDString((String)"\u60a8\u8981\u8bfb\u53d6\u7684\u5165\u804c\u529e\u7406\u5355\u6570\u636e\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\uff0c\u53ef\u80fd\u5df2\u7ecf\u88ab\u5220\u9664\u3002", (String)"OnbrdCommonAppServiceImpl_19", (String)"hr-hom-business", (Object[])new Object[0]);
            currView.showTipNotification(warnMsg);
            return;
        }
        Long onbrdId = onbrdBill.getLong("id");
        String name = onbrdBill.getString("name");
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setCaption(String.format(ResManager.loadKDString((String)"\u5165\u804c\u4eba\u5458\u4fe1\u606f-%s", (String)"OnbrdCommonAppServiceImpl_17", (String)"hr-hom-business", (Object[])new Object[0]), name));
        showParameter.setFormId("hom_persononbrdinfobody");
        showParameter.setCustomParam("checkRightAppId", (Object)currView.getFormShowParameter().getAppId());
        IFormView parentView = HOMObjectUtils.getCurrAppHomeView((IFormView)currView);
        String appRootPageId = parentView == null ? currView.getFormShowParameter().getRootPageId() : parentView.getPageId();
        showParameter.setPageId(HOMObjectUtils.getUniquePageId((String)"hom_persononbrdinfobody", (Object)onbrdId, (String)appRootPageId));
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setStatus(OperationStatus.VIEW);
        showParameter.setCustomParam("onbrdid", (Object)onbrdId.toString());
        showParameter.setCustomParam("candidateid", (Object)onbrdBill.getString("candidate.id"));
        currView.showForm(showParameter);
    }

    @Override
    public Map<Long, Optional<String>> startOnBrdValidateMustInputField(DynamicObject[] onBrdBills) {
        return this.validateMustInputField(onBrdBills, "startup_must_input_fields", "id,org,name,candidatenumber,gender,phone,certificatetype,certificatenumber,enterprise,managementscope,aadminorg,baselocation,contractlocation,workcalendar,employeenoscheme,serviceagescheme,viewtype,isprobation,probationtime,perprobationtime,apositiontype,aposition,stdposition,ajob,onbrdtype,affaction,laborreltype,laborrelstatus,postype,postype,empgroup,validuntil,handler");
    }

    @Override
    public Map<Long, Optional<String>> confirmOnBrdValidateMustInputField(DynamicObject[] onBrdBills) {
        return this.validateMustInputField(onBrdBills, "confirm_must_input_fields", "org,candidatenumber,gender,phone,certificatetype,enterprise,managementscope,aadminorg,baselocation,contractlocation,workcalendar,employeenoscheme,serviceagescheme,viewtype,isprobation,probationtime,perprobationtime,apositiontype,aposition,stdposition,ajob,onbrdtype,affaction,laborreltype,laborrelstatus,postype,postype,empgroup,validuntil,handler");
    }

    @Override
    public Set<DynamicObject> batchValidField(List<DynamicObject> onBrdList, List<String> validateFields) {
        if (CollectionUtils.isEmpty(validateFields)) {
            return null;
        }
        Set<Object> repeatBillDys = new HashSet<DynamicObject>();
        for (String validateField : validateFields) {
            List values = onBrdList.stream().filter(o -> !o.getString(validateField).isEmpty()).map(o -> o.getString(validateField)).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(values)) continue;
            QFilter qFilter = new QFilter(validateField, "in", values);
            HashSet enrollStatusSet = Sets.newHashSetWithExpectedSize((int)3);
            enrollStatusSet.add(OnbrdStatusEnum.WAIT_START.toString());
            enrollStatusSet.add(OnbrdStatusEnum.WAIT_ONBRD.toString());
            enrollStatusSet.add(OnbrdStatusEnum.HAS_ONBRD.toString());
            qFilter.and("enrollstatus", "in", (Object)enrollStatusSet).and("synchstatus", "!=", (Object)SynchStatusEnum.SYNCH_SUCCESS.getValue());
            DynamicObject[] onbrdBillDBs = IOnbrdBillDomainService.getInstance().findOnbrdBills(SELECT_PROPERTIES, new QFilter[]{qFilter});
            if (CollectionUtils.isNotEmpty(Arrays.asList(onbrdBillDBs))) {
                repeatBillDys.addAll(Arrays.asList(onbrdBillDBs));
            }
            repeatBillDys = PreOnBrdCommonUtil.getDistinctDynamicObject(repeatBillDys);
        }
        return repeatBillDys;
    }

    @Override
    public Optional<String> validateCertificateNum(JSONObject credentialsType, String certificatenumber) {
        boolean isPass = new CertificatePageServiceImpl().validateCreNumber(credentialsType, certificatenumber);
        if (!isPass) {
            String msg = ResManager.loadKDString((String)"\u8bc1\u4ef6\u53f7\u7801\u683c\u5f0f\u6709\u8bef\uff0c\u8bf7\u91cd\u65b0\u586b\u5199\u3002", (String)"OnbrdCommonAppServiceImpl_5", (String)"hr-hom-business", (Object[])new Object[0]);
            return Optional.of(msg);
        }
        return Optional.empty();
    }

    private Map<Long, Optional<String>> validateMustInputField(DynamicObject[] onBrdBills, String mustInputFieldConfigKey, String mustInputFieldConfigDefaultVal) {
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)onBrdBills.length);
        Set idSet = Stream.of(onBrdBills).map(onBrdBill -> onBrdBill.getLong("id")).collect(Collectors.toSet());
        HashSet<String> enrollStatusSet = new HashSet<String>();
        enrollStatusSet.add(OnbrdStatusEnum.WAIT_START.toString());
        enrollStatusSet.add(OnbrdStatusEnum.WAIT_ONBRD.toString());
        QFilter enrollStatusFilter = new QFilter("enrollstatus", "in", enrollStatusSet);
        QFilter idFilter = new QFilter("id", "in", idSet);
        String startupMustInputFields = ServiceFactory.getService(IHomConfigService.class).getConfVal(mustInputFieldConfigKey, mustInputFieldConfigDefaultVal);
        DynamicObject[] onBrdBillsFromDB = IOnbrdBillDomainService.getInstance().findOnbrdBills(mustInputFieldConfigDefaultVal, new QFilter[]{enrollStatusFilter, idFilter});
        String[] split = startupMustInputFields.split(",");
        Arrays.stream(onBrdBillsFromDB).forEach(dynamicObject -> {
            ArrayList<String> errorMsgField = new ArrayList<String>();
            Arrays.stream(split).forEach(property -> {
                if ((property = property.trim()).equals("ajob") || property.equals("stdposition") || property.equals("aposition")) {
                    return;
                }
                IDataEntityProperty dataEntityProperty = (IDataEntityProperty)dynamicObject.getDataEntityType().getProperties().get(property);
                if (dataEntityProperty == null) {
                    logger.error("not exists property {}", property);
                    return;
                }
                if (!HRObjectUtils.isEmpty((Object)dataEntityProperty.getValue(dynamicObject))) {
                    return;
                }
                if (property.equals("probationtime") || property.equals("perprobationtime")) {
                    if (dynamicObject.getBoolean("isprobation")) {
                        errorMsgField.add(dataEntityProperty.getDisplayName().getLocaleValue());
                    }
                } else if (property.equals("employeenoscheme") || property.equals("serviceagescheme")) {
                    if (HRStringUtils.equals((String)dynamicObject.getString("viewtype"), (String)ViewTypeEnum.AGAIN.getCode())) {
                        errorMsgField.add(dataEntityProperty.getDisplayName().getLocaleValue());
                    }
                } else {
                    errorMsgField.add(dataEntityProperty.getDisplayName().getLocaleValue());
                }
            });
            String aPositionType = dynamicObject.getString("apositiontype");
            if (HRStringUtils.isNotEmpty((String)aPositionType)) {
                String key = "stdposition";
                if ("1".equals(aPositionType)) {
                    key = "aposition";
                } else if ("2".equals(aPositionType)) {
                    key = "ajob";
                }
                if (HRObjectUtils.isEmpty((Object)dynamicObject.get(key))) {
                    errorMsgField.add(((IDataEntityProperty)dynamicObject.getDataEntityType().getProperties().get((Object)key)).getDisplayName().getLocaleValue());
                }
            }
            if (!CollectionUtils.isEmpty(errorMsgField)) {
                String errorMsg = MessageFormat.format(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c{0}\u201d \u3002", (String)"OnbrdCommonAppServiceImpl_18", (String)"hr-hom-business", (Object[])new Object[0]), String.join((CharSequence)"\u3001", errorMsgField));
                resultMap.put(dynamicObject.getLong("id"), Optional.of(errorMsg));
            }
        });
        return resultMap;
    }

    @Override
    public boolean tryRequireLockByHCF(IFormView formView, Long id, String entityNum, String opKey) {
        if (id == null || id == 0L || HRStringUtils.isEmpty((String)entityNum) || HRStringUtils.isEmpty((String)opKey)) {
            return true;
        }
        boolean result = false;
        try {
            String pkId = String.valueOf(id);
            IHomDataMutexService.getInstance().cleanMutexLockCacheBeforeRequireLock(formView, pkId, entityNum, opKey);
            result = IHomDataMutexService.getInstance().requireLock(pkId, entityNum, formView, opKey, false, "1");
        }
        catch (Exception e) {
            logger.error("tryRequireLockByHCF exception", (Throwable)e);
        }
        if (!result) {
            logger.error("tryRequireLockByHCF fail,{},{},{}", new Object[]{id, entityNum, opKey});
        }
        return result;
    }

    @Override
    public boolean releaseLockByHCF(Long id, String entityNum, String opKey) {
        if (id == null || id == 0L || HRStringUtils.isEmpty((String)entityNum) || HRStringUtils.isEmpty((String)opKey)) {
            return true;
        }
        boolean result = false;
        try {
            result = IHomDataMutexService.getInstance().release(String.valueOf(id), entityNum, opKey);
        }
        catch (Exception e) {
            logger.error("releaseLockByHCF exception", (Throwable)e);
        }
        if (!result) {
            logger.error("releaseLockByHCF fail,{},{},{}", new Object[]{id, entityNum, opKey});
        }
        return result;
    }
}

