/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.business.application.impl.onbrd;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.kdtx.common.Param;
import kd.bos.kdtx.common.exception.TCCTryException;
import kd.bos.kdtx.sdk.session.tcc.TCCGlobalSession;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.hr.hbp.business.service.diff.HRPlugInProxyFactory;
import kd.hr.hbp.business.service.diff.HRPluginProxy;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.bussiness.cert.HRCertCommonHelper;
import kd.hr.hbp.bussiness.cert.HRCertPromptInfoTypeEnum;
import kd.hr.hbp.common.model.org.staff.StaffUseParam;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hom.business.application.hpfs.IDevParamConfigExternalService;
import kd.hr.hom.business.application.hrcs.IHomToHrcsAppService;
import kd.hr.hom.business.application.hrpi.IHomToHrpiAppService;
import kd.hr.hom.business.application.impl.mq.HomPersonFilePublisher;
import kd.hr.hom.business.application.impl.rule.OnbrdConfirmValidatorService;
import kd.hr.hom.business.application.onbrd.IOnbrdConfirmAppService;
import kd.hr.hom.business.application.onbrd.IQueryVidService;
import kd.hr.hom.business.application.rule.IOnbrdConfirmValidatorService;
import kd.hr.hom.business.application.staff.IStaffUseService;
import kd.hr.hom.business.domain.repository.common.HomCommonRepository;
import kd.hr.hom.business.domain.service.ServiceFactory;
import kd.hr.hom.business.domain.service.activity.IActivityDomainService;
import kd.hr.hom.business.domain.service.common.ISendMessageService;
import kd.hr.hom.business.domain.service.impl.activity.ActivityDomainService;
import kd.hr.hom.business.domain.service.integrate.IIntegrateService;
import kd.hr.hom.business.domain.service.onbrd.IOnbrdBillDomainService;
import kd.hr.hom.common.constant.BaseDataIdConstants;
import kd.hr.hom.common.enums.ActivityNumberEnum;
import kd.hr.hom.common.enums.ActivityStatusEnum;
import kd.hr.hom.common.enums.CheckinStatusEnum;
import kd.hr.hom.common.enums.IntegrateEnum;
import kd.hr.hom.common.enums.OnbrdStatusEnum;
import kd.hr.hom.common.enums.ProcessStatusEnum;
import kd.hr.hom.common.enums.RuleEngineSceneNumberEnum;
import kd.hr.hom.common.enums.SynchStatusEnum;
import kd.hr.hom.common.enums.ViewTypeEnum;
import kd.hr.hom.common.util.DateUtils;
import kd.hr.hom.common.util.HOMObjectUtils;
import kd.sdk.hr.hom.business.onbrd.IShareTaskService;

public class OnbrdConfirmAppServiceImpl
implements IOnbrdConfirmAppService {
    private static final String PROPERTIES_SHOWPAGE = "id,name,candidate,employeeno,certificatetype,certificatenumber,effectdate,iseligibleonboard,processstatus,picturefield,phone,onbrdtcity,checkinstatus,synchstatus,peremail,aadminorg,ajob,aposition,stdposition,org,billstatus,validuntil,isreplacenumber,viewtype,apositiontype,employeenoscheme,personfield,candidatenumber,personindexid";
    private static final String SELECT_PROPERTIES = "id,billno,candidate,effectdate,aadminorg,ajob,validuntil,enrollstatus,checkinstatus,processstatus,name,resumeno,employeeno,certificatetype,certificatenumber,peremail,iseligibleonboard,onbrdtype,darkposition,aposition,apositiontype,stdposition,transdate,isprobation,probationtime,perprobationtime,role,synchstatus,phone,onbrdtcity,affaction,peremail,teacher,offernumber,datasource,candidatenumber,jobseq,jobfamily,jobclass,joblevelscm,jobgradescm,acompany,automaticinfo,personfield,billstatus,isreplacenumber,viewtype,employeenoscheme,firstemtstartdate,personindexid";
    private static final Log LOGGER = LogFactory.getLog(OnbrdConfirmAppServiceImpl.class);
    private static final ThreadPool THREAD_POOL = ThreadPools.newCachedThreadPool((String)"OnbrdConfirmAppServiceImpl", (int)5, (int)1000);

    @Override
    public Map<String, Object> doComfirmWithSimpleInfo(Long userId, DynamicObject onbrdBillSimpleInfo, String operateKey) {
        List<Map<String, Object>> operationResultList = this.doComfirmWithSimpleInfo(userId, new DynamicObject[]{onbrdBillSimpleInfo}, operateKey);
        Map<Object, Object> operationResult = Maps.newHashMapWithExpectedSize((int)1);
        if (!CollectionUtils.isEmpty(operationResultList)) {
            operationResult = operationResultList.get(0);
        }
        return operationResult;
    }

    public DynamicObject[] getOnbrdBillInfoForDealing(Set<Long> onbrdBillIds) {
        QFilter filter = onbrdBillIds.size() == 1 ? new QFilter("id", "=", onbrdBillIds.stream().findFirst().get()) : new QFilter("id", "in", (Object)onbrdBillIds.toArray(new Object[onbrdBillIds.size()]));
        return IOnbrdBillDomainService.getInstance().findOnbrdBills(SELECT_PROPERTIES, new QFilter[]{filter});
    }

    @Override
    public List<Map<String, Object>> doComfirmWithSimpleInfo(Long userId, DynamicObject[] onbrdBillSimpleInfoList, String operateKey) {
        HashMap onbrdBillSimpleInfoMap = Maps.newHashMapWithExpectedSize((int)onbrdBillSimpleInfoList.length);
        for (DynamicObject simpleInfo : onbrdBillSimpleInfoList) {
            onbrdBillSimpleInfoMap.put(simpleInfo.getLong("id"), simpleInfo);
        }
        Set<Long> onbrdBillIds = onbrdBillSimpleInfoMap.keySet();
        DynamicObject[] onbrdBillDetailInfoList = this.getOnbrdBillInfoForDealing(onbrdBillIds);
        ArrayList<DynamicObject> canConfirmSimpleList = new ArrayList<DynamicObject>(onbrdBillDetailInfoList.length);
        Map<Long, Map<String, Object>> allCheckResultMap = IOnbrdConfirmValidatorService.getInstance().reCheck(onbrdBillDetailInfoList, operateKey);
        ArrayList<Map<String, Object>> operationResultList = new ArrayList<Map<String, Object>>(allCheckResultMap.values());
        for (DynamicObject onbrdBillDetailInfo : onbrdBillDetailInfoList) {
            Long onbrdId = onbrdBillDetailInfo.getLong("id");
            Map<String, Object> reCheckResult = allCheckResultMap.get(onbrdId);
            if (Boolean.parseBoolean(reCheckResult.get("isSuccess").toString())) {
                canConfirmSimpleList.add(onbrdBillDetailInfo);
                continue;
            }
            LOGGER.info("Cannot confirm for onbrdBill : {}", (Object)onbrdId);
        }
        List onbrdBillParts = new ArrayList<ArrayList<DynamicObject>>(16);
        if (canConfirmSimpleList.size() > 1000) {
            onbrdBillParts = Lists.partition(canConfirmSimpleList, (int)1000);
        } else {
            onbrdBillParts.add(canConfirmSimpleList);
        }
        for (List onbrdBillsPart : onbrdBillParts) {
            this.doSomethinsForOnboarding(userId, onbrdBillsPart, operationResultList, operateKey);
        }
        return operationResultList;
    }

    @Override
    public Map<String, Object> getPersonInfoFeedbackMap(DynamicObject onbrdBillInfo) {
        HashMap<String, Object> personInfoMap = new HashMap<String, Object>();
        personInfoMap.put("id", onbrdBillInfo.getString("id"));
        OrmLocaleValue name = (OrmLocaleValue)onbrdBillInfo.get("name");
        personInfoMap.put("name", name == null ? "" : name.getLocaleValue());
        personInfoMap.put("resumeno", onbrdBillInfo.get("resumeno"));
        personInfoMap.put("employeeno", onbrdBillInfo.get("employeeno"));
        Object certificateType = onbrdBillInfo.get("certificatetype");
        if (certificateType instanceof DynamicObject) {
            OrmLocaleValue certificateTypeName = (OrmLocaleValue)((DynamicObject)certificateType).get("name");
            String localName = certificateTypeName == null ? "" : certificateTypeName.getLocaleValue();
            personInfoMap.put("certificatetype.name", localName);
        } else {
            personInfoMap.put("certificatetype.name", certificateType);
        }
        personInfoMap.put("certificatenumber", onbrdBillInfo.get("certificatenumber"));
        Date effectDate = onbrdBillInfo.getDate("effectdate");
        if (Objects.nonNull(effectDate)) {
            personInfoMap.put("effectdate", HRDateTimeUtils.format((Date)effectDate, (String)"yyyy/MM/dd"));
        }
        return personInfoMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doSomethinsForOnboarding(Long userId, List<DynamicObject> canConfirmSimpleList, List<Map<String, Object>> operationResultList, String operateKey) {
        if (CollectionUtils.isEmpty(canConfirmSimpleList)) {
            return;
        }
        TXHandle txHandle = TX.required();
        List<Long> onbrdIds = canConfirmSimpleList.stream().map(onbrdBill -> onbrdBill.getLong("id")).collect(Collectors.toList());
        String businessValue = IDevParamConfigExternalService.getInstance().getValueByKey("hom_isfinishworkflow");
        boolean isFinishWorkFlow = Boolean.parseBoolean(businessValue);
        try {
            if (RequestContext.getOrCreate().getCurrUserId() != -1L) {
                StaffUseParam staffUseParam = IStaffUseService.getInstance().getStaffUseParamTCCBeforeOnbrd(onbrdIds);
                TCCGlobalSession.Try((String)"hom_IHAOSStaffUseService", (String)"hrmp", (String)"haos", (String)"IHAOSStaffUseService", (Param)staffUseParam, null, (DBRoute)DBRoute.of((String)"hrb.hom"));
                LOGGER.info("OnbrdConfirmAppServiceImpl.doSomethinsForOnboarding occupy staff end,staffUseParam:{}", (Object)staffUseParam);
            }
            if (isFinishWorkFlow) {
                LOGGER.info("OnbrdConfirmServiceHelper start baterminateOrDeleteTask");
                Map<String, Object> terminateResult = IHomToHrcsAppService.getInstance().terminateOrDeleteTask(onbrdIds);
                if (!Boolean.TRUE.toString().equals(terminateResult.get("success"))) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u8be5\u5165\u804c\u6d41\u7a0b\u4e2d\u5b58\u5728\u5171\u4eab\u4efb\u52a1\u7ec8\u6b62\u5931\u8d25\u5bfc\u81f4\u786e\u8ba4\u5165\u804c\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\u89e6\u53d1\u3002", (String)"OnbrdConfirmAppServiceImpl_9", (String)"hr-hom-business", (Object[])new Object[0]));
                }
            }
            LOGGER.info("Start to update onbrdInfo to Hom DB , {}", (Object)canConfirmSimpleList.size());
            this.updateOnbrdInfoToHomDb(canConfirmSimpleList.toArray(new DynamicObject[canConfirmSimpleList.size()]), operateKey);
            Map updateUsedCertResult = HRCertCommonHelper.updateUsedCertCount((String)"1WXB5G9/BL46", (String)"hom_onbrdpersonlist", (int)canConfirmSimpleList.size());
            LOGGER.info("HRCertCommonHelper.updateUsedCertCount: {}", (Object)HOMObjectUtils.toJSONString((Object)updateUsedCertResult));
            String updateUsedCertInfoType = (String)updateUsedCertResult.get("infoType");
            this.addUpdateUsedCertResult(onbrdIds, operationResultList, updateUsedCertResult);
            if (HRStringUtils.equals((String)HRCertPromptInfoTypeEnum.FORBIDDEN.getName(), (String)updateUsedCertInfoType)) {
                LOGGER.info("Fail to update onbrdInfo When updateUsedCertCount");
                txHandle.markRollback();
                return;
            }
            txHandle.commit();
        }
        catch (Exception exception) {
            LOGGER.error((Throwable)exception);
            txHandle.markRollback();
            LOGGER.info("Fail to update onbrdInfo to Hom DB");
            String errorTip = exception instanceof TCCTryException ? IStaffUseService.getInstance().getErrorTipWithException(exception) : exception.getMessage();
            operationResultList.stream().filter(operationResult -> onbrdIds.contains(Long.parseLong(operationResult.get("id").toString())) && Boolean.parseBoolean(operationResult.get("isSuccess").toString())).forEach(operationResult -> {
                operationResult.put("isSuccess", Boolean.FALSE);
                operationResult.put("failReason", errorTip);
            });
            return;
        }
        finally {
            txHandle.close();
        }
        RequestContext requestContext = ActivityDomainService.getHandlerRequestContext(canConfirmSimpleList.get(0).getLong("id"));
        String asynTraceId = requestContext.getTraceId();
        LOGGER.info("dealShareTask:{}", (Object)asynTraceId);
        HRPluginProxy hrPluginProxy = HRPlugInProxyFactory.create(null, IShareTaskService.class, (String)"kd.sdk.hr.hom.business.onbrd.IShareTaskService", null);
        hrPluginProxy.callReplace(hrPlugin -> {
            List ids = canConfirmSimpleList.stream().map(canConfirmSimple -> canConfirmSimple.getLong("id")).collect(Collectors.toList());
            hrPlugin.dealShareTask("confirm", "hom_onbrdinfo", ids);
            return null;
        });
        LOGGER.info("syn asynTraceId:{}", (Object)asynTraceId);
        THREAD_POOL.execute(() -> {
            LOGGER.info("asyn asynTraceId:{}", (Object)asynTraceId);
            LOGGER.info("OnbrdConfirmServiceHelper Start to send message to Candidate");
            this.sendMessageToCandidate(canConfirmSimpleList);
            LOGGER.info("===start darkposition===");
            this.createPosition(canConfirmSimpleList, false);
            if (!CollectionUtils.isEmpty((Collection)canConfirmSimpleList)) {
                LOGGER.info("OnbrdConfirmServiceHelper Start to send onbrdInfo to Hers");
                OnbrdConfirmAppServiceImpl.sendBillInfoToHers(userId, canConfirmSimpleList);
            }
            IHomToHrpiAppService.getInstance().sendMessageToLeaderAndTeacher(canConfirmSimpleList);
            LOGGER.info("OnbrdConfirmServiceHelper End doing confirm for onbrd");
        }, requestContext);
        THREAD_POOL.execute(() -> {
            LOGGER.info("OnbrdConfirmServiceHelper Start to batchConsentTask checkininfo");
            ArrayList ids = Lists.newArrayListWithExpectedSize((int)canConfirmSimpleList.size());
            for (DynamicObject dynamicObject : canConfirmSimpleList) {
                ids.add(dynamicObject.getLong("id"));
            }
            IActivityDomainService.getInstance().batchConsentTask((List<Long>)ids, ActivityNumberEnum.CHECKININFO);
            LOGGER.info("OnbrdConfirmServiceHelper end to batchConsentTask checkininfo");
            if (!isFinishWorkFlow) {
                return;
            }
            try {
                LOGGER.info("batchTerminateTask start");
                IActivityDomainService.getInstance().batchTerminateTask(ids);
            }
            catch (Exception e) {
                LOGGER.warn("batchTerminateTask catch to abandon workflow", (Throwable)e);
            }
            LOGGER.info("OnbrdConfirmServiceHelper start to abandon workflow");
            IActivityDomainService.getInstance().batchTerminateFlow(ids);
            LOGGER.info("OnbrdConfirmServiceHelper success to abandon workflow");
        }, RequestContext.get());
    }

    private void addUpdateUsedCertResult(List<Long> onbrdIds, List<Map<String, Object>> operationResultList, Map<String, String> updateUsedCertResult) {
        String updateUsedCertInfoType = updateUsedCertResult.get("infoType");
        boolean ifShowMessage = Boolean.parseBoolean(updateUsedCertResult.get("showMessage"));
        String updateUsedCerttMessage = updateUsedCertResult.get("message");
        for (Map<String, Object> operationResult : operationResultList) {
            Long onbrdBillId = Long.parseLong(operationResult.get("id").toString());
            if (!onbrdIds.contains(onbrdBillId)) continue;
            if (HRStringUtils.equals((String)HRCertPromptInfoTypeEnum.FORBIDDEN.getName(), (String)updateUsedCertInfoType)) {
                operationResult.put("isSuccess", Boolean.FALSE);
                operationResult.put("failReason", updateUsedCerttMessage);
            }
            if (!ifShowMessage) continue;
            String warnMessage = operationResult.getOrDefault("warnMessage", "").toString();
            if (HRStringUtils.isNotEmpty((String)warnMessage)) {
                warnMessage = warnMessage + System.lineSeparator() + updateUsedCerttMessage;
            }
            operationResult.put("warnMessage", warnMessage);
        }
    }

    public void retryHpfs(Long userId, List<DynamicObject> canConfirmSimpleList) {
        if (!CollectionUtils.isEmpty(canConfirmSimpleList)) {
            LOGGER.info("OnbrdConfirmServiceHelper Start to send onbrdInfo to Hers");
            OnbrdConfirmAppServiceImpl.sendBillInfoToHers(userId, canConfirmSimpleList);
        }
        LOGGER.info("OnbrdConfirmServiceHelper End doing confirm for onbrd");
    }

    private void createPosition(List<DynamicObject> canConfirmSimpleList, boolean isUpdateDarkPosition) {
        if (CollectionUtils.isEmpty(canConfirmSimpleList)) {
            return;
        }
        try {
            QFilter filter;
            String selPoperties;
            IOnbrdBillDomainService onbrdService;
            Object[] onbrdBillArr;
            ArrayList dataList;
            ArrayList positionList = new ArrayList(canConfirmSimpleList.size());
            ArrayList jobList = new ArrayList(canConfirmSimpleList.size());
            for (DynamicObject onbrdBill : canConfirmSimpleList) {
                if (!isUpdateDarkPosition && onbrdBill.get("darkposition") != null) continue;
                String apositiontype = onbrdBill.getString("apositiontype");
                HashMap<String, Comparable<Long>> requestMap = new HashMap<String, Comparable<Long>>(4);
                requestMap.put("org", Long.valueOf(onbrdBill.getLong("aadminorg.id")));
                requestMap.put("user", Long.valueOf(onbrdBill.getLong("id")));
                requestMap.put("effect", onbrdBill.getDate("effectdate"));
                if ("0".equals(apositiontype) && onbrdBill.get("stdposition") != null) {
                    requestMap.put("standardposition", Long.valueOf(onbrdBill.getLong("stdposition.id")));
                    positionList.add(requestMap);
                    continue;
                }
                if (!"2".equals(apositiontype) || onbrdBill.get("ajob") == null) continue;
                requestMap.put("job", Long.valueOf(onbrdBill.getLong("ajob.id")));
                jobList.add(requestMap);
            }
            HashMap<Long, Map> allDataMap = new HashMap<Long, Map>(canConfirmSimpleList.size());
            if (!CollectionUtils.isEmpty(jobList)) {
                LOGGER.info("===createPosition jobList:{}==", (Object)((Object)jobList).toString());
                Map jobResponseMap = (Map)HRMServiceHelper.invokeHRMPService((String)"hbpm", (String)"IStandardPositionService", (String)"addDarkPositionByJob", (Object[])new Object[]{jobList});
                LOGGER.info("===createPosition jobResponseMap:{}===", (Object)jobResponseMap.toString());
                dataList = (ArrayList)jobResponseMap.get("data");
                if (dataList != null) {
                    Map<Long, Map> jobDataMap = dataList.stream().collect(Collectors.toMap(map -> (Long)map.get("user"), map -> map, (oldValue, newValue) -> newValue));
                    allDataMap.putAll(jobDataMap);
                }
            }
            if (!CollectionUtils.isEmpty(positionList)) {
                LOGGER.info("===createPosition positionList:{}==", (Object)((Object)positionList).toString());
                Map resMap = (Map)HRMServiceHelper.invokeHRMPService((String)"hbpm", (String)"IStandardPositionService", (String)"addDarkPosition", (Object[])new Object[]{positionList});
                LOGGER.info("===createPosition resMap:{}===", (Object)resMap.toString());
                dataList = (ArrayList)resMap.get("data");
                if (dataList != null) {
                    Map<Long, Map> positionMap = dataList.stream().collect(Collectors.toMap(map -> (Long)map.get("user"), map -> map, (oldValue, newValue) -> newValue));
                    allDataMap.putAll(positionMap);
                }
            }
            if (!CollectionUtils.isEmpty(allDataMap) && !HRArrayUtils.isEmpty((Object[])(onbrdBillArr = (onbrdService = IOnbrdBillDomainService.getInstance()).findOnbrdBills(selPoperties = "darkposition,role,stdposition,aposition,apositiontype", new QFilter[]{filter = new QFilter("id", "in", allDataMap.keySet())})))) {
                for (Object onbrdBill : onbrdBillArr) {
                    Long onbrdBillId = onbrdBill.getLong("id");
                    onbrdBill.set("darkposition", ((Map)allDataMap.get(onbrdBillId)).get("position"));
                    onbrdBill.set("aposition", ((Map)allDataMap.get(onbrdBillId)).get("position"));
                    onbrdBill.set("role", ((Map)allDataMap.get(onbrdBillId)).get("workrole"));
                    String apositiontype = onbrdBill.getString("apositiontype");
                    if (!"2".equals(apositiontype)) continue;
                    onbrdBill.set("stdposition", ((Map)allDataMap.get(onbrdBillId)).get("standardposition"));
                }
                onbrdService.saveOnbrdBillInfos((DynamicObject[])onbrdBillArr);
            }
        }
        catch (Exception exp) {
            LOGGER.error("===createPostion error===", (Throwable)exp);
        }
    }

    private void updateOnbrdInfoToHomDb(DynamicObject[] onbrdBillInfoList, String operateKey) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hom_integratelog");
        ArrayList<DynamicObject> dyList = new ArrayList<DynamicObject>(onbrdBillInfoList.length);
        Map<Long, Date> employeeAndFirstStartDateMap = this.getFirstDateMap(onbrdBillInfoList);
        List<Long> onbrdIds = this.filterCheckOfTaskStatus(onbrdBillInfoList);
        for (DynamicObject onbrdBillInfo : onbrdBillInfoList) {
            onbrdBillInfo.set("enrollstatus", (Object)OnbrdStatusEnum.HAS_ONBRD.getValue());
            if ("btn_confirmcheckin".equals(operateKey) || onbrdIds.contains(onbrdBillInfo.getLong("id"))) {
                onbrdBillInfo.set("checkinstatus", (Object)CheckinStatusEnum.HAS_CHECKIN.toString());
            }
            onbrdBillInfo.set("processstatus", (Object)ProcessStatusEnum.END_PROCESS.getValue());
            onbrdBillInfo.set("transdate", (Object)DateUtils.setTransDate((DynamicObject)onbrdBillInfo));
            onbrdBillInfo.set("synchstatus", (Object)SynchStatusEnum.SYNCH_WAIT.getValue());
            if (ViewTypeEnum.AGAIN.getCode().equals(onbrdBillInfo.getString("viewtype"))) {
                long personfieldId = onbrdBillInfo.getLong("personfield.id");
                onbrdBillInfo.set("firstemtstartdate", employeeAndFirstStartDateMap.getOrDefault(personfieldId, null));
            } else {
                onbrdBillInfo.set("firstemtstartdate", (Object)onbrdBillInfo.getDate("effectdate"));
            }
            DynamicObject logDy = serviceHelper.generateEmptyDynamicObject();
            logDy.set("onbrd", (Object)onbrdBillInfo.getLong("id"));
            logDy.set("createtime", (Object)new Date());
            logDy.set("creator", (Object)RequestContext.get().getCurrUserId());
            logDy.set("modifytime", (Object)new Date());
            logDy.set("modifier", (Object)RequestContext.get().getCurrUserId());
            logDy.set("sendstatus", (Object)IntegrateEnum.SEND_WAIT.getValue());
            logDy.set("sendtime", (Object)new Date());
            logDy.set("consumestatus", (Object)IntegrateEnum.CONSUME_WAIT.getValue());
            logDy.set("integratespot", (Object)IntegrateEnum.INTEGRATE_SPOT_PERSON.getValue());
            logDy.set("integratemethod", (Object)IntegrateEnum.INTEGRATE_MQ.getValue());
            dyList.add(logDy);
        }
        IOnbrdBillDomainService.getInstance().saveOnbrdBillInfos(onbrdBillInfoList);
        IIntegrateService.getInstance().saveIntegrateLogs(dyList.toArray(new DynamicObject[dyList.size()]));
    }

    private List<Long> filterCheckOfTaskStatus(DynamicObject[] onbrdBillInfoList) {
        List ids = Arrays.stream(onbrdBillInfoList).map(row -> row.getLong("id")).collect(Collectors.toList());
        QFilter qFilter = new QFilter("onbrdid", "in", ids);
        qFilter.and("activity.id", "in", (Object)1296914540574989312L);
        DynamicObject[] activityDyns = HomCommonRepository.queryDynamicObjects("hom_activeinfobody", "onbrdid,activityins.handlers,activityins.taskstatus", qFilter);
        Long currUserId = RequestContext.get().getCurrUserId();
        List<Long> filterIds = Arrays.stream(activityDyns).filter(row -> ((MulBasedataDynamicObjectCollection)Optional.ofNullable(row.get("activityins.handlers")).orElseGet(() -> new MulBasedataDynamicObjectCollection())).stream().anyMatch(handler -> currUserId.equals(handler.getLong("fbasedataid_id")))).filter(row -> ActivityStatusEnum.PROCESSING.getValue().equals(row.getString("activityins.taskstatus"))).map(row -> row.getLong("onbrdid.id")).collect(Collectors.toList());
        return filterIds;
    }

    private Map<Long, Date> getFirstDateMap(DynamicObject[] onbrdBillInfoList) {
        Set<Object> personFieldIds = Arrays.stream(onbrdBillInfoList).filter(row -> row.getLong("personfield.id") != 0L).map(row -> row.getLong("personfield.id")).collect(Collectors.toSet());
        QFilter qFilter = new QFilter("employee", "in", (Object)personFieldIds.toArray(new Object[0]));
        DynamicObject[] empentrels = IHomToHrpiAppService.getInstance().listFieldsFilterInfo("firststartdate,employee", qFilter, "hrpi_empentrel");
        LOGGER.info("getFirstDateMap onrbd is {}", personFieldIds);
        return Arrays.stream(empentrels).filter(row -> row.getDate("firststartdate") != null).collect(Collectors.toMap(row -> row.getLong("employee.id"), row -> row.getDate("firststartdate"), (k1, k2) -> k1));
    }

    public void sendMessageToCandidate(List<DynamicObject> onbrdBillInfoList) {
        try {
            List<Long> onbrdBillIds = onbrdBillInfoList.stream().filter(onbrdBill -> BaseDataIdConstants.HBSS_ONBOARDTYPE_1010.equals(onbrdBill.getLong("onbrdtype.id"))).map(onbrdBill -> onbrdBill.getLong("id")).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(onbrdBillIds)) {
                LOGGER.info("There don't need to sendMessage for Candidate");
                return;
            }
            ServiceFactory.getService(ISendMessageService.class).sendMessage(onbrdBillIds, RuleEngineSceneNumberEnum.NOTICE_CONFIRM);
        }
        catch (Exception exception) {
            LOGGER.info("OnbrdConfirmServiceHelper Fail To Send Message to Candidate:{}", (Object)exception.getMessage());
            LOGGER.error((Throwable)exception);
        }
    }

    public static void sendBillInfoToHers(Long userId, List<DynamicObject> onbrdBillInfoList) {
        try {
            HomPersonFilePublisher.publish(userId, onbrdBillInfoList);
        }
        catch (Exception exp) {
            LOGGER.error("Fail To Send Message to Hpfs :", (Throwable)exp);
        }
    }

    @Override
    public DynamicObject[] getOnbrdBillsForShowPage(Long[] onbrdBillIdArray) {
        QFilter filter = onbrdBillIdArray.length == 1 ? new QFilter("id", "=", (Object)onbrdBillIdArray[0]) : new QFilter("id", "in", (Object)onbrdBillIdArray);
        return IOnbrdBillDomainService.getInstance().findOnbrdBills(PROPERTIES_SHOWPAGE, new QFilter[]{filter});
    }

    @Override
    public void showOnBrdConfirmPageWithOneData(IFormView formView, DynamicObject onbrdBillInfo, CloseCallBack closeCallBack, String operateKey) {
        Optional<String> checkErrorMsg = this.getOnbrdConfirmErrorMsg(onbrdBillInfo, operateKey);
        if (checkErrorMsg.isPresent()) {
            formView.showErrorNotification(checkErrorMsg.get());
            return;
        }
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setFormId("hom_onbrdconfirmsingle");
        formShowParameter.setStatus(OperationStatus.EDIT);
        Map onbrdBillInfoMap = new HashMap(16);
        try {
            onbrdBillInfoMap = HRDynamicObjectUtils.convertDynamicObjectToMap((DynamicObject)onbrdBillInfo);
        }
        catch (Exception exception) {
            LOGGER.error((Throwable)exception);
        }
        formShowParameter.setCustomParams(onbrdBillInfoMap);
        formShowParameter.setCustomParam("id", (Object)onbrdBillInfo.getString("id"));
        if ("btn_confirmcheckin".equals(operateKey)) {
            formShowParameter.setCaption(ResManager.loadKDString((String)"\u786e\u8ba4\u62a5\u5230", (String)"OnbrdConfirmAppServiceImpl_3", (String)"hr-hom-business", (Object[])new Object[0]));
        } else {
            formShowParameter.setCaption(ResManager.loadKDString((String)"\u786e\u8ba4\u5165\u804c", (String)"OnbrdConfirmAppServiceImpl_1", (String)"hr-hom-business", (Object[])new Object[0]));
        }
        formShowParameter.setCloseCallBack(closeCallBack);
        formView.showForm(formShowParameter);
    }

    @Override
    public Optional<String> getOnbrdConfirmErrorMsg(DynamicObject onbrdBillInfo, String operateKey) {
        return new OnbrdConfirmValidatorService().checkIfIsEligibleOnboard(onbrdBillInfo, operateKey);
    }

    @Override
    public void changeBoidToVid(DynamicObject onbrdBillInfo) {
        String billno = onbrdBillInfo.getString("billno");
        Long compId = onbrdBillInfo.getLong("acompany.id");
        Long deptId = onbrdBillInfo.getLong("aadminorg.id");
        Long positionId = onbrdBillInfo.getLong("aposition.id");
        Date effectDate = onbrdBillInfo.getDate("effectdate");
        Long stdPositionId = onbrdBillInfo.getLong("stdposition.id");
        Long jobId = onbrdBillInfo.getLong("ajob.id");
        LOGGER.info("###OnbrdConfirmAppServiceImpl before changeBoidToVid, billno:{},compId:{},deptId:{},stdPositionId:{},positionId:{},jobId:{},effectDate:{}", new Object[]{billno, compId, deptId, stdPositionId, positionId, jobId, effectDate});
        Long compBoid = HOMObjectUtils.getBoid((DynamicObject)onbrdBillInfo.getDynamicObject("acompany"));
        Long deptBoid = HOMObjectUtils.getBoid((DynamicObject)onbrdBillInfo.getDynamicObject("aadminorg"));
        Long stdPositionBoid = HOMObjectUtils.getBoid((DynamicObject)onbrdBillInfo.getDynamicObject("stdposition"));
        Long aPositionBoid = HOMObjectUtils.getBoid((DynamicObject)onbrdBillInfo.getDynamicObject("aposition"));
        Long aJobBoid = HOMObjectUtils.getBoid((DynamicObject)onbrdBillInfo.getDynamicObject("ajob"));
        IQueryVidService queryVidService = IQueryVidService.getInstance();
        Long aCompId = queryVidService.queryOrgVid(compBoid, effectDate);
        Long aDeptId = queryVidService.queryOrgVid(deptBoid, effectDate);
        Long aJobId = queryVidService.queryJobVid(aJobBoid, effectDate);
        Long aPositionId = queryVidService.queryPositionVid(aPositionBoid, effectDate);
        Long aStdPositionId = queryVidService.queryStdPositionVid(stdPositionBoid, effectDate);
        onbrdBillInfo.set("acompany", (Object)aCompId);
        onbrdBillInfo.set("aadminorg", (Object)aDeptId);
        onbrdBillInfo.set("stdposition", (Object)aStdPositionId);
        onbrdBillInfo.set("aposition", (Object)aPositionId);
        onbrdBillInfo.set("ajob", (Object)aJobId);
        LOGGER.info("###OnbrdConfirmAppServiceImpl after changeBoidToVid, aCompId:{},aDeptId:{},aStdPositionId:{},aPositionId:{},aJobId:{}", new Object[]{aCompId, aDeptId, aStdPositionId, aPositionId, aJobId});
    }

    @Override
    public void upgradeDarkPosition(List<DynamicObject> datas) {
        this.createPosition(datas, true);
    }
}

