/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.business.application.impl.onbrd;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Maps;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hom.business.application.onbrd.IOnbrdShareService;
import kd.hr.hom.business.domain.service.ServiceFactory;
import kd.hr.hom.business.domain.service.ssc.AbstractBuildButtonViewService;
import kd.hr.hom.common.enums.OnbrdSharePageEnum;

public class OnbrdShareServiceImpl
implements IOnbrdShareService {
    static EnumMap<OnbrdSharePageEnum, String> onbrdSharePageEnumMap = Maps.newEnumMap(OnbrdSharePageEnum.class);
    private static final Log LOGGER;

    @Override
    public Map<String, Object> getButtonViewByActivityId(Map<String, Object> params) {
        LOGGER.info("###OOnbrdServiceImpl.getButtonViewByActivityId params:{}", params);
        Object activityId = params.get("activityId");
        Object activityNumber = params.get("activityNumber");
        if (HRObjectUtils.isEmpty((Object)activityId) || HRObjectUtils.isEmpty((Object)activityNumber)) {
            return this.buildResultFail("activityId || activityNumber is null");
        }
        OnbrdSharePageEnum onbrdSharePageEnum = OnbrdSharePageEnum.getOnbrdSharePageEnum((String)activityNumber.toString());
        if (HRObjectUtils.isEmpty((Object)onbrdSharePageEnum)) {
            return this.buildResultFail("activityNumber is not match");
        }
        AbstractBuildButtonViewService service = (AbstractBuildButtonViewService)ServiceFactory.getService(onbrdSharePageEnumMap.get(onbrdSharePageEnum));
        if (!HRObjectUtils.isEmpty((Object)service)) {
            try {
                Map<String, Object> buttonViewInfoData = service.buildButtonViewInfo((Long)activityId);
                LOGGER.info("###OOnbrdServiceImpl.getButtonViewByActivityId buildButtonViewInfo:{}", (Object)JSON.toJSONString(buttonViewInfoData));
                return this.buildResultOk(buttonViewInfoData);
            }
            catch (KDBizException e) {
                LOGGER.error("###OnbrdShareServiceImpl.getButtonViewByActivityId.buildButtonViewInfo error:", (Throwable)e);
                return this.buildResultFail(e.getMessage());
            }
        }
        return this.buildResultFail("activityNumber is not match");
    }

    private Map<String, Object> buildResultOk(Map<String, Object> dataMap) {
        HashMap<String, Object> responseMap = new HashMap<String, Object>(2);
        responseMap.put("success", true);
        responseMap.put("data", dataMap);
        return responseMap;
    }

    private Map<String, Object> buildResultFail(String failMsg) {
        HashMap<String, Object> responseMap = new HashMap<String, Object>(2);
        responseMap.put("success", false);
        responseMap.put("data", null);
        responseMap.put("message", failMsg);
        return responseMap;
    }

    static {
        onbrdSharePageEnumMap.put(OnbrdSharePageEnum.HOM_ONBRDAPPROVE, "OnbrdApproveBtnViewStrategy");
        onbrdSharePageEnumMap.put(OnbrdSharePageEnum.HOM_ONBRDCOLLECT, "OnbrdCollectBtnViewStrategy");
        onbrdSharePageEnumMap.put(OnbrdSharePageEnum.HOM_ONBRDCOLLABORATE, "OnbrdCollaborateBtnViewStrategy");
        LOGGER = LogFactory.getLog(OnbrdShareServiceImpl.class);
    }
}

