/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.business.application.impl.onbrd;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowType;
import kd.bos.list.IListView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.operation.OperationServiceImpl;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.hr.hbp.business.servicehelper.HRExportHeadObject;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hom.business.application.impl.page.ShowConfirmPageServiceImpl;
import kd.hr.hom.business.application.onbrd.IOnbrdCommonAppService;
import kd.hr.hom.business.application.onbrd.IOnbrdStartUpAppService;
import kd.hr.hom.business.domain.service.common.IHomDataMutexService;
import kd.hr.hom.business.domain.service.impl.onbrd.OnbrdStartUpProcessService;
import kd.hr.hom.business.domain.service.onbrd.IOnbrdBillDomainService;
import kd.hr.hom.common.enums.ViewTypeEnum;
import kd.hr.hom.common.util.ExportExcelUtil;
import kd.hr.hom.common.util.HOMObjectUtils;
import kd.sdk.hr.hpfs.business.config.service.IDevParamConfigService;

public class OnbrdStartUpAppServiceImpl
implements IOnbrdStartUpAppService {
    private static final Log LOGGER = LogFactory.getLog(OnbrdStartUpAppServiceImpl.class);
    private static final String EXCEL_FIELD_IFCANDOCONFIRM = "ifCanDoConfirm";
    private static final String EXCEL_FIELD_CANNOTCONFIRMREASON = "canNotConfirmReason";
    private static final String STARTUP_SAVE = "startupsave";
    private static final String PROPERTIES_SELECTED = "id,name,resumeno,onbrdtype,aadminorg,certificatetype,certificatenumber,candidate,enrollstatus,checkinstatus,processstatus,starttime,effectdate,aadminorg,aposition,stdposition,ajob,viewtype,againcheckresults,employeeno,isreplacenumber,apositiontype,employeenoscheme,phone,peremail,personfield,personindexid";
    private static final ThreadPool THREAD_POOL = ThreadPools.newFixedThreadPool((String)"OnbrdStartUpAppServiceImpl", (int)30);

    @Override
    public void showStartupConfirmPage(Collection<Long> onbrdIds, IFormView view, CloseCallBack closeCallBack) {
        QFilter qFilter = new QFilter("id", "in", onbrdIds);
        Object[] onbrdBills = IOnbrdBillDomainService.getInstance().findOnbrdBills(PROPERTIES_SELECTED, new QFilter[]{qFilter});
        if (HRArrayUtils.isEmpty((Object[])onbrdBills)) {
            view.showErrorNotification(ResManager.loadKDString((String)"\u6570\u636e\u5e93\u4e2d\u627e\u4e0d\u5230\u5bf9\u5e94\u8bb0\u5f55\u3002", (String)"OnbrdStartUpAppServiceImpl_0", (String)"hr-hom-business", (Object[])new Object[0]));
            return;
        }
        ArrayList<Tuple<DynamicObject, String>> errorBillList = new ArrayList<Tuple<DynamicObject, String>>(onbrdBills.length);
        List<DynamicObject> successBillList = new OnbrdStartUpProcessService().validateStartUpData((DynamicObject[])onbrdBills, errorBillList);
        if (onbrdBills.length == 1) {
            Object onbrdBill = onbrdBills[0];
            String errorMsg = errorBillList.isEmpty() ? null : (String)((Tuple)errorBillList.get((int)0)).item2;
            String viewType = onbrdBill.getString("viewtype");
            this.showSingleConfirmPage(view, closeCallBack.getActionId(), errorMsg, viewType);
            return;
        }
        List successIds = successBillList.stream().map(item -> item.getLong("id")).collect(Collectors.toList());
        List<HRExportHeadObject> excelHead = this.excelHeadGenerator();
        List<Map<String, Object>> excelDataList = this.excelDataListGenerator(errorBillList, successBillList);
        String operation = ResManager.loadKDString((String)"\u542f\u52a8\u5165\u804c\u6d41\u7a0b", (String)"OnbrdStartUpAppServiceImpl_1", (String)"hr-hom-business", (Object[])new Object[0]);
        String fitCondition = ResManager.loadKDString((String)"\u6ee1\u8db3\u542f\u52a8\u6761\u4ef6", (String)"OnbrdStartUpAppServiceImpl_2", (String)"hr-hom-business", (Object[])new Object[0]);
        String noFitCondition = ResManager.loadKDString((String)"\u4e0d\u6ee1\u8db3\u542f\u52a8\u6761\u4ef6", (String)"OnbrdStartUpAppServiceImpl_3", (String)"hr-hom-business", (Object[])new Object[0]);
        String excelName = ResManager.loadKDString((String)"\u542f\u52a8\u5165\u804c\u6d41\u7a0b\u786e\u5b9a", (String)"OnbrdStartUpAppServiceImpl_4", (String)"hr-hom-business", (Object[])new Object[0]);
        FormShowParameter confirmPage = new ShowConfirmPageServiceImpl().getConfirmPage(String.valueOf(onbrdBills.length), String.valueOf(successBillList.size()), String.valueOf(errorBillList.size()), null, operation, operation, fitCondition, noFitCondition, excelName, excelDataList, excelHead, successIds);
        confirmPage.setCloseCallBack(closeCallBack);
        view.showForm(confirmPage);
    }

    private void showSingleConfirmPage(IFormView view, String callBackId, String errorMsg, String viewType) {
        ConfirmCallBackListener callBackListener = new ConfirmCallBackListener(callBackId);
        if (HRStringUtils.isEmpty((String)errorMsg)) {
            if (HRStringUtils.equals((String)viewType, (String)ViewTypeEnum.AGAIN.getCode())) {
                view.showConfirm(ResManager.loadKDString((String)"\u662f\u5426\u786e\u8ba4\u542f\u52a8\u5165\u804c\uff1f", (String)"OnbrdStartUpAppServiceImpl_21", (String)"hr-hom-business", (Object[])new Object[0]), MessageBoxOptions.YesNo, callBackListener);
            } else {
                view.showConfirm(ResManager.loadKDString((String)"\u5df2\u6ee1\u8db3\u542f\u52a8\u6761\u4ef6\uff0c\u53ef\u542f\u52a8\u5165\u804c\u6d41\u7a0b\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u7ee7\u7eed\uff1f", (String)"OnbrdStartUpAppServiceImpl_15", (String)"hr-hom-business", (Object[])new Object[0]), MessageBoxOptions.YesNo, callBackListener);
            }
        } else {
            this.showMessage(view, ResManager.loadKDString((String)"\u4e0d\u6ee1\u8db3\u542f\u52a8\u6761\u4ef6", (String)"OnbrdStartUpAppServiceImpl_3", (String)"hr-hom-business", (Object[])new Object[0]), errorMsg, callBackListener);
        }
    }

    public void showMessage(IFormView view, String msg, String detail, ConfirmCallBackListener callBack) {
        HashMap<String, String> jo = new HashMap<String, String>();
        jo.put("msg", msg);
        jo.put("detail", detail);
        jo.put("messageType", (String)MessageTypes.Default);
        if (callBack != null) {
            jo.put("id", callBack.getCallBackId());
            IPageCache cache = (IPageCache)view.getService(IPageCache.class);
            cache.put("ConfirmCallBackListener." + callBack.getCallBackId(), SerializationUtils.toJsonString((Object)callBack));
        }
        ((IClientViewProxy)view.getService(IClientViewProxy.class)).addAction("showMessage", jo);
    }

    @Override
    public FormShowParameter showResultPage(OperationResult operationResult, Map<Long, Optional<String>> validateErrMap) {
        if (operationResult != null && !operationResult.isSuccess()) {
            LOGGER.error(JSONObject.toJSONString((Object)operationResult));
        }
        int successSize = 0;
        int failSize = 0;
        List<IOperateInfo> allErrorInfo = new ArrayList();
        List<Object> successPkIds = new ArrayList();
        if (operationResult != null) {
            allErrorInfo = operationResult.getAllErrorOrValidateInfo();
            successPkIds = operationResult.getSuccessPkIds();
            successSize = successPkIds.size();
            failSize = (int)((long)failSize + (allErrorInfo == null ? 0L : allErrorInfo.stream().map(operateInfo -> HOMObjectUtils.getLongValOfCustomParam((Object)operateInfo.getPkValue())).distinct().count()));
        }
        if (validateErrMap == null) {
            validateErrMap = new HashMap<Long, Optional<String>>();
        }
        failSize += validateErrMap.size();
        String successMsg = ResManager.loadKDString((String)"\u201c\u542f\u52a8\u5165\u804c\u201d\u64cd\u4f5c\u6210\u529f\u3002", (String)"OnbrdStartUpAppServiceImpl_5", (String)"hr-hom-business", (Object[])new Object[0]);
        String failMsg = ResManager.loadKDString((String)"\u201c\u542f\u52a8\u5165\u804c\u201d\u64cd\u4f5c\u5931\u8d25\u3002", (String)"OnbrdStartUpAppServiceImpl_6", (String)"hr-hom-business", (Object[])new Object[0]);
        String excelName = ResManager.loadKDString((String)"\u542f\u52a8\u5165\u804c\u6d41\u7a0b", (String)"OnbrdStartUpAppServiceImpl_7", (String)"hr-hom-business", (Object[])new Object[0]);
        List<HRExportHeadObject> excelHead = this.excelHeadGenerator();
        List<Map<String, Object>> dataList = this.generateExcelDataList(allErrorInfo, successPkIds, validateErrMap);
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.getOpenStyle().setTargetKey("_submaintab_");
        formShowParameter.setCustomParam("excelname", (Object)excelName);
        formShowParameter.setCustomParam("headdatalist", excelHead);
        formShowParameter.setCustomParam("exportdatalist", dataList);
        formShowParameter.setCustomParam("successperson", (Object)String.valueOf(successSize));
        formShowParameter.setCustomParam("successoperation", (Object)successMsg);
        formShowParameter.setCustomParam("failperson", (Object)String.valueOf(failSize));
        formShowParameter.setCustomParam("failoperation", (Object)failMsg);
        formShowParameter.setFormId("hom_result");
        formShowParameter.setCaption(ResManager.loadKDString((String)"\u64cd\u4f5c\u63d0\u793a", (String)"OnbrdStartUpAppServiceImpl_16", (String)"hr-hom-business", (Object[])new Object[0]));
        return formShowParameter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationResult closedCallBack(IFormView view, List<Long> successIds) {
        OperationResult result;
        Object[] onbrdBills;
        if (CollectionUtils.isEmpty(successIds)) {
            return null;
        }
        boolean checkPermResult = IOnbrdCommonAppService.getInstance().checkPermissionAndShowTips("hom_personwaitstart", "24IKC8A2VZBP", view);
        if (!checkPermResult) {
            return null;
        }
        QFilter qFilter = new QFilter("id", "in", successIds);
        String staffAdminOrg = IDevParamConfigService.getInstance().queryBusinessValueByBusinessKey("staff_adminorg");
        String selectFields = PROPERTIES_SELECTED;
        if (!HRStringUtils.isBlank((CharSequence)staffAdminOrg)) {
            selectFields = HRStringUtils.format((String)"{}{}{}", (Object[])new Object[]{PROPERTIES_SELECTED, ",", staffAdminOrg});
        }
        if (HRArrayUtils.isEmpty((Object[])(onbrdBills = IOnbrdBillDomainService.getInstance().findOnbrdBills(selectFields, new QFilter[]{qFilter})))) {
            LOGGER.info("The data had been delete !");
            return null;
        }
        Map<Long, Optional<String>> validateDataResult = new OnbrdStartUpProcessService().validateData((DynamicObject[])onbrdBills);
        List<Long> validatePassedIds = validateDataResult.entrySet().stream().filter(entry -> !((Optional)entry.getValue()).isPresent()).map(Map.Entry::getKey).collect(Collectors.toList());
        Map<Long, Optional<String>> validateErrMap = validateDataResult.entrySet().stream().filter(entry -> ((Optional)entry.getValue()).isPresent()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        if (CollectionUtils.isEmpty(validatePassedIds)) {
            this.showViewResultPage(view, null, validateErrMap);
            return null;
        }
        IHomDataMutexService homDataMutexService = IHomDataMutexService.getInstance();
        Map<Long, Boolean> batchRequireResult = homDataMutexService.batchRequire(validatePassedIds, "hom_onbrdinfo", "modify");
        List<Long> failLockIds = batchRequireResult.entrySet().stream().filter(entry -> (Boolean)entry.getValue() == false).map(Map.Entry::getKey).collect(Collectors.toList());
        String dataMutexFailMsg = ResManager.loadKDString((String)"\u8be5\u5355\u636e\u4fe1\u606f\u6b63\u5728\u7f16\u8f91\u4e2d\uff0c\u65e0\u6cd5\u542f\u52a8\u5165\u804c\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"OnbrdStartUpAppServiceImpl_17", (String)"hr-hom-business", (Object[])new Object[0]);
        failLockIds.forEach(failLockId -> validateErrMap.put((Long)failLockId, Optional.of(dataMutexFailMsg)));
        IOnbrdCommonAppService.getInstance().showMutexMsgWithOnbrdBill(view, failLockIds, ResManager.loadKDString((String)"\u542f\u52a8\u5165\u804c\u6d41\u7a0b", (String)"OnbrdStartUpAppServiceImpl_1", (String)"hr-hom-business", (Object[])new Object[0]));
        List<Long> successLockIds = batchRequireResult.entrySet().stream().filter(Map.Entry::getValue).map(Map.Entry::getKey).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(successLockIds)) {
            return null;
        }
        try {
            OperateOption option = OperateOption.create();
            option.setVariableValue("currbizappid", view.getFormShowParameter().getAppId());
            OperationServiceImpl operationService = new OperationServiceImpl();
            result = operationService.localInvokeOperation(STARTUP_SAVE, "hom_personwaitstart", (Object[])successLockIds.toArray(new Long[0]), option);
        }
        finally {
            homDataMutexService.batchRelease(successLockIds, "hom_onbrdinfo", "modify");
        }
        if (result != null) {
            List successPkIds = result.getSuccessPkIds().stream().map(id -> Long.parseLong(id.toString())).collect(Collectors.toList());
            String originTraceId = RequestContext.getOrCreate().getTraceId();
            THREAD_POOL.execute(() -> {
                LOGGER.info("originTraceId:{}", (Object)originTraceId);
                new OnbrdStartUpProcessService().sendOnbrdActivityPlanIdToWorkflow(successPkIds);
            }, RequestContext.get());
            this.showViewResultPage(view, result, validateErrMap);
        }
        return result;
    }

    private void showViewResultPage(IFormView view, OperationResult operationResult, Map<Long, Optional<String>> validateErrMap) {
        if (view instanceof IListView) {
            FormShowParameter formShowParameter = this.showResultPage(operationResult, validateErrMap);
            view.showForm(formShowParameter);
            view.invokeOperation("refresh");
        } else {
            if (operationResult != null && !operationResult.isSuccess() && !CollectionUtils.isEmpty((Collection)operationResult.getAllErrorOrValidateInfo())) {
                view.showErrorNotification(((IOperateInfo)operationResult.getAllErrorOrValidateInfo().get(0)).getMessage());
            }
            if (validateErrMap != null && validateErrMap.size() > 0) {
                validateErrMap.values().stream().findFirst().get().ifPresent(arg_0 -> ((IFormView)view).showErrorNotification(arg_0));
            }
        }
    }

    private List<HRExportHeadObject> excelHeadGenerator() {
        ArrayList<HRExportHeadObject> headdatalist = new ArrayList<HRExportHeadObject>(16);
        headdatalist.add(new HRExportHeadObject("candidate.number", ResManager.loadKDString((String)"\u5019\u9009\u4eba\u7f16\u53f7", (String)"OnbrdStartUpAppServiceImpl_8", (String)"hr-hom-business", (Object[])new Object[0])));
        headdatalist.add(new HRExportHeadObject("name", ResManager.loadKDString((String)"\u59d3\u540d", (String)"OnbrdStartUpAppServiceImpl_9", (String)"hr-hom-business", (Object[])new Object[0])));
        headdatalist.add(new HRExportHeadObject("onbrdtype", ResManager.loadKDString((String)"\u5165\u804c\u7c7b\u578b", (String)"OnbrdStartUpAppServiceImpl_10", (String)"hr-hom-business", (Object[])new Object[0])));
        headdatalist.add(new HRExportHeadObject("aadminorg", ResManager.loadKDString((String)"\u5165\u804c\u90e8\u95e8", (String)"OnbrdStartUpAppServiceImpl_11", (String)"hr-hom-business", (Object[])new Object[0])));
        headdatalist.add(new HRExportHeadObject(EXCEL_FIELD_IFCANDOCONFIRM, ResManager.loadKDString((String)"\u80fd\u5426\u542f\u52a8\u5165\u804c\u6d41\u7a0b", (String)"OnbrdStartUpAppServiceImpl_12", (String)"hr-hom-business", (Object[])new Object[0])));
        headdatalist.add(new HRExportHeadObject(EXCEL_FIELD_CANNOTCONFIRMREASON, ResManager.loadKDString((String)"\u4e0d\u80fd\u542f\u52a8\u5165\u804c\u6d41\u7a0b\u539f\u56e0", (String)"OnbrdStartUpAppServiceImpl_13", (String)"hr-hom-business", (Object[])new Object[0])));
        return headdatalist;
    }

    private List<Map<String, Object>> excelDataListGenerator(List<Tuple<DynamicObject, String>> errorBillList, List<DynamicObject> successBillList) {
        errorBillList = errorBillList == null ? new ArrayList() : errorBillList;
        successBillList = successBillList == null ? new ArrayList() : successBillList;
        ArrayList<Map<String, Object>> exportExcelList = new ArrayList<Map<String, Object>>();
        errorBillList.forEach(billTuple -> {
            Map<String, Object> personInfoMap = this.convertDynamicObjectToMapForExcel((DynamicObject)billTuple.item1, (String)billTuple.item2);
            exportExcelList.add(personInfoMap);
        });
        successBillList.forEach(bill -> {
            Map<String, Object> personInfoMap = this.convertDynamicObjectToMapForExcel((DynamicObject)bill, null);
            exportExcelList.add(personInfoMap);
        });
        return exportExcelList;
    }

    private Map<String, Object> convertDynamicObjectToMapForExcel(DynamicObject bill, String errorInfo) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("candidate.number", bill.getString("candidate.number"));
        map.put("name", bill.getString("name"));
        ExportExcelUtil.updateDynamicObjectNameToMap(map, (DynamicObject)bill, (String)"onbrdtype", (String)"onbrdtype");
        ExportExcelUtil.updateDynamicObjectNameToMap(map, (DynamicObject)bill, (String)"aadminorg", (String)"aadminorg");
        if (HRStringUtils.isNotEmpty((String)errorInfo)) {
            map.put(EXCEL_FIELD_IFCANDOCONFIRM, ResManager.loadKDString((String)"\u5426", (String)"OnbrdStartUpAppServiceImpl_19", (String)"hr-hom-business", (Object[])new Object[0]));
            map.put(EXCEL_FIELD_CANNOTCONFIRMREASON, errorInfo);
        } else {
            map.put(EXCEL_FIELD_IFCANDOCONFIRM, ResManager.loadKDString((String)"\u662f", (String)"OnbrdStartUpAppServiceImpl_18", (String)"hr-hom-business", (Object[])new Object[0]));
        }
        return map;
    }

    private List<Map<String, Object>> generateExcelDataList(List<IOperateInfo> allErrorInfo, List<Object> successPkIds, Map<Long, Optional<String>> validateErrMap) {
        List<DynamicObject> successList = null;
        if (!CollectionUtils.isEmpty(successPkIds)) {
            QFilter successIdFilter = new QFilter("id", "in", successPkIds);
            Object[] successArray = IOnbrdBillDomainService.getInstance().findOnbrdBills(PROPERTIES_SELECTED, new QFilter[]{successIdFilter});
            if (!HRArrayUtils.isEmpty((Object[])successArray)) {
                successList = Stream.of(successArray).collect(Collectors.toList());
            }
        }
        ArrayList<Tuple<DynamicObject, String>> errorBillList = new ArrayList<Tuple<DynamicObject, String>>();
        HashSet<Long> failPkIds = new HashSet<Long>();
        if (allErrorInfo != null && !allErrorInfo.isEmpty()) {
            failPkIds.addAll(allErrorInfo.stream().map(operateInfo -> HOMObjectUtils.getLongValOfCustomParam((Object)operateInfo.getPkValue())).collect(Collectors.toSet()));
        }
        if (!CollectionUtils.isEmpty(validateErrMap)) {
            failPkIds.addAll(validateErrMap.keySet());
        }
        QFilter failIdFilter = new QFilter("id", "in", failPkIds);
        DynamicObject[] failArray = IOnbrdBillDomainService.getInstance().findOnbrdBills(PROPERTIES_SELECTED, new QFilter[]{failIdFilter});
        Map<Long, DynamicObject> failBillMap = Stream.of(failArray).collect(Collectors.toMap(bill -> bill.getLong("id"), bill -> bill, (oldValue, newValue) -> newValue));
        if (allErrorInfo != null && !allErrorInfo.isEmpty()) {
            HashSet onbrdIdTempSet = new HashSet(allErrorInfo.size());
            allErrorInfo.forEach(operateInfo -> {
                long onbrdId = HOMObjectUtils.getLongValOfCustomParam((Object)operateInfo.getPkValue());
                if (onbrdIdTempSet.contains(onbrdId)) {
                    LOGGER.info("That has duplicate onbrdId:{}, msg:{}", (Object)onbrdId, (Object)operateInfo.getMessage());
                    return;
                }
                onbrdIdTempSet.add(onbrdId);
                DynamicObject onbrdBill = (DynamicObject)failBillMap.get(onbrdId);
                if (onbrdBill != null) {
                    errorBillList.add(Tuple.create((Object)onbrdBill, (Object)operateInfo.getMessage()));
                } else {
                    LOGGER.info("The onbrdBill of failBillMap is null, onbrdId:{}", (Object)onbrdId);
                }
            });
        }
        if (!CollectionUtils.isEmpty(validateErrMap)) {
            validateErrMap.forEach((key, value) -> value.ifPresent(errMsg -> errorBillList.add(Tuple.create(failBillMap.get(key), (Object)errMsg))));
        }
        return this.excelDataListGenerator(errorBillList, successList);
    }
}

