/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.business.application.impl.onbrd;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.hr.hbp.common.util.HRCollUtil;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRListUtils;
import kd.hr.hbp.common.util.HRMapUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hom.business.application.common.enums.ChgEffectType;
import kd.hr.hom.business.application.hpfs.IPerChgBizService;
import kd.hr.hom.business.application.hrpi.IHomToHrpiAppService;
import kd.hr.hom.business.application.hsbs.IHsbsExternalService;
import kd.hr.hom.business.application.onbrd.IRepealOnbrdConfirmService;
import kd.hr.hom.common.entity.DataDiv;
import kd.hr.hom.common.enums.OnbrdStatusEnum;
import kd.hr.hom.common.enums.SynchStatusEnum;

public class RepealOnbrdConfirmServiceImpl
implements IRepealOnbrdConfirmService {
    public static final Log LOGGER = LogFactory.getLog(RepealOnbrdConfirmServiceImpl.class);
    public static final String EMPLOYEE_ID = "employeeId";
    public static final String DEPEMP_INFO = "depempInfo";

    @Override
    public DataDiv<DynamicObject> validStatusAndProcessBill(DynamicObject onbrdBill) {
        DataDiv dataDiv = new DataDiv((Object)onbrdBill);
        String enrollStatus = onbrdBill.getString("enrollstatus");
        String syncStatus = onbrdBill.getString("synchstatus");
        if (!OnbrdStatusEnum.HAS_ONBRD.getValue().equals(enrollStatus) || !SynchStatusEnum.SYNCH_SUCCESS.getValue().equals(syncStatus)) {
            String msg = ResManager.loadKDString((String)"\u53ea\u80fd\u5bf9\u5165\u804c\u72b6\u6001\u4e3a\u201c\u5df2\u5165\u804c\u201d\u4e14\u540c\u6b65\u7ed3\u679c\u4e3a\u201c\u540c\u6b65\u6210\u529f\u201d\u7684\u5355\u636e\u6267\u884c\u201c\u64a4\u56de\u5165\u804c\u201d\u64cd\u4f5c\u3002", (String)"RepealOnbrdConfirmServiceImpl_1", (String)"hr-hom-business", (Object[])new Object[0]);
            dataDiv.addErrMsg(msg);
            return dataDiv;
        }
        QFilter qFilter = new QFilter("candidate.id", "=", (Object)onbrdBill.getLong("candidate.id"));
        Object[] employees = IHomToHrpiAppService.getInstance().listFieldsFilterInfo("candidate", qFilter, "hrpi_employee");
        if (HRArrayUtils.isNotEmpty((Object[])employees)) {
            dataDiv.addContextParam(EMPLOYEE_ID, (Object)employees[0].getLong("id"));
            dataDiv.addContextParam("employee", employees[0]);
            if (this.validPerChg((DataDiv<DynamicObject>)dataDiv, ChgEffectType.EFFECTED).hasErrMsg() || this.validPerChg((DataDiv<DynamicObject>)dataDiv, ChgEffectType.EFFECTING).hasErrMsg()) {
                return dataDiv;
            }
            if (this.validEmpFilePerChg((DataDiv<DynamicObject>)dataDiv, ChgEffectType.EFFECTED).hasTipMsg() || this.validEmpFilePerChg((DataDiv<DynamicObject>)dataDiv, ChgEffectType.EFFECTING).hasTipMsg()) {
                return dataDiv;
            }
        }
        return dataDiv;
    }

    @Override
    public void callRpcService(DataDiv<DynamicObject> dataDiv) {
        HashMap<String, Object> params = new HashMap<String, Object>(16);
        Object depempInfo = dataDiv.getContextParam(DEPEMP_INFO);
        if (HRObjectUtils.isEmpty((Object)depempInfo)) {
            return;
        }
        DynamicObject depempInfoDy = (DynamicObject)depempInfo;
        params.put("employee_id", dataDiv.getContextParam(EMPLOYEE_ID));
        params.put("depemp_id", depempInfoDy.getLong("id"));
        params.put("person_id", depempInfoDy.getLong("person.id"));
        params.put("cmpemp_id", depempInfoDy.getLong("cmpemp.id"));
        params.put("alaborrelstatus_id", 1080L);
        params.put("contractenddate", new Date());
        params.put("effecttime", HRDateTimeUtils.addDay((Date)new Date(), (long)1L));
        LOGGER.info("###RepealOnbrdConfirmServiceImpl.callRpcServicecall rpc request param:{}", (Object)JSON.toJSONString(params));
        this.callbizInterface("hlcm", "IHLCMService", "quitInvalidContract", params);
        this.callbizInterface("ham", "IHAMQuitService", "quitEffectHam", params);
        this.callbizInterface("hdm", "IPartBillService", "quitNotice", params);
        this.callbizInterface("hdm", "ITransferService", "dealPersonQuit", params);
        this.callbizInterface("hdm", "IRegBillService", "executePersonQuitEffect", params);
        HashMap paramsMap = Maps.newHashMapWithExpectedSize((int)3);
        paramsMap.put("personIds", ImmutableList.of((Object)depempInfoDy.getLong("person.id")));
        paramsMap.put("protocolTypes", ImmutableList.of((Object)"1", (Object)"2"));
        paramsMap.put("terminateCauseId", 1010L);
        this.callbizInterface("hlcm", "IHLCMService", "abandonSignProcess", paramsMap);
    }

    private void callbizInterface(String appid, String serviceName, String methodName, Map<String, Object> params) {
        try {
            LOGGER.info("###RepealOnbrdConfirmServiceImpl.callbizInterface:{}#{}", (Object)serviceName, (Object)methodName);
            Map regResponse = (Map)HRMServiceHelper.invokeHRService((String)appid, (String)serviceName, (String)methodName, (Object[])new Object[]{params});
            LOGGER.info("###RepealOnbrdConfirmServiceImpl.callRpcService call response\uff1a{}", (Object)regResponse);
        }
        catch (Exception e) {
            LOGGER.error("###RepealOnbrdConfirmServiceImpl.callRpcService exception:", (Throwable)e);
        }
    }

    private DataDiv<DynamicObject> validPerChg(DataDiv<DynamicObject> dataDiv, ChgEffectType type) {
        TreeSet errNameSet = new TreeSet();
        Long employeeId = (Long)dataDiv.getContextParam(EMPLOYEE_ID);
        Map<String, Object> perChgParamsMap = null;
        String errMsg = "";
        if (ChgEffectType.EFFECTED.getValue() == type.getValue()) {
            perChgParamsMap = this.buildGetChgRecordParam(employeeId, "1");
            errMsg = ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u751f\u6548\u7684%1$s\u5355\u636e\uff0c\u4e0d\u5141\u8bb8\u64a4\u56de\u3002", (String)"RepealOnbrdConfirmServiceImpl_2", (String)"hr-hom-business", (Object[])new Object[0]);
        }
        if (ChgEffectType.EFFECTING.getValue() == type.getValue()) {
            perChgParamsMap = this.buildGetChgRecordParam(employeeId, "0", "2");
            errMsg = ResManager.loadKDString((String)"\u5df2\u6709\u5728\u9014\u7684%1$s\u5355\u636e\uff0c\u8bf7\u7ec8\u6b62\u5355\u636e\u540e\u518d\u64cd\u4f5c\u64a4\u56de\u3002", (String)"RepealOnbrdConfirmServiceImpl_3", (String)"hr-hom-business", (Object[])new Object[0]);
        }
        Map<Long, List<Map<String, Object>>> perChgResult = IPerChgBizService.getInstance().getChgRecord(perChgParamsMap);
        if (ChgEffectType.EFFECTED.getValue() == type.getValue()) {
            perChgResult.values().forEach(list -> list.removeIf(map -> Objects.equals(1120, map.get("chgevent"))));
        }
        if (!HRMapUtils.isEmpty(perChgResult)) {
            List<Map<String, Object>> perChgInfos = perChgResult.get(employeeId);
            errNameSet.addAll(perChgInfos.stream().map(i -> i.getString("chgeventName")).collect(Collectors.toSet()));
        }
        if (HRCollUtil.isNotEmpty(errNameSet)) {
            String perChgStr = String.join((CharSequence)"\u3001", errNameSet);
            String msg = String.format(errMsg, perChgStr);
            dataDiv.addErrMsg(msg);
        }
        return dataDiv;
    }

    private DataDiv<DynamicObject> validEmpFilePerChg(DataDiv<DynamicObject> dataDiv, ChgEffectType type) {
        Map<Long, List<Map<String, Object>>> empFileListMap;
        TreeSet tipNameSet = new TreeSet();
        Long employeeId = (Long)dataDiv.getContextParam(EMPLOYEE_ID);
        Map<String, Object> empFileParamsMap = null;
        String tipMsg = "";
        if (ChgEffectType.EFFECTED.getValue() == type.getValue()) {
            empFileParamsMap = this.buildQueryAllFileBoByEmpParam(employeeId, "C");
            tipMsg = ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u751f\u6548\u7684%1$s\u5355\u636e\u3002", (String)"RepealOnbrdConfirmServiceImpl_5", (String)"hr-hom-business", (Object[])new Object[0]);
        }
        if (ChgEffectType.EFFECTING.getValue() == type.getValue()) {
            empFileParamsMap = this.buildQueryAllFileBoByEmpParam(employeeId, "A", "B");
            tipMsg = ResManager.loadKDString((String)"\u5df2\u6709\u5728\u9014\u7684%1$s\u5355\u636e\u3002", (String)"RepealOnbrdConfirmServiceImpl_6", (String)"hr-hom-business", (Object[])new Object[0]);
        }
        if (!HRMapUtils.isEmpty(empFileListMap = IHsbsExternalService.getInstance().queryAllFileBoByEmp(empFileParamsMap)) && HRCollUtil.isNotEmpty((Collection)empFileListMap.get(employeeId))) {
            Set fileNames = empFileListMap.get(employeeId).stream().map(i -> i.get("fileName").toString()).collect(Collectors.toSet());
            tipNameSet.addAll(fileNames);
        }
        if (HRCollUtil.isNotEmpty(tipNameSet)) {
            String perChgStr = String.join((CharSequence)"\u3001", tipNameSet);
            String msg = String.format(tipMsg, perChgStr);
            dataDiv.addTipMsg(msg);
        }
        return dataDiv;
    }

    private Map<String, Object> buildGetChgRecordParam(Long employeeId, String ... status) {
        HashMap<String, Object> param = new HashMap<String, Object>(4);
        param.put("sign", EMPLOYEE_ID);
        param.put("signList", Collections.singletonList(employeeId));
        param.put("status", HRListUtils.toList((Object[])status));
        return param;
    }

    private Map<String, Object> buildQueryAllFileBoByEmpParam(Long employeeId, String ... status) {
        HashMap<String, Object> paramsMap = new HashMap<String, Object>(2);
        paramsMap.put("employees", HRListUtils.toList((Object[])new Long[]{employeeId}));
        paramsMap.put("status", HRListUtils.toList((Object[])status));
        return paramsMap;
    }
}

