/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.business.application.impl.processing;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.workflow.MessageCenterServiceHelper;
import kd.bos.url.UrlService;
import kd.bos.workflow.engine.msg.info.MessageInfo;
import kd.hr.hbp.common.util.HRCollUtil;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hom.business.application.utils.SendMessageUtil;
import kd.hr.hom.business.domain.repository.common.HomCommonRepository;
import kd.hr.hom.business.domain.service.activity.IActivityCommonInfoService;
import kd.hr.hom.business.domain.service.impl.activity.ActivityNum;
import kd.hr.hom.business.domain.service.impl.common.SendMessageServiceImpl;
import kd.hr.hom.business.domain.service.onbrd.IOnbrdBillDomainService;
import kd.hr.hom.common.enums.ActivityStatusEnum;
import kd.hr.hom.common.enums.RuleEngineSceneNumberEnum;

public class ActivityHandleTask
extends AbstractTask {
    private static final Log LOGGER = LogFactory.getLog(ActivityHandleTask.class);

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        DynamicObject templateDyn = HomCommonRepository.queryDynamicObjectByNumber("msg_template", "", "OBD017");
        Tuple<Map<Long, Integer>, DynamicObject> result = this.getTotalNum();
        Map totalMap = (Map)result.item1;
        String templateMsg = this.getMessageContext((DynamicObject)result.item2);
        LOGGER.info("ActivityHandleTask_TemplateMsg:{}", (Object)templateMsg);
        if (HRStringUtils.isEmpty((String)templateMsg)) {
            LOGGER.info("ActivityHandleTask_TemplateMsg_isEmpty");
            return;
        }
        totalMap.forEach((userid, value) -> {
            String context = MessageFormat.format(templateMsg, value.toString());
            LocaleString localeStringTitle = ResManager.getLocaleString((String)"\u5165\u804c\u534f\u4f5c\u5904\u7406\u63d0\u9192", (String)"SendMessageUtil_4", (String)"hr-hom-business");
            this.sendMessageById(localeStringTitle, context, (Long)userid, templateDyn);
        });
    }

    private void sendMessageById(LocaleString localeStringTitle, String content, Long userId, DynamicObject templateDyn) {
        ArrayList<Long> userIds = new ArrayList<Long>();
        userIds.add(userId);
        MessageInfo message = new MessageInfo();
        message.setMessageType(templateDyn.getString("msgtype"));
        if (!SendMessageUtil.getMsgChannel(templateDyn.getString("msgchannel"))) {
            return;
        }
        message.setNotifyType(templateDyn.getString("msgchannel"));
        message.setMessageTitle((ILocaleString)localeStringTitle);
        message.setMessageContent((ILocaleString)new LocaleString(content));
        List<Long> filterIds = SendMessageUtil.getFilterIds(userIds);
        if (HRCollUtil.isEmpty(filterIds)) {
            return;
        }
        message.setUserIds(filterIds);
        message.setContentUrl(this.getUrl());
        message.setSendTime(new Date(System.currentTimeMillis()));
        message.setMessageTag((ILocaleString)ResManager.getLocaleString((String)"\u901a\u77e5", (String)"SendMessageUtil_0", (String)"hr-hom-business"));
        message.setEntityNumber(templateDyn.getString("msgentity.id"));
        MessageCenterServiceHelper.batchSendMessages(Collections.singletonList(message));
    }

    private String getMessageContext(DynamicObject activeinfobody) {
        Long billId = activeinfobody.getLong("onbrdid.id");
        String buNum = activeinfobody.getString("onbrdid.org.number");
        LOGGER.info("ActivityHandleTask_getMessageContext_buNum:{}", (Object)buNum);
        QFilter qFilter = new QFilter("id", "=", (Object)billId);
        DynamicObject onbrdBill = IOnbrdBillDomainService.getInstance().findOnbrdBill("", new QFilter[]{qFilter});
        String textMessageTemplateNumber = new SendMessageServiceImpl().getTextMessageTemplateNumber(buNum, RuleEngineSceneNumberEnum.UNDO_NOTICE, onbrdBill);
        LOGGER.info("ActivityHandleTask_getMessageContext_textMessageTemplateNumber:{}", (Object)textMessageTemplateNumber);
        if (HRStringUtils.isEmpty((String)textMessageTemplateNumber)) {
            return null;
        }
        DynamicObject dynamicObject = HomCommonRepository.queryDynamicObjectByNumber("msg_template", "", textMessageTemplateNumber);
        if (dynamicObject == null) {
            return null;
        }
        String msgTemplate = dynamicObject.getString("commonlang");
        JSONObject mObject = JSON.parseObject((String)msgTemplate);
        return HRStringUtils.isBlank((CharSequence)mObject.getString("content")) ? mObject.getString("emailContent") : mObject.getString("content");
    }

    private Tuple<Map<Long, Integer>, DynamicObject> getTotalNum() {
        Map<Object, Object> map = new HashMap();
        QFilter qFilter = new QFilter("activityins.taskstatus", "=", (Object)ActivityStatusEnum.PROCESSING.getValue());
        QFilter typeFilter = new QFilter("activity.id", "not in", ActivityNum.HANDLE_ID_LIST);
        QFilter activity = new QFilter("activityins", "!=", (Object)0L);
        DynamicObject[] dynamicObjects = IActivityCommonInfoService.getInstance().getActivityInfo(new QFilter[]{qFilter, typeFilter, activity});
        if (dynamicObjects == null || dynamicObjects.length == 0) {
            return new Tuple(map, null);
        }
        map = this.getNumMap(dynamicObjects);
        Long billId = dynamicObjects[0].getLong("onbrdid.id");
        String buNum = dynamicObjects[0].getString("onbrdid.org.number");
        LOGGER.info("getTotalNum_buNmb:{},id:{}", (Object)buNum, (Object)billId);
        return Tuple.create(map, (Object)dynamicObjects[0]);
    }

    private Map<Long, Integer> getNumMap(DynamicObject[] dynamicObjects) {
        HashMap<Long, Integer> numMap = new HashMap<Long, Integer>();
        Arrays.stream(dynamicObjects).forEach(dynamicObject -> {
            DynamicObjectCollection collection = dynamicObject.getDynamicObjectCollection("activityins.handlers");
            this.setNumMapInfo(collection, numMap);
        });
        return numMap;
    }

    private void setNumMapInfo(DynamicObjectCollection collection, Map<Long, Integer> numMap) {
        if (CollectionUtils.isEmpty((Collection)collection) || numMap == null) {
            return;
        }
        HashSet userIds = new HashSet();
        collection.stream().forEach(userDy -> userIds.add(userDy.getLong("fbasedataid.id")));
        for (Long userId : userIds) {
            Integer num = numMap.get(userId);
            if (num == null) {
                num = 1;
                numMap.put(userId, num);
                continue;
            }
            Integer n = num;
            Integer n2 = num = Integer.valueOf(num + 1);
            numMap.put(userId, num);
        }
    }

    private String getUrl() {
        String contentUrl = UrlService.getDomainContextUrl();
        HashMap<String, String> parameterMap = new HashMap<String, String>();
        parameterMap.put("taskstatus", ActivityStatusEnum.PROCESSING.getValue());
        parameterMap.put("formId", "hom_activehandlelist");
        String paramString = parameterMap.entrySet().stream().map(entry -> String.format(Locale.ROOT, "%s=%s", entry.getKey(), entry.getValue())).collect(Collectors.joining("&"));
        return String.format(Locale.ROOT, "%s/?%s", contentUrl, paramString);
    }
}

