/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.business.application.impl.processing;

import java.text.ParseException;
import java.util.Date;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hom.business.domain.repository.OnbrdBillRepository;
import kd.hr.hom.business.domain.service.onbrd.IOnbrdBillDomainService;
import kd.hr.hom.common.enums.CheckinStatusEnum;
import kd.hr.hom.common.enums.ExceptionCauseEnum;
import kd.hr.hom.common.enums.OnbrdStatusEnum;

public class EnrollCountOverdueTask
extends AbstractTask {
    private static final Log LOGGER = LogFactory.getLog(EnrollCountOverdueTask.class);

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        Date nowTime = new Date();
        String nowDate = HRDateTimeUtils.format((Date)nowTime, (String)"yyyy-MM-dd");
        try {
            DynamicObject[] overdueObjs;
            QFilter filterCheckinStatus = new QFilter("checkinstatus", "=", (Object)CheckinStatusEnum.WAIT_CHECKIN.getValue());
            QFilter filterEnrollDateLess = new QFilter("preeneffectdate", "<", (Object)HRDateTimeUtils.parseDate((String)nowDate));
            QFilter enrollStatus = new QFilter("enrollstatus", "=", (Object)OnbrdStatusEnum.WAIT_ONBRD.getValue());
            filterCheckinStatus.and(filterEnrollDateLess).and(enrollStatus);
            for (DynamicObject overdueObj : overdueObjs = IOnbrdBillDomainService.getInstance().findOnbrdBills("preenrollstatus,preeneffectdate,preenonbrdtcity,effectdate,onbrdtcity,checkintype,nocheckintimes,ischeckinexception,exceptioncause,checkinstatus,preenonbrdtcity.id,enrollstatus", new QFilter[]{filterCheckinStatus})) {
                overdueObj.set("checkinstatus", (Object)CheckinStatusEnum.CHECKIN_EXCEPTION.toString());
                overdueObj.set("exceptioncause", (Object)ExceptionCauseEnum.NO_CHECKIN.getNumber());
                overdueObj.set("ischeckinexception", (Object)"1");
                overdueObj.set("nocheckintimes", (Object)(overdueObj.getInt("nocheckintimes") + 1));
            }
            OnbrdBillRepository.saveOnbrdBillInfos(overdueObjs);
        }
        catch (ParseException parseException) {
            LOGGER.error(String.valueOf(parseException));
        }
    }
}

