/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.business.application.impl.processing;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.schedule.executor.AbstractTask;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.hr.hom.business.application.utils.ScheduleTaskUtil;
import kd.hr.hom.business.domain.service.hcf.IHcfDataDomainService;
import kd.hr.hom.business.domain.service.onbrd.IOnbrdBillDomainService;
import kd.hr.hom.common.util.HOMObjectUtils;

public class OnbrdNationalityUpgradeTask
extends AbstractTask {
    private static final Log LOGGER = LogFactory.getLog(OnbrdNationalityUpgradeTask.class);

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        IOnbrdBillDomainService onbrdBillService = IOnbrdBillDomainService.getInstance();
        String properties = "id" + "," + "candidate" + "," + "nationality";
        QFilter qfilter = new QFilter("nationality", "=", (Object)0L);
        qfilter.or(new QFilter("nationality", "is null", null));
        Object[] onbrdBills = onbrdBillService.findOnbrdBills(properties, new QFilter[]{qfilter});
        if (HRArrayUtils.isEmpty((Object[])onbrdBills)) {
            ScheduleTaskUtil.disEnableTask("hom_nationality_upgrade_SKDP_S");
            LOGGER.info("That is no data need to Upgrade Nationality");
            return;
        }
        LOGGER.info("Need Upgrade Nationality size:{}", (Object)onbrdBills.length);
        List<Long> candidateIdList = Stream.of(onbrdBills).map(onbrdBill -> onbrdBill.getLong("candidate.id")).collect(Collectors.toList());
        Map<Long, DynamicObject> baseinfoAllMap = this.queryHcfBaseinfoDyMap(candidateIdList);
        Map<Long, DynamicObject> onbrdBillMap = Stream.of(onbrdBills).collect(Collectors.toMap(onbrdBill -> onbrdBill.getLong("candidate.id"), onbrdBill -> onbrdBill, (oldValue, newValue) -> newValue));
        for (Map.Entry<Long, DynamicObject> entry : baseinfoAllMap.entrySet()) {
            DynamicObject onbrdBill2 = onbrdBillMap.get(entry.getKey());
            DynamicObject baseinfo = entry.getValue();
            onbrdBill2.set("nationality", (Object)baseinfo.getLong("nationality.id"));
        }
        onbrdBillService.saveOnbrdBillInfos((DynamicObject[])onbrdBills);
        LOGGER.info("End Upgrade Nationality");
        ScheduleTaskUtil.disEnableTask("hom_nationality_upgrade_SKDP_S");
    }

    private Map<Long, DynamicObject> queryHcfBaseinfoDyMap(List<Long> candidateIdList) {
        int partitionLenght = 100;
        List candidateIdParts = new ArrayList<List<Long>>(16);
        if (candidateIdList.size() > partitionLenght) {
            candidateIdParts = Lists.partition(candidateIdList, (int)partitionLenght);
        } else {
            candidateIdParts.add(candidateIdList);
        }
        String hcfProperties = "id" + "," + "candidate" + "," + "nationality";
        HashMap baseinfoAllMap = Maps.newHashMapWithExpectedSize((int)candidateIdList.size());
        int emptySize = 0;
        for (List candidateIds : candidateIdParts) {
            Map<Long, DynamicObject> baseinfoMap = IHcfDataDomainService.getInstance().querySingleRowEntity(candidateIds, "hcf_canbaseinfo", hcfProperties);
            if (CollectionUtils.isEmpty(baseinfoMap)) continue;
            for (Map.Entry<Long, DynamicObject> entry : baseinfoMap.entrySet()) {
                DynamicObject baseinfo = entry.getValue();
                if (baseinfo.getLong("nationality.id") == 0L) {
                    ++emptySize;
                    continue;
                }
                baseinfoAllMap.put(entry.getKey(), entry.getValue());
            }
        }
        LOGGER.info("Query HcfBaseinfo size:" + baseinfoAllMap.size() + ",emptySize:" + emptySize);
        LOGGER.info("baseinfoAllMap.keySet():" + HOMObjectUtils.toJSONString(baseinfoAllMap.keySet()));
        return baseinfoAllMap;
    }
}

