/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.business.application.impl.processing;

import java.util.Arrays;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hom.business.domain.repository.common.HomCommonRepository;
import kd.hr.hom.common.enums.ActivityStatusEnum;
import kd.hr.hom.common.enums.CheckinStatusEnum;
import kd.hr.hom.common.enums.PreEnrollStatusEnum;

public class StatusUpgradeTask
extends AbstractTask {
    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        this.updatePreStatus();
        this.updateCheckinStatus();
    }

    private void updatePreStatus() {
        QFilter activity = new QFilter("activity", "=", (Object)1296911737613900800L);
        QFilter onbrd = new QFilter("onbrdid", "<>", (Object)0L);
        activity.and(onbrd);
        DynamicObject[] reservationActivityObjs = HomCommonRepository.queryDynamicObjects("hom_activeinfobody", "activityins.taskstatus,onbrdid", activity);
        Set<Object> onbrds = Arrays.stream(reservationActivityObjs).map(dynamicObject -> dynamicObject.getLong("onbrdid.id")).collect(Collectors.toSet());
        DynamicObject[] reservationOnbrdObjs = HomCommonRepository.queryDynamicObjectByPks("hom_onbrdbilltpl", "preenrollstatus", onbrds.toArray(new Object[0]));
        block0: for (DynamicObject reservationActivityObj : reservationActivityObjs) {
            String taskstatus = reservationActivityObj.getString("activityins.taskstatus");
            for (DynamicObject reservationOnbrdObj : reservationOnbrdObjs) {
                long onbrdId = reservationActivityObj.getLong("onbrdid.id");
                if (onbrdId != reservationOnbrdObj.getLong("id")) continue;
                if (ActivityStatusEnum.PROCESSING.getValue().equals(taskstatus) || ActivityStatusEnum.TERMINATED.getValue().equals(taskstatus)) {
                    reservationOnbrdObj.set("preenrollstatus", (Object)PreEnrollStatusEnum.WAIT_RESERVATION.getValue());
                    continue block0;
                }
                if (!ActivityStatusEnum.COMPLETED.getValue().equals(taskstatus)) continue block0;
                reservationOnbrdObj.set("preenrollstatus", (Object)PreEnrollStatusEnum.HAS_RESERVATION.getValue());
                continue block0;
            }
        }
        HomCommonRepository.updateDynamicObjects("hom_onbrdbilltpl", reservationOnbrdObjs);
    }

    private void updateCheckinStatus() {
        QFilter activity = new QFilter("activity", "=", (Object)1296914540574989312L);
        QFilter onbrd = new QFilter("onbrdid", "<>", (Object)0L);
        activity.and(onbrd);
        DynamicObject[] reservationActivityObjs = HomCommonRepository.queryDynamicObjects("hom_activeinfobody", "activityins.taskstatus,onbrdid", activity);
        Set<Object> onbrds = Arrays.stream(reservationActivityObjs).map(dynamicObject -> dynamicObject.getLong("onbrdid.id")).collect(Collectors.toSet());
        DynamicObject[] reservationOnbrdObjs = HomCommonRepository.queryDynamicObjectByPks("hom_onbrdbilltpl", "checkinstatus,preeneffectdate", onbrds.toArray(new Object[0]));
        block0: for (DynamicObject reservationActivityObj : reservationActivityObjs) {
            String taskstatus = reservationActivityObj.getString("activityins.taskstatus");
            for (DynamicObject reservationOnbrdObj : reservationOnbrdObjs) {
                long onbrdId = reservationActivityObj.getLong("onbrdid.id");
                if (onbrdId != reservationOnbrdObj.getLong("id")) continue;
                if (ActivityStatusEnum.PROCESSING.getValue().equals(taskstatus) || ActivityStatusEnum.TERMINATED.getValue().equals(taskstatus)) {
                    Date date = HRDateTimeUtils.truncateDate((Date)new Date());
                    Date preeneffectdate = reservationOnbrdObj.getDate("preeneffectdate");
                    if (preeneffectdate != null && HRDateTimeUtils.dayAfter((Date)date, (Date)preeneffectdate)) {
                        reservationOnbrdObj.set("checkinstatus", (Object)CheckinStatusEnum.CHECKIN_EXCEPTION.getValue());
                        continue block0;
                    }
                    reservationOnbrdObj.set("checkinstatus", (Object)CheckinStatusEnum.WAIT_CHECKIN.getValue());
                    continue block0;
                }
                if (!ActivityStatusEnum.COMPLETED.getValue().equals(taskstatus)) continue block0;
                reservationOnbrdObj.set("checkinstatus", (Object)CheckinStatusEnum.HAS_CHECKIN.getValue());
                continue block0;
            }
        }
        HomCommonRepository.updateDynamicObjects("hom_onbrdbilltpl", reservationOnbrdObjs);
    }
}

