/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.business.application.impl.rule;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.ImportLogger;
import kd.hr.hbp.formplugin.web.imp.MultiEntityRowData;
import kd.hr.hom.business.application.impl.rule.HcfMultiRowCommonValidator;

public class HcfEduExpValidator
extends HcfMultiRowCommonValidator {
    @Override
    protected void validateCustom(String optionCode, List<MultiEntityRowData> rowDataList, ImportLogger importLogger) {
        super.validateCustom(optionCode, rowDataList, importLogger);
        this.validateHighestdegree(optionCode, rowDataList, importLogger);
    }

    private void validateHighestdegree(String optionCode, List<MultiEntityRowData> rowDataList, ImportLogger importLogger) {
        HashMap highestdegreeMap = Maps.newHashMapWithExpectedSize((int)rowDataList.size());
        for (MultiEntityRowData multiEntityRowData : rowDataList) {
            DynamicObject eduExpFromExcel = multiEntityRowData.getOpEntity();
            if (!eduExpFromExcel.getBoolean("ishighestdegree")) continue;
            String candidateNumber = eduExpFromExcel.getString("candidate.number");
            ArrayList<Integer> rowIndexList = (ArrayList<Integer>)highestdegreeMap.get(candidateNumber);
            if (rowIndexList == null) {
                rowIndexList = new ArrayList<Integer>();
            }
            rowIndexList.add(multiEntityRowData.getRownum());
            highestdegreeMap.put(candidateNumber, rowIndexList);
        }
        for (Map.Entry entry : highestdegreeMap.entrySet()) {
            List rowIndexList = (List)entry.getValue();
            if (rowIndexList == null || rowIndexList.size() <= 1) continue;
            StringBuilder rowIndexSb = new StringBuilder();
            rowIndexList.stream().forEach(rowIndex -> rowIndexSb.append(rowIndex + 1).append(','));
            String errorMsg = String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u6570\u636e\u5b58\u5728\u91cd\u590d\uff0c\u6700\u9ad8\u5b66\u5386\u6570\u636e\u5fc5\u987b\u552f\u4e00\u3002", (String)"HcfEduExpValidator_0", (String)"hr-hom-business", (Object[])new Object[0]), rowIndexSb.substring(0, rowIndexSb.length() - 1));
            for (Integer rowIndex2 : rowIndexList) {
                importLogger.log(rowIndex2, errorMsg);
            }
        }
    }
}

