/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.business.application.impl.rule;

import java.util.List;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.ImportLogger;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.imp.MultiEntityRowData;
import kd.hr.hom.business.application.impl.rule.HcfMultiRowCommonValidator;
import kd.hr.hom.business.application.onbrd.IOnbrdCommonAppService;

public class HcfFamilyValidator
extends HcfMultiRowCommonValidator {
    @Override
    protected void validateCustom(String optionCode, List<MultiEntityRowData> rowDataList, ImportLogger importLogger) {
        super.validateCustom(optionCode, rowDataList, importLogger);
        this.locationCodeSplicing(rowDataList, importLogger, "locationcode", "mobilephone");
        this.validateDataFormat(rowDataList, importLogger);
    }

    private void validateDataFormat(List<MultiEntityRowData> rowDataList, ImportLogger importLogger) {
        IOnbrdCommonAppService onbrdCommonAppService = IOnbrdCommonAppService.getInstance();
        for (MultiEntityRowData rowData : rowDataList) {
            Optional<String> phoneResult;
            DynamicObject familyInfoFromExcel = rowData.getOpEntity();
            String phone = familyInfoFromExcel.getString("mobilephone");
            if (HRStringUtils.isNotEmpty((String)phone) && !phone.startsWith("+")) {
                phone = "+" + phone;
                familyInfoFromExcel.set("mobilephone", (Object)phone);
            }
            if (!(phoneResult = onbrdCommonAppService.validatePhone(phone)).isPresent()) continue;
            importLogger.log(rowData.getRownum(), phoneResult.get());
        }
    }
}

