/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.business.application.impl.rule;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.UnmodifiableIterator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.imp.MultiEntityRowData;
import kd.hr.hom.business.application.impl.rule.OnbrdMultiImportValidator;
import kd.hr.hom.business.application.rule.IMultiImportValidatorService;
import kd.hr.hom.business.application.rule.IOnbrdImportCacheService;
import kd.hr.hom.business.domain.service.impl.hcf.HcfDataDomainService;
import kd.hr.hom.business.domain.service.onbrd.IOnbrdBillDomainService;
import kd.hr.hom.common.constant.MultiEntityImportConstants;

public class HcfMultiRowCommonValidator
implements IMultiImportValidatorService {
    private static final Log logger = LogFactory.getLog(HcfMultiRowCommonValidator.class);

    @Override
    public void validate(String optionCode, List<MultiEntityRowData> rowDataList, ImportLogger importLogger) {
        Set<Long> candidateIds;
        if (CollectionUtils.isEmpty(rowDataList)) {
            return;
        }
        String entityName = rowDataList.get(0).getMainEntity();
        this.validateCandidate(rowDataList, importLogger);
        Set errorRows = importLogger.getLogCache().keySet();
        List<MultiEntityRowData> goodRowDataList = rowDataList.stream().filter(rowData -> !errorRows.contains(rowData.getRownum())).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(goodRowDataList)) {
            this.validateCustom(optionCode, goodRowDataList, importLogger);
            this.judgeIfDuplicate(goodRowDataList, importLogger, entityName, (List)MultiEntityImportConstants.ENTITY_UNIQUE_FIELDS_MAP.get((Object)entityName));
        }
        if (HRStringUtils.equals((String)optionCode, (String)"new") && !CollectionUtils.isEmpty(candidateIds = rowDataList.stream().filter(rowData -> errorRows.contains(rowData.getRownum())).map(rowData -> rowData.getOpEntity().getLong("candidate.id")).collect(Collectors.toSet()))) {
            this.deleteByCandidateId(entityName, candidateIds);
        }
    }

    protected void validateCustom(String optionCode, List<MultiEntityRowData> rowDataList, ImportLogger importLogger) {
        logger.info("validateCustom");
    }

    public static String getEntityName(String sheetName) {
        ImmutableMap entityNameMap = ImmutableMap.builder().put((Object)"hcf_caneduexp", (Object)ResManager.loadKDString((String)"\u6559\u80b2\u7ecf\u5386", (String)"HcfMultiRowCommonValidator_3", (String)"hr-hom-business", (Object[])new Object[0])).put((Object)"hcf_cancontact_ext", (Object)ResManager.loadKDString((String)"\u7d27\u6025\u8054\u7cfb\u4eba", (String)"HcfMultiRowCommonValidator_4", (String)"hr-hom-business", (Object[])new Object[0])).put((Object)"hcf_canfamily_ext", (Object)ResManager.loadKDString((String)"\u5bb6\u5ead\u6210\u5458", (String)"HcfMultiRowCommonValidator_5", (String)"hr-hom-business", (Object[])new Object[0])).put((Object)"hcf_canlgability", (Object)ResManager.loadKDString((String)"\u8bed\u8a00\u6280\u80fd", (String)"HcfMultiRowCommonValidator_6", (String)"hr-hom-business", (Object[])new Object[0])).put((Object)"hcf_canprework", (Object)ResManager.loadKDString((String)"\u5de5\u4f5c\u7ecf\u5386", (String)"HcfMultiRowCommonValidator_7", (String)"hr-hom-business", (Object[])new Object[0])).put((Object)"hcf_rsmpatinv", (Object)ResManager.loadKDString((String)"\u4e13\u5229\u53d1\u660e", (String)"HcfMultiRowCommonValidator_8", (String)"hr-hom-business", (Object[])new Object[0])).put((Object)"hcf_canbankcard", (Object)ResManager.loadKDString((String)"\u94f6\u884c\u5361", (String)"HcfMultiRowCommonValidator_9", (String)"hr-hom-business", (Object[])new Object[0])).build();
        return (String)entityNameMap.getOrDefault((Object)sheetName, (Object)"");
    }

    private void validateCandidate(List<MultiEntityRowData> rowDataList, ImportLogger importLogger) {
        Set errorRows = importLogger.getLogCache().keySet();
        List goodRowDataList = rowDataList.stream().filter(rowData -> !errorRows.contains(rowData.getRownum())).collect(Collectors.toList());
        Set candidateNums = goodRowDataList.stream().map(rowData -> rowData.getOpEntity().getString("candidate.number")).collect(Collectors.toSet());
        QFilter qFilter = new QFilter("number", "in", candidateNums);
        Map<String, DynamicObject> candidateMap = new HcfDataDomainService().queryCandidate("number", new QFilter[]{qFilter});
        goodRowDataList.stream().forEach(rowData -> {
            if (HRObjectUtils.isEmpty(candidateMap.get(rowData.getOpEntity().getString("candidate.number")))) {
                importLogger.log(rowData.getRownum(), ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u5019\u9009\u4eba\u3002", (String)"HcfMultiRowCommonValidator_0", (String)"hr-hom-business", (Object[])new Object[0]));
            }
        });
    }

    private Map<String, DynamicObject> getUniqueDataMap(DynamicObject[] records, List<String> uniqueProperties) {
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)records.length);
        for (DynamicObject dynamicObject : records) {
            String key = this.getUniqueKey(dynamicObject, uniqueProperties);
            resultMap.put(key, dynamicObject);
        }
        return resultMap;
    }

    public String getUniqueKey(DynamicObject dynamicObject, List<String> uniqueProperties) {
        String candidateId = dynamicObject.getString("candidate.id");
        if (candidateId == null) {
            logger.info(String.valueOf(dynamicObject.getLong("id")) + " candidate is null");
            candidateId = "0";
        }
        StringBuilder key = new StringBuilder(candidateId);
        for (String property : uniqueProperties) {
            Object object = dynamicObject.get(property);
            String propertyValue = null;
            propertyValue = ObjectUtils.isEmpty((Object)object) ? "0" : (object instanceof DynamicObject ? dynamicObject.getDynamicObject(property).getString("id") : (object instanceof Date ? HRDateTimeUtils.format((Date)dynamicObject.getDate(property), (String)"yyyy/MM/dd") : (object instanceof OrmLocaleValue ? dynamicObject.getLocaleString(property).getLocaleValue() : dynamicObject.getString(property))));
            key.append(':').append(propertyValue);
        }
        return key.toString();
    }

    private void deleteByCandidateId(String entityName, Set<Long> candidateIds) {
        String sheetEntityName;
        logger.info(entityName + ",start candidateIds:" + JSONObject.toJSON(candidateIds));
        HcfDataDomainService hcfDataDomainService = new HcfDataDomainService();
        List<Long> candidateIdSetCurrent = IOnbrdImportCacheService.getInstance().getCurrentNewCandidateIds();
        if (CollectionUtils.isEmpty(candidateIdSetCurrent)) {
            return;
        }
        Set<Long> candidateIdDeletes = candidateIds.stream().filter(candidateId -> candidateIdSetCurrent.contains(candidateId)).collect(Collectors.toSet());
        if (CollectionUtils.isEmpty(candidateIdDeletes)) {
            return;
        }
        logger.info("candidateIdDeletes.size()\uff1a" + candidateIdDeletes.size() + "," + JSONObject.toJSON(candidateIdDeletes));
        List<Long> candidateIdList = candidateIdDeletes.stream().collect(Collectors.toList());
        UnmodifiableIterator unmodifiableIterator = MultiEntityImportConstants.ENTITY_SHEET_SEQUENCE.iterator();
        while (unmodifiableIterator.hasNext() && !HRStringUtils.equals((String)(sheetEntityName = (String)unmodifiableIterator.next()), (String)entityName)) {
            hcfDataDomainService.deleteHcfAttachedData(sheetEntityName, candidateIdList);
        }
        for (String singleRowEntityName : OnbrdMultiImportValidator.HCF_ENTITY_FIELD_MAP.keySet()) {
            hcfDataDomainService.deleteHcfAttachedData(singleRowEntityName, candidateIdList);
        }
        IOnbrdBillDomainService.getInstance().deleteByCandidateIds(candidateIdDeletes);
        hcfDataDomainService.deleteByIds(candidateIdDeletes, "hcf_candidate");
        logger.info(entityName + ",end candidateIds:" + JSONObject.toJSON(candidateIds));
    }

    private void judgeIfDuplicate(List<MultiEntityRowData> rowDataList, ImportLogger importLogger, String entityName, List<String> uniqueProperties) {
        Set<Long> candidateIdSet = rowDataList.stream().map(rowData -> rowData.getOpEntity().getLong("candidate.id")).collect(Collectors.toSet());
        StringBuilder properties = new StringBuilder("candidate");
        uniqueProperties.stream().forEach(property -> properties.append(',').append((String)property));
        DynamicObject[] dataFromDBs = new HcfDataDomainService().queryHcfAttachedData(candidateIdSet, entityName, properties.toString());
        Map<String, DynamicObject> uniqueDBDataMap = this.getUniqueDataMap(dataFromDBs, uniqueProperties);
        HashMap uniqueExcelDataMap = Maps.newHashMapWithExpectedSize((int)rowDataList.size());
        for (MultiEntityRowData rowData2 : rowDataList) {
            DynamicObject currentData = rowData2.getOpEntity();
            String key = this.getUniqueKey(currentData, uniqueProperties);
            DynamicObject dataFromDB = uniqueDBDataMap.get(key);
            if (!HRObjectUtils.isEmpty((Object)dataFromDB) && dataFromDB.getLong("id") != currentData.getLong("id")) {
                importLogger.log(rowData2.getRownum(), ResManager.loadKDString((String)"\u5728\u6570\u636e\u5e93\u5df2\u5b58\u5728\u76f8\u540c\u7684\u6570\u636e\uff1b", (String)"HcfMultiRowCommonValidator_1", (String)"hr-hom-business", (Object[])new Object[0]));
                continue;
            }
            Integer rowNumFromExcel = (Integer)uniqueExcelDataMap.get(key);
            if (!HRObjectUtils.isEmpty((Object)rowNumFromExcel)) {
                importLogger.log(rowData2.getRownum(), String.format(Locale.ROOT, ResManager.loadKDString((String)"\u5728\u7b2c%s\u884c\u5df2\u5b58\u5728\u76f8\u540c\u7684\u6570\u636e\uff1b", (String)"HcfMultiRowCommonValidator_2", (String)"hr-hom-business", (Object[])new Object[0]), rowNumFromExcel + 1));
                continue;
            }
            uniqueExcelDataMap.put(key, rowData2.getRownum());
        }
    }

    public void locationCodeSplicing(List<MultiEntityRowData> rowDataList, ImportLogger importLogger, String locationCode, String phoneCode) {
        for (MultiEntityRowData rowData : rowDataList) {
            DynamicObject opEntity = rowData.getOpEntity();
            String locationCodeStr = opEntity.getString(locationCode);
            String phoneCodeStr = opEntity.getString(phoneCode);
            if (HRStringUtils.isEmpty((String)locationCodeStr) && HRStringUtils.isEmpty((String)phoneCodeStr)) {
                opEntity.set(phoneCode, null);
                continue;
            }
            String phone = locationCodeStr + "-" + phoneCodeStr;
            opEntity.set(phoneCode, (Object)phone);
        }
    }
}

