/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.business.application.impl.rule;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.collect.Table;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.hr.hbp.business.domain.odc.service.CommonPermissionValidateService;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.model.org.staff.StaffQueryOutParam;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hom.business.application.common.ReentryRuleService;
import kd.hr.hom.business.application.common.enums.OnboardChgEnum;
import kd.hr.hom.business.application.hpfs.IPersonFileIntegrateService;
import kd.hr.hom.business.application.hrcs.IHomToHrcsAppService;
import kd.hr.hom.business.application.hrpi.IHomToHrpiAppService;
import kd.hr.hom.business.application.onbrd.IOnbrdCommonAppService;
import kd.hr.hom.business.application.rule.IOnbrdCommonValidator;
import kd.hr.hom.business.application.staff.IStaffUseService;
import kd.hr.hom.business.application.utils.BlackListValidUtil;
import kd.hr.hom.business.domain.repository.common.HomCommonRepository;
import kd.hr.hom.business.domain.service.ServiceFactory;
import kd.hr.hom.business.domain.service.common.IBaseDataDomainService;
import kd.hr.hom.business.domain.service.handler.HPFSTemplatePropertyHandler;
import kd.hr.hom.business.domain.service.hbpm.IHbpmDataDomainService;
import kd.hr.hom.business.domain.service.onbrd.IOnbrdBillDomainService;
import kd.hr.hom.business.domain.service.onbrd.IOnbrdService;
import kd.hr.hom.business.domain.service.preonbrd.IPreOnBrdService;
import kd.hr.hom.common.constant.BaseDataConstants;
import kd.hr.hom.common.constant.BaseDataIdConstants;
import kd.hr.hom.common.entity.DimValueResultDTO;
import kd.hr.hom.common.entity.HomCommonWrapper;
import kd.hr.hom.common.enums.EmployeeNoSchemeEnum;
import kd.hr.hom.common.enums.OnbrdStatusEnum;
import kd.hr.hom.common.enums.PositionTypeEnum;
import kd.hr.hom.common.enums.SynchStatusEnum;
import kd.hr.hom.common.util.HOMObjectUtils;
import kd.hr.hom.common.util.HbpmResultUtils;

public class OnbrdCommonValidator
implements IOnbrdCommonValidator {
    private static final Log LOGGER = LogFactory.getLog(OnbrdCommonValidator.class);
    private static final List<String> KEY_POSTYPE_POSSTATUS = Arrays.asList("postype", "posstatus");

    @Override
    public void validateImportMustInput(List<HomCommonWrapper> rowDataWrapperList) {
        this.validatePositionWithAdminorg(rowDataWrapperList);
        this.validateProbationtime(rowDataWrapperList);
        this.initAndCheckJobInfo(rowDataWrapperList);
        this.initRoleByAposition(rowDataWrapperList);
        this.initConLoc(rowDataWrapperList);
        this.validateEffectDate(rowDataWrapperList);
        LOGGER.info("=====");
    }

    @Override
    public void setDefaultValueBeforeValidate(List<HomCommonWrapper> rowDataWrapperList) {
        for (HomCommonWrapper rowDataWrapper : rowDataWrapperList) {
            DynamicObject onbrdBillFromExcel = rowDataWrapper.getBizData();
            onbrdBillFromExcel.set("leadertype", (Object)"0");
            String locationCodeStr = onbrdBillFromExcel.getString("locationcode");
            String phoneCodeStr = onbrdBillFromExcel.getString("phonecode");
            if (HRStringUtils.isEmpty((String)locationCodeStr) && HRStringUtils.isEmpty((String)phoneCodeStr)) {
                onbrdBillFromExcel.set("phone", null);
                continue;
            }
            String phone = locationCodeStr + "-" + phoneCodeStr;
            onbrdBillFromExcel.set("phone", (Object)phone);
        }
    }

    private void validatePositionWithAdminorg(List<HomCommonWrapper> rowDataWrapperList) {
        Set<Long> apositionIdSet = rowDataWrapperList.stream().map(rowData -> rowData.getBizData().getLong("aposition.id")).collect(Collectors.toSet());
        Map<Long, DynamicObject> apositionMap = IBaseDataDomainService.getInstance().getBaseDataInfoByIds("hbpm_positionhr", apositionIdSet, "adminorg");
        List<Map<String, Long>> orgStdPositions = rowDataWrapperList.stream().filter(rowDataWrapper -> {
            DynamicObject onbrdBillFromExcel = rowDataWrapper.getBizData();
            String apositiontype = onbrdBillFromExcel.getString("apositiontype");
            return HRStringUtils.equals((String)PositionTypeEnum.POSITIONTYPE_STDPOSITION.getValue(), (String)apositiontype) && !HRObjectUtils.isEmpty((Object)onbrdBillFromExcel.getDynamicObject("stdposition"));
        }).map(rowDataWrapper -> {
            HashMap<String, Long> infoMap = new HashMap<String, Long>(4);
            infoMap.put("orgId", rowDataWrapper.getBizData().getLong("aadminorg.id"));
            infoMap.put("standardPositionId", rowDataWrapper.getBizData().getLong("stdposition.id"));
            return infoMap;
        }).collect(Collectors.toList());
        Map<String, Boolean> orgStdPositionMap = IBaseDataDomainService.getInstance().valideStdPositionAndOrg(orgStdPositions);
        for (HomCommonWrapper rowDataWrapper2 : rowDataWrapperList) {
            DynamicObject onbrdBillFromExcel = rowDataWrapper2.getBizData();
            String apositiontype = onbrdBillFromExcel.getString("apositiontype");
            if (HRStringUtils.equals((String)PositionTypeEnum.POSITIONTYPE_STDPOSITION.getValue(), (String)apositiontype)) {
                DynamicObject stdposition = onbrdBillFromExcel.getDynamicObject("stdposition");
                if (HRObjectUtils.isEmpty((Object)stdposition)) {
                    rowDataWrapper2.addErrMsg(ResManager.loadKDString((String)"\u4efb\u5c97\u6a21\u5f0f\u4e3a\u201c\u5165\u804c\u5230\u6807\u51c6\u5c97\u4f4d\u201d\uff0c\u6807\u51c6\u5c97\u4f4d\u5fc5\u586b\u3002", (String)"OnbrdCommonValidator_0", (String)"hr-hom-business", (Object[])new Object[0]));
                    continue;
                }
                String key = onbrdBillFromExcel.getLong("aadminorg.id") + "-" + onbrdBillFromExcel.getLong("stdposition.id");
                Boolean ifPassed = orgStdPositionMap.get(key);
                if (ifPassed != null && ifPassed.booleanValue()) {
                    onbrdBillFromExcel.set("aposition", null);
                    onbrdBillFromExcel.set("ajob", null);
                    continue;
                }
                LOGGER.info("key:{}", (Object)key);
                rowDataWrapper2.addErrMsg(ResManager.loadKDString((String)"\u6240\u586b\u6807\u51c6\u5c97\u4f4d\u975e\u5165\u804c\u90e8\u95e8\u4e0b\u5c97\u4f4d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"OnbrdCommonValidator_22", (String)"hr-hom-business", (Object[])new Object[0]));
                continue;
            }
            if (HRStringUtils.equals((String)PositionTypeEnum.POSITIONTYPE_POSITION.getValue(), (String)apositiontype)) {
                DynamicObject apositionInfo;
                DynamicObject aposition = onbrdBillFromExcel.getDynamicObject("aposition");
                if (HRObjectUtils.isEmpty((Object)aposition)) {
                    rowDataWrapper2.addErrMsg(ResManager.loadKDString((String)"\u4efb\u5c97\u6a21\u5f0f\u4e3a\u201c\u5165\u804c\u5230\u5c97\u4f4d\u201d\uff0c\u5c97\u4f4d\u5fc5\u586b\u3002", (String)"OnbrdCommonValidator_1", (String)"hr-hom-business", (Object[])new Object[0]));
                    continue;
                }
                onbrdBillFromExcel.set("stdposition", null);
                onbrdBillFromExcel.set("ajob", null);
                long adminorgId = onbrdBillFromExcel.getLong("aadminorg.id");
                if (adminorgId == (apositionInfo = apositionMap.get(aposition.getLong("id"))).getLong("adminorg.id")) continue;
                rowDataWrapper2.addErrMsg(ResManager.loadKDString((String)"\u6240\u586b\u5c97\u4f4d\u975e\u5165\u804c\u90e8\u95e8\u4e0b\u5c97\u4f4d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"OnbrdCommonValidator_3", (String)"hr-hom-business", (Object[])new Object[0]));
                continue;
            }
            DynamicObject job = onbrdBillFromExcel.getDynamicObject("ajob");
            if (HRObjectUtils.isEmpty((Object)job)) {
                rowDataWrapper2.addErrMsg(ResManager.loadKDString((String)"\u4efb\u5c97\u6a21\u5f0f\u4e3a\u201c\u5165\u804c\u5230\u804c\u4f4d\u201d\uff0c\u804c\u4f4d\u5fc5\u586b\u3002", (String)"OnbrdCommonValidator_2", (String)"hr-hom-business", (Object[])new Object[0]));
                continue;
            }
            onbrdBillFromExcel.set("aposition", null);
            onbrdBillFromExcel.set("stdposition", null);
        }
    }

    private void validateProbationtime(List<HomCommonWrapper> rowDataWrapperList) {
        List<Long> laborrelstatusIds = rowDataWrapperList.stream().map(rowDataWrapper -> rowDataWrapper.getBizData().getLong("laborrelstatus.id")).collect(Collectors.toList());
        Map<Long, DynamicObject> laborrelstatusMap = IBaseDataDomainService.getInstance().getBaseDataInfoByIds("hbss_laborrelstatus", laborrelstatusIds, "labrelstatuscls");
        for (HomCommonWrapper rowDataWrapper2 : rowDataWrapperList) {
            boolean isProbation;
            DynamicObject onbrdBillFromExcel = rowDataWrapper2.getBizData();
            boolean flag = onbrdBillFromExcel.getBoolean("isprobation");
            if (flag) {
                Object probationTime = onbrdBillFromExcel.get("probationtime");
                Object perprobationTime = onbrdBillFromExcel.get("perprobationtime");
                if (HRObjectUtils.isEmpty((Object)probationTime) || HRObjectUtils.isEmpty((Object)perprobationTime)) {
                    rowDataWrapper2.addErrMsg(ResManager.loadKDString((String)"\u662f\u5426\u8bd5\u7528\u671f\u4e3a\u201c\u662f\u201d\u65f6\uff0c\u5fc5\u987b\u586b\u5199\u8bd5\u7528\u671f\u548c\u8bd5\u7528\u671f\u9650\u5355\u4f4d\u3002", (String)"OnbrdImportValidator_4", (String)"hr-hom-business", (Object[])new Object[0]));
                }
            } else {
                onbrdBillFromExcel.set("probationtime", (Object)0);
                onbrdBillFromExcel.set("perprobationtime", (Object)"4");
            }
            long laborrelstatusId = onbrdBillFromExcel.getLong("laborrelstatus.id");
            DynamicObject laborrelstatus = laborrelstatusMap.get(laborrelstatusId);
            boolean bl = isProbation = laborrelstatus != null && BaseDataIdConstants.HBSS_LABRELSTATUSCLS_1010.equals(laborrelstatus.getLong("labrelstatuscls.id"));
            if (flag && !isProbation) {
                rowDataWrapper2.addErrMsg(ResManager.loadKDString((String)"\u8be5\u5458\u5de5\u7684\u7528\u5de5\u5173\u7cfb\u72b6\u6001\u5206\u7c7b\u4e0d\u7b49\u4e8e\u201c\u8bd5\u7528\u201d\uff0c\u662f\u5426\u6709\u8bd5\u7528\u671f\u5e94\u4e3a\u201c\u5426\u201d\uff0c\u8bd5\u7528\u671f\u5e94\u4e3a\u7a7a\u3002", (String)"OnbrdCommonValidator_21", (String)"hr-hom-business", (Object[])new Object[0]));
                continue;
            }
            if (flag || !isProbation) continue;
            rowDataWrapper2.addErrMsg(ResManager.loadKDString((String)"\u8be5\u5458\u5de5\u7684\u7528\u5de5\u5173\u7cfb\u72b6\u6001\u5206\u7c7b\u7b49\u4e8e\u201c\u8bd5\u7528\u201d\uff0c\u662f\u5426\u6709\u8bd5\u7528\u671f\u5e94\u4e3a\u201c\u662f\u201d\uff0c\u8bd5\u7528\u671f\u4e0d\u5e94\u4e3a\u7a7a\u3002", (String)"OnbrdCommonValidator_23", (String)"hr-hom-business", (Object[])new Object[0]));
        }
    }

    @Override
    public void initAndCheckJobInfo(List<HomCommonWrapper> rowDataWrapperList) {
        Set apositionIdSet = rowDataWrapperList.stream().map(rowData -> rowData.getBizData().getLong("aposition.id")).collect(Collectors.toSet());
        Set stdpositionIdset = rowDataWrapperList.stream().map(rowData -> rowData.getBizData().getLong("stdposition.id")).collect(Collectors.toSet());
        List<Long> jobIdset = rowDataWrapperList.stream().map(rowData -> rowData.getBizData().getLong("ajob.id")).collect(Collectors.toList());
        ArrayList<Long> apositionIdList = new ArrayList<Long>(apositionIdSet);
        ArrayList<Long> stdpositionIdList = new ArrayList<Long>(stdpositionIdset);
        Map<Long, Map<String, Object>> stdpositionResultMap = IHbpmDataDomainService.getInstance().getBatchStandardBuScmJob(stdpositionIdList);
        Map<Long, Map<String, Object>> apositionResultMap = IHbpmDataDomainService.getInstance().getBatchHrBuScmJob(apositionIdList);
        Map<Long, Object> stdpositionLevelAndGradeMap = IHbpmDataDomainService.getInstance().queryJobLevelAndJobGradeByStdPositionIds(stdpositionIdList);
        Map<Long, Object> apositionLevelAndGradeMap = IHbpmDataDomainService.getInstance().queryJobLevelAndJobGradeByPositionIds(apositionIdList);
        Map<Long, Map<String, List<DynamicObject>>> jobLevelGradeInfosMap = IBaseDataDomainService.getInstance().getJobLevelGradesByJobIds(jobIdset);
        this.preCheckJoblevelgradeScm(rowDataWrapperList);
        Map<Long, Long> jobIdRecheckMap = this.setAjobByPosition(rowDataWrapperList, stdpositionResultMap, apositionResultMap);
        for (HomCommonWrapper rowDataWrapper : rowDataWrapperList) {
            Map<String, List<DynamicObject>> jobLevelGradeInfoMap;
            Map stdpositionLevelGradeMap;
            DynamicObject onbrdBillFromExcel = rowDataWrapper.getBizData();
            Map positionLevelGradeMap = HRObjectUtils.isEmpty(apositionLevelAndGradeMap) ? null : (Map)apositionLevelAndGradeMap.get(onbrdBillFromExcel.getLong("aposition.id"));
            boolean ifRecheck = this.checkAjobLevelGrade(rowDataWrapper, positionLevelGradeMap, stdpositionLevelGradeMap = HRObjectUtils.isEmpty(stdpositionLevelAndGradeMap) ? null : (Map)stdpositionLevelAndGradeMap.get(onbrdBillFromExcel.getLong("stdposition.id")), jobLevelGradeInfoMap = HRObjectUtils.isEmpty(jobLevelGradeInfosMap) ? null : jobLevelGradeInfosMap.get(onbrdBillFromExcel.getLong("ajob.id")));
            if (!ifRecheck || HOMObjectUtils.isEmptyWithDynamicObjectField((DynamicObject)onbrdBillFromExcel, (String)"ajob")) continue;
            Long jobId = HOMObjectUtils.getDynamicObjectFieldId((DynamicObject)onbrdBillFromExcel, (String)"ajob");
            jobIdRecheckMap.put(onbrdBillFromExcel.getLong("id"), jobId);
        }
        this.recheckAndSetValueWithJoblevelgrade(rowDataWrapperList, jobIdRecheckMap);
        this.checkJoblevelgradeScm(rowDataWrapperList);
    }

    private void preCheckJoblevelgradeScm(List<HomCommonWrapper> rowDataWrapperList) {
        for (HomCommonWrapper rowDataWrapper : rowDataWrapperList) {
            DynamicObject onbrdBillFromExcel = rowDataWrapper.getBizData();
            String aJobLevelText = onbrdBillFromExcel.getString("ajobleveltext");
            long joblevelscmId = onbrdBillFromExcel.getLong("joblevelscm.id");
            if (HRStringUtils.isNotEmpty((String)aJobLevelText) && joblevelscmId == 0L) {
                rowDataWrapper.addErrMsg(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u804c\u7ea7\u5bf9\u5e94\u7684\u804c\u7ea7\u65b9\u6848\u3002", (String)"OnbrdCommonValidator_5", (String)"hr-hom-business", (Object[])new Object[0]));
            }
            String aJobgradeText = onbrdBillFromExcel.getString("ajobgradetext");
            long jobgradescmId = onbrdBillFromExcel.getLong("jobgradescm.id");
            if (HRStringUtils.isNotEmpty((String)aJobgradeText) && jobgradescmId == 0L) {
                rowDataWrapper.addErrMsg(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u804c\u7b49\u5bf9\u5e94\u7684\u804c\u7b49\u65b9\u6848\u3002", (String)"OnbrdCommonValidator_9", (String)"hr-hom-business", (Object[])new Object[0]));
            }
            if (HRStringUtils.isNotEmpty((String)aJobLevelText)) {
                onbrdBillFromExcel.set("ajoblevel", null);
            }
            if (!HRStringUtils.isNotEmpty((String)aJobgradeText)) continue;
            onbrdBillFromExcel.set("ajobgrade", null);
        }
    }

    private void recheckAndSetValueWithJoblevelgrade(List<HomCommonWrapper> rowDataWrapperList, Map<Long, Long> jobIdRecheckMap) {
        ArrayList<Long> jobIdList = new ArrayList<Long>(jobIdRecheckMap.values());
        Map<Long, Map<String, Object>> jobinfosMap = IBaseDataDomainService.getInstance().getJobLevelGradeRangeInfoByJobIds(jobIdList);
        LOGGER.info("jobinfosMap.size():{}, jobIdRecheckMap.keySet():{}", (Object)jobinfosMap.size(), jobIdRecheckMap.keySet());
        for (HomCommonWrapper rowDataWrapper : rowDataWrapperList) {
            DynamicObject onbrdBillFromExcel = rowDataWrapper.getBizData();
            long jobId = HOMObjectUtils.getDynamicObjectFieldId((DynamicObject)onbrdBillFromExcel, (String)"ajob");
            Map<String, Object> jobinfo = jobinfosMap.get(jobId);
            if (!jobIdRecheckMap.containsKey(onbrdBillFromExcel.getLong("id")) || jobinfo == null) {
                LOGGER.info("jobId:{}", (Object)jobId);
                continue;
            }
            long joblevelscmIdExcel = onbrdBillFromExcel.getLong("joblevelscm.id");
            long joblevelscmIdQuery = HOMObjectUtils.getLongValOfCustomParam((Object)jobinfo.get("joblevelScmid"));
            if (joblevelscmIdQuery != 0L && joblevelscmIdExcel != 0L && joblevelscmIdQuery != joblevelscmIdExcel) {
                rowDataWrapper.addErrMsg(ResManager.loadKDString((String)"\u6240\u586b\u804c\u7ea7\u65b9\u6848\u4e0e\u804c\u4f4d\u4fe1\u606f\u4e0d\u5339\u914d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"OnbrdCommonValidator_17", (String)"hr-hom-business", (Object[])new Object[0]));
            } else if (joblevelscmIdQuery != 0L && joblevelscmIdExcel == 0L) {
                HOMObjectUtils.setDynamicObjectId((DynamicObject)onbrdBillFromExcel, (String)"joblevelscm", (Object)joblevelscmIdQuery);
            }
            long jobgradescmIdExcel = onbrdBillFromExcel.getLong("jobgradescm.id");
            long jobgradescmIdQuery = HOMObjectUtils.getLongValOfCustomParam((Object)jobinfo.get("jobgradeScmid"));
            if (jobgradescmIdQuery != 0L && jobgradescmIdExcel != 0L && jobgradescmIdQuery != jobgradescmIdExcel) {
                rowDataWrapper.addErrMsg(ResManager.loadKDString((String)"\u6240\u586b\u804c\u7b49\u65b9\u6848\u4e0e\u804c\u4f4d\u4fe1\u606f\u4e0d\u5339\u914d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"OnbrdCommonValidator_18", (String)"hr-hom-business", (Object[])new Object[0]));
            } else if (jobgradescmIdQuery != 0L && jobgradescmIdExcel == 0L) {
                HOMObjectUtils.setDynamicObjectId((DynamicObject)onbrdBillFromExcel, (String)"jobgradescm", (Object)jobgradescmIdQuery);
            }
            List joblevelRanges = (List)jobinfo.get("joblevelRanges");
            String aJobLevelText = onbrdBillFromExcel.getString("ajobleveltext");
            DynamicObject aJobLevel = onbrdBillFromExcel.getDynamicObject("ajoblevel");
            if (joblevelRanges != null && joblevelRanges.size() > 0 && HRStringUtils.isNotEmpty((String)aJobLevelText) && aJobLevel == null) {
                Map<String, DynamicObject> joblevelRangeMap = joblevelRanges.stream().collect(Collectors.toMap(joblevel -> joblevel.getString("name"), joblevel -> joblevel, (oldValue, newValue) -> newValue));
                aJobLevel = joblevelRangeMap.get(aJobLevelText);
                if (aJobLevel != null) {
                    onbrdBillFromExcel.set("ajoblevel", (Object)aJobLevel);
                } else {
                    rowDataWrapper.addErrMsg(ResManager.loadKDString((String)"\u672a\u5339\u914d\u5230\u804c\u4f4d\u4fe1\u606f\u53ef\u9009\u8303\u56f4\u5185\u7684\u804c\u7ea7\u3002", (String)"OnbrdCommonValidator_19", (String)"hr-hom-business", (Object[])new Object[0]));
                }
            } else {
                LOGGER.info("joblevelRanges is empty OR aJobLevel != null");
            }
            List jobgradeRanges = (List)jobinfo.get("jobgradeRanges");
            String aJobgradeText = onbrdBillFromExcel.getString("ajobgradetext");
            DynamicObject aJobgrade = onbrdBillFromExcel.getDynamicObject("ajobgrade");
            if (jobgradeRanges != null && jobgradeRanges.size() > 0 && HRStringUtils.isNotEmpty((String)aJobgradeText) && aJobgrade == null) {
                Map<String, DynamicObject> jobgradeRangeMap = jobgradeRanges.stream().collect(Collectors.toMap(jobgrade -> jobgrade.getString("name"), jobgrade -> jobgrade, (oldValue, newValue) -> newValue));
                aJobgrade = jobgradeRangeMap.get(aJobgradeText);
                if (aJobgrade != null) {
                    onbrdBillFromExcel.set("ajobgrade", (Object)aJobgrade);
                    continue;
                }
                rowDataWrapper.addErrMsg(ResManager.loadKDString((String)"\u672a\u5339\u914d\u5230\u804c\u4f4d\u4fe1\u606f\u53ef\u9009\u8303\u56f4\u5185\u7684\u804c\u7b49\u3002", (String)"OnbrdCommonValidator_20", (String)"hr-hom-business", (Object[])new Object[0]));
                continue;
            }
            LOGGER.info("jobgradeRanges is empty OR aJobgrade != null");
        }
    }

    private void checkPermissionWithJob(List<HomCommonWrapper> rowDataWrapperList) {
        DimValueResultDTO dimValueWithSub = IHomToHrcsAppService.getInstance().getDimValueWithSub("hom_onbrdinfo", "ajobscmorg");
        if (dimValueWithSub == null || dimValueWithSub.isAll()) {
            LOGGER.info("dimValueResult == null || dimValueResult.isAll()");
            return;
        }
        List jobIdset = rowDataWrapperList.stream().map(rowData -> rowData.getBizData().getLong("ajob.id")).collect(Collectors.toList());
        QFilter qFilter = BaseDataServiceHelper.getBaseDataFilter((String)"hjm_jobhr", (List)dimValueWithSub.getOrgIds(), (boolean)true);
        qFilter.and("id", "in", jobIdset);
        Map<Long, List<DynamicObject>> jobIdMaps = BaseDataServiceHelper.queryBaseData((String)"hjm_jobhr", null, (QFilter)qFilter, (String)"id").stream().collect(Collectors.groupingBy(i -> i.getLong("id")));
        for (HomCommonWrapper rowDataWrapper : rowDataWrapperList) {
            DynamicObject onbrdBillFromExcel = rowDataWrapper.getBizData();
            boolean isJobType = "2".equals(onbrdBillFromExcel.getString("apositiontype"));
            boolean notExistCanUseJobId = HRObjectUtils.isEmpty(jobIdMaps.get(onbrdBillFromExcel.getLong("ajob.id")));
            if (!isJobType || !notExistCanUseJobId) continue;
            rowDataWrapper.addErrMsg(ResManager.loadKDString((String)"\u586b\u5199\u7684\u804c\u4f4d\u4e0d\u5728\u6743\u9650\u8303\u56f4\u5185\uff0c\u8bf7\u4fee\u6539\u3002", (String)"OnbrdCommonValidator_4", (String)"hr-hom-business", (Object[])new Object[0]));
        }
    }

    private void checkJoblevelgradeScm(List<HomCommonWrapper> rowDataWrapperList) {
        IBaseDataDomainService baseDataDomainService = IBaseDataDomainService.getInstance();
        Set<Long> jobLevelIds = rowDataWrapperList.stream().map(rowData -> rowData.getBizData().getLong("ajoblevel.id")).collect(Collectors.toSet());
        Set<Long> jobGradeIds = rowDataWrapperList.stream().map(rowData -> rowData.getBizData().getLong("ajobgrade.id")).collect(Collectors.toSet());
        Map<Long, DynamicObject> jobLevelMap = baseDataDomainService.getBaseDataInfoByIds("hbjm_joblevelhr", jobLevelIds, "joblevelscm");
        Map<Long, DynamicObject> jobGradeMap = baseDataDomainService.getBaseDataInfoByIds("hbjm_jobgradehr", jobGradeIds, "jobgradescm");
        List<Map<String, Object>> levelScmInfos = rowDataWrapperList.stream().filter(rowData -> HRStringUtils.isNotEmpty((String)rowData.getBizData().getString("ajobleveltext"))).map(rowData -> {
            HashMap levelScmInfo = Maps.newHashMapWithExpectedSize((int)3);
            DynamicObject onbrdBill = rowData.getBizData();
            levelScmInfo.put("scmId", onbrdBill.getLong("joblevelscm.id"));
            levelScmInfo.put("joblevelName", onbrdBill.getString("ajobleveltext"));
            return levelScmInfo;
        }).collect(Collectors.toList());
        Map<Object, Object> levelQueryInfosMap = CollectionUtils.isEmpty(levelScmInfos) ? new HashMap() : baseDataDomainService.getJobLevelInfoByScmId(levelScmInfos);
        List<Map<String, Object>> gradeScmInfos = rowDataWrapperList.stream().filter(rowData -> HRStringUtils.isNotEmpty((String)rowData.getBizData().getString("ajobgradetext"))).map(rowData -> {
            HashMap gradeScmInfo = Maps.newHashMapWithExpectedSize((int)3);
            DynamicObject onbrdBill = rowData.getBizData();
            gradeScmInfo.put("scmId", onbrdBill.getLong("jobgradescm.id"));
            gradeScmInfo.put("jobgradeName", onbrdBill.getString("ajobgradetext"));
            return gradeScmInfo;
        }).collect(Collectors.toList());
        Map<Object, Object> gradeQueryInfosMap = CollectionUtils.isEmpty(gradeScmInfos) ? new HashMap() : baseDataDomainService.getJobGradeInfoByScmId(gradeScmInfos);
        for (HomCommonWrapper rowDataWrapper : rowDataWrapperList) {
            DynamicObject onbrdBillFromExcel = rowDataWrapper.getBizData();
            long joblevelId = onbrdBillFromExcel.getLong("ajoblevel.id");
            String aJobLevelText = onbrdBillFromExcel.getString("ajobleveltext");
            long joblevelscmId = onbrdBillFromExcel.getLong("joblevelscm.id");
            if (joblevelId != 0L && joblevelscmId != 0L && jobLevelMap.get(joblevelId).getLong("joblevelscm.id") != joblevelscmId) {
                rowDataWrapper.addErrMsg(ResManager.loadKDString((String)"\u804c\u7ea7\u65b9\u6848\u4e0e\u804c\u7ea7\u4e0d\u5339\u914d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"OnbrdCommonValidator_7", (String)"hr-hom-business", (Object[])new Object[0]));
            } else if (HRStringUtils.isNotEmpty((String)aJobLevelText) && joblevelId == 0L && joblevelscmId != 0L) {
                String key = joblevelscmId + "-" + aJobLevelText;
                Map levelQueryInfo = (Map)levelQueryInfosMap.get(key);
                if (levelQueryInfo == null || HOMObjectUtils.isEmpty(levelQueryInfo.get("joblevel"))) {
                    LOGGER.info("cannot find joblevel:{}", (Object)key);
                    rowDataWrapper.addErrMsg(ResManager.loadKDString((String)"\u804c\u7ea7\u4e0e\u804c\u7ea7\u65b9\u6848\u4e0d\u5339\u914d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"OnbrdCommonValidator_8", (String)"hr-hom-business", (Object[])new Object[0]));
                } else {
                    onbrdBillFromExcel.set("ajoblevel", levelQueryInfo.get("joblevel"));
                }
            }
            long jobgradeId = onbrdBillFromExcel.getLong("ajobgrade.id");
            String aJobgradeText = onbrdBillFromExcel.getString("ajobgradetext");
            long jobgradescmId = onbrdBillFromExcel.getLong("jobgradescm.id");
            if (jobgradeId != 0L && jobgradescmId != 0L && jobGradeMap.get(jobgradeId).getLong("jobgradescm.id") != jobgradescmId) {
                rowDataWrapper.addErrMsg(ResManager.loadKDString((String)"\u804c\u7b49\u65b9\u6848\u4e0e\u804c\u7b49\u4e0d\u5339\u914d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"OnbrdCommonValidator_11", (String)"hr-hom-business", (Object[])new Object[0]));
                continue;
            }
            if (!HRStringUtils.isNotEmpty((String)aJobgradeText) || jobgradeId != 0L || jobgradescmId == 0L) continue;
            String key = jobgradescmId + "-" + aJobgradeText;
            Map gradeQueryInfo = (Map)gradeQueryInfosMap.get(key);
            if (gradeQueryInfo == null || HOMObjectUtils.isEmpty(gradeQueryInfo.get("jobgrade"))) {
                LOGGER.info("cannot find jobgrade:{}", (Object)key);
                rowDataWrapper.addErrMsg(ResManager.loadKDString((String)"\u804c\u7b49\u4e0e\u804c\u7b49\u65b9\u6848\u4e0d\u5339\u914d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"OnbrdCommonValidator_12", (String)"hr-hom-business", (Object[])new Object[0]));
                continue;
            }
            onbrdBillFromExcel.set("ajobgrade", gradeQueryInfo.get("jobgrade"));
        }
    }

    public void initRoleByAposition(List<HomCommonWrapper> rowDataWrapperList) {
        HashSet<Long> positionIds = new HashSet<Long>(rowDataWrapperList.size());
        ArrayList<Long> rolesId = new ArrayList<Long>(rowDataWrapperList.size());
        ArrayList<DynamicObject> roleOnbrds = new ArrayList<DynamicObject>(rowDataWrapperList.size());
        for (HomCommonWrapper rowDataWrapper : rowDataWrapperList) {
            DynamicObject onbrdBillFromExcel = rowDataWrapper.getBizData();
            String apositiontype = onbrdBillFromExcel.getString("apositiontype");
            if (!HRStringUtils.equals((String)"1", (String)apositiontype)) continue;
            positionIds.add(onbrdBillFromExcel.getLong("aposition.id"));
            roleOnbrds.add(onbrdBillFromExcel);
        }
        this.setRoleByAposition(positionIds, rolesId, roleOnbrds);
    }

    private void initConLoc(List<HomCommonWrapper> rowDataWrapperList) {
        HashSet<String> locName = new HashSet<String>(rowDataWrapperList.size());
        for (HomCommonWrapper rowDataWrapper : rowDataWrapperList) {
            DynamicObject onbrdBillFromExcel = rowDataWrapper.getBizData();
            DynamicObject contractLoc = onbrdBillFromExcel.getDynamicObject("contractlocation");
            if (contractLoc == null) continue;
            locName.add(contractLoc.getString("name"));
        }
        this.setConLoc(rowDataWrapperList, locName);
    }

    @Override
    public void validateDataFormat(List<HomCommonWrapper> rowDataWrapperList) {
        IOnbrdCommonAppService onbrdCommonAppService = IOnbrdCommonAppService.getInstance();
        for (HomCommonWrapper commonWrapper : rowDataWrapperList) {
            DynamicObject onbrdBillFromExcel = commonWrapper.getBizData();
            String email = onbrdBillFromExcel.getString("peremail");
            Optional<String> emailResult = onbrdCommonAppService.validateEmail(email);
            emailResult.ifPresent(arg_0 -> ((HomCommonWrapper)commonWrapper).addErrMsg(arg_0));
            String phone = onbrdBillFromExcel.getString("phone");
            if (HRStringUtils.isNotEmpty((String)phone) && !phone.startsWith("+")) {
                phone = "+" + phone;
                onbrdBillFromExcel.set("phone", (Object)phone);
            }
            Optional<String> phoneResult = onbrdCommonAppService.validatePhone(phone);
            phoneResult.ifPresent(arg_0 -> ((HomCommonWrapper)commonWrapper).addErrMsg(arg_0));
        }
        this.validateFormatWithCertificate(rowDataWrapperList);
    }

    @Override
    public void validateFormatWithCertificate(List<HomCommonWrapper> rowDataWrapperList) {
        IOnbrdCommonAppService onbrdCommonAppService = IOnbrdCommonAppService.getInstance();
        for (HomCommonWrapper commonWrapper : rowDataWrapperList) {
            String credentialsNumber;
            DynamicObject onbrdBillFromExcel = commonWrapper.getBizData();
            DynamicObject credentialsType = onbrdBillFromExcel.getDynamicObject("certificatetype");
            Optional<String> creNumberResult = onbrdCommonAppService.validateCertificateNum(credentialsType, credentialsNumber = onbrdBillFromExcel.getString("certificatenumber"));
            if (!creNumberResult.isPresent()) continue;
            commonWrapper.addErrMsg(creNumberResult.get());
        }
    }

    @Override
    public void judgeIfDuplicate(List<HomCommonWrapper> rowDataWrapperList) {
        this.judgeCertificateIfDuplicate(rowDataWrapperList);
        this.judgeEmployeenoIfDuplicate(rowDataWrapperList);
        this.judgePhoneIfDuplicate(rowDataWrapperList);
        this.judgeEmailIfDuplicate(rowDataWrapperList);
        this.judgeDuplicateByHrpiRpc(rowDataWrapperList, null);
    }

    @Override
    public void judgeCertificateIfDuplicate(List<HomCommonWrapper> rowDataWrapperList) {
        Set idSet = rowDataWrapperList.stream().map(rowData -> rowData.getBizData().getLong("id")).collect(Collectors.toSet());
        QFilter enrollStatusFilter = this.getEnrollFilter();
        QFilter idFilter = new QFilter("id", "not in", idSet);
        String properties = "id,candidate,enrollstatus,certificatetype,certificatenumber";
        DynamicObject[] onbrdBillsFromDB = IOnbrdBillDomainService.getInstance().findOnbrdBills(properties, new QFilter[]{enrollStatusFilter, idFilter});
        Map<String, DynamicObject> certificateDBMap = Stream.of(onbrdBillsFromDB).filter(onbrdBill -> !HRObjectUtils.isEmpty((Object)onbrdBill.getDynamicObject("certificatetype"))).collect(Collectors.toMap(onbrdBill -> this.getCertificateKey((DynamicObject)onbrdBill), onbrdBill -> onbrdBill, (oldValue, newValue) -> newValue));
        HashMap<String, HomCommonWrapper> certificateExcelMap = new HashMap<String, HomCommonWrapper>(rowDataWrapperList.size());
        for (HomCommonWrapper rowDataWrapper : rowDataWrapperList) {
            HomCommonWrapper preRowDataWrapper;
            DynamicObject onbrdBillFromExcel = rowDataWrapper.getBizData();
            String key = this.getCertificateKey(onbrdBillFromExcel);
            if (HRStringUtils.isBlank((CharSequence)key)) continue;
            if (certificateDBMap.get(key) != null) {
                rowDataWrapper.addErrMsg(MessageFormat.format(ResManager.loadKDString((String)"\u5df2\u6709\u76f8\u540c\u8bc1\u4ef6\u53f7\u7801\uff08{0}\uff09\u7684\u4eba\u5458\u5728\u5165\u804c\u6d41\u7a0b\u4e2d\u3002", (String)"OnbrdImportValidator_1", (String)"hr-hom-business", (Object[])new Object[0]), onbrdBillFromExcel.getString("certificatenumber")));
            }
            if ((preRowDataWrapper = (HomCommonWrapper)certificateExcelMap.get(key)) != null) {
                rowDataWrapper.addErrMsg(String.format(ResManager.loadKDString((String)"\u201c\u8bc1\u4ef6\u7c7b\u578b+\u8bc1\u4ef6\u53f7\u7801\u201d\u4e0e\u5df2\u6709\u6570\u636e\uff08\u7b2c%s\u884c\uff09\u91cd\u590d\u3002", (String)"OnbrdImportValidator_2", (String)"hr-hom-business", (Object[])new Object[0]), preRowDataWrapper.getRowIndex() + 1));
                continue;
            }
            certificateExcelMap.put(key, rowDataWrapper);
        }
    }

    @Override
    public void judgePhoneIfDuplicate(List<HomCommonWrapper> rowDataWrapperList) {
        HashMap<String, HomCommonWrapper> phoneExcelMap = new HashMap<String, HomCommonWrapper>();
        for (HomCommonWrapper rowDataWrapper : rowDataWrapperList) {
            DynamicObject onbrdBillFromExcel = rowDataWrapper.getBizData();
            String phone = onbrdBillFromExcel.getString("phone");
            if (HRStringUtils.isEmpty((String)phone)) continue;
            if (phoneExcelMap.get(phone) != null) {
                rowDataWrapper.addErrMsg(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u2019\u624b\u673a\u53f7\u2018\u4e0e\u7b2c%s\u884c\u7684\u6570\u636e\u91cd\u590d;", (String)"OnbrdImportInitServiceImpl_4", (String)"hr-hom-business", (Object[])new Object[0]), ((HomCommonWrapper)phoneExcelMap.get(phone)).getRowIndex() + 1));
                continue;
            }
            phoneExcelMap.put(phone, rowDataWrapper);
        }
        this.validSameField(phoneExcelMap, "phone");
    }

    @Override
    public void judgeEmployeenoIfDuplicate(List<HomCommonWrapper> rowDataWrapperList) {
        HashMap<String, HomCommonWrapper> numExcelMap = new HashMap<String, HomCommonWrapper>();
        for (HomCommonWrapper rowDataWrapper : rowDataWrapperList) {
            DynamicObject onbrdBillFromExcel = rowDataWrapper.getBizData();
            String employNo = onbrdBillFromExcel.getString("employeeno");
            if (HRStringUtils.isEmpty((String)employNo)) continue;
            if (numExcelMap.get(employNo) != null) {
                rowDataWrapper.addErrMsg(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u2019\u5de5\u53f7\u2018\u4e0e\u7b2c%s\u884c\u7684\u6570\u636e\u91cd\u590d;", (String)"OnbrdImportInitServiceImpl_5", (String)"hr-hom-business", (Object[])new Object[0]), ((HomCommonWrapper)numExcelMap.get(employNo)).getRowIndex() + 1));
                continue;
            }
            numExcelMap.put(employNo, rowDataWrapper);
        }
        this.validSameField(numExcelMap, "employeeno");
    }

    @Override
    public void judgeEmailIfDuplicate(List<HomCommonWrapper> rowDataWrapperList) {
        HashMap<String, HomCommonWrapper> emailMap = new HashMap<String, HomCommonWrapper>(rowDataWrapperList.size());
        for (HomCommonWrapper rowDataWrapper : rowDataWrapperList) {
            DynamicObject onbrdBillFromExcel = rowDataWrapper.getBizData();
            String email = onbrdBillFromExcel.getString("peremail");
            if (HRStringUtils.isEmpty((String)email)) continue;
            if (emailMap.get(email) != null) {
                rowDataWrapper.addErrMsg(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u2019\u90ae\u7bb1\u2018\u4e0e\u7b2c%s\u884c\u7684\u6570\u636e\u91cd\u590d;", (String)"OnbrdImportInitServiceImpl_24", (String)"hr-hom-business", (Object[])new Object[0]), ((HomCommonWrapper)emailMap.get(email)).getRowIndex() + 1));
                continue;
            }
            emailMap.put(email, rowDataWrapper);
        }
        this.validSameField(emailMap, "peremail");
    }

    @Override
    public void judgeDuplicateByHrpiRpc(List<HomCommonWrapper> rowDataWrapperList, List<String> fieldList) {
        if (CollectionUtils.isEmpty(fieldList)) {
            fieldList = new ArrayList<String>(8);
            fieldList.add("certificatetype.id");
            fieldList.add("certificatenumber");
            fieldList.add("employeeno");
            fieldList.add("peremail");
            fieldList.add("phone");
        }
        HashMap<Long, HomCommonWrapper> checkPersonMap = new HashMap<Long, HomCommonWrapper>(rowDataWrapperList.size());
        ArrayList<DynamicObject> onbrdbills = new ArrayList<DynamicObject>(rowDataWrapperList.size());
        for (HomCommonWrapper rowDataWrapper : rowDataWrapperList) {
            DynamicObject onbrdBillFromExcel = rowDataWrapper.getBizData();
            onbrdbills.add(onbrdBillFromExcel);
            checkPersonMap.put(onbrdBillFromExcel.getLong("id"), rowDataWrapper);
        }
        Map<Long, String> resultMap = IHomToHrpiAppService.getInstance().checkAndTipByPersonFields(onbrdbills, fieldList);
        if (CollectionUtils.isEmpty(resultMap)) {
            return;
        }
        String msg = ResManager.loadKDString((String)"\u4e0e\u5728\u804c\u4eba\u5458\u6570\u636e\u91cd\u590d\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"HomToHrpi_0", (String)"hr-hom-business", (Object[])new Object[0]);
        for (Map.Entry<Long, String> entry : resultMap.entrySet()) {
            String fieldDisplayName = entry.getValue();
            if (HRStringUtils.isEmpty((String)fieldDisplayName)) continue;
            HomCommonWrapper rowDataWrapper = (HomCommonWrapper)checkPersonMap.get(entry.getKey());
            String buildMsg = fieldDisplayName + msg + ";";
            rowDataWrapper.addErrMsg(buildMsg);
        }
    }

    private void validSameField(Map<String, HomCommonWrapper> fieldExcelMap, String key) {
        if (CollectionUtils.isEmpty(fieldExcelMap)) {
            return;
        }
        Set idSet = fieldExcelMap.values().stream().map(rowData -> rowData.getBizData().getLong("id")).collect(Collectors.toSet());
        QFilter filter = new QFilter(key, "in", fieldExcelMap.keySet());
        DynamicObject[] onbrdBills = IOnbrdBillDomainService.getInstance().findOnbrdBills(key, new QFilter[]{filter, this.getEnrollFilter()});
        Map<String, String> billMap = Stream.of(onbrdBills).filter(onbrdBill -> !idSet.contains(onbrdBill.getLong("id"))).filter(onbrdBill -> !HRStringUtils.isEmpty((String)onbrdBill.getString(key))).collect(Collectors.toMap(onbrdBill -> onbrdBill.getString(key), onbrdBill -> onbrdBill.getString(key), (oldValue, newValue) -> newValue));
        if (CollectionUtils.isEmpty(billMap)) {
            return;
        }
        for (Map.Entry<String, String> entry : billMap.entrySet()) {
            HomCommonWrapper rowDataWrapper;
            String value = entry.getKey();
            if (HRStringUtils.isEmpty((String)value) || (rowDataWrapper = fieldExcelMap.get(value)) == null) continue;
            String msg = "";
            msg = key.equals("employeeno") ? String.format(ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u5de5\u53f7\u4e3a%s\u7684\u4eba\u5458\u5df2\u5728\u5165\u804c\u6d41\u7a0b\u4e2d;", (String)"OnbrdImportInitServiceImpl_7", (String)"hr-hom-business", (Object[])new Object[0]), value) : (key.equals("phone") ? String.format(ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u624b\u673a\u53f7\u4e3a%s\u7684\u4eba\u5458\u5df2\u5728\u5165\u804c\u6d41\u7a0b\u4e2d;", (String)"OnbrdImportInitServiceImpl_6", (String)"hr-hom-business", (Object[])new Object[0]), value) : String.format(ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u90ae\u7bb1\u4e3a%s\u7684\u4eba\u5458\u5df2\u5728\u5165\u804c\u6d41\u7a0b\u4e2d;", (String)"OnbrdImportInitServiceImpl_25", (String)"hr-hom-business", (Object[])new Object[0]), value));
            rowDataWrapper.addErrMsg(msg);
        }
    }

    private String getCertificateKey(DynamicObject onbrdBillInfo) {
        String certificatetypeName = onbrdBillInfo.getString("certificatetype.name");
        String certificatenumber = onbrdBillInfo.getString("certificatenumber");
        if (HRStringUtils.isBlank((CharSequence)certificatenumber) || HRStringUtils.isBlank((CharSequence)certificatetypeName)) {
            return "";
        }
        return certificatetypeName + ":" + certificatenumber;
    }

    @Override
    public void checkChgevent(List<HomCommonWrapper> rowDataWrapperList) {
        Tuple<List<Long>, String> tuple = IBaseDataDomainService.getInstance().getHpfsChgactionInfo();
        List chgeventKeys = (List)tuple.item1;
        Tuple<Map<Long, Map<String, List<Long>>>, Map<Long, Map<String, String>>> chgRuleInfo = IPersonFileIntegrateService.getInstance().getChgRuleInfo(chgeventKeys);
        rowDataWrapperList.stream().forEach(rowData -> this.checkChgeventData((HomCommonWrapper)rowData, tuple, chgRuleInfo));
    }

    @Override
    public void checkEmpgroup(List<HomCommonWrapper> rowDataWrapperList) {
        Set<Long> empgroupIds = rowDataWrapperList.stream().map(rowDataWrapper -> rowDataWrapper.getBizData().getLong("empgroup.id")).collect(Collectors.toSet());
        IBaseDataDomainService baseDataDomainService = IBaseDataDomainService.getInstance();
        Map<Long, DynamicObject> empgroupMap = baseDataDomainService.getBaseDataInfoByIds("hbss_empgroup", empgroupIds, "bussinessfield");
        for (HomCommonWrapper rowDataWrapper2 : rowDataWrapperList) {
            Long bussinessfieldId;
            Long empgroupId = rowDataWrapper2.getBizData().getLong("empgroup.id");
            DynamicObject empgroup = empgroupMap.get(empgroupId);
            if (empgroup == null || BaseDataIdConstants.HBSS_BUSSINESSFIELD_103010.equals(bussinessfieldId = Long.valueOf(empgroup.getLong("bussinessfield.id")))) continue;
            rowDataWrapper2.addErrMsg(ResManager.loadKDString((String)"\u53ea\u80fd\u9009\u62e9\u6240\u5c5e\u4e1a\u52a1\u7c7b\u578b\u4e3a\u201c\u4eba\u4e8b\u4e1a\u52a1\u201d\u7684\u4eba\u4e8b\u4eba\u5458\u7ec4\u3002", (String)"OnbrdImportValidator_11", (String)"hr-hom-business", (Object[])new Object[0]));
        }
    }

    @Override
    public void validateStaffUse(List<HomCommonWrapper> rowDataWrapperList) {
        Object[] onbrdBills = (DynamicObject[])rowDataWrapperList.stream().map(HomCommonWrapper::getBizData).filter(onbrdBill -> HRStringUtils.equals((String)OnbrdStatusEnum.WAIT_ONBRD.getValue(), (String)onbrdBill.getString("enrollstatus"))).toArray(DynamicObject[]::new);
        if (HRArrayUtils.isEmpty((Object[])onbrdBills)) {
            return;
        }
        IStaffUseService staffUseService = IStaffUseService.getInstance();
        List onbrdBillIds = Stream.of(onbrdBills).map(onbrdBill -> onbrdBill.getLong("id")).collect(Collectors.toList());
        QFilter filter = new QFilter("id", "in", onbrdBillIds);
        DynamicObject[] onbrdBillFromDBs = IOnbrdBillDomainService.getInstance().findOnbrdBills(staffUseService.getSelectProperties(), new QFilter[]{filter});
        List<Tuple<DynamicObject, DynamicObject>> changedList = staffUseService.getBillListChanged(onbrdBillFromDBs, (DynamicObject[])onbrdBills);
        if (CollectionUtils.isEmpty(changedList)) {
            LOGGER.info("These datas no change, size:{}", (Object)onbrdBills.length);
            return;
        }
        DynamicObject[] billChanged = (DynamicObject[])changedList.stream().map(tuple -> (DynamicObject)tuple.item2).toArray(DynamicObject[]::new);
        LOGGER.info("change size:{}", (Object)billChanged.length);
        Map<Long, StaffQueryOutParam> queryOutParamMap = staffUseService.queryStaffUseInfos(billChanged, "UPDATE");
        for (HomCommonWrapper rowDataWrapper : rowDataWrapperList) {
            Long candidateId = rowDataWrapper.getBizData().getLong("candidate.id");
            StaffQueryOutParam staffQueryOutParam = queryOutParamMap.get(candidateId);
            if (staffQueryOutParam == null || staffQueryOutParam.isAllow() || CollectionUtils.isEmpty((Collection)staffQueryOutParam.getReasonList())) continue;
            LOGGER.info("staffQueryOutParam:{}", (Object)HOMObjectUtils.toJSONString((Object)staffQueryOutParam));
            for (String msg : staffQueryOutParam.getReasonList()) {
                rowDataWrapper.addErrMsg(msg);
            }
        }
    }

    @Override
    public void validateEffectDate(List<HomCommonWrapper> rowDataWrapperList) {
        DynamicObject[] onbrdBills = (DynamicObject[])rowDataWrapperList.stream().map(HomCommonWrapper::getBizData).toArray(DynamicObject[]::new);
        Map<Long, String> validateResultMap = IOnbrdCommonAppService.getInstance().validateEffectDateWithOrgField(onbrdBills);
        for (HomCommonWrapper rowDataWrapper : rowDataWrapperList) {
            long onbrdBillId = rowDataWrapper.getBizData().getLong("id");
            String validateResult = validateResultMap.get(onbrdBillId);
            if (HRStringUtils.isNotEmpty((String)validateResult)) {
                rowDataWrapper.addErrMsg(validateResult);
            }
            Date effectDate = rowDataWrapper.getBizData().getDate("effectdate");
            Date validunitl = rowDataWrapper.getBizData().getDate("validuntil");
            if (effectDate == null || validunitl == null || !HRDateTimeUtils.dayAfter((Date)effectDate, (Date)validunitl)) continue;
            String format = HRDateTimeUtils.format((Date)validunitl, (String)"yyyy-MM-dd");
            rowDataWrapper.addErrMsg(String.format(ResManager.loadKDString((String)"\u5165\u804c\u65e5\u671f\u9700\u5728\u5165\u804c\u6709\u6548\u671f\uff08%s\uff09\u5185\u3002", (String)"ReservationOnbrdPlugin_3", (String)"hr-hom-formplugin", (Object[])new Object[0]), format));
        }
    }

    @Override
    public void validNumber(List<HomCommonWrapper> rowDataWrapperList) {
        boolean replaceNumberSwitch = ReentryRuleService.getInstance().queryReplaceNumberSwitch();
        rowDataWrapperList.stream().forEach(row -> row.getBizData().set("isreplacenumber", (Object)"0"));
        Set<String> numbers = rowDataWrapperList.stream().filter(row -> StringUtils.isNotBlank((CharSequence)row.getBizData().getString("employeeno"))).map(row -> row.getBizData().getString("employeeno")).collect(Collectors.toSet());
        DynamicObject[] dynamicObjects = ReentryRuleService.getInstance().queryEmpentrelInfoByNumber(numbers.toArray(new String[0]));
        if (dynamicObjects == null || dynamicObjects.length == 0) {
            return;
        }
        Map<String, String> numberToName = Arrays.stream(dynamicObjects).collect(Collectors.toMap(dy -> dy.getString("number"), dy -> dy.getString("name"), (k1, k2) -> k1));
        for (HomCommonWrapper homCommonWrapper : rowDataWrapperList) {
            boolean replaceNumber;
            String oldName;
            DynamicObject dataEntity = homCommonWrapper.getBizData();
            String number = dataEntity.getString("employeeno");
            if (StringUtils.isBlank((CharSequence)number) || StringUtils.isBlank((CharSequence)(oldName = numberToName.getOrDefault(number, ""))) || !(replaceNumber = ReentryRuleService.getInstance().isReplaceNumber(dataEntity))) continue;
            if (replaceNumberSwitch) {
                String newName = dataEntity.getString("name");
                String msg = ResManager.loadKDString((String)"%1$s\u5c06\u53d6\u4ee3%2$s\u7684\u5de5\u53f7%3$s", (String)"OnbrdInfoEdit_20", (String)"hr-hom-formplugin", (Object[])new Object[0]);
                String format = String.format(Locale.ROOT, msg, newName, oldName, number).trim();
                dataEntity.set("isreplacenumber", (Object)"1");
                homCommonWrapper.addWarningMsg(format);
                continue;
            }
            String msg = ResManager.loadKDString((String)"\u201c\u5de5\u53f7\u201d\u4e0e\u7cfb\u7edf\u5df2\u6709\u6570\u636e\u91cd\u590d\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"OnbrdInfoEdit_21", (String)"hr-hom-formplugin", (Object[])new Object[0]);
            homCommonWrapper.addErrMsg(msg);
        }
    }

    @Override
    public void validExtendEmployeeno(List<HomCommonWrapper> validatePassList) {
        DynamicObject[] dynamicObjects = HomCommonRepository.queryDynamicObjectByPks("hom_onbrdbilltpl", "employeenoscheme,employeeno", validatePassList.stream().map(row -> row.getBizData().getLong("id")).filter(row -> row != 0L).toArray(Object[]::new));
        Map<Long, String> employeeNoMap = Arrays.stream(dynamicObjects).filter(row -> EmployeeNoSchemeEnum.OLD_EMPLOYEE_NO.getValue().equals(row.getString("employeenoscheme"))).collect(Collectors.toMap(row -> row.getLong("id"), row -> row.getString("employeeno"), (k1, k2) -> k1));
        validatePassList.forEach(rowData -> {
            String newEmployeeNo = rowData.getBizData().getString("employeeno");
            String oldEmployeeNo = employeeNoMap.getOrDefault(rowData.getBizData().getLong("id"), "");
            if (StringUtils.isNotBlank((CharSequence)oldEmployeeNo) && !oldEmployeeNo.equals(newEmployeeNo)) {
                String msg = ResManager.loadKDString((String)"\u662f\u5426\u7ee7\u627f\u5de5\u53f7\u4e3a\u201c\u662f\u201d\uff0c\u5bfc\u5165\u5de5\u53f7\u7684\u503c\u548c\u539f\u5de5\u53f7\u9700\u4e00\u81f4\uff0c\u8bf7\u4fee\u6539\u3002", (String)"OnbrdInfoEdit_22", (String)"hr-hom-formplugin", (Object[])new Object[0]);
                rowData.addErrMsg(msg);
            }
        });
    }

    @Override
    public void validateCadre(List<HomCommonWrapper> rowDataWrapperList) {
        for (HomCommonWrapper homCommonWrapper : rowDataWrapperList) {
            DynamicObject dataEntity = homCommonWrapper.getBizData();
            boolean isCadre = dataEntity.getBoolean("iscadre");
            DynamicObject dynamicObject = dataEntity.getDynamicObject("cadretype");
            if (isCadre || HRObjectUtils.isEmpty((Object)dynamicObject)) continue;
            String msg = ResManager.loadKDString((String)"\u5458\u5de5\u4e3a\u201c\u5e72\u90e8\u201d\u65f6\uff0c\u624d\u5141\u8bb8\u586b\u5199\u201c\u5e72\u90e8\u7c7b\u522b\u201d\u3002", (String)"OnbrdInfoEdit_26", (String)"hr-hom-formplugin", (Object[])new Object[0]);
            homCommonWrapper.addErrMsg(msg);
        }
    }

    @Override
    public void validIsInBlackList(List<HomCommonWrapper> rowDataWrapperList) {
        DynamicObject[] onbrdBills = (DynamicObject[])rowDataWrapperList.stream().map(HomCommonWrapper::getBizData).toArray(DynamicObject[]::new);
        Map<Long, String> validResultMap = BlackListValidUtil.getInstance().blackListValid(onbrdBills);
        for (HomCommonWrapper rowDataWrapper : rowDataWrapperList) {
            long onbrdBillId = rowDataWrapper.getBizData().getLong("id");
            String validateResult = validResultMap.get(onbrdBillId);
            if (!HRStringUtils.isNotEmpty((String)validateResult)) continue;
            rowDataWrapper.addErrMsg(validateResult);
        }
    }

    @Override
    public void validPreOnbrd(List<HomCommonWrapper> rowDataWrapperList) {
        List<DynamicObject> collect = rowDataWrapperList.stream().map(HomCommonWrapper::getBizData).collect(Collectors.toList());
        IPreOnBrdService service = ServiceFactory.getService(IPreOnBrdService.class);
        Table<Integer, String, DynamicObject> validatePreOnbrdMap = service.validatePreOnbrd(collect.toArray(new DynamicObject[0]));
        if (!validatePreOnbrdMap.isEmpty()) {
            Set cells = validatePreOnbrdMap.cellSet();
            for (Table.Cell cell : cells) {
                rowDataWrapperList.get((Integer)cell.getRowKey() - 1).addErrMsg(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u6709\u5728\u9014\u7684\u9884\u5165\u804c\u7533\u8bf7\uff08\u5355\u636e\u7f16\u53f7\uff1a%s\uff09\uff0c\u4e0d\u53ef\u4e3a\u540c\u4e00\u4eba\u5458\u91cd\u590d\u53d1\u8d77\u3002", (String)"OnbrdInfoEdit_23", (String)"hr-hom-formplugin", (Object[])new Object[0]), ((DynamicObject)cell.getValue()).getString("prebatchonbrd.billno")));
            }
        }
    }

    @Override
    public void validateVirtuallyOrg(List<HomCommonWrapper> rowDataWrapperList) {
        List<Long> adminOrgIds = rowDataWrapperList.stream().map(warpper -> warpper.getBizData().getLong("aadminorg.id")).collect(Collectors.toList());
        IOnbrdService service = ServiceFactory.getService(IOnbrdService.class);
        Map<String, Boolean> stringBooleanMap = service.validateVirtuallyOrg(adminOrgIds, new Date());
        if (!stringBooleanMap.isEmpty()) {
            for (HomCommonWrapper warpper2 : rowDataWrapperList) {
                String adminOrgId = warpper2.getBizData().getString("aadminorg.id");
                Boolean result = stringBooleanMap.get(adminOrgId);
                if (HRObjectUtils.isEmpty((Object)result) || !result.booleanValue()) continue;
                warpper2.addErrMsg(ResManager.loadKDString((String)"\u8be5\u7ec4\u7ec7\u4e3a\u865a\u62df\u7ec4\u7ec7\uff0c\u8bf7\u9009\u62e9\u5176\u4ed6\u7ec4\u7ec7\u3002", (String)"OnbrdInfoEdit_27", (String)"hr-hom-formplugin", (Object[])new Object[0]));
            }
        }
    }

    @Override
    public void validateDepartPerson(List<HomCommonWrapper> rowDataWrapperList) {
        List ermanFileIds = rowDataWrapperList.stream().filter(dataValidate -> !HRObjectUtils.isEmpty((Object)dataValidate.getBizData().getDynamicObject("teacher"))).map(dataValidate -> {
            DynamicObject ermanFile = dataValidate.getBizData().getDynamicObject("teacher");
            return ermanFile.getLong("id");
        }).collect(Collectors.toList());
        Map employeeStatusMap = new HashMap();
        if (!CollectionUtils.isEmpty(ermanFileIds)) {
            employeeStatusMap = (Map)HRMServiceHelper.invokeHRMPService((String)"hrpi", (String)"IHRPIEmployeeService", (String)"checkEmployeeStatus", (Object[])new Object[]{ermanFileIds, "person"});
        }
        DynamicObject[] dynamicObjects = HomCommonRepository.queryDynamicObjectByPks("bos_user", "id,isforbidden", rowDataWrapperList.stream().filter(data -> !HRObjectUtils.isEmpty((Object)data.getBizData().get("handler"))).map(data -> data.getBizData().getLong("handler.id")).toArray());
        Map<Long, Boolean> forbiddenMap = Arrays.stream(dynamicObjects).collect(Collectors.toMap(dy -> dy.getLong("id"), dynamicObject -> dynamicObject.getBoolean("isforbidden")));
        Map finalEmployeeStatusMap = employeeStatusMap;
        rowDataWrapperList.forEach(dataValidate -> {
            Long employeeId;
            Boolean status;
            String errorMsg;
            DynamicObject onbrdBill = dataValidate.getBizData();
            if (!HRObjectUtils.isEmpty((Object)onbrdBill.getDynamicObject("handler"))) {
                boolean isforbidden = forbiddenMap.getOrDefault(onbrdBill.getLong("handler.id"), false);
                String enable = onbrdBill.getString("handler.enable");
                if (isforbidden || !"1".equals(enable)) {
                    errorMsg = ResManager.loadKDString((String)"\u5165\u804c\u8ddf\u8e2a\u4eba\u5df2\u79bb\u804c\uff0c\u8bf7\u4fee\u6539\u5165\u804c\u8ddf\u8e2a\u4eba\u4fe1\u606f\u3002", (String)"OnbrdCommonValidator_24", (String)"hr-hom-business", (Object[])new Object[0]);
                    dataValidate.addErrMsg(errorMsg);
                }
            }
            if (!(HRObjectUtils.isEmpty((Object)onbrdBill.getDynamicObject("teacher")) || HRObjectUtils.isEmpty((Object)(status = (Boolean)finalEmployeeStatusMap.get(employeeId = Long.valueOf(onbrdBill.getLong("teacher.id"))))) || status.booleanValue())) {
                errorMsg = ResManager.loadKDString((String)"\u8be5\u5bfc\u5e08\u5df2\u79bb\u804c", (String)"OnbrdCommonValidator_25", (String)"hr-hom-business", (Object[])new Object[0]);
                dataValidate.addErrMsg(errorMsg);
            }
        });
    }

    private void checkChgeventData(HomCommonWrapper rowDataWrapper, Tuple<List<Long>, String> tuple, Tuple<Map<Long, Map<String, List<Long>>>, Map<Long, Map<String, String>>> chgRuleInfo) {
        DynamicObject onbrdBillFromExcel = rowDataWrapper.getBizData();
        List chgeventKeys = (List)tuple.item1;
        String chgNames = (String)tuple.item2;
        String chgNamesMsg = ResManager.loadKDString((String)"\u6682\u65e0\u53ef\u9009\u6570\u636e\u3002", (String)"OnbrdImportInitServiceImpl_17", (String)"hr-hom-business", (Object[])new Object[0]);
        String name = ResManager.loadKDString((String)"\u53d8\u52a8\u64cd\u4f5c", (String)"OnbrdImportInitServiceImpl_23", (String)"hr-hom-business", (Object[])new Object[0]);
        DynamicObject affaction = onbrdBillFromExcel.getDynamicObject("affaction");
        if (ObjectUtils.isEmpty((Object)affaction)) {
            return;
        }
        if (CollectionUtils.isEmpty((Collection)chgeventKeys) || !chgeventKeys.contains(affaction.getLong("id"))) {
            String tips = ResManager.loadKDString((String)"\u5f55\u5165\u7684\u201c{0}\u201d\u503c\u4e0d\u5728\u53ef\u9009\u8303\u56f4\u5185\uff1a{1}\u3002", (String)"OnbrdImportInitServiceImpl_16", (String)"hr-hom-business", (Object[])new Object[]{name, HRStringUtils.isEmpty((String)chgNames) ? chgNamesMsg : chgNames});
            rowDataWrapper.addErrMsg(tips);
            return;
        }
        this.checkChgDataRule(chgRuleInfo, rowDataWrapper);
    }

    private void checkChgDataRule(Tuple<Map<Long, Map<String, List<Long>>>, Map<Long, Map<String, String>>> chgRuleInfo, HomCommonWrapper rowDataWrapper) {
        Arrays.stream(BaseDataConstants.RULEDATA_NAME).forEach(str -> {
            boolean businessValue = HPFSTemplatePropertyHandler.isNewChgAction("hom_onbrd_hpfs_new");
            if (businessValue && KEY_POSTYPE_POSSTATUS.contains(str)) {
                return;
            }
            this.setChgDataMsg((String)str, rowDataWrapper, chgRuleInfo);
        });
    }

    private void setChgDataMsg(String str, HomCommonWrapper rowDataWrapper, Tuple<Map<Long, Map<String, List<Long>>>, Map<Long, Map<String, String>>> chgRuleInfo) {
        String tip;
        DynamicObject onbrdBillFromExcel = rowDataWrapper.getBizData();
        DynamicObject affaction = onbrdBillFromExcel.getDynamicObject("affaction");
        Long affactionId = affaction.getLong("id");
        Map ruleDataMap = (Map)chgRuleInfo.item1;
        Map ruleDataName = (Map)chgRuleInfo.item2;
        if (ObjectUtils.isEmpty((Object)affaction)) {
            return;
        }
        DynamicObject dynamicObject = onbrdBillFromExcel.getDynamicObject(str);
        Map tipsMap = (Map)ruleDataName.get(affactionId);
        Map dataMap = (Map)ruleDataMap.get(affactionId);
        String namesMsg = ResManager.loadKDString((String)"\u6682\u65e0\u53ef\u9009\u6570\u636e\u3002", (String)"OnbrdImportInitServiceImpl_17", (String)"hr-hom-business", (Object[])new Object[0]);
        String string = tip = tipsMap == null ? null : (String)tipsMap.get(str);
        if (ObjectUtils.isEmpty((Object)dynamicObject)) {
            return;
        }
        if (CollectionUtils.isEmpty((Map)dataMap) || CollectionUtils.isEmpty((Collection)((Collection)dataMap.get(str)))) {
            String tips = ResManager.loadKDString((String)"\u5f55\u5165\u7684\u201c{0}\u201d\u503c\u4e0d\u5728\u53ef\u9009\u8303\u56f4\u5185\uff1a{1}\u3002", (String)"OnbrdImportInitServiceImpl_16", (String)"hr-hom-business", (Object[])new Object[]{OnboardChgEnum.getNameByNum(str), namesMsg});
            rowDataWrapper.addErrMsg(tips);
            return;
        }
        List longs = (List)dataMap.get(str);
        if (!longs.contains(dynamicObject.getLong("id"))) {
            String tips = ResManager.loadKDString((String)"\u5f55\u5165\u7684\u201c{0}\u201d\u503c\u4e0d\u5728\u53ef\u9009\u8303\u56f4\u5185\uff1a{1}\u3002", (String)"OnbrdImportInitServiceImpl_16", (String)"hr-hom-business", (Object[])new Object[]{OnboardChgEnum.getNameByNum(str), HRStringUtils.isEmpty((String)tip) ? namesMsg : tip});
            rowDataWrapper.addErrMsg(tips);
        }
    }

    private Map<Long, Long> setAjobByPosition(List<HomCommonWrapper> rowDataWrapperList, Map<Long, Map<String, Object>> stdpositionResultMap, Map<Long, Map<String, Object>> apositionResultMap) {
        HashMap jobIdRecheckMap = Maps.newHashMapWithExpectedSize((int)rowDataWrapperList.size());
        for (HomCommonWrapper rowDataWrapper : rowDataWrapperList) {
            long jobId;
            long jobgradescmIdQuery;
            long joblevelscmIdQuery;
            Long jobId2;
            DynamicObject onbrdBillFromExcel = rowDataWrapper.getBizData();
            String apositionType = onbrdBillFromExcel.getString("apositiontype");
            DynamicObject aposition = onbrdBillFromExcel.getDynamicObject("aposition");
            DynamicObject stdposition = onbrdBillFromExcel.getDynamicObject("stdposition");
            long joblevelscmIdExcel = onbrdBillFromExcel.getLong("joblevelscm.id");
            long jobgradescmIdExcel = onbrdBillFromExcel.getLong("jobgradescm.id");
            if (HRStringUtils.equals((String)"0", (String)apositionType) && !HRObjectUtils.isEmpty((Object)stdposition) && !HRObjectUtils.isEmpty(stdpositionResultMap) && !HRObjectUtils.isEmpty(stdpositionResultMap.get(stdposition.getLong("id")))) {
                Map<String, Object> resultMap = stdpositionResultMap.get(stdposition.getLong("id"));
                HOMObjectUtils.setDynamicObjectId((DynamicObject)onbrdBillFromExcel, (String)"ajobscmorg", (Object)resultMap.get("orgdesignbu.id"));
                HOMObjectUtils.setDynamicObjectId((DynamicObject)onbrdBillFromExcel, (String)"ajobscm", (Object)resultMap.get("jobscm.id"));
                jobId2 = HOMObjectUtils.getLongValOfCustomParam((Object)resultMap.get("job.id"));
                HOMObjectUtils.setDynamicObjectId((DynamicObject)onbrdBillFromExcel, (String)"ajob", (Object)jobId2);
                joblevelscmIdQuery = HOMObjectUtils.getLongValOfCustomParam((Object)resultMap.get("joblevelscm.id"));
                if (joblevelscmIdQuery != 0L && joblevelscmIdExcel != 0L && joblevelscmIdQuery != joblevelscmIdExcel) {
                    rowDataWrapper.addErrMsg(ResManager.loadKDString((String)"\u6240\u586b\u804c\u7ea7\u65b9\u6848\u4e0e\u6807\u51c6\u5c97\u4f4d\u4e0d\u5339\u914d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"OnbrdCommonValidator_13", (String)"hr-hom-business", (Object[])new Object[0]));
                }
                if ((jobgradescmIdQuery = HOMObjectUtils.getLongValOfCustomParam((Object)resultMap.get("jobgradescm.id"))) != 0L && jobgradescmIdExcel != 0L && jobgradescmIdQuery != jobgradescmIdExcel) {
                    rowDataWrapper.addErrMsg(ResManager.loadKDString((String)"\u6240\u586b\u804c\u7b49\u65b9\u6848\u4e0e\u6807\u51c6\u5c97\u4f4d\u4e0d\u5339\u914d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"OnbrdCommonValidator_14", (String)"hr-hom-business", (Object[])new Object[0]));
                }
                if (joblevelscmIdQuery == 0L && jobgradescmIdQuery == 0L && jobId2 != 0L) {
                    jobIdRecheckMap.put(onbrdBillFromExcel.getLong("id"), jobId2);
                }
                LOGGER.info(HOMObjectUtils.toJSONString(resultMap));
                continue;
            }
            if (HRStringUtils.equals((String)"1", (String)apositionType) && !HRObjectUtils.isEmpty((Object)aposition) && !HRObjectUtils.isEmpty(apositionResultMap) && !HRObjectUtils.isEmpty(apositionResultMap.get(aposition.getLong("id")))) {
                Map<String, Object> resultMap = apositionResultMap.get(aposition.getLong("id"));
                HOMObjectUtils.setDynamicObjectId((DynamicObject)onbrdBillFromExcel, (String)"ajobscmorg", (Object)resultMap.get("orgdesignbu"));
                HOMObjectUtils.setDynamicObjectId((DynamicObject)onbrdBillFromExcel, (String)"ajobscm", (Object)resultMap.get("jobscm"));
                jobId2 = HOMObjectUtils.getLongValOfCustomParam((Object)resultMap.get("job"));
                HOMObjectUtils.setDynamicObjectId((DynamicObject)onbrdBillFromExcel, (String)"ajob", (Object)jobId2);
                joblevelscmIdQuery = HOMObjectUtils.getLongValOfCustomParam((Object)resultMap.get("highjoblevel.joblevelscm"));
                if (joblevelscmIdQuery != 0L && joblevelscmIdExcel != 0L && joblevelscmIdQuery != joblevelscmIdExcel) {
                    rowDataWrapper.addErrMsg(ResManager.loadKDString((String)"\u6240\u586b\u804c\u7ea7\u65b9\u6848\u4e0e\u5c97\u4f4d\u4e0d\u5339\u914d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"OnbrdCommonValidator_15", (String)"hr-hom-business", (Object[])new Object[0]));
                }
                if ((jobgradescmIdQuery = HOMObjectUtils.getLongValOfCustomParam((Object)resultMap.get("highjobgrade.jobgradescm"))) != 0L && jobgradescmIdExcel != 0L && jobgradescmIdQuery != jobgradescmIdExcel) {
                    rowDataWrapper.addErrMsg(ResManager.loadKDString((String)"\u6240\u586b\u804c\u7b49\u65b9\u6848\u4e0e\u5c97\u4f4d\u4e0d\u5339\u914d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"OnbrdCommonValidator_16", (String)"hr-hom-business", (Object[])new Object[0]));
                }
                if (joblevelscmIdQuery == 0L && jobgradescmIdQuery == 0L && jobId2 != 0L) {
                    jobIdRecheckMap.put(onbrdBillFromExcel.getLong("id"), jobId2);
                }
                LOGGER.info(HOMObjectUtils.toJSONString(resultMap));
                continue;
            }
            if (!HRStringUtils.equals((String)"2", (String)apositionType) || (jobId = onbrdBillFromExcel.getLong("ajob.id")) == 0L) continue;
            jobIdRecheckMap.put(onbrdBillFromExcel.getLong("id"), jobId);
        }
        return jobIdRecheckMap;
    }

    private boolean checkAjobLevelGrade(HomCommonWrapper rowDataWrapper, Map<String, Object> positionLevelGradeMap, Map<String, Object> stdpositionLevelGradeMap, Map<String, List<DynamicObject>> jobLevelGradeInfoMap) {
        DynamicObject onbrdBillFromExcel = rowDataWrapper.getBizData();
        String aJobLevel = onbrdBillFromExcel.getString("ajobleveltext");
        String aJobgrade = onbrdBillFromExcel.getString("ajobgradetext");
        String apositionType = onbrdBillFromExcel.getString("apositiontype");
        DynamicObject aposition = onbrdBillFromExcel.getDynamicObject("aposition");
        DynamicObject stdposition = onbrdBillFromExcel.getDynamicObject("stdposition");
        boolean hasLevelInfos = true;
        boolean hasGradeInfos = true;
        if (StringUtils.isNotBlank((CharSequence)aJobLevel)) {
            if (HRStringUtils.equals((String)"1", (String)apositionType) && !HRObjectUtils.isEmpty((Object)aposition)) {
                hasLevelInfos = this.levelAposition(rowDataWrapper, positionLevelGradeMap, aJobLevel);
            } else if (HRStringUtils.equals((String)"0", (String)apositionType) && !HRObjectUtils.isEmpty((Object)stdposition)) {
                hasLevelInfos = this.levelStdAposition(rowDataWrapper, stdpositionLevelGradeMap, aJobLevel);
            } else if (HRStringUtils.equals((String)"2", (String)apositionType) && !HOMObjectUtils.isEmptyWithDynamicObjectField((DynamicObject)onbrdBillFromExcel, (String)"ajob")) {
                hasLevelInfos = this.levelWithAjob(rowDataWrapper, jobLevelGradeInfoMap, aJobLevel);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)aJobgrade)) {
            if (HRStringUtils.equals((String)"1", (String)apositionType) && !HRObjectUtils.isEmpty((Object)aposition)) {
                hasGradeInfos = this.gradeAposition(rowDataWrapper, positionLevelGradeMap, aJobgrade);
            } else if (HRStringUtils.equals((String)"0", (String)apositionType) && !HRObjectUtils.isEmpty((Object)stdposition)) {
                hasGradeInfos = this.gradeStdAposition(rowDataWrapper, stdpositionLevelGradeMap, aJobgrade);
            } else if (HRStringUtils.equals((String)"2", (String)apositionType) && !HOMObjectUtils.isEmptyWithDynamicObjectField((DynamicObject)onbrdBillFromExcel, (String)"ajob")) {
                hasGradeInfos = this.gradeWithAjob(rowDataWrapper, jobLevelGradeInfoMap, aJobgrade);
            }
        }
        return !hasGradeInfos || !hasLevelInfos;
    }

    private void setConLoc(List<HomCommonWrapper> rowDataWrapperList, Set<String> locName) {
        if (CollectionUtils.isEmpty(rowDataWrapperList) || CollectionUtils.isEmpty(locName)) {
            return;
        }
        QFilter filter = new QFilter("name", "in", locName);
        DynamicObject[] contractLocs = new HRBaseServiceHelper("hbss_workplace").query("iscontractworkplace", new QFilter[]{filter});
        HashMap<Long, Boolean> contractLocMap = new HashMap<Long, Boolean>(contractLocs.length);
        for (DynamicObject dy : contractLocs) {
            contractLocMap.put(dy.getLong("id"), dy.getBoolean("iscontractworkplace"));
        }
        for (HomCommonWrapper rowDataWrapper : rowDataWrapperList) {
            Long conLocId;
            DynamicObject onbrdBillFromExcel = rowDataWrapper.getBizData();
            DynamicObject conLoc = onbrdBillFromExcel.getDynamicObject("contractlocation");
            if (conLoc == null || contractLocMap.get(conLocId = Long.valueOf(conLoc.getLong("id"))) != null && ((Boolean)contractLocMap.get(conLocId)).booleanValue()) continue;
            rowDataWrapper.addErrMsg(ResManager.loadKDString((String)"\u534f\u8bae\u5de5\u4f5c\u5730\u9519\u8bef;", (String)"OnbrdImportInitServiceImpl_3", (String)"hr-hom-business", (Object[])new Object[0]));
        }
    }

    private void setRoleByAposition(Set<Long> positionId, List<Long> rolesId, List<DynamicObject> roleOnbrds) {
        if (CollectionUtils.isEmpty(roleOnbrds) || CollectionUtils.isEmpty(positionId)) {
            return;
        }
        QFilter filter = new QFilter("id", "in", positionId);
        DynamicObject[] hbpmPositions = new HRBaseServiceHelper("hbpm_positionhr").query("workrole", new QFilter[]{filter});
        HashMap<Long, DynamicObject> positionMap = new HashMap<Long, DynamicObject>(hbpmPositions.length);
        for (DynamicObject hbpmPosition : hbpmPositions) {
            positionMap.put(hbpmPosition.getLong("id"), hbpmPosition);
        }
        for (DynamicObject onbrd : roleOnbrds) {
            DynamicObject workRole;
            DynamicObject hbpmPosition;
            DynamicObject aposition = onbrd.getDynamicObject("aposition");
            if (aposition == null || (workRole = (hbpmPosition = (DynamicObject)positionMap.get(aposition.getLong("id"))).getDynamicObject("workrole")) == null) continue;
            onbrd.set("role", (Object)workRole);
            rolesId.add(hbpmPosition.getLong("workrole.id"));
        }
    }

    private boolean levelAposition(HomCommonWrapper rowDataWrapper, Map<String, Object> levelGradeMap, String aJobLevelText) {
        List joblevels = HbpmResultUtils.getJobLevel(levelGradeMap);
        if (CollectionUtils.isEmpty((Collection)joblevels)) {
            LOGGER.info("levelAposition is empty");
            return false;
        }
        Map<String, DynamicObject> joblevelMap = joblevels.stream().collect(Collectors.toMap(joblevel -> joblevel.getString("name"), joblevel -> joblevel, (oldValue, newValue) -> newValue));
        DynamicObject aJobLevel = joblevelMap.get(aJobLevelText);
        if (aJobLevel != null) {
            DynamicObject onbrdBillFromExcel = rowDataWrapper.getBizData();
            onbrdBillFromExcel.set("ajoblevel", (Object)aJobLevel);
        } else {
            rowDataWrapper.addErrMsg(ResManager.loadKDString((String)"\u672a\u5339\u914d\u5230\u5c97\u4f4d\u53ef\u9009\u8303\u56f4\u5185\u7684\u804c\u7ea7\u3002", (String)"OnbrdImportInitServiceImpl_9", (String)"hr-hom-business", (Object[])new Object[0]));
        }
        return true;
    }

    private boolean levelStdAposition(HomCommonWrapper rowDataWrapper, Map<String, Object> levelGradeMap, String aJobLevelText) {
        List joblevels = HbpmResultUtils.getJobLevel(levelGradeMap);
        if (CollectionUtils.isEmpty((Collection)joblevels)) {
            LOGGER.info("levelStdAposition is empty");
            return false;
        }
        Map<String, DynamicObject> joblevelMap = joblevels.stream().collect(Collectors.toMap(joblevel -> joblevel.getString("name"), joblevel -> joblevel, (oldValue, newValue) -> newValue));
        DynamicObject aJobLevel = joblevelMap.get(aJobLevelText);
        if (aJobLevel != null) {
            DynamicObject onbrdBillFromExcel = rowDataWrapper.getBizData();
            onbrdBillFromExcel.set("ajoblevel", (Object)aJobLevel);
        } else {
            rowDataWrapper.addErrMsg(ResManager.loadKDString((String)"\u672a\u5339\u914d\u5230\u6807\u51c6\u5c97\u4f4d\u53ef\u9009\u8303\u56f4\u5185\u7684\u804c\u7ea7\u3002", (String)"OnbrdImportInitServiceImpl_11", (String)"hr-hom-business", (Object[])new Object[0]));
        }
        return true;
    }

    private boolean levelWithAjob(HomCommonWrapper rowDataWrapper, Map<String, List<DynamicObject>> jobLevelGradeInfoMap, String aJobLevel) {
        DynamicObject onbrdBillFromExcel = rowDataWrapper.getBizData();
        if (HRObjectUtils.isEmpty(jobLevelGradeInfoMap) || CollectionUtils.isEmpty((Collection)jobLevelGradeInfoMap.get("joblevel"))) {
            LOGGER.info("levelWithAjob is empty");
            return false;
        }
        List<DynamicObject> jobLevelInfos = jobLevelGradeInfoMap.get("joblevel");
        Map<String, DynamicObject> joblevelMap = jobLevelInfos.stream().collect(Collectors.toMap(jobLevelInfo -> jobLevelInfo.getString("name"), jobLevelInfo -> jobLevelInfo, (oldValue, newValue) -> newValue));
        if (CollectionUtils.isEmpty(joblevelMap)) {
            LOGGER.info("levelWithAjob joblevelMap is empty");
            return false;
        }
        if (!joblevelMap.containsKey(aJobLevel)) {
            rowDataWrapper.addErrMsg(ResManager.loadKDString((String)"\u672a\u5339\u914d\u5230\u804c\u4f4d\u53ef\u9009\u8303\u56f4\u5185\u7684\u804c\u7ea7\u3002", (String)"OnbrdImportInitServiceImpl_10", (String)"hr-hom-business", (Object[])new Object[0]));
        } else {
            DynamicObject aJobLevelDy = joblevelMap.get(aJobLevel);
            onbrdBillFromExcel.set("ajoblevel", (Object)aJobLevelDy);
        }
        return true;
    }

    private boolean gradeStdAposition(HomCommonWrapper rowDataWrapper, Map<String, Object> levelGradeMap, String aJobgradeText) {
        List jobGrades = HbpmResultUtils.getJobGrade(levelGradeMap);
        if (CollectionUtils.isEmpty((Collection)jobGrades)) {
            LOGGER.info("gradeStdAposition is empty");
            return false;
        }
        Map<String, DynamicObject> jobGradeMap = jobGrades.stream().collect(Collectors.toMap(jobGrade -> jobGrade.getString("name"), jobGrade -> jobGrade, (oldValue, newValue) -> newValue));
        DynamicObject aJobgrade = jobGradeMap.get(aJobgradeText);
        if (aJobgrade != null) {
            DynamicObject onbrdBillFromExcel = rowDataWrapper.getBizData();
            onbrdBillFromExcel.set("ajobgrade", (Object)aJobgrade);
        } else {
            rowDataWrapper.addErrMsg(ResManager.loadKDString((String)"\u672a\u5339\u914d\u5230\u6807\u51c6\u5c97\u4f4d\u53ef\u9009\u8303\u56f4\u5185\u7684\u804c\u7b49\u3002", (String)"OnbrdImportInitServiceImpl_15", (String)"hr-hom-business", (Object[])new Object[0]));
        }
        return true;
    }

    private boolean gradeAposition(HomCommonWrapper rowDataWrapper, Map<String, Object> levelGradeMap, String aJobgradeText) {
        List jobGrades = HbpmResultUtils.getJobGrade(levelGradeMap);
        if (CollectionUtils.isEmpty((Collection)jobGrades)) {
            LOGGER.info("gradeAposition is empty");
            return false;
        }
        Map<String, DynamicObject> jobGradeMap = jobGrades.stream().collect(Collectors.toMap(jobGrade -> jobGrade.getString("name"), jobGrade -> jobGrade, (oldValue, newValue) -> newValue));
        DynamicObject ajobgrade = jobGradeMap.get(aJobgradeText);
        if (ajobgrade != null) {
            DynamicObject onbrdBillFromExcel = rowDataWrapper.getBizData();
            onbrdBillFromExcel.set("ajobgrade", (Object)ajobgrade);
        } else {
            rowDataWrapper.addErrMsg(ResManager.loadKDString((String)"\u672a\u5339\u914d\u5230\u5c97\u4f4d\u53ef\u9009\u8303\u56f4\u5185\u7684\u804c\u7b49\u3002", (String)"OnbrdImportInitServiceImpl_13", (String)"hr-hom-business", (Object[])new Object[0]));
        }
        return true;
    }

    private boolean gradeWithAjob(HomCommonWrapper rowDataWrapper, Map<String, List<DynamicObject>> jobLevelGradeInfoMap, String aJobgrade) {
        if (HRObjectUtils.isEmpty(jobLevelGradeInfoMap) || CollectionUtils.isEmpty((Collection)jobLevelGradeInfoMap.get("jobgrade"))) {
            LOGGER.info("gradeWithAjob is empty");
            return false;
        }
        List<DynamicObject> jobGradeInfos = jobLevelGradeInfoMap.get("jobgrade");
        Map<String, DynamicObject> jobGradeMap = jobGradeInfos.stream().collect(Collectors.toMap(jobGradeInfo -> jobGradeInfo.getString("name"), jobGradeInfo -> jobGradeInfo, (oldValue, newValue) -> newValue));
        if (CollectionUtils.isEmpty(jobGradeMap)) {
            LOGGER.info("gradeWithAjob jobGradeMap is empty");
            return false;
        }
        if (!jobGradeMap.containsKey(aJobgrade)) {
            rowDataWrapper.addErrMsg(ResManager.loadKDString((String)"\u672a\u5339\u914d\u5230\u804c\u4f4d\u53ef\u9009\u8303\u56f4\u5185\u7684\u804c\u7b49\u3002", (String)"OnbrdImportInitServiceImpl_14", (String)"hr-hom-business", (Object[])new Object[0]));
        } else {
            DynamicObject aJobgradeDy = jobGradeMap.get(aJobgrade);
            DynamicObject onbrdBillFromExcel = rowDataWrapper.getBizData();
            onbrdBillFromExcel.set("ajobgrade", (Object)aJobgradeDy);
        }
        return true;
    }

    private QFilter getEnrollFilter() {
        HashSet enrollStatusSet = Sets.newHashSetWithExpectedSize((int)3);
        enrollStatusSet.add(OnbrdStatusEnum.WAIT_START.toString());
        enrollStatusSet.add(OnbrdStatusEnum.WAIT_ONBRD.toString());
        enrollStatusSet.add(OnbrdStatusEnum.HAS_ONBRD.toString());
        QFilter enrollStatusFilter = new QFilter("enrollstatus", "in", (Object)enrollStatusSet).and("synchstatus", "!=", (Object)SynchStatusEnum.SYNCH_SUCCESS.getValue());
        return enrollStatusFilter;
    }

    @Override
    public void validAjobScmOrgPermission(List<HomCommonWrapper> rowDataWrapperList) {
        List onbrdBills = rowDataWrapperList.stream().map(HomCommonWrapper::getBizData).collect(Collectors.toList());
        CommonPermissionValidateService validateService = new CommonPermissionValidateService(onbrdBills, "hom_onbrdinfo");
        for (HomCommonWrapper commonWrapper : rowDataWrapperList) {
            DynamicObject onbrdBill = commonWrapper.getBizData();
            String errMsg = validateService.validate(onbrdBill);
            if (HRStringUtils.isBlank((CharSequence)errMsg)) continue;
            commonWrapper.addErrMsg(errMsg);
        }
    }
}

